//
//  EAModuleX88.h
//  ATIDDemo
//
//  Created by ATID 
//  Copyright (c) 2015년 ATID. All rights reserved.
//

#import <Foundation/Foundation.h>

#import "EAProtocol288.h"
#import "EARfidValues.h"

#define NIBBLE_UNIT                 4
#define MIN_OFFSET                  16

@protocol EAReaderDelegate;

@interface EAModule288 : NSObject {
    EAProtocol288* mProtocol;
    int mVersionCode;
}

- (id)initWithDevice:(EADevice *)device delegate:(id<EAReaderDelegate>)delegate;

- (id)initWithProtocol:(EAProtocol288 *)protocol;

- (NSString *)firmwareVersion;
- (NSString *)deviceVersion;
- (NSString *)bleVersion;
- (ResultType)readMemory:(BankType)bank offset:(int)offset length:(int)length;
- (ResultType)readMemory:(BankType)bank offset:(int)offset length:(int)length mask:(NSString *)mask;
- (ResultType)writeMemory:(BankType)bank offset:(int)offset value:(NSString *)value;
- (ResultType)writeMemory:(BankType)bank offset:(int)offset value:(NSString *)value mask:(NSString *)mask;
- (ResultType)lock:(int)action mask:(int)mask tagmask:(NSString *)tagmask;
- (ResultType)inventoryMemory:(BankType)bank offset:(int)offset length:(int)length;
- (ResultType)inventoryMemory:(BankType)bank offset:(int)offset length:(int)length mask:(NSString *)mask;

- (ResultType)saveStoredTag:(NSString *)tag;

- (MaskTargetType)getMaskTarget:(int)index;
- (void)setMaskTarget:(int)index maskTargetType:(MaskTargetType)target;
- (MaskActionType)getMaskAction:(int)index;
- (void)setMaskAction:(int)index maskActionType:(MaskActionType)action;
- (BankType)getMaskBank:(int)index;
- (void)setMaskBank:(int)index maskBank:(BankType)bank;
- (int)getMaskOffset:(int)index;
- (void)setMaskOffset:(int)index maskOffset:(int)offset;


- (void)setTagDataType:(int)tagData;


- (void)setVersionCode:(int)versionCode;

- (void)setDebugMode:(BOOL)enabled;
- (NSData *)getDebugConfig:(NSString *) barcode;

- (NSString *)RFidVersion; /*ej_ryu*/
- (NSString *)BTVersion;
- (void)getExtendAll;
@end
