//
//  EAReader.h
//  ATIDDemo
//
//  Created by ATID 
//  Copyright (c) 2015년 ATID. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "EAProtocol288.h"
#import "EAModule288.h"

#define TAG_PC_LENGTH               4

#define TAG_DATA_TYPE_ASCII         0
#define TAG_DATA_TYPE_HEX           1


#define VERSION_PREFIX              @"bl-"
#define MAX_VERSION                 4

#define FIRMWARE_MI                 0
#define FIRMWARE_MA                 1


@protocol EAReaderDelegate;

@interface EAReader : NSObject {
@private
    EAProtocol288 *mProtocol;
    EAModule288 *mModule;
    
    CommandType mAction;
    BOOL mIsResult;
    
    int mVersionCode;
    
    NSMutableArray *mChannelMask;
}

- (id)initWithDevice:(EADevice *)device delegate:(id<EAReaderDelegate>)delegate;
- (void)disconnect;

- (CommandType)getAction;
- (void)setDelegate:(id<EAReaderDelegate>)delegate;

// Action Command Methods
- (ResultType)inventory;
- (ResultType)inventory: (NSString *)mask;
- (ResultType)inventory6B: (NSString *)mask;
- (ResultType)readMemory:(BankType)bank offset:(int)offset length:(int)length mask:(NSString *)mask;
- (ResultType)writeMemory:(BankType)bank offset:(int)offset value:(NSString *)value mask:(NSString *)mask;
- (ResultType)lock:(LockParam *)param tagmask:(NSString *)tagmask;
- (ResultType)stop;
- (ResultType)stopSync; // cc barcode
- (ResultType)inventoryMemory:(BankType)bank offset:(int)offset length:(int)length mask:(NSString *)mask;

// Configuration Command Methods
- (ResultType)loadStoredData;
- (ResultType)saveStoredTag:(NSString *)tag;
- (ResultType)deleteAllStoredData;
- (ResultType)setDebugMode:(BOOL)enabled;
- (ResultType)loadDebugMessage;

// Peroperties Methods
- (NSString *)firmwareVersion;
- (NSString *)bleVersion;
- (NSString *)RFidVersion; /*ej_ryu*/
- (NSString *)BTVersion; /*ej_ryu*/
- (NSString *)frameworkVersion; /*ej_ryu*/
- (NSString *)deviceVersion; /*ej_ryu*/
- (int) firmwareType;

- (int)storedCount;

- (int)batteryStatus;


@property (nonatomic, strong) EADevice *mDevice;

@property (nonatomic, assign) BuzzerState buzzer;
@property (nonatomic, assign) RegionType region;
@property (nonatomic, assign) int operationTime;
@property (nonatomic, assign) int inventoryTime;
@property (nonatomic, assign) int idleTime;
@property (nonatomic, assign) int autoOffTime;
@property (nonatomic, strong) NSString *accessPassword;
@property (nonatomic, assign) SessionType inventorySession;
@property (nonatomic, assign) SessionFlag sessionFlag;

@property (nonatomic, strong) NSDate *time;
@property (nonatomic, strong) NSString *serialNumber;
@property (nonatomic, assign) int tagdatatype;

@property (nonatomic, assign) BOOL continuousMode;
//@property (nonatomic, assign) BOOL allDefault;
@property (nonatomic, assign) int antennaStatus;
@property (nonatomic, assign) int globalBand;
@property (nonatomic, assign) int antennaSwitchingTime;
@property (nonatomic, assign) int readerMode;
@property (nonatomic, assign) int autoCommand;
@property (nonatomic, assign) BOOL baudRate;
@property (nonatomic, assign) int repeatTagReportTime;
@property (nonatomic, assign) int gPIODelay;
@property (nonatomic, assign) int gPIOOutPortStatus;
@property (nonatomic, assign) BOOL selectAction;
@property (nonatomic, assign) int selectBitPtr;
@property (nonatomic, assign) int selectionBank;
@property (nonatomic, assign) BOOL powerOff;
@property (nonatomic, assign) BOOL typeBC;
@property (nonatomic, assign) BOOL bTUSB;
@property (nonatomic, assign) BOOL saveMode;
@property (nonatomic, assign) int singleMulti;
//@property (nonatomic, assign) BOOL getSaveData;
//@property (nonatomic, assign) BOOL deleteSaveData;
@property (nonatomic, assign) BOOL lowBatteryState;
@property (nonatomic, assign) int inventoryFormat;
@property (nonatomic, assign) BOOL packetOption;
@property (nonatomic, assign) int powerGain;
@property (nonatomic, assign) int scanTime;



- (NSString *)getRegister;
- (void)setRegister:(NSString *)value;

- (void)setTagDataType:(int)value;

- (void)setSerialNumber:(NSString *)serialNo password:(NSString *)password;
- (void)setRegion:(RegionType)region password:(NSString *)password;
- (void)setGlobalBand:(int) status password:(NSString *)password;

- (void)getSaveData;
- (void)deleteSaveData;
- (void)saveData;
- (ResultType)setAllDefault;

@end
