package com.atid.at288n.app.demo.type;

public enum LockType {
	NotChanged(0, "Not Changed"),
	Lock(1, "Lock"),
	Unlock(2, "Unlock"),
	Permalock(3, "Permalock");

	private int value;
	private String name;
	
	LockType(int value, String name) {
		this.value = value;
		this.name = name;
	}
	
	public int value() {
		return this.value;
	}
	
	@Override
	public String toString() {
		return this.name;
	}
	
	public static LockType valueOf(int value) {
		for (LockType t : LockType.values()) {
			if (t.value() == value) {
				return t;
			}
		}
		return NotChanged;
	}
}
