package com.atid.at288n.app.demo.view;

import com.atid.at288.lib.Reader;
import com.atid.at288n.app.demo.IReaderActivity;

import android.content.Context;
import android.util.AttributeSet;
import android.widget.LinearLayout;

public abstract class BaseView extends LinearLayout {

	protected String TAG;
	protected String title;
	protected Reader reader;
	protected IReaderActivity parent;
	protected int icon;
	
	public BaseView(Context context) {
		super(context);
		this.TAG = "";
		this.title = "";
		this.reader = null;
		this.parent = null;
		this.icon = 0;
	}

	public BaseView(Context context, AttributeSet attrs) {
		super(context, attrs);
		this.TAG = "";
		this.title = "";
		this.reader = null;
		this.parent = null;
		this.icon = 0;
	}

	public void onCreate(IReaderActivity parent, Reader reader) {
		this.parent = parent;
		this.reader = reader;
	}

	public String getTitle() {
		return this.title;
	}
	
	public int getIcon() {
		return this.icon;
	}

	public abstract void initView();
	public abstract void exitView();
	public abstract void createView();
	
	public abstract void clearMaskParams();

	public abstract void onReaderStateChange(int state);
	public abstract void onReaderReadTag(int event, String tag);
	public abstract void onReaderResponse(int event, String code);
	public abstract void onReaderProperty(char code, String value);
	public abstract void onReaderAction(char code);
	public abstract void onReaderExtentedProperty(char code, String value);
	public abstract void onReaderTimeout();
}
