package com.atid.at288n.app.demo.view;

import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.AsyncTask;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemSelectedListener;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.ListView;
import android.widget.Spinner;
import android.widget.TextView;

import com.atid.at288.lib.Reader;
import com.atid.at288.lib.type.BankType;
import com.atid.at288.lib.type.SelectionActionType;
import com.atid.at288.lib.type.StoredModeType;
import com.atid.at288n.app.demo.IReaderActivity;
import com.atid.at288n.app.demo.R;
import com.atid.at288n.app.demo.dialog.WaitDialog;
import com.atid.at288n.app.demo.type.ActionType;
import com.atid.at288n.app.demo.view.adapter.TagListAdapter;
import com.atid.at288n.app.demo.view.dialog.MaskSelectionDialog;

public class InventoryView extends BaseView implements Button.OnClickListener,
		OnItemSelectedListener {

	private TagListAdapter adapterTagList;

	private ArrayAdapter<CharSequence> adapterPowerGain;
	private Spinner spinPowerGain;

	private CheckBox chkStoredMode;
	private TextView txtTagCount;

	private Button btnInventory;
	private Button btnMask;
	private Button btnClear;

	private ActionType action = ActionType.Stop;
	private MaskSelectionDialog mask = null;
	private InitChecker initChecker = new InitChecker();
	private boolean storedMode = false;

	//MKJ
	private ArrayAdapter<CharSequence> adapterReadType;
	private Spinner spinReadType;
	
	
	// -------------------------------------------------------------
	// Constructor
	// -------------------------------------------------------------

	public InventoryView(Context context) {
		super(context);
		init(context);
	}

	public InventoryView(Context context, AttributeSet attrs) {
		super(context, attrs);
		init(context);
	}

	private void init(Context context) {
		TAG = "InventoryView";
		
		action = ActionType.Stop;

		if (!isInEditMode()) {
			LayoutInflater inflater = (LayoutInflater) context
					.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
			inflater.inflate(R.layout.view_inventory, this, true);
		}
	}

	// -------------------------------------------------------------
	// Event Handler
	// -------------------------------------------------------------

	@Override
	public void onCreate(IReaderActivity parent, Reader reader) {
		super.onCreate(parent, reader);

		// Initialize Title
		title = getResources().getString(R.string.inventory_title);
		icon = R.drawable.ic_inventory;
		// Initialize Widget
		initWidget();
		// Disable Widget
		enableWidget(false);

		mask = new MaskSelectionDialog(getContext(), maskListener);
	}

	@Override
	public void onClick(View v) {
		Log.d(TAG, String.format("onClick(%d)", v.getId()));

		switch (v.getId()) {
		case R.id.stored_mode:
			reader.setStoredMode(this.chkStoredMode.isChecked() ? StoredModeType.Stored : StoredModeType.NotStored);
			break;
		case R.id.read_inventory:
			if (ActionType.Stop == this.action) {
				if (mask.getMask().equals("")) {
					reader.inventory(null);
					Log.e(TAG, "inventory without mask");
				} else {
					reader.inventory(mask.getMask());
					Log.e(TAG, "inventory with mask");
				}
			} else {
				reader.stopOperation();
			}
			enableWidget(false);
			break;
		case R.id.clear:
			clearTagList();
			break;
		case R.id.mask:
			mask.show();
			break;
		}
	}

	@Override
	public void onItemSelected(AdapterView<?> parent, View view, int position,
			long id) {
		Log.d(TAG, String.format("onItemSelected(parent:%d, position:%d, id:%d)", parent.getId(),
				position, id));

		if (!initChecker.init) {
			return;
		}

		switch (parent.getId()) {
		case R.id.power_gain:
			// Change Power Gain...
			this.reader.setPowerEx(position);
			break;
		case R.id.spin_read_type:
			this.reader.setContinueModeExN(position);
			break;
		}
	}

	@Override
	public void onNothingSelected(AdapterView<?> parent) {

	}

	DialogInterface.OnClickListener maskListener = new DialogInterface.OnClickListener() {

		@Override
		public void onClick(DialogInterface dialog, int which) {
			reader.setSelectionBank(mask.getBank());
			reader.setSelectionOffset(mask.getOffset());
			reader.setSelectionAction(mask.getAction());
			mask.setMask(mask.getMask());
		}
	};

	@Override
	public void initView() {
		// Initalize Checker
		initChecker.init();

		// Enable Activity Widget
		enableWidget(false);
		// Clear Tag List
		clearTagList();

		this.adapterTagList.setDisplayTid(false);
		
		if(reader.TagType == Reader.ISO18000_6B){
			checkInit(InitChecker.BANK);
			checkInit(InitChecker.OFFSET);
			checkInit(InitChecker.ACTION);
		}
		
		InitTask requestParamsTask = new InitTask();
		requestParamsTask.execute();
	}
	
	public void requestParameters() {

		// Set Access Password
		reader.setAccessPassword("");
		// Set Mask Memory Bank
		reader.setSelectionBank(mask.getBank());
		// Set Mask Offset
		reader.setSelectionOffset(mask.getOffset());
		// Set Mask Action
		reader.setSelectionAction(mask.getAction());

		// Request Mask Memory Bank
		reader.getSelectionBank();
		// Request Mask Offset
		reader.getSelectionOffset();
		// Request Mask Action
		reader.getSelectionAction();
		
		// Request Global Band
		reader.getGlobalBand();
		// Request All Extended Properties
		reader.getAllExtendedProperty();
	}

	@Override
	public void exitView() {
		reader.stopOperation();
		this.action = ActionType.Stop;
		enableWidget(true);
	}

	@Override
	public void createView() {
		
	}
	
	public void createView(int Globalband) {
		
		if(adapterPowerGain != null) {
			return;
		}

		if (Globalband == 8)//Japan 1W 
		{
			adapterPowerGain = ArrayAdapter.createFromResource(getContext(),
							R.array.power_gain_array,
							android.R.layout.simple_spinner_dropdown_item);
		}
		else if (Globalband == 9)//Japan 0.25W
		{
			adapterPowerGain = ArrayAdapter.createFromResource(getContext(), 
							R.array.power_gain_japan_array,
							android.R.layout.simple_spinner_dropdown_item);
		}
		else if (Globalband == 12)//Japan 0.125W
		{
			adapterPowerGain = ArrayAdapter.createFromResource(getContext(), 
							R.array.power_gain_japan_array_125,
							android.R.layout.simple_spinner_dropdown_item);
		}
		else					//Normal
		{
			adapterPowerGain = ArrayAdapter.createFromResource(getContext(), 
							R.array.power_gain_array,
							android.R.layout.simple_spinner_dropdown_item);
		}
		
		spinPowerGain.setAdapter(adapterPowerGain);
		
		if(reader.IsAT288N_MA()) {
			this.spinReadType.setAdapter(null);
			this.adapterReadType = ArrayAdapter.createFromResource(getContext(),
					R.array.read_type_array_ma,
					android.R.layout.simple_spinner_dropdown_item);
			this.spinReadType.setAdapter(this.adapterReadType);
		} else {
			this.spinReadType.setAdapter(null);
			this.adapterReadType = ArrayAdapter.createFromResource(getContext(),
					R.array.read_type_array,
					android.R.layout.simple_spinner_dropdown_item);
			this.spinReadType.setAdapter(this.adapterReadType);
		}
	}

	@Override
	public void onReaderStateChange(int state) {
		Log.d(TAG, String.format("onReaderStateChange(%d)", state));
		if (state == Reader.STATE_LISTEN || state == Reader.STATE_NONE) {
			parent.closeSubView();
		}
	}

	@Override
	public void onReaderReadTag(int event, String tag) {
		Log.d(TAG, String.format("onReaderReadTag(%d, %s)", event, tag));
		adapterTagList.addTag(tag);
		txtTagCount.setText("" + adapterTagList.getCount());
	}

	@Override
	public void onReaderResponse(int event, String code) {
		Log.d(TAG, String.format("onReaderResponse(%d, %s)", event, code));
	}

	@Override
	public void onReaderProperty(char code, String value) {
		Log.d(TAG, String.format("onReaderProperty(%c, %s)", code, value));
		switch (code) {
		case Reader.PROPERTY_CONTINUE_MODE:
			break;
		case Reader.PROPERTY_SELECTION_BANK:
			mask.setBank(BankType.valueOf(Integer.parseInt(value)));
			checkInit(InitChecker.BANK);
			break;
		case Reader.PROPERTY_SELECTION_OFFSET:
			mask.setOffset(Integer.parseInt(value));
			checkInit(InitChecker.OFFSET);
			break;
		case Reader.PROPERTY_SELECTION_ACTION:
			mask.setAction(SelectionActionType.valueOf(Integer
					.parseInt(value)));
			checkInit(InitChecker.ACTION);
			break;
		case Reader.PROPERTY_GLOBAL_BAND:
			int globalBand = Integer.parseInt(value);
			createView(globalBand);
			break;
		}
		
		if(reader.TagType == Reader.ISO18000_6B){
			
		}
	}

	@Override
	public void onReaderAction(char code) {
		Log.d(TAG, String.format("onReaderActionChange(%c)", code));
		switch (code) {
		case Reader.ACTION_STOP:
			action = ActionType.Stop;
			break;
		default:
			action = ActionType.Inventory;
			break;
		}
		enableWidget(true);
	}

	@Override
	public void onReaderExtentedProperty(char code, String value) {
		Log.d(TAG, String.format("onReaderExtendedProperty(%c, %s)", code,
				value));
		enableWidget(true);
		
		switch (code) {
		case Reader.PROPERTY_EX_POWER_GAIN:
			spinPowerGain.setSelection(Integer.parseInt(value));
			checkInit(InitChecker.POWER);
			break;
		case Reader.PROPERTY_EX_STORED_MODE:
			storedMode = Integer.parseInt(value) > 0;
			chkStoredMode.setChecked(storedMode);
			checkInit(InitChecker.STORED_MODE);
			checkInit(InitChecker.POWER);
			checkInit(InitChecker.CONTINUE_MODE);
			break;
		case Reader.PROPERTY_EX_USE_SERIAL_NO:
			checkInit(InitChecker.USE_SERIAL_NO);
			break;
		case Reader.PROPERTY_EX_CONTINUE_MODE:
			if(reader.IsAT288N_MA() && spinReadType.getCount() > 2) {
				this.spinReadType.setAdapter(null);
				this.adapterReadType = ArrayAdapter.createFromResource(getContext(),
						R.array.read_type_array_ma,
						android.R.layout.simple_spinner_dropdown_item);
				this.spinReadType.setAdapter(this.adapterReadType);
			} else if(!reader.IsAT288N_MA() && spinReadType.getCount() < 3){
				this.spinReadType.setAdapter(null);
				this.adapterReadType = ArrayAdapter.createFromResource(getContext(),
						R.array.read_type_array,
						android.R.layout.simple_spinner_dropdown_item);
				this.spinReadType.setAdapter(this.adapterReadType);
			}
			spinReadType.setSelection(Integer.parseInt(value));
			
			break;
		}
	}

	@Override
	public void onReaderTimeout() {
	}

	// =================================================================
	// MainActivity Widget Control Methods
	// =================================================================

	// Initialize Widget
	private void initWidget() {
		// Initialize tag listview
		this.adapterTagList = new TagListAdapter(getContext());
		ListView lstTag = (ListView) findViewById(R.id.tag_list);
		lstTag.setAdapter(adapterTagList);
		lstTag.setChoiceMode(ListView.CHOICE_MODE_SINGLE);

		// Initialize power gain spinner
		this.spinPowerGain = (Spinner) findViewById(R.id.power_gain);
		this.spinPowerGain.setPrompt(getResources().getString(
				R.string.power_gain_prompt_label));
		this.spinPowerGain.setOnItemSelectedListener(this);

		//2016-08-31 stored mode add
		this.chkStoredMode = (CheckBox) findViewById(R.id.stored_mode);
		this.chkStoredMode.setOnClickListener(this);
		
		// Initialize tag count textview
		this.txtTagCount = (TextView) findViewById(R.id.tag_count);

		// Initialize inventory button
		this.btnInventory = (Button) findViewById(R.id.read_inventory);
		this.btnInventory.setOnClickListener(this);

		// Initialize clear button
		this.btnClear = (Button) findViewById(R.id.clear);
		this.btnClear.setOnClickListener(this);

		// Initialize mask button
		this.btnMask = (Button) findViewById(R.id.mask);
		this.btnMask.setOnClickListener(this);
		
		// Initialize InventoryFormat spinner
		this.spinReadType = (Spinner) findViewById(R.id.spin_read_type);
		this.spinReadType.setPrompt(getResources().getString(
				R.string.read_type_prompt_label));
		this.spinReadType.setOnItemSelectedListener(this);
		this.adapterReadType = ArrayAdapter.createFromResource(getContext(),
				R.array.read_type_array,
				android.R.layout.simple_spinner_dropdown_item);
		this.spinReadType.setAdapter(this.adapterReadType);
	}

	// Enable Widget
	private void enableWidget(boolean enabled) {
		if (enabled) {
			if (this.action == ActionType.Stop) { 
				this.spinPowerGain.setEnabled(true); 
				if(reader.TagType != Reader.ISO18000_6B)
					this.btnMask.setEnabled(true);
				else 
					this.btnMask.setEnabled(false);
				this.spinReadType.setEnabled(true);
				this.chkStoredMode.setEnabled(true);
				this.btnInventory.setText(getResources().getString(
						R.string.read_inventory_button_label));
				this.btnInventory.setEnabled(true);
				this.btnClear.setEnabled(true);		
			} else {
				this.spinPowerGain.setEnabled(false);
				this.spinReadType.setEnabled(false);
				this.chkStoredMode.setEnabled(false);
				this.btnInventory.setText(getResources().getString(
						R.string.stop_button_label));
				this.btnInventory.setEnabled(true);
				this.btnClear.setEnabled(false);
				this.btnMask.setEnabled(false);
			}
		} else {
			this.spinReadType.setEnabled(false);
			this.spinPowerGain.setEnabled(false);
			this.chkStoredMode.setEnabled(false);
			this.btnInventory.setEnabled(false);
			this.btnClear.setEnabled(false);
			this.btnMask.setEnabled(false);
		}
	}

	// Clear Tag List View
	private void clearTagList() {
		this.adapterTagList.clear();
		this.txtTagCount.setText("" + this.adapterTagList.getCount());
	}

	// Check Initialize Reader Service
	private void checkInit(int index) {
		if (initChecker.init) {
			return;
		}
		
		initChecker.check[index] = true;
		if (initChecker.isInitialized()) {
			initChecker.init = true;
			enableWidget(true);
			WaitDialog.hide();
		}
	}

	// =================================================================
	// Declare Internal Classes
	// =================================================================

	private class InitChecker {
		public static final int POWER = 0;
		public static final int CONTINUE_MODE = 1;
		public static final int BANK = 2;
		public static final int OFFSET = 3;
		public static final int ACTION = 4;
		public static final int USE_SERIAL_NO = 5;
		public static final int STORED_MODE = 6;

		public boolean init;
		public boolean[] check;

		public InitChecker() {
			init();
		}
		
		public void init() {
			init = false;
			check = new boolean[] { false, false, true, true, true, false,
					false };
		}

		private boolean isInitialized() {
			//ATLog.e(TAG, "(%s, %s, %s, %s, %s, %s, %s)",check[0],check[1],check[2],check[3],check[4],check[5],check[6]);
			return !init && check[0] && check[1] && check[2] && check[3]
					&& check[4] && check[5] && check[6];
		}
	}
	
	private class InitTask extends AsyncTask<Void, Void, Void> {

		private Context context = InventoryView.this.getContext();
		ProgressDialog asyncDialog = new ProgressDialog(context);
		
		@Override
		protected void onPreExecute() {
			asyncDialog.setProgressStyle(ProgressDialog.STYLE_SPINNER);
			asyncDialog.setMessage("wait for initialize");
			asyncDialog.setCancelable(false);
			asyncDialog.show();
			super.onPreExecute();
		}

		@Override
		protected Void doInBackground(Void... params) {
			
			requestParameters();
			
			return null;
		}

		@Override
		protected void onPostExecute(Void result) {
			asyncDialog.dismiss();
			super.onPostExecute(result);
		}
		
	}

	@Override
	public void clearMaskParams() {
		if(mask != null) {
			mask.resetContents();
		}
	}
}
