package com.atid.at288n.app.demo.view.adapter;

import java.util.ArrayList;

import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;

import com.atid.at288n.app.demo.R;
import com.atid.at288n.app.demo.type.LockType;

public class AccessOptionListAdapter extends BaseAdapter {

	// =================================================================
	// Declare Constant
	// =================================================================
	private final String TAG ="AccessOptionListAdeptor";
	public static final int KILL_PASSWORD = 0;
	public static final int ACCESS_PASSWORD = 1;
	public static final int EPC = 2;
	public static final int TID = 3;
	public static final int USER = 4;
	public static final int MAX_SHIFT = 4;
	public static final int SHIFT_INTERVAL = 2;

	// =================================================================
	// Declare Member Variable
	// =================================================================

	private LayoutInflater inflater;
	private ArrayList<AccessOptionListItem> list;

	// =================================================================
	// Constructor
	// =================================================================

	public AccessOptionListAdapter(Context context) {
		this.inflater = (LayoutInflater) context
				.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		this.list = new ArrayList<AccessOptionListItem>();
		this.list.add(new AccessOptionListItem(context.getResources()
				.getString(R.string.kill_password_label)));
		this.list.add(new AccessOptionListItem(context.getResources()
				.getString(R.string.access_password_label)));
		this.list.add(new AccessOptionListItem(context.getResources()
				.getString(R.string.epc_label)));
		this.list.add(new AccessOptionListItem(context.getResources()
				.getString(R.string.tid_label)));
		this.list.add(new AccessOptionListItem(context.getResources()
				.getString(R.string.user_label)));
	}

	// =================================================================
	// Public Methods
	// =================================================================
	
	public void clear() {
		for (AccessOptionListItem item : list) {
			item.setLock(LockType.NotChanged);
		}
	}
	
	public String getMask() {
		int mask = 0;
		int value = 0;
		
		for (int i = 0; i < list.size(); i++) {
			switch (list.get(i).getLock()) {
			case Lock:
			case Unlock:
				value = 2;
				value <<= (MAX_SHIFT - i) * SHIFT_INTERVAL;
				break;
			case Permalock:
				value = 3;
				value <<= (MAX_SHIFT - i) * SHIFT_INTERVAL;
				break;
			default:
				continue;
			}
			mask += value;
		}
		return String.format("%04X", mask);
	}
	
	public String getAction() {
		int action = 0;
		int value = 0;
		
		for (int i = 0; i < list.size(); i++) {
			switch (list.get(i).getLock()) {
			case Lock:
				value = 2;
				value <<= (MAX_SHIFT - i) * SHIFT_INTERVAL;
				break;
			case Permalock:
				value = 3;
				value <<= (MAX_SHIFT - i) * SHIFT_INTERVAL;
				break;
			default:
				continue;
			}
			
			Log.d(TAG, "@@@@@@@@@@AccessOptionList: "+value);
			action += value;
		}
		return String.format("%04X", action);
	}
	
	public LockType getLock(int position) {
		return this.list.get(position).getLock();
	}
	
	public void setLock(int position, LockType lock) {
		this.list.get(position).setLock(lock);
		this.notifyDataSetChanged();
	}
	
	// =================================================================
	// BaseAdapter Override Methods
	// =================================================================

	@Override
	public int getCount() {
		return this.list.size();
	}

	@Override
	public Object getItem(int position) {
		return this.list.get(position);
	}

	@Override
	public long getItemId(int position) {
		return position;
	}

	@Override
	public View getView(int position, View convertView, ViewGroup parent) {
		AccessOptionListViewHolder holder = null;

		if (null == convertView) {
			convertView = inflater.inflate(R.layout.item_option_list, parent,
					false);
			holder = new AccessOptionListViewHolder(convertView);
		} else {
			holder = (AccessOptionListViewHolder)convertView.getTag();
		}
		holder.setItem(this.list.get(position));
		return convertView;
	}

	// =================================================================
	// Internal Option List Item
	// =================================================================

	private class AccessOptionListItem {
		private String name;
		private LockType lock;

		public AccessOptionListItem(String name) {
			this.name = name;
			this.lock = LockType.NotChanged;
		}

		public String getName() {
			return this.name;
		}

		public LockType getLock() {
			return this.lock;
		}

		public void setLock(LockType lock) {
			this.lock = lock;
		}
	}

	// =================================================================
	// Internal View Holder
	// =================================================================

	private class AccessOptionListViewHolder {
		private TextView name;
		private TextView value;

		public AccessOptionListViewHolder(View parent) {
			this.name = (TextView) parent.findViewById(R.id.name);
			this.value = (TextView) parent.findViewById(R.id.value);
			parent.setTag(this);
		}

		public void setItem(AccessOptionListItem item) {
			this.name.setText(item.getName());
			this.value.setText(item.getLock().toString());
		}
	}
}
