package com.atid.at288n.app.demo.view.adapter;

import java.util.ArrayList;
import java.util.Locale;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;

import com.atid.at288.lib.type.BankType;
import com.atid.at288n.app.demo.R;

public class MemoryOptionListAdapter extends BaseAdapter {

	// =================================================================
	// Declare Constant
	// =================================================================

	public static final int BANK = 0;
	public static final int OFFSET = 1;
	public static final int LENGTH = 2;
	public static final int PASSWORD = 3;

	// =================================================================
	// Declare Member Variable
	// =================================================================

	private LayoutInflater inflater;
	private ArrayList<MemoryOptionListItem> list;

	// =================================================================
	// Constructor
	// =================================================================

	public MemoryOptionListAdapter(Context context) {
		super();

		this.inflater = (LayoutInflater) context
				.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		this.list = new ArrayList<MemoryOptionListItem>();
		this.list.add(new MemoryOptionListBankItem(context.getResources()
				.getString(R.string.memory_bank_label), BankType.EPC));
		this.list.add(new MemoryOptionListIntegerItem(context.getResources()
				.getString(R.string.memory_offset_label), 2));
		this.list.add(new MemoryOptionListIntegerItem(context.getResources()
				.getString(R.string.memory_length_label), 2));
		this.list.add(new MemoryOptionListStringItem(context.getResources()
				.getString(R.string.memory_password_label), ""));
	}

	// =================================================================
	// Public Methods
	// =================================================================

	public void clear() {
		((MemoryOptionListBankItem)this.list.get(BANK)).setBank(BankType.EPC);
		((MemoryOptionListIntegerItem)this.list.get(OFFSET)).setValue(2);
		((MemoryOptionListIntegerItem)this.list.get(LENGTH)).setValue(2);
		//((MemoryOptionListStringItem)this.list.get(PASSWORD)).setValue("");
		this.notifyDataSetChanged();
	}
	
	public BankType getBank() {
		return ((MemoryOptionListBankItem)this.list.get(BANK)).getBank();
	}
	
	public void setBank(BankType bank) {
		((MemoryOptionListBankItem)this.list.get(BANK)).setBank(bank);
		this.notifyDataSetChanged();
	}
	
	public int getOffset() {
		return ((MemoryOptionListIntegerItem)this.list.get(OFFSET)).getValue();
	}
	
	public void setOffset(int value) {
		((MemoryOptionListIntegerItem)this.list.get(OFFSET)).setValue(value);
		this.notifyDataSetChanged();
	}
	
	public int getLength() {
		return ((MemoryOptionListIntegerItem)this.list.get(LENGTH)).getValue();
	}
	
	public void setLength(int value) {
		((MemoryOptionListIntegerItem)this.list.get(LENGTH)).setValue(value);
		this.notifyDataSetChanged();
	}
	
	public String getPassword() {
		return ((MemoryOptionListStringItem)this.list.get(PASSWORD)).getValue();
	}
	
	public void setPassword(String value) {
		((MemoryOptionListStringItem)this.list.get(PASSWORD)).setValue(value);
		this.notifyDataSetChanged();
	}
	
	public void setMaxPowerGain(int value) {
		this.notifyDataSetChanged();
	}

	// =================================================================
	// BaseAdapter Override Methods
	// =================================================================

	@Override
	public int getCount() {
		return list.size();
	}

	@Override
	public Object getItem(int position) {
		return list.get(position);
	}

	@Override
	public long getItemId(int position) {
		return position;
	}

	@Override
	public View getView(int position, View convertView, ViewGroup parent) {
		MemoryOptionListViewHolder holder = null;

		if (null == convertView) {
			convertView = inflater.inflate(R.layout.item_option_list, parent,
					false);
			holder = new MemoryOptionListViewHolder(convertView);
		} else {
			holder = (MemoryOptionListViewHolder)convertView.getTag();
		}
		holder.setItem(position, list.get(position));
		return convertView;
	}

	// =================================================================
	// Internal Option List Item
	// =================================================================

	private class MemoryOptionListItem {
		private String name;

		public MemoryOptionListItem(String name) {
			this.name = name;
		}

		public String getName() {
			return this.name;
		}
	}

	private class MemoryOptionListIntegerItem extends MemoryOptionListItem {
		private int value;

		public MemoryOptionListIntegerItem(String name, int value) {
			super(name);
			this.value = value;
		}

		public int getValue() {
			return this.value;
		}
		
		public void setValue(int value) {
			this.value = value;
		}
	}

	private class MemoryOptionListBankItem extends MemoryOptionListItem {
		private BankType bank;

		public MemoryOptionListBankItem(String name, BankType bank) {
			super(name);
			this.bank = bank;
		}

		public BankType getBank() {
			return this.bank;
		}
		
		public void setBank(BankType bank) {
			this.bank = bank;
		}
	}

	private class MemoryOptionListStringItem extends MemoryOptionListItem {
		private String value;

		public MemoryOptionListStringItem(String name, String value) {
			super(name);
			this.value = value;
		}

		public String getValue() {
			return this.value;
		}
		
		public void setValue(String value) {
			this.value = value;
		}
	}

	// =================================================================
	// Internal View Holder
	// =================================================================

	private class MemoryOptionListViewHolder {
		private TextView name;
		private TextView value;

		public MemoryOptionListViewHolder(View parent) {
			this.name = (TextView) parent.findViewById(R.id.name);
			this.value = (TextView) parent.findViewById(R.id.value);
			parent.setTag(this);
		}

		public void setItem(int index, MemoryOptionListItem item) {
			this.name.setText(item.getName());
			switch (index) {
			case BANK:
				this.value.setText(((MemoryOptionListBankItem)item).getBank().toString());
				break;
			case OFFSET:
				this.value.setText(String.format(Locale.US, "%d word", ((MemoryOptionListIntegerItem)item).getValue()));
				break;
			case LENGTH:
				this.value.setText(String.format(Locale.US, "%d word", ((MemoryOptionListIntegerItem)item).getValue()));
				break;
			case PASSWORD:
				this.value.setText(((MemoryOptionListStringItem)item).getValue());
				break;
			}
		}
	}
}
