package com.atid.at288n.app.demo.view.adapter;

import java.util.ArrayList;
import java.util.Locale;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;

import com.atid.at288n.app.demo.R;

public class MemoryValueListAdapter extends BaseAdapter {

	// =================================================================
	// Declare Constant
	// =================================================================

	private static final int MAX_PADDING = 4;
	private static final int MAX_LINE = 16;

	// =================================================================
	// Declare Member Variable
	// =================================================================

	private LayoutInflater inflater;
	private ArrayList<MemoryValueListItem> list;

	// =================================================================
	// Constructor
	// =================================================================

	public MemoryValueListAdapter(Context context) {
		super();

		this.inflater = (LayoutInflater) context
				.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		this.list = new ArrayList<MemoryValueListItem>();
		this.list.add(new MemoryValueListItem(0));
	}

	// =================================================================
	// Public Methods
	// =================================================================
	public void clear() {
		this.list.clear();
		this.list.add(new MemoryValueListItem(0));
		this.notifyDataSetChanged();
	}

	public void setValue(int offset, String value) {
		int paddingLen = MAX_PADDING - (value.length() % MAX_PADDING);
		int length = paddingLen == MAX_PADDING ? value.length() : value
				.length() + paddingLen;
		int line = ((length - 1) / MAX_LINE) + 1;
		MemoryValueListItem item = null;

		value = paddingRight(value, length, "0");

		this.list.clear();
		for (int i = 0; i < line; i++) {
			item = new MemoryValueListItem((i * MAX_PADDING) + offset);
			for (int j = 0; j < MAX_PADDING; j++) {
				int start = (i * MAX_LINE) + (j * MAX_PADDING);
				int end = start + MAX_PADDING;
				String split;
				if (length <= start) {
					break;
				} else {
					split = value.substring(start, end);
					item.setValues(j, split);
				}
			}
			this.list.add(item);
		}
		this.notifyDataSetChanged();
	}

	private String paddingRight(String str, int len, String add) {
		String res = str;
		int addLen = len - str.length();
		for (int i = 0; i < addLen; i++) {
			res = res + add;
		}
		return res;
	}

	// =================================================================
	// BaseAdapter Override Methods
	// =================================================================

	@Override
	public int getCount() {
		return list.size();
	}

	@Override
	public Object getItem(int position) {
		return list.get(position);
	}

	@Override
	public long getItemId(int position) {
		return position;
	}

	@Override
	public View getView(int position, View convertView, ViewGroup parent) {
		MemoryValueListViewHolder holder = null;

		if (null == convertView) {
			convertView = inflater.inflate(R.layout.item_memory_list, parent,
					false);
			holder = new MemoryValueListViewHolder(convertView);
		} else {
			holder = (MemoryValueListViewHolder) convertView.getTag();
		}
		holder.setItem(list.get(position));
		return convertView;
	}

	// =================================================================
	// Internal Memory Value List Item
	// =================================================================
	private class MemoryValueListItem {
		private String[] addresses;
		private String[] values;

		public MemoryValueListItem(int offset) {
			this.addresses = new String[] { String.format(Locale.US, "%d word", offset),
					String.format(Locale.US, "%d word", offset + 1),
					String.format(Locale.US, "%d word", offset + 2),
					String.format(Locale.US, "%d word", offset + 3) };
			this.values = new String[] { "0000", "0000", "0000", "0000" };
		}

		public String getAddress(int index) {
			return this.addresses[index];
		}

		public void setAddress(int index, String address) {
			this.addresses[index] = address;
		}

		public String getValue(int index) {
			return this.values[index];
		}

		public void setValues(int index, String value) {
			this.values[index] = value;
		}
	}

	// =================================================================
	// Internal View Holder
	// =================================================================

	private class MemoryValueListViewHolder {
		private TextView[] addresses;
		private TextView[] values;

		public MemoryValueListViewHolder(View parent) {
			this.addresses = new TextView[] {
					(TextView) parent.findViewById(R.id.address1),
					(TextView) parent.findViewById(R.id.address2),
					(TextView) parent.findViewById(R.id.address3),
					(TextView) parent.findViewById(R.id.address4) };
			this.values = new TextView[] {
					(TextView) parent.findViewById(R.id.read_value1),
					(TextView) parent.findViewById(R.id.read_value2),
					(TextView) parent.findViewById(R.id.read_value3),
					(TextView) parent.findViewById(R.id.read_value4) };
			parent.setTag(this);
		}

		public void setItem(MemoryValueListItem item) {
			for (int i = 0; i < 4; i++) {
				this.addresses[i].setText(item.getAddress(i));
				this.values[i].setText(item.getValue(i));
			}
		}
	}
}
