package com.atid.at288n.app.demo.view.adapter;

import java.util.ArrayList;

import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;

import com.atid.at288n.app.demo.R;

public class TagListAdapter extends BaseAdapter {

	// =================================================================
	// Declare Constant
	// =================================================================

	private static final String TAG = "TagListAdapter";

	// =================================================================
	// Declare Member Variable
	// =================================================================

	private LayoutInflater inflater;
	private ArrayList<TagListItem> list;
	private boolean displayPc;
	
	// =================================================================
	// Constructor
	// =================================================================

	public TagListAdapter(Context context) {
		super();

		this.inflater = (LayoutInflater) context
				.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		this.list = new ArrayList<TagListItem>();
		this.displayPc = true;
	}

	// =================================================================
	// Public Methods
	// =================================================================
	public void clear() {
		this.list.clear();
		this.notifyDataSetChanged();
	}

	public boolean getDisplayPc() {
		return this.displayPc;
	}

	public void setDisplayPc(boolean displayPc) {
		this.displayPc = displayPc;
		this.notifyDataSetChanged();
	}

	public void addTag(String tag) {
		TagListItem item = null;
		String serialNo = null;
		String tidNo = null;
		String [] tags = tag.split(",");
		
		switch(tags.length)
		{
		case 1:
			serialNo = "";
			tag = tags[0];
			tidNo = "";
			break;
		case 2:
			serialNo = tags[0];
			tag = tags[1];
			tidNo = "";
			break;
		case 3:
			serialNo = tags[0];
			tag = tags[1];
			tidNo = tags[2];
			break;
		}
		
		Log.d(TAG, String.format(">>>displayPC:%s, displayMem:%s, serialNo:%s, tag:%s, tidNo:%s", displayPc, displayTid, serialNo, tag, tidNo));
		
		if (null == (item = findItem(tag))) {
			Log.d(TAG, String.format("addTag(%s)", serialNo == null ? tag
					: serialNo + ", " + tag));
			//this.list.add(new TagListItem(serialNo, tag));
			this.list.add(new TagListItem(serialNo, tag, tidNo));
		} else {
			Log.d(TAG, String.format("addTag(%s) [%d]", serialNo == null ? tag
					: serialNo + ", " + tag, item.getCount()));
			if (null != serialNo) {
				item.setSerialNo(serialNo);
				item.setTid(tidNo);
			}
			item.increaseCount();
		}

		this.notifyDataSetChanged();
	}

	public String getTag(int position) {
		return list.get(position).getTag();
	}

	public String getEpc(int position) {
		return list.get(position).getTag(false);
	}

	private TagListItem findItem(String tag) {
		for (TagListItem item : list) {
			if (item.equals(tag))
				return item;
		}
		return null;
	}

	// =================================================================
	// BaseAdapter Override Methods
	// =================================================================

	@Override
	public int getCount() {
		return list.size();
	}

	@Override
	public Object getItem(int position) {
		return list.get(position);
	}

	@Override
	public long getItemId(int position) {
		return position;
	}

	@Override
	public View getView(int position, View convertView, ViewGroup parent) {
		TagListViewHolder holder = null;

		if (null == convertView) {
			convertView = inflater.inflate(R.layout.item_tag_list, parent,
					false);
			holder = new TagListViewHolder(convertView);
		} else {
			holder = (TagListViewHolder) convertView.getTag();
		}

		holder.setItem(list.get(position), this.displayPc, this.displayTid);
		
		return convertView;
	}

	private boolean displayTid;

	public boolean getDisplayTid() {
		return this.displayTid;
	}

	public void setDisplayTid(boolean displayTid) {
		this.displayTid = displayTid;
		this.notifyDataSetChanged();
	}
	

	
	// =================================================================
	// Internal Tag List Item
	// =================================================================

	private class TagListItem {
		private String serialNo;
		private String tag;
		private int count;
		private String tid;

		public TagListItem(String serialNo, String tag) {
			this.serialNo = serialNo;
			this.tag = tag;
			this.count = 1;
		}
		
		public TagListItem(String serialNo, String tag, String tid) {
			this.serialNo = serialNo;
			this.tag = tag;
			this.count = 1;
			this.tid = tid;
		}

		public String getTag() {
			return this.tag;
		}

		public String getTag(boolean pc) {
			return pc ? this.tag : this.tag.substring(4);
		}

		public String getSerialNo() {
			return this.serialNo;
		}
		
		public void setSerialNo(String serialNo) {
			this.serialNo = serialNo;
		}

		public int getCount() {
			return this.count;
		}

		public void increaseCount() {
			this.count++;
		}

		public boolean equals(String tag) {
			return this.tag.equals(tag);
		}
		
		public String getTid() {
			return this.tid;
		}
		
		public void setTid(String tid) {
			this.tid = tid;
		}
	}

	// =================================================================
	// Internal View Holder
	// =================================================================

	private class TagListViewHolder {
		private TextView serialNo;
		private TextView tag;
		private TextView count;
		private TextView tid;

		public TagListViewHolder(View parent) {
			this.serialNo = (TextView) parent.findViewById(R.id.serial_no);
			this.tag = (TextView) parent.findViewById(R.id.tag_value);
			this.count = (TextView) parent.findViewById(R.id.tag_count);
			this.tid = (TextView) parent.findViewById(R.id.tid_no); //2014.06.30 munhg
			parent.setTag(this);
		}

		public void setItem(TagListItem item, boolean displayPc) {
			if (item.getSerialNo() == null) {
				this.serialNo.setVisibility(View.GONE);
			} else {
				this.serialNo.setVisibility(View.VISIBLE);
				this.serialNo.setText(item.getSerialNo());
			}
			this.tag.setText(item.getTag(displayPc));
			this.count.setText("" + item.getCount());
		}
		
		public void setItem(TagListItem item, boolean displayPc, boolean displayTid) {
			if (item.getSerialNo() == null) {
				this.serialNo.setVisibility(View.GONE);
			} else {
				this.serialNo.setVisibility(View.VISIBLE);
				this.serialNo.setText(item.getSerialNo());
			}
			
			if(!displayTid)
			{
				this.tid.setVisibility(View.GONE);
			} else {
				this.tid.setVisibility(View.VISIBLE);
				this.tid.setText(item.getTid());
			}
			
			this.tag.setText(item.getTag(displayPc));
			this.count.setText("" + item.getCount());
		}
	}
}
