package com.atid.at288n.app.demo.view.dialog;

import android.annotation.SuppressLint;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemSelectedListener;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.Spinner;

import com.atid.at288.lib.type.BankType;
import com.atid.at288.lib.type.SelectionActionType;
import com.atid.at288n.app.demo.R;

@SuppressLint("ViewConstructor")
public class MaskSelectionDialog extends LinearLayout implements
		Button.OnClickListener, OnItemSelectedListener {

	// =================================================================
	// Declare Constant
	// =================================================================
	private static final int WORD_BIT = 16;
	private static final int DEFAULT_OFFSET = 1;
	
	// =================================================================
	// Declare Member Variable
	// =================================================================

	private BankType bank;
	private int offset;
	private SelectionActionType action;
	private String mask;

	private ArrayAdapter<CharSequence> adapterBankType;
	private Spinner spinBankType;

	private ArrayAdapter<CharSequence> adapterOffset;
	private Spinner spinOffset;

	private ArrayAdapter<CharSequence> adapterAction;
	private Spinner spinAction;

	private EditText edtMask;

	private Button btnReset;

	private final DialogInterface.OnClickListener listener;

	// =================================================================
	// Constructor
	// =================================================================

	public MaskSelectionDialog(Context context,
			DialogInterface.OnClickListener listener) {
		super(context);
		this.bank = BankType.EPC;
		this.offset = DEFAULT_OFFSET;
		this.action = SelectionActionType.Matching;
		this.mask = "";
		this.listener = listener;
	}

	public MaskSelectionDialog(Context context, AttributeSet attrs,
			DialogInterface.OnClickListener listener) {
		super(context, attrs);
		this.bank = BankType.EPC;
		this.offset = DEFAULT_OFFSET;
		this.action = SelectionActionType.Matching;
		this.mask = "";
		this.listener = listener;
	}

	// =================================================================
	// Public Methods
	// =================================================================

	public BankType getBank() {
		return this.bank;
	}

	public void setBank(BankType bank) {
		this.bank = bank;
	}

	public int getOffset() {
		return this.offset * WORD_BIT;
	}

	public void setOffset(int offset) {
		this.offset = (int) (offset / WORD_BIT);
	}

	public SelectionActionType getAction() {
		return this.action;
	}

	public void setAction(SelectionActionType action) {
		this.action = action;
	}

	public String getMask() {
		if (null != this.edtMask) {
			this.mask = this.edtMask.getText().toString();
		}
		return this.mask;
	}

	public void setMask(String mask) {
		this.mask = mask;
	}

	public void show() {
		Context context = getContext();
		LinearLayout root = (LinearLayout) LinearLayout.inflate(context,
				R.layout.dialog_mask_selection, null);
		AlertDialog.Builder builder = null;

		// Initialize bank type spinner
		this.spinBankType = (Spinner) root.findViewById(R.id.bank_type);
		this.spinBankType.setOnItemSelectedListener(this);
		this.adapterBankType = ArrayAdapter.createFromResource(context,
				R.array.bank_type_array,
				android.R.layout.simple_spinner_dropdown_item);
		this.spinBankType.setAdapter(this.adapterBankType);
		this.spinBankType.setSelection(this.bank.value());

		// Initialize offset spinner
		this.spinOffset = (Spinner) root.findViewById(R.id.mask_offset);
		this.spinOffset.setOnItemSelectedListener(this);
		this.adapterOffset = ArrayAdapter.createFromResource(context,
				R.array.mask_offset_array,
				android.R.layout.simple_spinner_dropdown_item);
		this.spinOffset.setAdapter(this.adapterOffset);
		this.spinOffset.setSelection(this.offset);

		// Initialize action spinner
		this.spinAction = (Spinner) root.findViewById(R.id.action_type);
		this.spinAction.setOnItemSelectedListener(this);
		this.adapterAction = ArrayAdapter.createFromResource(context,
				R.array.action_type_array,
				android.R.layout.simple_spinner_dropdown_item);
		this.spinAction.setAdapter(this.adapterAction);
		this.spinAction.setSelection(this.action.value());

		// Initialize mask edittext
		this.edtMask = (EditText) root.findViewById(R.id.mask_value);
		this.edtMask.setText(this.mask);

		// Initialize reset button
		this.btnReset = (Button) root.findViewById(R.id.reset);
		this.btnReset.setOnClickListener(this);

		// create alert dialog
		builder = new AlertDialog.Builder(context);
		builder.setTitle(R.string.mask_selection_title);
		builder.setView(root);
		builder.setPositiveButton(R.string.save_button_label, listener);
		builder.setNegativeButton(R.string.cancel_button_label, new DialogInterface.OnClickListener() {

			@Override
			public void onClick(DialogInterface dialog, int which) {
				Log.e("TEST", "onClick");
				edtMask.setText(mask);
				//mask = "";
			}
		});
		builder.setOnCancelListener(new DialogInterface.OnCancelListener() {
			
			@Override
			public void onCancel(DialogInterface dialog) {
				Log.e("TEST", "onCancel");
				edtMask.setText(mask);
			}
		});
		builder.show();
	}
	
	public void resetContents() {
		this.bank = BankType.EPC;
		this.offset = DEFAULT_OFFSET;
		this.action = SelectionActionType.Matching;
		this.mask = "";

		if(this.spinBankType != null)
			this.spinBankType.setSelection(this.bank.value());
		if(this.spinOffset != null)
			this.spinOffset.setSelection(this.offset);
		if(this.spinAction != null)
			this.spinAction.setSelection(this.action.value());
		if(this.edtMask != null)
			this.edtMask.setText(this.mask);
	}

	// =================================================================
	// Override Methods
	// =================================================================

	@Override
	public void onClick(View v) {
		switch (v.getId()) {
		case R.id.reset:
			resetContents();
			break;
		}
	}

	@Override
	public void onItemSelected(AdapterView<?> parent, View view, int position,
			long id) {
		switch (parent.getId()) {
		case R.id.bank_type:
			this.bank = BankType.valueOf(position);
			break;
		case R.id.mask_offset:
			this.offset = position;
			break;
		case R.id.action_type:
			this.action = SelectionActionType.valueOf(position);
			break;
		}
	}

	@Override
	public void onNothingSelected(AdapterView<?> parent) {

	}
}
