﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Drawing.Imaging;

namespace AT288Demo.Net.Custom
{
    public partial class ProgressControl : Control
    {
        #region Member Variable
        private Image m_Image;
        private Color m_MaskColor;
        #endregion

        #region Contructor
        public ProgressControl()
        {
            this.SetStyle(ControlStyles.SupportsTransparentBackColor, true);
            this.DoubleBuffered = true;

            m_Image = null;
            m_MaskColor = Color.White;

            InitializeComponent();
            this.BackColor = Color.Transparent;
        }
        #endregion

        #region Properties
        public Image Image
        {
            get { return m_Image; }
            set
            {
                m_Image = value;
                if (m_Image != null)
                {
                    ImageAnimator.Animate(m_Image, new EventHandler(this.OnFrameChanged));
                }
            }
        }

        public Color MaskColor
        {
            get { return m_MaskColor; }
            set { m_MaskColor = value; }
        }
        #endregion

        #region Overwrited Event Handler
        protected override void OnPaint(PaintEventArgs pe)
        {
            if (m_Image != null)
            {
                ImageAnimator.UpdateFrames();

                Bitmap bmp = new Bitmap(m_Image.Width, m_Image.Height);
                Graphics gg = Graphics.FromImage(bmp);
                gg.Clear(this.m_MaskColor);
                gg.DrawImage(m_Image, new Point(0, 0));
                //gg.DrawImage(m_Image, rect, 0, 0, m_Image.Width, m_Image.Height, GraphicsUnit.Pixel, attr);
                //pe.Graphics.DrawImage(bmp, new Point(0, 0));
                ImageAttributes attr = new ImageAttributes();
                //Rectangle rect = new Rectangle(0, 0, m_Image.Width, m_Image.Height);
                int x = (ClientSize.Width / 2) - (m_Image.Width / 2);
                int y = (ClientSize.Height / 2) - (m_Image.Height / 2);
                attr.SetColorKey(this.m_MaskColor, this.m_MaskColor);
                pe.Graphics.DrawImage(bmp, this.ClientRectangle, x, y, m_Image.Width, m_Image.Height, GraphicsUnit.Pixel, attr);
            }
        }
        #endregion

        #region ImageAnimator Event Handler
        private void OnFrameChanged(object sender, EventArgs e)
        {
            this.Invalidate();
        }
        #endregion
    }
}
