﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace AT288Demo.Net.Dialog
{
    public partial class LBTChannelDialog : Form
    {
        #region Member variable
        private int m_nLBTChannel;
        private CheckBox[] m_chkChannel;
        #endregion

        #region Constructoer
        public LBTChannelDialog()
        {
            m_nLBTChannel = 0;

            InitializeComponent();

            m_chkChannel = new CheckBox[]
            { 
                chkCh0, chkCh1, chkCh2, chkCh3, 
                chkCh4, chkCh5, chkCh6, chkCh7, 
                chkCh8 
            };
        }
        #endregion

        #region Properties
        public int LBTChannel { get { return m_nLBTChannel; } set { m_nLBTChannel = value; } }
        #endregion

        #region Event Handler
        private void LBTChannelDialog_Load(object sender, EventArgs e)
        {
            int state = 0;

            for (int i = 0; i < m_chkChannel.Length; i++)
            {
                state = (m_nLBTChannel >> i) & 0x1;
                m_chkChannel[i].Checked = state > 0 ? true : false;
            }
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            int state = 0;

            m_nLBTChannel = 0;
            for (int i = 0; i < m_chkChannel.Length; i++)
            {
                state = m_chkChannel[i].Checked ? 1 : 0;
                m_nLBTChannel += (state << i);
            }
            DialogResult = DialogResult.OK;
            Close();
        }
        #endregion
    }
}
