﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using AT288Lib.Net;

namespace AT288Demo.Net.Dialog
{
    public partial class SelectionMaskDialog : Form
    {
        #region 생성자
        public SelectionMaskDialog()
        {
            InitializeComponent();
        }
        #endregion

        #region 속성
        public MemoryType Bank { get { return (MemoryType)cbBank.SelectedIndex; } set { cbBank.SelectedIndex = (int)value; } }
        public int Offset { get { return cbOffset.SelectedIndex; } set { cbOffset.SelectedIndex = value; } }
        public string Mask { get { return txtMask.Text; } set { txtMask.Text = value; } }
        public SelectionActionType Action
        {
            get { return (SelectionActionType)cbAction.SelectedIndex; }
            set { cbAction.SelectedIndex = (int)value; }
        }
        #endregion

        #region 이벤트 처리기
        private void btnOK_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.OK;
        }

        private void txtMask_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (char.IsControl(e.KeyChar)) return;
            if (char.IsDigit(e.KeyChar)) return;
            if (char.IsLetter(e.KeyChar))
            {
                if (char.IsLower(e.KeyChar)) e.KeyChar = char.ToUpper(e.KeyChar);
                if (e.KeyChar == 'a' || e.KeyChar == 'A' ||
                    e.KeyChar == 'b' || e.KeyChar == 'B' ||
                    e.KeyChar == 'c' || e.KeyChar == 'C' ||
                    e.KeyChar == 'd' || e.KeyChar == 'D' ||
                    e.KeyChar == 'e' || e.KeyChar == 'E' ||
                    e.KeyChar == 'f' || e.KeyChar == 'F') return;
            }
            e.Handled = true;
        }
        #endregion
    }
}
