﻿using System;
using System.Collections.Generic;
using System.Text;

namespace AT288Demo.Net
{
    public class TagItem
    {
        #region 멤버변수
        private int m_nIndex;
        private string m_strSerialNo;
        private string m_strValue;
        private int m_nCount;
        #endregion

        #region 생성자
        public TagItem(string serialNo, string value)
        {
            //m_nIndex = index;
            m_strSerialNo = serialNo;
            m_strValue = value;
            m_nCount = 1;
        }

        //추가!!!!!!!
        public TagItem(string value)
        {
            //m_nIndex = index;
            m_strSerialNo = String.Empty;
            m_strValue = value;
            m_nCount = 1;
        }

        public TagItem(int index,string serialNo, string value)
        {
            m_nIndex = index;
            m_strSerialNo = serialNo;
            m_strValue = value;
            m_nCount = 1;
        }
        #endregion

        #region 속성
        public int Index { get { return m_nIndex; } }
        public string SerialNo { get { return m_strSerialNo; } }
        public string Value { get { return m_strValue; } }
        public int Count { get { return m_nCount; } }
        #endregion

        #region 메서드
        public void Increase()
        {
            m_nCount++;
        }
        #endregion
    }

    public class TagItemList
    {
        #region 멤버변수
        private List<TagItem> m_lstTag;
        #endregion

        #region 생성자
        public TagItemList()
        {
            m_lstTag = new List<TagItem>();
        }
        #endregion

        #region 속성
        public int Count { get { return m_lstTag.Count; } }
        public TagItem this[int index] { get { return m_lstTag[index]; } }
        #endregion

        #region 메서드
        public int AddTag(string serialNo, string tag)
        {
            TagItem item = null;
            int index = 0;

            if ((item = FindTagItem(serialNo, tag)) == null)
            {
                index = m_lstTag.Count + 1;
                item = new TagItem(index, serialNo, tag);
                m_lstTag.Add(item);
            }
            else
            {
                index = item.Index;
                item.Increase();
            }
            return index;
        }

        public void Clear()
        {
            m_lstTag.Clear();
        }

        public TagItem GetTagItem(int index)
        {
            return m_lstTag[index];
        }
        #endregion

        #region 내부 함수
        private TagItem FindTagItem(string serialNo, string value)
        {   int count =0;
            foreach (TagItem item in m_lstTag)
            {
                if (item.SerialNo == serialNo && item.Value == value)
                {
                    //item.Index = count; 
                    return item; 
                }
                count ++;
            }
            return null;
        }
        #endregion
    }
}
