﻿using System;
using System.Collections.Generic;
using System.Text;
using AT288Lib.Net;
using System.Windows.Forms;
namespace AT288Demo.Net
{
    public static class Util
    {
        // set combobox integer
        public static void SetComboBoxInteger(ComboBox combo, int value)
        {
            int index = -1;

            while ((index = combo.FindString(value.ToString(), index)) >= 0)
            {
                if (combo.Items[index].ToString() == value.ToString())
                {
                    combo.SelectedIndex = index;
                    break;
                }
            }
        }

        // Return memroy type string
        public static string GetMemoryTypeString(MemoryType type)
        {
            switch (type)
            {
                case MemoryType.Reserved: return "Reserved";
                case MemoryType.EPC: return "EPC";
                case MemoryType.TID: return "TID";
                case MemoryType.User: return "User";
            }
            return "Unknown";
        }

        // Return selection action type
        public static string GetSelectionActionTypeString(SelectionActionType type)
        {
            switch (type)
            {
                case SelectionActionType.Matching: return "Matching";
                case SelectionActionType.NonMatching: return "Non-Matching";
            }
            return "Unknonw";
        }
    }
}
