//
//  AppDelegate.h
//  AT288N_DEMO
//
//  Created by 류은주 on 2017. 7. 28..
//  Copyright © 2017년 ATID. All rights reserved.
//

#import <UIKit/UIKit.h>
#import <CoreData/CoreData.h>
#import <EA288RfidFramework/EAReader.h>
#import "MBProgressHUD.h"

#define DATA_TARGET             @[@"S0", @"S1", @"S2", @"S3", @"SL"]
#define DATA_ACTION             @[@"Matching", @"Non Matching"]
#define DATA_BANK               @[@"Reserved", @"EPC", @"TID", @"User"]
#define DATA_BIT                @[@"0", @"16", @"32", @"48", @"64", @"80", @"96", @"112", @"128", @"144", @"160", @"176", @"192", @"208", @"224", @"240"]
#define DATA_WORD               @[@"0", @"1", @"2", @"3", @"4", @"5", @"6", @"7", @"8", @"9", @"10", @"11", @"12", @"13", @"14", @"15"]
#define DATA_SELECT_FLAG        @[@"SL", @"~SL", @"All"]
#define DATA_INVENTORY_SESSION  @[@"S0", @"S1", @"S2", @"S3"]
#define DATA_SESSION_FLAG       @[@"A Only", @"B Only", @"A or B"]
#define DATA_INVENTORY_TYPE_MI     @[@"Multi Tag Read",@"Once Tag Read",@"Filter Tag Read"]
#define DATA_INVENTORY_FORMAT_MI   @[@"PC+EPC",@"Serial No. + PC+EPC", @"EPC",@"Serial No. + EPC"]
#define DATA_INVENTORY_TYPE_MA     @[@"Multi Tag Read",@"Once Tag Read"]
#define DATA_INVENTORY_FORMAT_MA   @[@"Data",@"Serial No. + Data"]
#define DATA_GEN_TYPE   @[@"ISO18000 6C GEN2",@"ISO18000 6B"]


#define MAX_PASSWORD_LENGTH         8
#define MAX_WRITE_DATA_WORD         32
#define MAX_WRITE_DATA_LENGTH       MAX_WRITE_DATA_WORD * 4


@interface AppDelegate : UIResponder <UIApplicationDelegate>

@property (strong, nonatomic) UIWindow *window;

@property (readonly, strong) NSPersistentContainer *persistentContainer;

//- (void)initMask:(NSString *)maskValue maskType:(MaskType)maskType;
//- (void)exitMask;
- (void)saveContext;
- (NSString *)getAppVersion;
+ (MBProgressHUD *)showGlobalProgressHUDWithTitle:(NSString *)title;
+ (void)dismissGlobalHUD;

@property (strong, nonatomic) EAReader *mReader;
@property (strong, nonatomic) CBCentralManager *mCentralManager;
@property (strong, nonatomic) CBCentralManager *ConnectCentralManager;
@property (strong, nonatomic) CBPeripheral *mPeripheral;
@property (strong, nonatomic) MBProgressHUD *HUD;
@property (strong, nonatomic) NSString *latestdevicename;
@property (strong, nonatomic) NSString *connectdevicename;
@property (strong, nonatomic) NSString *connectdeviceadd;
@property (strong, nonatomic) NSString *maskstrvalue;
@property (nonatomic) int killpasswordvalue;
@property (nonatomic) int accesspasswordvalue;
@property (nonatomic) int epcvalue;
@property (nonatomic) int tidvalue;
@property (nonatomic) int uservalue;
@property (nonatomic) int inventorymode;

@end

