//
//  ReadWriteMemroyViewController.m
//  AT188N_DEMO_1703
//
//  Created by 류은주 on 2017. 5. 31..
//  Copyright © 2017년 ATID. All rights reserved.
//
#define PICKER_VIEW_BANK        0
#define PICKER_VIEW_OFFSET      1
#define PICKER_VIEW_LENGTH      2
#define PICKER_VIEW_POWER_GAIN  3

#define TEXT_FIELD_WRITE_DATA       10
#define TEXT_FIELD_PASSWORD         11

#define MSG_TAG_WAIT        @"Tag memory to Access. Click the button."


#import "ReadWriteMemroyViewController.h"
#import "SWRevealViewController.h"

@interface ReadWriteMemroyViewController ()
{
    AppDelegate *appDelegate;

    NSInteger isEditing;
    UIAlertController *currentAlertView;
    BOOL isActionResult;

    
    BOOL opmode;
    BOOL isReportRSSI;
    
    int inventorytype;
}

@property (weak, nonatomic) IBOutlet UIBarButtonItem *menuopen;
@property (weak, nonatomic) IBOutlet UIButton *readBtn;
@property (weak, nonatomic) IBOutlet UIButton *writeBtn;
@property (weak, nonatomic) IBOutlet UILabel *selectionTagLabel;
@property (weak, nonatomic) IBOutlet UILabel *messageLabel;
@property (weak, nonatomic) IBOutlet UITextField *banktextfield;
@property (weak, nonatomic) IBOutlet UITextField *offsettextfield;
@property (weak, nonatomic) IBOutlet UITextField *lengthtextfield;
@property (weak, nonatomic) IBOutlet UITextField *passwordtextfield;
@property (weak, nonatomic) IBOutlet UITextField *writedatatextfield;
@property (weak, nonatomic) IBOutlet UIPickerView *pickerview;
@property (weak, nonatomic) IBOutlet UILabel *accessdataLabel;
@property (weak, nonatomic) IBOutlet UIView *banktopview;
@property (weak, nonatomic) IBOutlet UIView *offsettopview;
@property (weak, nonatomic) IBOutlet UIView *lengthtopview;
@property (weak, nonatomic) IBOutlet UILabel *rssiLabel;
@property (weak, nonatomic) IBOutlet UILabel *phaseLabel;
@property (weak, nonatomic) IBOutlet UIView *readdatablind;

@property (strong, nonatomic) NSArray *bankPickerData;
@property (strong, nonatomic) NSArray *offsetPickerData;
@property (strong, nonatomic) NSArray *lengthPickerData;
@property (strong, nonatomic) NSArray *bitData;
@property (strong, nonatomic) NSArray *wordData;
@property (strong, nonatomic) NSArray *powerGainPickerData;
@property (readwrite, nonatomic) NSInteger offsetValue;
@property (readwrite, nonatomic) NSInteger lengthValue;
@property (weak, nonatomic) IBOutlet UIButton *startBtn;
@end

@implementation ReadWriteMemroyViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    SWRevealViewController *revealController = self.revealViewController;
    if(revealController)
    {
        [self.menuopen setTarget:self.revealViewController];
        [self.menuopen setAction:@selector(revealToggle:)];
        [self.view addGestureRecognizer:self.revealViewController.panGestureRecognizer];
        //    [revealController panGestureRecognizer];
        [revealController tapGestureRecognizer];

    }
    
//    [AppDelegate showGlobalProgressHUDWithTitle:@"Loading..."];
    HUD = [[MBProgressHUD alloc] initWithView:self.navigationController.view];
    HUD.labelText = @"Loading...";
    [self.navigationController.view addSubview:HUD];
    [HUD show:YES];
    dispatch_async(dispatch_get_global_queue( DISPATCH_QUEUE_PRIORITY_LOW, 0), ^{
        // Do something...
        appDelegate = (AppDelegate *)[[UIApplication sharedApplication] delegate];
        
        [appDelegate.mReader setDelegate:self];
        
        if (appDelegate.mReader == nil) {
            return;
        }
        
        isActionResult = NO;
        
        opmode = 0;
        
        dispatch_async(dispatch_get_main_queue(), ^{

            [self.readBtn setImage:[UIImage imageNamed:@"icon_read_able.png"] forState:UIControlStateNormal];
            [self.writeBtn setImage:[UIImage imageNamed:@"icon_write_disable.png"] forState:UIControlStateNormal];
            [self.startBtn setTitle:@"Read" forState:UIControlStateNormal];
            [self setBank:1];
            [self setOffset:2];
            [self setLength:2];
            [self.pickerview reloadAllComponents];
            self.messageLabel.text = @"Result";
            self.selectionTagLabel.text = MSG_TAG_WAIT;
            
            [AppDelegate dismissGlobalHUD];
            [HUD hide:YES];
            [HUD removeFromSuperview];
        });
    });
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    NSNotificationCenter *center = [NSNotificationCenter defaultCenter];
    [center addObserver:self selector:@selector(BluetoothDisconnected:) name:@"BluetoothDisconnected" object:nil];
    
    
    [appDelegate.mReader setDelegate:self];
    
    dispatch_async(dispatch_get_main_queue(), ^{
    if(opmode == 1){
        [self.readBtn setImage:[UIImage imageNamed:@"icon_read_disable.png"] forState:UIControlStateNormal];
        [self.writeBtn setImage:[UIImage imageNamed:@"icon_write_able.png"] forState:UIControlStateNormal];
        [self.readdatablind setHidden:NO];
        [self.startBtn setTitle:@"Write" forState:UIControlStateNormal];
    }
    });

}
- (void)viewDidAppear:(BOOL)animated {
    [super viewDidAppear:animated];
    //appDelegate.mReader.singleMulti = 1;
}
- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    [[NSNotificationCenter defaultCenter] removeObserver:self name:@"BluetoothDisconnected" object:nil];
}

- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender{
    
}
- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
 #pragma mark - Navigation
 
 // In a storyboard-based application, you will often want to do a little preparation before navigation
 - (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
 // Get the new view controller using [segue destinationViewController].
 // Pass the selected object to the new view controller.
 }
 */
#pragma mark - UIPickerViewDataSource
- (NSInteger)numberOfComponentsInPickerView:(UIPickerView *)pickerView
{
    return 1;
}
- (NSInteger)pickerView:(UIPickerView *)pickerView numberOfRowsInComponent:(NSInteger)component
{
    if (pickerView.tag == PICKER_VIEW_BANK) {
        return self.bankPickerData.count;
    } else if (pickerView.tag == PICKER_VIEW_OFFSET) {
        return self.bitData.count;
    } else if (pickerView.tag == PICKER_VIEW_LENGTH) {
        return self.lengthPickerData.count;
    } else if (pickerView.tag == PICKER_VIEW_POWER_GAIN) {
        return self.powerGainPickerData.count;
    }
    return 0;
}

#pragma mark - UIPickerViewDelegate
- (NSString *)pickerView:(UIPickerView *)pickerView titleForRow:(NSInteger)row forComponent:(NSInteger)component
{
    if (pickerView.tag == PICKER_VIEW_BANK) {
        return [self.bankPickerData objectAtIndex:row];
    } else if (pickerView.tag == PICKER_VIEW_OFFSET) {
        return [self.offsetPickerData objectAtIndex:row];
    } else if (pickerView.tag == PICKER_VIEW_LENGTH) {
        return [self.lengthPickerData objectAtIndex:row];
    } else if (pickerView.tag == PICKER_VIEW_POWER_GAIN) {
        return [self.powerGainPickerData objectAtIndex:row];
    }
    return @"None";
}
#pragma mark - UITextFieldDelegate
-(BOOL) textField:(UITextField *)textField shouldChangeCharactersInRange:(NSRange)range replacementString:(NSString *)string
{
    NSUInteger textlen = [textField.text length] + [string length] - range.length;
    
    if (isEditing == TEXT_FIELD_PASSWORD) {
        if (textlen > MAX_PASSWORD_LENGTH) {
            return NO;
        }
    } else if (isEditing == TEXT_FIELD_WRITE_DATA) {
        if (textlen > MAX_WRITE_DATA_LENGTH) {
            return NO;
        }
    }
    NSCharacterSet* nonHex = [[NSCharacterSet
                               characterSetWithCharactersInString:@"0123456789ABCDEFabcdef"]
                              invertedSet];
    NSRange nonHexRange = [string rangeOfCharacterFromSet:nonHex];
    BOOL isHex = (nonHexRange.location == NSNotFound);
    
    if(isHex){
        NSString *newString = [textField.text stringByReplacingCharactersInRange:range withString:string];
        textField.text = [newString uppercaseString];
    }
    return NO;
}
#pragma mark - Getters
- (NSArray *)bankPickerData {
    return DATA_BANK;
}

- (NSArray *)offsetPickerData {
    if (_offsetPickerData == nil) {
        NSMutableArray *tmpArray = [[NSMutableArray alloc] init];
        for (NSString *offset in self.wordData) {
            [tmpArray addObject:[NSString stringWithFormat:@"%@ WORD", offset]];
        }
        _offsetPickerData = tmpArray;
    }
    return _offsetPickerData;
}
- (NSArray *)lengthPickerData {
    if (_lengthPickerData == nil) {
        NSMutableArray *tmpArray = [[NSMutableArray alloc] init];
        for (NSString *length in self.wordData) {
            [tmpArray addObject:[NSString stringWithFormat:@"%@ WORD", length]];
        }
        _lengthPickerData = tmpArray;
    }
    return _lengthPickerData;
}

- (NSArray *)bitData {
    return DATA_BIT;
}

- (NSArray *)wordData {
    return DATA_WORD;
}
- (IBAction)bankBtnTapped:(id)sender {
    self.pickerview.tag = PICKER_VIEW_BANK;
    [self.pickerview reloadAllComponents];
    
    if (![self.banktextfield.text isEqualToString:@""]) {
        [self.pickerview selectRow:[self.bankPickerData indexOfObject:self.banktextfield.text] inComponent:0 animated:NO];
    } else {
        [self.pickerview selectRow:0 inComponent:0 animated:NO];
    }
    
    self.pickerview.hidden = NO;
    self.offsettopview.hidden = YES;
    self.lengthtopview.hidden = YES;
    self.banktopview.hidden = NO;
    
}
- (IBAction)offsetBtnTapped:(id)sender {
    self.pickerview.tag = PICKER_VIEW_OFFSET;
    [self.pickerview reloadAllComponents];
    
    if (![self.offsettextfield.text isEqualToString:@""]) {
        [self.pickerview selectRow:[self.offsetPickerData indexOfObject:self.offsettextfield.text] inComponent:0 animated:NO];
    } else {
        [self.pickerview selectRow:0 inComponent:0 animated:NO];
    }
    
    self.pickerview.hidden = NO;
    self.lengthtopview.hidden = YES;
    self.banktopview.hidden = YES;
    self.offsettopview.hidden = NO;
}
- (IBAction)lengthBtnTapped:(id)sender {
    self.pickerview.tag = PICKER_VIEW_LENGTH;
    [self.pickerview reloadAllComponents];
    
    if (![self.lengthtextfield.text isEqualToString:@""]) {
        [self.pickerview selectRow:[self.lengthPickerData indexOfObject:self.lengthtextfield.text] inComponent:0 animated:NO];
    } else {
        [self.pickerview selectRow:0 inComponent:0 animated:NO];
    }
    
    self.pickerview.hidden = NO;
    self.banktopview.hidden = YES;
    self.offsettopview.hidden = YES;
    self.lengthtopview.hidden = NO;
}
- (IBAction)passwordBtnTapped:(id)sender {
    isEditing = TEXT_FIELD_PASSWORD;
    UIAlertController *alert = [UIAlertController alertControllerWithTitle:@"Password:" message:@"Please enter password." preferredStyle:UIAlertControllerStyleAlert];
    
    [alert addTextFieldWithConfigurationHandler:^(UITextField *textField) {
        textField.keyboardType = UIKeyboardTypeAlphabet;
        textField.text = self.passwordtextfield.text;
        textField.delegate = self;
    }];
    
    UIAlertAction* ok = [UIAlertAction
                         actionWithTitle:@"OK"
                         style:UIAlertActionStyleDefault
                         handler:^(UIAlertAction * action)
                         {
                             UITextField* textField = alert.textFields.firstObject;
                             [self setPassword:textField.text];
                             
                             [alert dismissViewControllerAnimated:YES completion:nil];
                             
                         }];
    UIAlertAction* cancel = [UIAlertAction
                             actionWithTitle:@"Cancel"
                             style:UIAlertActionStyleDefault
                             handler:^(UIAlertAction * action)
                             {
                                 [alert dismissViewControllerAnimated:YES completion:nil];
                                 
                             }];
    
    [alert addAction:cancel];
    [alert addAction:ok];
    
    
    [self presentViewController:alert animated:YES completion:nil];
}

- (IBAction)writeDataBtnTapped:(id)sender {
    isEditing = TEXT_FIELD_WRITE_DATA;
    
    if(opmode == 0){
        return;
    }
    
    UIAlertController *alert = [UIAlertController alertControllerWithTitle:@"Write Data:" message:@"Please enter write data." preferredStyle:UIAlertControllerStyleAlert];
    
    [alert addTextFieldWithConfigurationHandler:^(UITextField *textField) {
        textField.keyboardType = UIKeyboardTypeAlphabet;
        textField.text = self.writedatatextfield.text;
        textField.delegate = self;
    }];
    
    UIAlertAction* ok = [UIAlertAction
                         actionWithTitle:@"OK"
                         style:UIAlertActionStyleDefault
                         handler:^(UIAlertAction * action)
                         {
                             UITextField* textField = alert.textFields.firstObject;
                             [self setWriteData:textField.text];
                             
                             [alert dismissViewControllerAnimated:YES completion:nil];
                             
                         }];
    UIAlertAction* cancel = [UIAlertAction
                             actionWithTitle:@"Cancel"
                             style:UIAlertActionStyleDefault
                             handler:^(UIAlertAction * action)
                             {
                                 [alert dismissViewControllerAnimated:YES completion:nil];
                                 
                             }];
    
    [alert addAction:cancel];
    [alert addAction:ok];
    
    
    [self presentViewController:alert animated:YES completion:nil];
}
- (IBAction)readmodeBtn:(id)sender {
    opmode = 0;
    [self.readBtn setImage:[UIImage imageNamed:@"icon_read_able.png"] forState:UIControlStateNormal];
    [self.writeBtn setImage:[UIImage imageNamed:@"icon_write_disable.png"] forState:UIControlStateNormal];
    [self.readdatablind setHidden: YES];
    [self.startBtn setTitle:@"Read" forState:UIControlStateNormal];
}
- (IBAction)writemodeBtn:(id)sender {
    opmode = 1;
    [self.readBtn setImage:[UIImage imageNamed:@"icon_read_disable.png"] forState:UIControlStateNormal];
    [self.writeBtn setImage:[UIImage imageNamed:@"icon_write_able.png"] forState:UIControlStateNormal];
    [self.readdatablind setHidden: NO];
    [self.startBtn setTitle:@"Write" forState:UIControlStateNormal];
    self.accessdataLabel.text = @"";
}

- (IBAction)startBtnTapped:(id)sender {
    if(opmode == 0){
       // appDelegate.mReader.singleMulti = 1;
        [self readAction];
    } else {
        [self writeAction];
    }
}
- (IBAction)clearBtnTapped:(id)sender {
    self.selectionTagLabel.text = MSG_TAG_WAIT;
    self.messageLabel.text = @"Result";
    self.accessdataLabel.text = @"";
    
}
- (IBAction)bankTopViewOkTapped:(id)sender {
    NSInteger idx = [self.pickerview selectedRowInComponent:0];
    [self setBank:idx];
    [self hidePickerView];
    
}
- (IBAction)offsetTopViewOkTapped:(id)sender {
    NSInteger idx = [self.pickerview selectedRowInComponent:0];
    [self setOffset:idx];
    [self hidePickerView];
}
- (IBAction)LengthTopViewOkTapped:(id)sender {
    NSInteger idx = [self.pickerview selectedRowInComponent:0];
    [self setLength:idx];
    [self hidePickerView];
}

- (IBAction)topviewcancelTapped:(id)sender {
    [self hidePickerView];
}
#pragma mark - Custom
- (void)hidePickerView {
    self.banktopview.hidden = YES;
    self.offsettopview.hidden = YES;
    self.lengthtopview.hidden = YES;
    self.pickerview.hidden = YES;
}

- (void)setBank:(NSInteger)index {
    self.banktextfield.text = [self.bankPickerData objectAtIndex:index];
}
- (void)setOffset:(NSInteger)index {
    self.offsettextfield.text = [self.offsetPickerData objectAtIndex:index];
    self.offsetValue = index;
}
- (void)setLength:(NSInteger)index {
    self.lengthtextfield.text = [self.lengthPickerData objectAtIndex:index];
    self.lengthValue = index;
}
- (void)setPassword:(NSString *)password {
    self.passwordtextfield.text = password;
}
- (void)setWriteData:(NSString *)writeData {
    self.writedatatextfield.text = writeData;
}

- (void)readAction {
    isActionResult = NO;
    
    self.messageLabel.text = @"Reading tag memory. Please wait…";
    
    BankType bank = (int)[self.bankPickerData indexOfObject:self.banktextfield.text];
    
    NSString *password = self.passwordtextfield.text;
    
    [appDelegate.mReader setAccessPassword:password];
    
    [appDelegate.mReader readMemory:bank offset:(int)self.offsetValue length:(int)self.lengthValue mask:appDelegate.maskstrvalue];
    
    currentAlertView = [UIAlertController alertControllerWithTitle:@"Please wait..." message:@"Reading tag memory" preferredStyle:UIAlertControllerStyleAlert];
    
    
    UIAlertAction* ok = [UIAlertAction
                         actionWithTitle:@"OK"
                         style:UIAlertActionStyleDefault
                         handler:^(UIAlertAction * action)
                         {
                             [self stopAction];
                             if (![currentAlertView isBeingDismissed]){
                             [currentAlertView dismissViewControllerAnimated:YES completion:nil];
                             }
                             
                         }];
    
    [currentAlertView addAction:ok];
    
    
    [self presentViewController:currentAlertView animated:YES completion:nil];
}
- (void)writeAction {
    isActionResult = NO;
    
    // Write Data Validation
    if([self.writedatatextfield.text length] == 0){
        UIAlertController *alert = [UIAlertController alertControllerWithTitle:@"Error" message:@"Please Input a Write Data" preferredStyle:UIAlertControllerStyleAlert];
        
        UIAlertAction* ok = [UIAlertAction
                             actionWithTitle:@"OK"
                             style:UIAlertActionStyleDefault
                             handler:^(UIAlertAction * action)
                             {
                                 [alert dismissViewControllerAnimated:YES completion:nil];
                             }];
        
        [alert addAction:ok];
        
        [self presentViewController:alert animated:YES completion:nil];
        return;

    }
    if ([self.writedatatextfield.text length] % 4 != 0) {
        UIAlertController *alert = [UIAlertController alertControllerWithTitle:@"Error" message:@"Write Data must be entered in WORD unit.(1WORD = 16-bit)" preferredStyle:UIAlertControllerStyleAlert];
        
        UIAlertAction* ok = [UIAlertAction
                             actionWithTitle:@"OK"
                             style:UIAlertActionStyleDefault
                             handler:^(UIAlertAction * action)
                             {
                                 [alert dismissViewControllerAnimated:YES completion:nil];
                             }];
        
        [alert addAction:ok];
        
        [self presentViewController:alert animated:YES completion:nil];
        return;
    }
    
    if ([self.writedatatextfield.text length] / 4 > 32) {
        
        UIAlertController *alert = [UIAlertController alertControllerWithTitle:@"Error" message:@"Write Data cannot be exceed 32WORD.(1WORD = 16-bit)" preferredStyle:UIAlertControllerStyleAlert];
        
        UIAlertAction* ok = [UIAlertAction
                             actionWithTitle:@"OK"
                             style:UIAlertActionStyleDefault
                             handler:^(UIAlertAction * action)
                             {
                                 [alert dismissViewControllerAnimated:YES completion:nil];
                             }];
        
        [alert addAction:ok];
        
        [self presentViewController:alert animated:YES completion:nil];
        return;
    }
    
    
    self.messageLabel.text = @"Writing tag memory.Please wait…";
    
    BankType bank = (int)[self.bankPickerData indexOfObject:self.banktextfield.text];
    
    NSString *password = self.passwordtextfield.text;
    
    // cc 항상 값을 보내 패스워드 메모리를 변경한다......  if (![password isEqualToString:@""])
    [appDelegate.mReader setAccessPassword:password];
    
    [appDelegate.mReader writeMemory:bank offset:(int)self.offsetValue value:self.writedatatextfield.text mask:appDelegate.maskstrvalue];
    
    currentAlertView = [UIAlertController alertControllerWithTitle:@"Please wait..." message:@"Writing tag memory" preferredStyle:UIAlertControllerStyleAlert];
    
    
    UIAlertAction* ok = [UIAlertAction
                         actionWithTitle:@"OK"
                         style:UIAlertActionStyleDefault
                         handler:^(UIAlertAction * action)
                         {
                             [self stopAction];
                             [currentAlertView dismissViewControllerAnimated:YES completion:nil];
                             
                         }];
    
    [currentAlertView addAction:ok];
    
    
    [self presentViewController:currentAlertView animated:YES completion:nil];
    

}
- (void)stopAction {
    [appDelegate.mReader stop];
}


#pragma mark - Reader Event Handler Methods
- (void)deviceStateChange:(ResultType)error {
    if (error != ResultNoError) {
        
        UIAlertController *alert = [UIAlertController alertControllerWithTitle:@"Error" message:@"Failed to get response. Try again." preferredStyle:UIAlertControllerStyleAlert];
        
        UIAlertAction* ok = [UIAlertAction
                             actionWithTitle:@"OK"
                             style:UIAlertActionStyleDefault
                             handler:^(UIAlertAction * action)
                             {
                                 [alert dismissViewControllerAnimated:YES completion:nil];
                             }];
        
        [alert addAction:ok];
        
        [self presentViewController:alert animated:YES completion:nil];
    }
}
- (void)readMemory:(NSString *)tag extradata:(NSString *)extradata {
    
    isActionResult = YES;
    self.messageLabel.text = @"Success";
    self.selectionTagLabel.text = extradata;
    self.accessdataLabel.text = tag;
    if (![currentAlertView isBeingDismissed]){
    [currentAlertView dismissViewControllerAnimated:YES completion:nil];
    }
}
- (void) memoryaccessresult:(int)result{
    isActionResult = YES;
    [self stopAction];
    dispatch_async(dispatch_get_global_queue( DISPATCH_QUEUE_PRIORITY_HIGH, 0), ^{
        dispatch_async(dispatch_get_main_queue(), ^{
            if(result == 0){
                self.messageLabel.text = @"Fail";
            }else if(result == 1){
                self.messageLabel.text = @"Success";
            }else if(result == 2){
                self.messageLabel.text = @"Undefined Error";
            }else if(result == 3){
                self.messageLabel.text = @"Memory Overrun";
            }else if(result == 4){
                self.messageLabel.text = @"Memory Locked";
            }else if(result == 5){
                self.messageLabel.text = @"Insufficient Power";
            }else if(result == 6){
                self.messageLabel.text = @"Non-Specific Error";
            }else {
                self.messageLabel.text = @"TimeOut";
            }
            
            if (![currentAlertView isBeingDismissed]){
            [currentAlertView dismissViewControllerAnimated:YES completion:nil];
            }
        });
    });
    
}
- (void)changedActionState:(CommandType)action {
    NSLog(@"RMV - Changed Action State to : %x", action);
    
    if (action == CommandStop) {
        if (![currentAlertView isBeingDismissed]){
        [currentAlertView dismissViewControllerAnimated:YES completion:nil];
        }
        
        if (isActionResult == NO)
        {
            self.selectionTagLabel.text = MSG_TAG_WAIT;
            self.messageLabel.text = @"Fail to get a data";
        }
        
    }
}

#pragma mark - NSNotification
- (void)BluetoothDisconnected:(NSNotification *)notification {
    if (![currentAlertView isBeingDismissed]){
    [currentAlertView dismissViewControllerAnimated:YES completion:nil];
    }
    dispatch_async(dispatch_get_main_queue(), ^{
        NSLog(@"Read Memory BluetoohDisconnected");
        [self performSegueWithIdentifier:@"RegistDevice" sender:nil];
    });
}

//- (NSString *)stringToHex:(NSString *)string
//{
//    const char *utf8 = [string UTF8String];
//    NSMutableString *hex = [NSMutableString string];
//    while ( *utf8 ) [hex appendFormat:@"%02X" , *utf8++ & 0x00FF];
//    
//    return [NSString stringWithFormat:@"%@", hex];
//}

@end
