//
//  EAPacketManager.h
//  ATIDDemo
//
//  Created by ATID 
//  Copyright (c) 2015년 ATID. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "EADeviceBluetoothLe.h"

// Declare Packet Type Codes
typedef enum {
    PacketSSI = 0x00,                   // '\0'
    PacketResponse = 0x20,              // ' '
    PacketReqSetProperty = 0x77,        // 'w'
    PacketResSetProperty = 0x57,        // 'W'
    PacketReqGetProperty = 0x72,        // 'r'
    PacketResGetProperty = 0x52,        // 'R'
    PacketCommand = 0x61,               // 'a'
    PacketCommandAck = 0x41,            // 'A'
    PacketEvent = 0x65,                 // 'e'
    PacketDebug = 0x64,                 // 'd'
    PacketDebugAck = 0x44,              // 'D'
    PacketErrorAck = 0x45,              // 'E'
} PacketType;

// Declare Property Type Codes
typedef enum {
    PropertyBuzzer = 0x62,              // 'b'
    PropertyContinuousMode = 0x63,      // 'c'
    PropertyAllDefault = 0x64,          // 'd'
    PropertyAntennaStatus = 0x65,       // 'e'
    PropertyGlobalBand = 0x66,          // 'f'
    PropertyPacketOption = 0x69,        // 'i'
    PropertyAntennaSwitchingCount = 0x6B, // 'k'
    PropertyAntennaSwitchingTime = 0x6A, // 'j'
    PropertyFirmwareVersion = 0x76,     // 'v'
    PropertySelectionBank = 0x39,       // '9'
    PropertyStartQ = 0x71,                  //'q'

    PropertyAccessPassword = 0x77,      // 'w'
    PropertyIdleTime = 0x30,            // '0'
    PropertyReaderMode = 0x78,        // 'x'  // cc barcode
    PropertyAutoCommand = 0x79,       //'y'
    PropertyBaudRate = 0x31,             // '1'
    PropertyRepeatTagReportTime = 0x33,  // '3'
    PropertyGPIODelay = 0x34,            // '4'
    PropertyGPIOOutPortStatus = 0x35,    // '5'
    PropertySelectAction = 0x38,      // '8'
    PropertySelectBitPtr = 0x3b,      // ';'
    
    PropertyInventorySession = 0x73,    // 's'
    PropertyMinQ = 0x5B,                // '['
    PropertyMaxQ = 0x5D,                // ']'
    
    PropertyChannelFrequency = 0x42,        // 'B'
    PropertyExtendAll = 0x30,            // '0'
    PropertyPower = 0x31,               // '1'
    PropertyPowerGain = 0x32,           // '2'
    PropertyTypeBC = 0x33,              // '3'
    PropertyBTUSB = 0x34,               // '4'
    PropertySingleMulti = 0x35,           // '5'
    PropertySaveMode = 0x36,            // '6'
    PropertyGetSaveData = 0x61,         // 'a'
    PropertyDeleteSaveData = 0x62,      // 'b'
    PropertyLowBatteryState = 0x39,     // '9'
    PropertyInventoryFormat = 0x38,      // '8'
    
    PropertyAutoOffTime = 0x50,         // 'P'
    
//    PropertyRegion = 0x6E,              // 'n'
  
//    PropertySessionFlag = 0x66,         // 'f'
    PropertyMaskTarget = 0x54,          // 'T'
    PropertyMaskAction = 0x41,          // 'A'
    PropertyMaskBank = 0x42,            // 'B'
    PropertyMaskOffset = 0x4F,          // 'O'
    PropertyMask = 0x4D,                // 'M'

    PropertySerialNo = 0x73,            // 's'

    PropertyTagDataType = 0x23,         // '#'

} PropertyType;

// Declare Sub Command Type Codes
typedef enum {
    CommandInventory = 0x66,    		// 'f'
    CommandInventory6B = 0x62,            // 'b'
    CommandInventoryMemory = 0x69,      // 'i'
    CommandReadMemory = 0x72,    		// 'r'
    CommandWriteMemory = 0x77,          // 'w'
    CommandKill = 0x6B,    				// 'k'
    CommandLock = 0x6C,    				// 'l'
    CommandStop = 0x33,    				// 's'
    CommandLoadStoredTag = 0x4C,        // 'L'
    CommandSaveStoredTag = 0x54,        // 'T'
    CommandRemoveAllStoredTag = 0x44,   // 'D'
} CommandType;

// Declare Event Type Codes
typedef enum {
    EventTagValue = 0x54,               // 'T'
    EventAccessResult = 0x41,           // 'A'
    EventMemoryAccessResult = 0x43,           // 'C' // cc //2016-05-31
    EventOpModeChange = 0x6F,            // 'o' /*ej_ryu*/
    EventPowergainChange = 0x70         //'p' /*ej_ryu*/
} EventType;

// Declare Debug Type Codes
typedef enum {
    DebugMessage = 0x64,                // 'd'
    DebugMode = 0x73,                   // 's'
    DebugBleVer = 0x67,                 // 'g'
    DebugConfig = 0x31,                 // '1'
    DebugFactory = 0x46,                 // 'F'
} DebugType;

// Declare Error Type Codes
typedef enum {
    ErrorModule = 0x45,                 // 'E'
} ErrorType;


@interface EAPacket : NSObject {
@private
    PacketType mPacketType;
    uint8_t mSubType;
    NSCondition *mSync;
    int mTimeoutCount;
}

@property (nonatomic) NSInteger errorCode;
@property (strong, nonatomic) NSData *data;

- (id)initWithPacketType:(PacketType)type subType:(uint8_t)subType;

- (PacketType)type;
- (uint8_t)subType;

- (void)signal;
- (void)wait;

- (BOOL)equalPacket:(PacketType)type subType:(uint8_t)subType;
- (BOOL)checkTimeoutInterval:(int)interval withTimeout:(int)maxTimeout;

@end

@interface EAPacketManager : NSObject {
@private
    NSMutableArray *mPackets;
}

- (void)addPacket:(EAPacket *)packet;
- (void)waitPacket:(EAPacket *)packet;
- (EAPacket *)waitPacket:(PacketType)type subType:(uint8_t)subType;
- (EAPacket *)findPacket:(PacketType)type subType:(uint8_t)subType;
- (EAPacket *)firstPacket;
- (void)removePacket:(EAPacket *)packet;
- (void)checkTimeoutPacket:(int)interval;
- (BOOL)isWaitPacket;

@end
