//
//  EADeviceProtocol.h
//  ATIDDemo
//
//  Created by ATID 
//  Copyright (c) 2015년 ATID. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "EADevice.h"
#import "EARfidValues.h"
#import "EAPacket.h"
#import "EAReaderDelegate.h"

#define WATCHER_INTERVAL        1

@interface EAProtocol288 : NSObject<EADeviceReadDataDelegate> {
@private
    NSCondition *mRecvSync;
    NSThread *mRecvThread;
    NSThread *mWatchThread;
    NSMutableData *mRecvData;
    NSMutableArray *readdata;
    
    EAPacketManager *mPackets;
    CommandType mAction;
    
    EADevice *mDevice;
    //EAReader *mReader;/*ej_ryu*/
    
//    BOOL isBarcodeMode;
    BOOL mIsBarcodeContinueMode;
    BOOL isUserKeyStop;
}

@property (weak, nonatomic) id<EAReaderDelegate> delegate;
@property (nonatomic, assign) BOOL isBarcodeMode;
@property (nonatomic, assign) int dataType; // mDataType        Tag Data Type : ASCII or HEX
@property (nonatomic, assign) int versionCode; // mVersionCode
@property (nonatomic, assign) BOOL isReportRssi; // mIsReportRssi
@property (strong, nonatomic) EAReader *mReader;

- (id)initWithDevice:(EADevice *)device delegate:(id<EAReaderDelegate>)receiver;
- (void)disconnect;

- (CBPeripheral *)peripheral;
- (CommandType)getAction;

- (NSString *)getProperty:(PropertyType)type;
- (NSString *)getYProperty:(PropertyType)type;
- (void)getNProperty:(PropertyType)type;
- (NSString *)getdoubleProperty:(PropertyType)type param:(int)num;
- (NSString *)getXProperty:(PropertyType)type;
- (NSString *)getProperty:(PropertyType)type withParameter:(NSString *)param;
- (ResultType)setProperty:(PropertyType)type;
- (ResultType)setProperty:(PropertyType)type withParameter:(NSString *)param;
- (ResultType)setYProperty:(PropertyType)type withParameter:(NSString *)param;
- (ResultType)setYProperty:(PropertyType)type;
- (ResultType)setdoubleProperty:(PropertyType)type numParam:(int) num withParameter:(NSString *)param;
- (ResultType)command:(CommandType)command;
- (ResultType)command:(CommandType)command withParameter:(NSString *)param;
- (EAResultData *)commandSync:(CommandType)command withParameter:(NSString *)param;
- (ResultType)debug:(DebugType)debugType;
- (ResultType)debug:(DebugType)debugType withParameter:(NSString*)param;
- (EAResultData *)debugSync:(DebugType)command withParameter:(NSString *)param;


- (void) receiveData;
- (void)setScanTime:(int)time;
- (int)getScanTime;
@end
