package com.atid.app.atx.ble.access.lockmemory.dialog;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.atid.app.atx.ble.access.lockmemory.R;
import com.atid.lib.util.StringUtil;
import com.atid.lib.util.diagnotics.ATLog;

import java.util.Locale;

public class NumberDialog extends IntegerDialog {

	private static final String TAG = NumberDialog.class.getSimpleName();
	private static final int INFO = ATLog.L2;

	public NumberDialog() {
		super();
	}

	public NumberDialog(TextView view) {
		super(view);
	}

	@Override
	public void showDialog(Context context, String title, final IValueChangedListener changedListener,
			final ICancelListener cancelListener) {

		if (txtValue != null) {
			if (!txtValue.isEnabled())
				return;
		}

		final InputMethodManager imm = (InputMethodManager) context.getSystemService(Context.INPUT_METHOD_SERVICE);
		LinearLayout root = (LinearLayout) LinearLayout.inflate(context, R.layout.dialog_number, null);
		final EditText edtVal = (EditText) root.findViewById(R.id.value);

		AlertDialog.Builder builder = new AlertDialog.Builder(context);
		builder.setTitle(StringUtil.isNullOrEmpty(title) ? "" : title);
		builder.setView(root);
		builder.setPositiveButton(R.string.action_ok, new DialogInterface.OnClickListener() {

			@Override
			public void onClick(DialogInterface dialog, int which) {
				imm.hideSoftInputFromWindow(edtVal.getWindowToken(), 0);
				
				String value = edtVal.getText().toString();
				if (!StringUtil.isNullOrEmpty(value)) {
					mValue = StringUtil.toInteger(value);
					display();
					if (changedListener != null) {
						changedListener.onValueChanged(NumberDialog.this);
					}
				} else {
					ATLog.e(TAG, "ERROR. showDialog().$PositiveButton.onClick() - Input value is unknown");
					if (cancelListener != null) {
						cancelListener.onCanceled(NumberDialog.this);
					}	

				}
				ATLog.i(TAG, INFO, "INFO. showDialog().$PositiveButton.onClick()");				
			}
		});
		builder.setNegativeButton(R.string.action_cancel, new DialogInterface.OnClickListener() {

			@Override
			public void onClick(DialogInterface dialog, int which) {
				imm.hideSoftInputFromWindow(edtVal.getWindowToken(), 0);
				display();
				if (cancelListener != null) {
					cancelListener.onCanceled(NumberDialog.this);
				}
				ATLog.i(TAG, INFO, "INFO. showDialog().$NegativeButton.onClick()");
			}
		});

		builder.setCancelable(true);
		builder.setOnCancelListener(new DialogInterface.OnCancelListener() {

			@Override
			public void onCancel(DialogInterface dialog) {
				imm.hideSoftInputFromWindow(edtVal.getWindowToken(), 0);
				display();
				if (cancelListener != null) {
					cancelListener.onCanceled(NumberDialog.this);
				}
				ATLog.i(TAG, INFO, "INFO. showDialog().onCancel()");
			}
		});
		AlertDialog dialog = builder.create();
		dialog.setOnShowListener(new DialogInterface.OnShowListener() {

			@Override
			public void onShow(DialogInterface dialog) {
				edtVal.setText(String.format(Locale.US, "%d", mValue));
				edtVal.selectAll();
				edtVal.requestFocus();
				imm.showSoftInput(edtVal, InputMethodManager.SHOW_FORCED);
				ATLog.i(TAG, INFO, "INFO. showDialog().onShow()");
			}
		});
		dialog.setCanceledOnTouchOutside(false);
		dialog.show();

		ATLog.i(TAG, INFO, "INFO. showDialog()");
	}

}
