package com.atid.app.atx.ble.inventory.key.device;

import com.atid.lib.atx88.AT188Reader;
import com.atid.lib.atx88.AT388Reader;
import com.atid.lib.reader.ATEAReader;
import com.atid.lib.transport.ATransport;
import com.atid.lib.transport.ATransportBluetooth;
import com.atid.lib.transport.ATransportBluetoothLe;
import com.atid.lib.transport.ATransportUsb;
import com.atid.lib.transport.types.ConnectType;
import com.atid.lib.types.DeviceType;
import com.atid.lib.util.StringUtil;
import com.atid.lib.util.diagnotics.ATLog;

public class ReaderManager {
	private static final String TAG = ReaderManager.class.getSimpleName();
	
	private static final String DEVTYPE_AT188 = "AT188";
	private static final String DEVTYPE_AT188NP = "AT188NP";
	private static final String DEVTYPE_AT288NS = "AT188NS";
	private static final String DEVTYPE_AT388 = "AT388";
	private static final String DEVTYPE_ATS100 = "ATS100";
	private static final String DEVTYPE_ATS200 = "ATS200";
	private static final String DEVTYPE_ATD100 = "ATD100";
	
	private static ATEAReader mReader = null;
	
	public static DeviceType parseType(String name) {
	
		if (StringUtil.isNullOrEmpty(name))
			return DeviceType.Unknown;
		
		if (name.contains(DEVTYPE_AT188)) {
			return DeviceType.AT188N;
		} else if (name.contains(DEVTYPE_AT188NP)) {
			return DeviceType.AT188NP;
		}else if (name.contains(DEVTYPE_AT288NS)) {
			return DeviceType.AT288NS;
		}else if (name.contains(DEVTYPE_AT388)) {
			return DeviceType.AT388;
		} else if (name.contains(DEVTYPE_ATS100)) {
			return DeviceType.ATS100;
		} else if (name.contains(DEVTYPE_ATS200)) {
			return DeviceType.ATS200;
		}else if (name.contains(DEVTYPE_ATD100)) {
			return DeviceType.ATD100;
		}
		
		return DeviceType.Unknown;
	}
	
	public static ATransport getTransport(ConnectType connType, String name, String address , boolean autoConnect) {
		ATransport transport = null;
		
		DeviceType type = parseType(name);
		
		switch(connType) {
		case Bluetooth :
			transport = new ATransportBluetooth(type, name, address);
			break;

		case BluetoothLe:
			transport = new ATransportBluetoothLe(type, name, address);
			break;

		case USB :
			transport = new ATransportUsb(type, name, address, autoConnect);
			break;
			
		default :
			ATLog.e(TAG, "ERROR. getTransport([%s]) - Failed to not support connect type", connType.toString());
			return null;
		}

		return transport;
	}
	
	public static ATEAReader getReader(ConnectType connType, String name, String address, boolean autoConnect) {
		ATransport transport = null;
		
		if ((transport = getTransport(connType, name, address, autoConnect)) == null) {
			ATLog.e(TAG, "ERROR. getReader(%s) - Unsupported connection type", connType.toString());
			return null;
		}
		
		switch (transport.getDeviceType()) {
			case AT188:
			case AT188N:
			case AT188NP:
				mReader = new AT188Reader(transport);
				break;
			case AT288NS:
			case AT388:
			case ATS100:
			case ATS200:
			case ATD100:
				mReader = new AT388Reader(transport);
				break;

			default:
				if (connType == ConnectType.USB) {
					mReader = new AT388Reader(transport);
				} else {
					ATLog.e(TAG, "ERROR. getReader(%s) - Unsupported device type", name);
					return null;
				}

				break;
		}

		return mReader;
	}
	
	public static ATEAReader getReader(ATransport transport) {
		
		if (transport == null) {
			ATLog.e(TAG, "ERROR. getReader(%s) - transport is null");
			return null;
		}
		
		switch (transport.getDeviceType()) {
		case AT188 :
		case AT188N :
		case AT188NP :
			mReader = new AT188Reader(transport);
			break;
		case AT288NS :
		case AT388 :
		case ATS100 :
		case ATS200 :
		case ATD100 :
			mReader = new AT388Reader(transport);
			break;
			
		default :
			if (transport.getConnectType() == ConnectType.USB) {
				mReader = new AT388Reader(transport);
			} else {
				ATLog.e(TAG, "ERROR. getReader(%s) - Unsupported device type", transport.getDeviceName().toString());
				return null;
			}
			
			break;
		}
		
		return mReader;
	}
	
	public static ATEAReader getReader() {
		return mReader;
	}
}
