package com.atid.app.atx.usb.access.lockmemory;

import java.util.ArrayList;
import java.util.Locale;

import com.atid.app.atx.usb.access.lockmemory.device.ReaderManager;
import com.atid.app.atx.usb.access.lockmemory.dialog.BaseDialog;
import com.atid.app.atx.usb.access.lockmemory.dialog.MessageBox;
import com.atid.app.atx.usb.access.lockmemory.dialog.MessageBoxCancel;
import com.atid.app.atx.usb.access.lockmemory.dialog.PasswordDialog;
import com.atid.app.atx.usb.access.lockmemory.dialog.WaitDialog;
import com.atid.lib.atx88.ATx88Reader;
import com.atid.lib.diagnostics.ATException;
import com.atid.lib.module.rfid.uhf.ATRfidUhf;
import com.atid.lib.module.rfid.uhf.event.IATRfidUhfEventListener;
import com.atid.lib.module.rfid.uhf.params.Lock6cParam;
import com.atid.lib.module.rfid.uhf.params.PermaLock6cParam;
import com.atid.lib.module.rfid.uhf.params.TagExtParam;
import com.atid.lib.reader.ATEAReader;
import com.atid.lib.reader.event.IATEAReaderEventListener;
import com.atid.lib.reader.types.KeyState;
import com.atid.lib.reader.types.KeyType;
import com.atid.lib.reader.types.NotificationState;
import com.atid.lib.reader.types.OperationMode;
import com.atid.lib.reader.types.UsbChargerControl;
import com.atid.lib.reader.types.UsbChargerState;
import com.atid.lib.reader.types.UsbChargerType;
import com.atid.lib.transport.types.ConnectState;
import com.atid.lib.transport.types.ConnectType;
import com.atid.lib.types.ActionState;
import com.atid.lib.types.DeviceType;
import com.atid.lib.types.ResultCode;
import com.atid.lib.util.SysUtil;
import com.atid.lib.util.diagnotics.ATLog;

import android.Manifest;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application.ActivityLifecycleCallbacks;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.os.PowerManager;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.RadioGroup.OnCheckedChangeListener;
import android.widget.TextView;
import android.widget.ToggleButton;

public class MainActivity extends Activity implements OnClickListener, OnCheckedChangeListener,
		IATEAReaderEventListener, IATRfidUhfEventListener{

	private static final String TAG = MainActivity.class.getSimpleName();
	private static final int INFO = ATLog.L1;

	private static final int REQUEST_PERMISSION_CODE = 1000;

	private static final int LOCK_TYPE_UNKNOWN = 0;
	private static final int LOCK_TYPE_LOCK = 1;
	private static final int LOCK_TYPE_UNLOCK = 2;
	private static final int LOCK_TYPE_PERMA_LOCK = 3;

	// ------------------------------------------------------------------------
	// Member Variable
	// ------------------------------------------------------------------------
	private TextView txtVersion;
	private TextView txtDevice;
	private TextView txtAddress;
	
	private TextView txtResult;
	private TextView txtData;
	private TextView txtRssi;
	private TextView txtPhase;

	private ToggleButton tbKillPassword;
	private ToggleButton tbAccessPassword;
	private ToggleButton tbEpc;
	private ToggleButton tbTid;
	private ToggleButton tbUser;

	private TextView txtPassword;
	
	private RadioGroup rgLockType;
	private RadioButton rdLock;
	private RadioButton rdUnlock;
	private RadioButton rdPermaLock;
	
	private PasswordDialog dlgPassword;

	private Button btnAction;
	private Button btnSetting;
	private Button btnClear;
	
	private ATEAReader mReader;
	
	private int mLockType;
	private volatile boolean mIsAction;
	private volatile boolean mIsInitialize;
	private volatile boolean mIsReportRssi;	
	private volatile boolean mIsConnected;
	
	private boolean mIsRunAppHomeButton = true;
	
	private PowerManager.WakeLock mWakeLock;
	private ActivityLifecycleManager mActivityLifecycleCallbacks;
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		
		mActivityLifecycleCallbacks = new ActivityLifecycleManager();
		getApplication().registerActivityLifecycleCallbacks(mActivityLifecycleCallbacks);
		
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);
		
		SysUtil.setContext(this);		// must used the usb device
		
		checkPermission();
		
		ATLog.i(TAG, INFO, "INFO. onCreate()");		
	}

	@SuppressLint("NewApi")
	private void checkPermission() {
		if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
			
			final String[] permissionList = new String[] {
					Manifest.permission.WAKE_LOCK
			};
			
			ArrayList<String> permissions = new ArrayList<String>();
			int grantResult = PackageManager.PERMISSION_GRANTED;
			for (int i = 0 ; i < permissionList.length ; i++) {
				grantResult = ContextCompat.checkSelfPermission(MainActivity.this, permissionList[i]);
				if (grantResult == PackageManager.PERMISSION_DENIED) {
					permissions.add(permissionList[i]);
				}
			}
			
			if (permissions.size() <= 0) {
				onPermissionResult(true);
			} else {
				String[] requestPermissions = new String[permissions.size()];
				//permissions.toArray(requestPermissions);
				ActivityCompat.requestPermissions(this, permissions.toArray(requestPermissions), REQUEST_PERMISSION_CODE);
				                                         
			}
		} else {
			onPermissionResult(true);
		}
	}		
	
	@Override
	protected void onDestroy() {
		
		closeActivity();
		
		if (mReader != null) {
			mReader.removeListener(this);
			mReader.destroy();
		}
		super.onDestroy();
		getApplication().unregisterActivityLifecycleCallbacks(mActivityLifecycleCallbacks);
	}	
	
	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		getMenuInflater().inflate(R.menu.main, menu);
		return true;
	}

	@Override 
	public boolean onPrepareOptionsMenu(Menu menu) {
		ATLog.i(TAG, INFO, "INFO. onPrepareOptionsMenu()");

		MenuItem menuAction = menu.findItem(R.id.menu_action);
		MenuItem menuAutoConnect = menu.findItem(R.id.menu_auto_connect);

		if (mReader != null) {
			
			if (mReader.getDeviceAttached()) {
				menuAction.setEnabled(true);
				menuAutoConnect.setEnabled(true);
				
				if (mReader.getState() == ConnectState.Connected) {
					menuAction.setTitle(R.string.action_disconnect);
				} else {
					menuAction.setTitle(R.string.action_connect);
				}
				
				if (mReader.getAutoConnect()) {
					menuAutoConnect.setTitle(R.string.action_disable_auto_connect);
				} else {
					menuAutoConnect.setTitle(R.string.action_enable_auto_connect);
				}

			} else {
				menuAction.setEnabled(false);
				menuAutoConnect.setEnabled(false);
			}
		} else {
			menuAction.setEnabled(false);
			menuAutoConnect.setEnabled(false);
		}
		
		return super.onPrepareOptionsMenu(menu);
	}
	
	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		int id = item.getItemId();
		switch(id) {
		case R.id.menu_action:
			if (null != mReader) {
				if(mReader.getState() == ConnectState.Connected) {
					mReader.disconnect();
				} else {
					if (!mReader.connect() ) {
						ATLog.e(TAG, "ERROR. onOptionsItemSelected - Failed to connect reader");
						MessageBox.show( this, getString(R.string.msg_not_connect_usb),
								getString(R.string.title_error));
					}
				}				
			}
			return true;

		case R.id.menu_auto_connect:
			if (mReader.getAutoConnect()) {
				mReader.setAutoConnect(false);
			} else {
				mReader.setAutoConnect(true);
			}
			return true;
		default:
			break;
		}
		return super.onOptionsItemSelected(item);
	}
	
	@Override
	public void onUserLeaveHint() {
		
		if (!mIsRunAppHomeButton) {
			if (mReader != null) {
				closeActivity();
			}
		}
		ATLog.i(TAG, INFO, "INFO. onUserLeaveHint()");
		super.onUserLeaveHint();
	}	
	
	@Override
	public void onClick(View v) {
		
		if (!mIsConnected) {
			ATLog.e(TAG, "ERROR - onClick(%d) - Device is not connected !!",v.getId());
			return;
		}
		
		switch(v.getId()) {

		case R.id.password:
			dlgPassword.showDialog(this, R.string.password, new BaseDialog.IValueChangedListener() {
				
				@Override
				public void onValueChanged(BaseDialog dialog) {
					try {
						
						mReader.getRfidUhf().setAccessPassword(((PasswordDialog)dialog).getValue());
					} catch (ATException e) {
						ATLog.e(TAG, e, "ERROR. onClick(R.id.password).$onValueChanged() - Failed to save access password");
					}
				}
			});
			ATLog.i(TAG, INFO, "INFO. onClick() - password");
			break;		

			
		case R.id.action:
			action();
			break;
		case R.id.setting:
			btnAction.setEnabled(false);
			btnClear.setEnabled(false);
			btnSetting.setEnabled(false);

			setting();

			btnAction.setEnabled(true);
			btnClear.setEnabled(true);
			btnSetting.setEnabled(true);
			break;
		case R.id.clear:
			btnAction.setEnabled(false);
			btnSetting.setEnabled(false);
			btnClear.setEnabled(false);

			clear();

			btnAction.setEnabled(true);
			btnSetting.setEnabled(true);
			btnClear.setEnabled(true);
			break;
		}	
	}

	@Override
	public void onCheckedChanged(RadioGroup group, int checkedId) {
		String id="";
		
		switch(checkedId){
		case R.id.type_lock:
			mLockType = LOCK_TYPE_LOCK;
			id = "TYPE_LOCK";
			break;
		case R.id.type_unlock:
			mLockType = LOCK_TYPE_UNLOCK;
			id = "TYPE_UNLOCK";
			break;
		case R.id.type_permalock:
			mLockType = LOCK_TYPE_PERMA_LOCK;
			id = "TYPE_PERMA_LOCK";
			break;
		}
		
		ATLog.i(TAG, INFO, "INFO. onCheckedChanged() - Type[%s]", id);
	}
	
	@Override
	public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
		if (requestCode != REQUEST_PERMISSION_CODE) {
			return;
		}
		
		boolean result = true;
		for (int i = 0 ; i < grantResults.length ; i++) {
			result &= ( grantResults[i] != PackageManager.PERMISSION_DENIED );
		}
		onPermissionResult(result);
	}			
	
	@Override
	public void onActivityResult(int requestCode, int resultCode, Intent data) {
		if (requestCode == RfidOptionActivity.ID) {
			switch (resultCode) {
			case Activity.RESULT_FIRST_USER:
				mIsConnected = false;
				enableWidgets(false);
				closeActivity();
				break;
			case Activity.RESULT_OK:
			case Activity.RESULT_CANCELED:
				// Load Report Rssi
				try {
					mIsReportRssi = mReader.getRfidUhf().getReportRssi();
				} catch (ATException e) {
					ATLog.e(TAG, e, "ERROR. onActivityResult() - Failed to load report rssi");
				}
				
				if (!mIsReportRssi) {
					txtRssi.setText(String.format(Locale.US, "%.2f dB", 0.0));
					txtPhase.setText(String.format(Locale.US, "%.2f \u00B0", 0.0));
				}

				enableWidgets(true);
				break;
			}
			ATLog.i(TAG, INFO, "INFO. onActivityResult() - RfidOptionActivity [%d]" , resultCode);
		} 
		super.onActivityResult(requestCode, resultCode, data);
	}			
	
	private void onPermissionResult(boolean result) {
		
		if (!result) {
			MessageBox.show(this, R.string.msg_fail_permission, R.string.title_error,
					android.R.drawable.ic_dialog_alert, new DialogInterface.OnClickListener() {
						
						@Override
						public void onClick(DialogInterface dialog, int which) {
							MainActivity.this.finish();
							return;
						}
					});
		}
		
		mReader = ReaderManager.getReader(ConnectType.USB, "", "", false);
		if (mReader == null) {
			MessageBox.show(this, R.string.msg_fail_load_reader_instance, 
					R.string.title_error, android.R.drawable.ic_dialog_alert,
					new DialogInterface.OnClickListener() {
				
				@Override
				public void onClick(DialogInterface dialog, int which) {
					MainActivity.this.finish();
					return;
				}
			});
			return;
		}
		// Set Reader Event Listener
		mReader.addListener(this);
		
		dlgPassword = null;
		
		mLockType = LOCK_TYPE_UNKNOWN;

		mIsAction = false;
		mIsInitialize = false;
		mIsConnected = false;
		
		initActivity();

		dlgPassword = new PasswordDialog(txtPassword);
		
		// password
		dlgPassword.setValue("00000000");
		
		clear();
		
		enableWidgets(false);
	}	
		
	// ------------------------------------------------------------------------
	// Reader Event Handler Methods
	// ------------------------------------------------------------------------

	@Override
	public void onReaderStateChanged(ATEAReader reader, ConnectState state, Object params) {
		switch(state) {
		case Connected:
			
			if (mReader.getTransport().getConnectType() == ConnectType.USB) {
				txtDevice.setText(reader.getDeviceType().toString());
				txtAddress.setText(reader.getAddress());
			}
			
			WaitDialog.hide();
			mIsConnected = true;
			loadProperties();
			break;
		case Connecting:
			WaitDialog.show(this, R.string.msg_connecting_usb);
			break;				
		case Disconnected:
			WaitDialog.hide();
			mIsConnected = false;
			enableWidgets(false);
			closeActivity();
			break;
		default:
			break;
		}
		ATLog.i(TAG, INFO, "EVENT. onReaderStateChanged([%s], %s)", reader, state);
		
	}
	
	@Override
	public void onReaderActionChanged(ATEAReader reader, ResultCode code, ActionState action, Object params) {
		if(code != ResultCode.NoError ){
			ATLog.i(TAG, INFO, "ERROR. onReaderActionChanged([%s], %s, %s) - Failed to action changed [%s]",
					reader, code , action, code);
			enableWidgets(true);
			return;
		}
		
		if( action == ActionState.Stop) {
			if(mIsAction) {
				mIsAction = false;
				switch(mLockType ) {
				case LOCK_TYPE_LOCK:
					outputMessage(getString(R.string.msg_fail_lock_tag));
					break;
				case LOCK_TYPE_UNLOCK:
					outputMessage(getString(R.string.msg_fail_unlock_tag));
					break;
				case LOCK_TYPE_PERMA_LOCK:
					outputMessage(getString(R.string.msg_fail_permalock_tag));
					break;
				}
				txtData.setText(getString(R.string.access_data_noti));
				txtRssi.setText(String.format(Locale.US, "%.2f dB", 0.0));
				txtPhase.setText(String.format(Locale.US, "%.2f \u00B0", 0.0));
			}
			btnAction.setText(R.string.action_start);
		} else {
			btnAction.setText(R.string.action_stop);
		}
		enableWidgets(true);

		ATLog.i(TAG, INFO, "EVENT. onReaderActionChanged([%s], %s, %s)", reader, code, action);
	}
	
	@Override
	public void onReaderOperationModeChanged(ATEAReader reader, OperationMode mode, Object params) {

		ATLog.i(TAG, INFO, "EVENT. onReaderOperationModeChanged([%s], %s)", reader, mode);
	}

	@Override
	public void onReaderBatteryState(ATEAReader reader, int batteryState, Object params) {

		ATLog.i(TAG, INFO, "EVENT. onReaderBatteryState([%s], %d)", reader, batteryState);
	}

	@Override
	public void onReaderKeyChanged(ATEAReader reader, KeyType type, KeyState state, Object params) {

		ATLog.i(TAG, INFO, "EVENT. onReaderKeyChanged([%s], %s, %s)", reader, type, state);	
	}
	
	@Override
	public void onReaderUsbChargerChanged(ATEAReader reader, UsbChargerType type, UsbChargerState state, Object params) {

		if (reader.getTransport().getConnectType() == ConnectType.USB) {

			final ATx88Reader x88Reader = (ATx88Reader) reader;
			if (state == UsbChargerState.Insert) {
				
				MessageBoxCancel.show(this, R.string.msg_usb_charigng_on, R.string.title_usb_charging,
						android.R.drawable.ic_menu_info_details, new DialogInterface.OnClickListener() {
							
							@Override
							public void onClick(DialogInterface dialog, int which) {

								try {
									x88Reader.setUsbChargingPhone(UsbChargerControl.Charging);
								} catch (ATException e) {
									ATLog.e(TAG, e, "ERROR. $onReaderUsbChargerChanged().onClick - %s",
											R.string.msg_fail_set_usb_charging);
									MessageBoxCancel.hide();
									showMessage(String.format(Locale.US, "%s\r\nError[%s]",
											getResources().getString(R.string.msg_fail_set_usb_charging), e.getCode()));
									
									return;
								}
								
								MessageBoxCancel.hide();
							}
						}, new DialogInterface.OnCancelListener() {
							
							@Override
							public void onCancel(DialogInterface dialog) {
								try {
									x88Reader.setUsbChargingPhone(UsbChargerControl.NoCharging);
								} catch (ATException e) {
									ATLog.e(TAG, e, "ERROR. $onReaderUsbChargerChanged().onCancel() - %s",
											R.string.msg_fail_set_usb_charging);
									MessageBoxCancel.hide();
									showMessage(String.format(Locale.US, "%s\r\nError[%s]",
											getResources().getString(R.string.msg_fail_set_usb_charging), e.getCode()));
									
									return;
								}

								MessageBoxCancel.hide();
							}
						});

			} else {
				MessageBoxCancel.hide();
			}				
		}
		
		ATLog.i(TAG, INFO, "EVENT. onReaderUsbChargerChanged([%s], %s, %s)", reader, type, state);
	}

	// ------------------------------------------------------------------------
	// RFID Reader Event Handler Methods
	// ------------------------------------------------------------------------
	@Override
	public void onRfidUhfReadTag(ATRfidUhf uhf, String tag, Object params) {

		ATLog.i(TAG, INFO, "EVENT. onReaderReadTag([%s], [%s], [%.2f, %.2f])", mReader, tag);
	}		

	@Override
	public void onRfidUhfAccessResult(ATRfidUhf uhf, ResultCode code, ActionState action, String epc, String data,
			Object params) {

		if(epc != null)
			txtData.setText(epc);
		
		if(code == ResultCode.NoError) {
			outputMessage(getString(R.string.msg_success));
			if(params != null) {
				TagExtParam param = (TagExtParam) params;
				txtRssi.setText(String.format(Locale.US, "%.2f dB", param.getRssiD()));
				txtPhase.setText(String.format(Locale.US, "%.2f \u00B0", param.getPhaseD()));
			}
			
		} else {
			outputMessage(code.getMessage());
			txtRssi.setText(String.format(Locale.US, "%.2f dB", 0.0));
			txtPhase.setText(String.format(Locale.US, "%.2f \u00B0", 0.0));
		}
		
		mIsAction = false;
		
		ATLog.i(TAG, INFO, "EVENT. onRfidUhfAccessResult([%s], [%s], %s, [%s], [%s])", mReader, code, action, epc,
				data);
	}			
	
	@Override
	public void onRfidUhfPowerGainChanged(ATRfidUhf uhf, int power, Object params) {

		ATLog.i(TAG, INFO, "EVENT. onRfidUhfPowerGainChanged([%s], %d)", mReader, power);
	}
	
	// ------------------------------------------------------------------------
	// Internal Widget Control Methods
	// ------------------------------------------------------------------------
	private void initActivity() {
		txtVersion = (TextView) findViewById(R.id.app_version);
		txtVersion.setText(SysUtil.getVersion(this));
		txtDevice = (TextView) findViewById(R.id.device);
		txtAddress = (TextView) findViewById(R.id.address);
		
		txtResult = (TextView) findViewById(R.id.result);
		txtData = (TextView) findViewById(R.id.data);
		txtRssi = (TextView) findViewById(R.id.rssi);
		txtPhase = (TextView) findViewById(R.id.phase);
		
		tbKillPassword = (ToggleButton) findViewById(R.id.tb_kill_password);
		tbAccessPassword = (ToggleButton) findViewById(R.id.tb_access_password);
		tbEpc = (ToggleButton) findViewById(R.id.tb_epc);
		tbTid = (ToggleButton) findViewById(R.id.tb_tid);
		tbUser = (ToggleButton) findViewById(R.id.tb_user);

		txtPassword = (TextView) findViewById(R.id.password);
		txtPassword.setOnClickListener(this);
		
		rgLockType = (RadioGroup) findViewById(R.id.lock_select_type);
		rgLockType.setOnCheckedChangeListener(this);
		
		rdLock = (RadioButton) findViewById(R.id.type_lock);
		rdUnlock = (RadioButton) findViewById(R.id.type_unlock);
		rdPermaLock = (RadioButton) findViewById(R.id.type_permalock);

		btnAction = (Button) findViewById(R.id.action);
		btnAction.setOnClickListener(this);
		btnSetting = (Button) findViewById(R.id.setting);
		btnSetting.setOnClickListener(this);
		btnClear = (Button) findViewById(R.id.clear);
		btnClear.setOnClickListener(this);		
	}
	
	private void closeActivity() {
		WaitDialog.hide();
		
		if (mReader != null) {
			if (mReader.getRfidUhf() != null ) {
				
				if (mReader.getAction() != ActionState.Stop) {
					mReader.getRfidUhf().stop();
					while (mReader.getAction() != ActionState.Stop &&
							mReader.getState() == ConnectState.Connected) {
						
						try {
							ATLog.i(TAG, INFO, "closeActivity() - wait for action stop.");
							Thread.sleep(50);
						} catch (InterruptedException e) {
							ATLog.e(TAG, e, "closeActivity() - Falied to sleep for thread");
						}
					}
				}
				btnAction.setText(R.string.action_start);
				mReader.getRfidUhf().removeListener(this);
			}
		}

		ATLog.i(TAG, INFO, "INFO. closeActivity()");
	}
	
	private void enableWidgets(boolean enabled) {
		
		txtResult.setEnabled(enabled);
		txtData.setEnabled(enabled);
		txtPhase.setEnabled(enabled);
		txtRssi.setEnabled(enabled);
		
		tbKillPassword.setEnabled(enabled);
		tbAccessPassword.setEnabled(enabled);
		tbEpc.setEnabled(enabled);
		tbTid.setEnabled(enabled);
		tbUser.setEnabled(enabled);

		txtPassword.setEnabled(enabled);
		
		rgLockType.setEnabled(enabled);
		rdLock.setEnabled(enabled);
		rdUnlock.setEnabled(enabled);
		rdPermaLock.setEnabled(enabled);

		btnAction.setEnabled(enabled);
		btnSetting.setEnabled(enabled && mReader.getAction() == ActionState.Stop);
		btnClear.setEnabled(enabled && mReader.getAction() == ActionState.Stop);
		
		txtDevice.setEnabled(enabled || mIsConnected);
		txtAddress.setEnabled(enabled || mIsConnected);
		
		ATLog.i(TAG, INFO, "INFO. enableWidgets(%s)", enabled);
	}
	// ------------------------------------------------------------------------
	// Internal Helper Methods
	// ------------------------------------------------------------------------
	public void action() {

		switch(mLockType) {
		case LOCK_TYPE_LOCK:
			actionLock();
			break;
		case LOCK_TYPE_UNLOCK:
			actionUnlock();
			break;
		case LOCK_TYPE_PERMA_LOCK:
			actionPermaLock();
			break;
		}
	}
	
	private void actionLock() {
		ResultCode res = ResultCode.NoError;
		enableWidgets(false);
		
		if(mReader.getAction() == ActionState.Stop) {
			
			Lock6cParam param = new Lock6cParam();
			
			param.setKillPassword(tbKillPassword.isChecked() ? Lock6cParam.LockState.Lock : Lock6cParam.LockState.NoChanged);
			param.setAccessPassword(tbAccessPassword.isChecked() ? Lock6cParam.LockState.Lock : Lock6cParam.LockState.NoChanged);
			param.setEpc(tbEpc.isChecked() ? Lock6cParam.LockState.Lock : Lock6cParam.LockState.NoChanged);
			param.setTid(tbTid.isChecked() ? Lock6cParam.LockState.Lock : Lock6cParam.LockState.NoChanged);
			param.setUser(tbUser.isChecked() ? Lock6cParam.LockState.Lock : Lock6cParam.LockState.NoChanged);
			
			if( (res = mReader.getRfidUhf().lock6c(param, dlgPassword.getValue())) != ResultCode.NoError ) {
				ATLog.e(TAG, "ERROR. actionLock() - Failed to lock memory [%s]", res);
				MessageBox.show(this, String.format(Locale.US, "%s. [%s]", getString(R.string.msg_fail_start_lock),
						res), getString(R.string.title_error) );
				mReader.getRfidUhf().stop();
				return;
			}
			outputMessage(getString(R.string.msg_lock_memory));
			
		} else {
			if( (res = mReader.getRfidUhf().stop()) != ResultCode.NoError) {
				ATLog.e(TAG, "ERROR. actionLock() - Failed to stop operation [%s]", res);
				MessageBox.show(this, String.format(Locale.US, "%s. [%s]", 
						getString(R.string.msg_fail_stop_action), res), getString(R.string.title_error));
				enableWidgets(true);
				return;
			}
		}
		
		mIsAction = true;
		ATLog.i(TAG, INFO, "INFO. actionLock()");
	}	
	
	private void actionUnlock() {
		ResultCode res = ResultCode.NoError;
		enableWidgets(false);
		
		if(mReader.getAction() == ActionState.Stop) {
			
			Lock6cParam param = new Lock6cParam();
			
			param.setKillPassword(tbKillPassword.isChecked() ? Lock6cParam.LockState.Unlock : Lock6cParam.LockState.NoChanged);
			param.setAccessPassword(tbAccessPassword.isChecked() ? Lock6cParam.LockState.Unlock : Lock6cParam.LockState.NoChanged);
			param.setEpc(tbEpc.isChecked() ? Lock6cParam.LockState.Unlock : Lock6cParam.LockState.NoChanged);
			param.setTid(tbTid.isChecked() ? Lock6cParam.LockState.Unlock : Lock6cParam.LockState.NoChanged);
			param.setUser(tbUser.isChecked() ? Lock6cParam.LockState.Unlock : Lock6cParam.LockState.NoChanged);
			
			if( (res = mReader.getRfidUhf().lock6c(param, dlgPassword.getValue())) != ResultCode.NoError ) {
				ATLog.e(TAG, "ERROR. actionUnlock() - Failed to unlock memory [%s]", res);
				MessageBox.show(this, String.format(Locale.US, "%s. [%s]", getString(R.string.msg_fail_start_unlock),
						res), getString(R.string.title_error) );
				mReader.getRfidUhf().stop();
				return;
			}
			outputMessage(getString(R.string.msg_unlock_memory));
			
		} else {
			if( (res = mReader.getRfidUhf().stop()) != ResultCode.NoError) {
				ATLog.e(TAG, "ERROR. actionUnlock() - Failed to stop operation [%s]", res);
				MessageBox.show(this, String.format(Locale.US, "%s. [%s]", 
						getString(R.string.msg_fail_stop_action), res), getString(R.string.title_error));
				enableWidgets(true);
				return;
			}
		}
		
		mIsAction = true;
		ATLog.i(TAG, INFO, "INFO. actionUnlock()");
	}
	
	private void actionPermaLock() {
		ResultCode res = ResultCode.NoError;
		enableWidgets(false);
		
		if(mReader.getAction() == ActionState.Stop) {
			
			PermaLock6cParam param = new PermaLock6cParam();
			
			param.setKillPassword(tbKillPassword.isChecked() ? PermaLock6cParam.LockState.PermalLock :
				PermaLock6cParam.LockState.NoChanged);
			param.setAccessPassword(tbAccessPassword.isChecked() ? PermaLock6cParam.LockState.PermalLock : 
				PermaLock6cParam.LockState.NoChanged);
			param.setEpc(tbEpc.isChecked() ? PermaLock6cParam.LockState.PermalLock : 
				PermaLock6cParam.LockState.NoChanged);
			param.setTid(tbTid.isChecked() ? PermaLock6cParam.LockState.PermalLock : 
				PermaLock6cParam.LockState.NoChanged);
			
			if((res = mReader.getRfidUhf().permaLock6c(param, dlgPassword.getValue())) != ResultCode.NoError){
				ATLog.e(TAG, "ERROR. actionPermaLock() - Failed to permalock memory [%s]", res);
				MessageBox.show(this, String.format(Locale.US, "%s. [%s]", getString(R.string.msg_fail_start_permalock),
						res), getString(R.string.title_error));
				mReader.getRfidUhf().stop();
				return;
			}
			outputMessage(getString(R.string.msg_permalock_memory));
			
		} else {
			if( (res = mReader.getRfidUhf().stop()) != ResultCode.NoError) {
				ATLog.e(TAG, "ERROR. actionPermaLock() - Failed to stop operation [%s]", res);
				MessageBox.show(this, String.format(Locale.US, "%s. [%s]", 
						getString(R.string.msg_fail_stop_action), res), getString(R.string.title_error));
				enableWidgets(true);
				return;
			}
		}
		
		mIsAction = true;
		ATLog.i(TAG, INFO, "INFO. actionPermaLock()");
	}	
	
	private void clear() {
		txtRssi.setText(String.format(Locale.US, "%.2f dB", 0.0));
		txtPhase.setText(String.format(Locale.US, "%.2f \u00B0", 0.0));
		
		txtResult.setText(getString(R.string.access_result));
		txtData.setText(getString(R.string.access_data_noti));
		
		ATLog.i(TAG, INFO, "INFO. clear()");
	}
	
	private void setting() {
		Intent intent = new Intent(this, RfidOptionActivity.class);
		intent.addFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP);

		startActivityForResult(intent, RfidOptionActivity.ID);
		
		ATLog.i(TAG, INFO, "INFO. setting()");
	}	
	
	private void outputMessage(String msg) {
		txtResult.setText(msg);
	}		

	private void showMessage(final String message) {
		runOnUiThread( new Runnable() {
			@Override
			public void run() {
				MessageBox.show(MainActivity.this, message);
			}
		});
		
	}
	
	// ------------------------------------------------------------------------
	// Load RFID Reader Properties
	// ------------------------------------------------------------------------
	private void loadProperties() {
		WaitDialog.show(this, R.string.msg_initialize_view);
		
		Thread thread = new Thread(mLoadingProperties);
		thread.start();
	}
	
	private Runnable mLoadingProperties = new Runnable() {
		@Override
		public void run() {
			mIsInitialize = loadingProperties();
			runOnUiThread(mLoadedProperties);
		}
	};
	
	private Runnable mLoadedProperties = new Runnable() {
		@Override
		public void run() {
			loadedProperties(mIsInitialize);
			WaitDialog.hide();
		}
	};	
	
	private boolean loadingProperties() {
		
		if (mIsConnected) {
			if (mReader.getRfidUhf() == null) {
				ATLog.e(TAG, "ERROR. loadingProperties() - Failed to get rfid instance");
				return false;
			}
		} else {
			ATLog.e(TAG, "ERROR. loadingProperties() - disconnected the usb ");
			return false;
		}
		
		// Set RFID Event Listener
		mReader.getRfidUhf().addListener(this);
		
		// Load Report Rssi
		if (mIsConnected) {
			try {
				mIsReportRssi = mReader.getRfidUhf().getReportRssi();
			} catch (ATException e) {
				ATLog.e(TAG, e, "ERROR. loadingProperties() - Failed to load report rssi");
				return false;
			}
			
		} else {
			ATLog.e(TAG, "ERROR. loadingProperties() - disconnected the usb ");
			return false;
		}
		
		// Disable Use Key Action
		if (mReader.getDeviceType() != DeviceType.ATD100) {
			if (mIsConnected) {
				try {
					mReader.setUseActionKey(false);
				} catch (ATException e) {
					ATLog.e(TAG, "ERROR. loadingProperties() - Failed to enabled key action");
					return false;
				}
			} else {
				ATLog.e(TAG, "ERROR. loadingProperties() - disconnected the usb ");
				return false;
			}			
		}
		
		// Load Password
		String password="";
		if (mIsConnected) {
			try{
				password = mReader.getRfidUhf().getAccessPassword();
			}catch(ATException e){
				ATLog.e(TAG, e, "ERROR. loadingProperties() - Failed to load access password");
				return false;
			}
		} else {
			ATLog.e(TAG, "ERROR. loadingProperties() - disconnected the usb ");
			return false;
		}
		
		// set Password
		dlgPassword.setValue(password);
		
		ATLog.i(TAG, INFO, "INFO. loadingProperties()");
		return true;
	}		
	
	private void loadedProperties(boolean isInitialize) {
		
		if (isInitialize) {
			
			dlgPassword.display();

			if (!mIsReportRssi) {
				txtRssi.setText(String.format(Locale.US, "%.2f dB", 0.0));
				txtPhase.setText(String.format(Locale.US, "%.2f \u00B0", 0.0));
			}
			
			enableWidgets(true);
		} else {
			enableWidgets(false);
		}
		
		rgLockType.check(R.id.type_lock);
		
		ATLog.i(TAG, INFO, "INFO. loadedProperties(%s)", isInitialize);
	}			
	
	// ------------------------------------------------------------------------
	// Activity Life cycle
	// ------------------------------------------------------------------------
	public class ActivityLifecycleManager implements ActivityLifecycleCallbacks {

		private int mRefCount = 0;
		private String _tag = ActivityLifecycleManager.class.getSimpleName();
		
		@SuppressWarnings("deprecation")
		@Override
		public void onActivityStarted(Activity activity) {
			mRefCount++;
			ATLog.i(TAG, INFO, "INFO. ActivityLifecycleManager.onActivityStarted : " + mRefCount);
			
			if(mRefCount == 1) {
				// Setup always wake up
				android.content.Context context = activity.getApplicationContext();
				//SysUtil.wakeLock(activity.getApplicationContext(), SysUtil.getAppName(context));
				
				if(mWakeLock != null) {
					ATLog.i(TAG, INFO, "INFO. Already exist wake lock");
				}
				
				PowerManager powerManager = (PowerManager) context.getSystemService(Context.POWER_SERVICE);
				mWakeLock = powerManager.newWakeLock(PowerManager.FULL_WAKE_LOCK, _tag);
				//mWakeLock = powerManager.newWakeLock(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON, TAG);
				mWakeLock.acquire();
				ATLog.i(TAG, INFO, "INFO. Acquires the wake lock.");
			}
		}
		
		@Override
		public void onActivityStopped(Activity activity) {
			mRefCount--;
			ATLog.i(TAG, INFO, "INFO. ActivityLifecycleManager.onActivityStopped : " + mRefCount);
			
			if(mRefCount == 0) {
				// release WakeLock.
				//SysUtil.wakeUnlock();
				
				if (mWakeLock == null)
					return;

				mWakeLock.release();
				mWakeLock = null;
				ATLog.i(TAG, INFO, "INFO. Releases the wake lock.");
			}
		}

		@Override
		public void onActivityCreated(Activity activity, Bundle savedInstanceState) {}
		@Override
		public void onActivityResumed(Activity activity) {}
		@Override
		public void onActivityPaused(Activity activity) {}
		@Override
		public void onActivitySaveInstanceState(Activity activity, Bundle outState) {}
		@Override
		public void onActivityDestroyed(Activity activity) {}
		
	}	
}
