﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Runtime.CompilerServices;

namespace testApp
{
    public class TagItemList : ObservableCollection<TagItem> { }

    public class TagItem : INotifyPropertyChanged
    {
        private int _no;
        private String _data;
        private float _count;

        public event PropertyChangedEventHandler PropertyChanged;

        public int No { get { return _no; } }
        public String Data { get { return _data; } }
        public float Count { get { return _count; } }

        public TagItem(int no, String data, int count)
        {
            _no = no;
            _data = data;
            _count = count;
        }

        public void Increase()
        {
            _count++;
            PropertyChanged?.Invoke(this, new PropertyChangedEventArgs("Count"));
        }

        public void Update(float rssi, float phase, float channel)
        {
            _count++;
            PropertyChanged?.Invoke(this, new PropertyChangedEventArgs("Count"));
        }

        public override string ToString()
        {
            return $"{_no}, {_data}, {_count}";
        }

        public override bool Equals(object obj)
        {
            if (obj == null)
                return false;

            TagItem tagItem = obj as TagItem;
            if (String.IsNullOrEmpty(tagItem._data))
                return false;

            return _data.Equals(tagItem._data);
        }

        public override int GetHashCode()
        {
            return base.GetHashCode();
        }
    }
}
