#define MCG_WINRT_SUPPORTED
using Mcg.System;
using System;
using System.Collections;
using System.Collections.Generic;
using System.Runtime.CompilerServices;
using System.Runtime.InteropServices;
using System.Runtime.InteropServices.WindowsRuntime;
using global::Windows.Foundation;
using global::Windows.Foundation.Collections;


// -----------------------------------------------------------------------------------------------------------
// 
// WARNING: THIS SOURCE FILE IS FOR 32-BIT BUILDS ONLY!
// 
// MCG GENERATED CODE
// 
// This C# source file is generated by MCG and is added into the application at compile time to support interop features.
// 
// It has three primary components:
// 
// 1. Public type definitions with interop implementation used by this application including WinRT & COM data structures and P/Invokes.
// 
// 2. The '__Interop' class containing marshaling code that acts as a bridge from managed code to native code.
// 
// 3. The 'McgNative' class containing marshaling code and native type definitions that call into native code and are called by native code.
// 
// -----------------------------------------------------------------------------------------------------------
// 
// warning CS0067: The event 'event' is never used
#pragma warning disable 67
// warning CS0169: The field 'field' is never used
#pragma warning disable 169
// warning CS0649: Field 'field' is never assigned to, and will always have its default value 0
#pragma warning disable 414
// warning CS0414: The private field 'field' is assigned but its value is never used
#pragma warning disable 649
// warning CS1591: Missing XML comment for publicly visible type or member 'Type_or_Member'
#pragma warning disable 1591
// warning CS0108 'member1' hides inherited member 'member2'. Use the new keyword if hiding was intended.
#pragma warning disable 108
// warning CS0114 'member1' hides inherited member 'member2'.  To make the current method override that implementation, add the override keyword. Otherwise add the new keyword.
#pragma warning disable 114
// warning CS0659 'type' overrides Object.Equals but does not override GetHashCode.
#pragma warning disable 659
// warning CS0465 Introducing a 'Finalize' method can interfere with destructor invocation. Did you intend to declare a destructor?
#pragma warning disable 465
// warning CS0028 'function declaration' has the wrong signature to be an entry point
#pragma warning disable 28
// warning CS0162 Unreachable code Detected
#pragma warning disable 162
// warning CS0628 new protected member declared in sealed class
#pragma warning disable 628

namespace __Interop
{
	internal static partial class Toolbox
	{
	#if MCG_WINRT_SUPPORTED
	    /// These shared CCW thunk functions can't be put into InternalApis\RH\Include\global::__Interop.McgHelpers.cs due to dependency on EnumeratorToIteratorAdapter or global::Windows.Foundation.Collections.IIterator<T>
	    /// 
	    /// <summary>
	    /// SharedCCW support: Static thunk function for calling methods on IIterator<T>
	    /// </summary>
	    public static object IEnumerableThunk<T>(System.Collections.Generic.IEnumerable<T> enumerable)
	    {
	        return new global::System.Runtime.InteropServices.WindowsRuntime.IIteratorOfT_PrivateCCWAdapter<T>(enumerable.GetEnumerator());
	    }

	    /// These shared CCW thunk functions can't be put into InternalApis\RH\Include\global::__Interop.McgHelpers.cs due to dependency on EnumeratorToIteratorAdapter or global::Windows.Foundation.Collections.IIterator<T>

	    /// <summary>
	    /// SharedCCW support: Static thunk function for calling methods on IIterator<T>
	    /// </summary>
	    public static int IIteratorThunk<T>(Windows.Foundation.Collections.IIterator<T> it, global::System.Runtime.InteropServices.Toolbox.IIterator_Oper oper, ref object item, int len) where T : class
	    {
	        int result = 0;

	        switch (oper)
	        {
	            case global::System.Runtime.InteropServices.Toolbox.IIterator_Oper.get_Current:
	                item = it.get_Current();
	                break;

	            case global::System.Runtime.InteropServices.Toolbox.IIterator_Oper.get_HasCurrent:
	                if (it.get_HasCurrent())
	                {
	                    result = 1;
	                }
	                break;

	            case global::System.Runtime.InteropServices.Toolbox.IIterator_Oper.MoveNext:
	                if (it.MoveNext())
	                {
	                    result = 1;
	                }
	                break;

	            case global::System.Runtime.InteropServices.Toolbox.IIterator_Oper.GetMany:
	                {
	                    T[] array = new T[len];

	                    result = (int)it.GetMany(array);

	                    item = array;
	                }
	                break;

	            default:
	                //Debug.Assert(false, "IIteratorThunk wrong oper");
	                break;
	        }

	        return result;
	    }

	    /// <summary>
	    /// SharedCCW support: Static thunk function for calling methods on IIterator<T>
	    /// </summary>
	    public static global::System.Array IIteratorBlittableThunk<T>(Windows.Foundation.Collections.IIterator<T> it, global::System.Runtime.InteropServices.Toolbox.IIterator_Oper oper, ref T item, ref int len) where T : struct
	    {
	        global::System.Array result = null;

	        switch (oper)
	        {
	            case global::System.Runtime.InteropServices.Toolbox.IIterator_Oper.get_Current:
	                item = it.get_Current();
	                break;

	            case global::System.Runtime.InteropServices.Toolbox.IIterator_Oper.get_HasCurrent:
	                if (it.get_HasCurrent())
	                {
	                    len = 1;
	                }
	                break;

	            case global::System.Runtime.InteropServices.Toolbox.IIterator_Oper.MoveNext:
	                if (it.MoveNext())
	                {
	                    len = 1;
	                }
	                break;

	            case global::System.Runtime.InteropServices.Toolbox.IIterator_Oper.GetMany:
	                {
	                    T[] array = new T[len];

	                    len = (int) it.GetMany(array);

	                    result = array;
	                }
	                break;

	            default:
	                //Debug.Assert(false, "IIteratorThunk wrong oper");
	                break;
	        }

	        return result;
	    }


	    /// <summary>
	    /// SharedCCW support: Static thunk function for calling Invoke method on global::Windows.Foundation.AsyncOperationCompletedHandler<T>
	    /// </summary>
	    public static int AsyncOperationCompletedHandlerThunk<T>(
	        global::Windows.Foundation.AsyncOperationCompletedHandler<T> handler, 
	        global::Windows.Foundation.IAsyncOperation<T> asyncInfo, 
	        global::Windows.Foundation.AsyncStatus asyncStatus
	        )
	    {
	        handler.Invoke(asyncInfo, asyncStatus);

	        return 0;
	    }
	#endif
	}

	#region McgHelpers

	/// <summary>
	/// Helper methods used by MCG. They are typically not safe to be used in System.Private.CoreLib/ProjectK prefast scenarios as
	/// there might be dependencies to System.Private.Interop.dll. Put the safe ones into McgCoreHelpers.cs
	/// </summary>
	internal sealed class McgHelpers
	{
	    /// <summary>
	    /// Failfast for reduced method if the reducer has a bug
	    /// </summary>
	    [global::System.Runtime.CompilerServices.MethodImpl(
	        global::System.Runtime.CompilerServices.MethodImplOptions.NoInlining)]
	    internal static void FailFastForReducedMethod()
	    {
	        // Throwing out a exception so that it is easier to debug (we fail fast now) MCG reducer bugs
	        throw new global::System.InvalidOperationException();
	    }

	    // REM MCG_LOADLIBRARY_SUPPORTED is to avoid triggering WACK (until we got LoadLibrary feature from Windows)
	#if MCG_LOADLIBRARY_SUPPORTED
	    internal class NativeMethods
	    {
	        [DllImport("Kernel32.dll")]
	        internal static extern IntPtr LoadLibraryW(IntPtr name);

	        [DllImport("kernel32.dll")]
	        internal extern static uint FreeLibrary(IntPtr libName);

	        [DllImport("kernel32.dll")]
	        internal extern static IntPtr GetProcAddress(IntPtr hModule, IntPtr entryPoint);

	        [DllImport("kernel32.dll")]
	        internal static extern int GetLastError();
	    }

	    internal class LoadLibraryHelper
	    {
	        [FlagsAttribute]
	        internal enum LoadLibraryFlag
	        {
	            None = 0,
	            Ansi = 1,
	            NoMangle = 2,
	            BestFit = 4,
	            ThrowOnUnmappableChar = 8
	        }

	        const int ERROR_BAD_EXE_FORMAT = 193;
	        /// <summary>
	        /// Find Entry point address through LoadLibrary and GetProcAddress
	        /// </summary>
	        /// <param name="moduleName">native dll name</param>
	        /// <param name="entryPointName">native function name</param>
	        /// <param name="loadLibraryFlag">flags related to LoadLibrary</param>
	        /// <returns>valid function pointer if succee</returns>
	        internal static IntPtr GetEntryPoint(string moduleName, string entryPointName, CallingConvention callingConvention, LoadLibraryFlag loadLibraryFlag)
	        {
	            if (string.IsNullOrEmpty(moduleName))
	                throw new EntryPointNotFoundException(SR.GetString(SR.PInvoke_GetProcAddress_NoName));
	            
	            if (string.IsNullOrEmpty(entryPointName))
	                throw new EntryPointNotFoundException(SR.GetString(SR.PInvoke_GetProcAddress, entryPointName, moduleName));
	            //TODO: Cache this: We don't want call LoadLibrary for every first p/invoke call. Each LoadLibrary
	            IntPtr hMod = LoadLibraryModule(moduleName);
	            IntPtr entryPoint = FindEntryPoint(hMod, entryPointName, callingConvention, loadLibraryFlag);
	            if (entryPoint == IntPtr.Zero)
	              throw new EntryPointNotFoundException(SR.GetString(SR.PInvoke_GetProcAddress, entryPointName, moduleName));
	            return entryPoint;
	        }

	        /// <summary>
	        /// Load Library
	        /// </summary>
	        /// <param name="moduleName">native dll name</param>
	        /// <returns>if fail, return defualt(IntPtr)</returns>
	        private static unsafe IntPtr LoadLibraryModule(string moduleName)
	        {
	            fixed (char* pModuleName = moduleName)
	            {
	                IntPtr hmod = NativeMethods.LoadLibraryW(new IntPtr(pModuleName));
	                if (hmod != IntPtr.Zero)
	                    return hmod;

	                int hr = NativeMethods.GetLastError();
	                if (hr == ERROR_BAD_EXE_FORMAT)
	                {
	                    throw new BadImageFormatException();
	                }
	                else
	                {
	                    string hrMsg = ExternalInterop.GetMessage(hr);
	                    throw new System.DllNotFoundException(String.Format(SR.PInvoke_LoadLib, moduleName, hrMsg));
	                }
	            }
	        }

	        /// <summary>
	        /// Find Entry Point
	        /// </summary>
	        /// <param name="hMod">module address</param>
	        /// <param name="entryPointName">native function name</param>
	        /// <param name="isStdCall">Whether stdcall or not</param>
	        /// <param name="isAnsi">Whether Charset is ansi or not</param>
	        /// <param name="noMangle">Whether ExactSpelling is set</param>
	        /// <param name="bestFit">Whether BestFitMapping is set</param>
	        /// <param name="throwOnUnmappableChar">Whether throw on unmappable char</param>
	        /// <returns>valid function pointer if succeed</returns>
	        private static unsafe IntPtr FindEntryPoint(IntPtr hMod, string entryPointName, CallingConvention callingConvention, LoadLibraryFlag loadLibraryFlag)
	        {
	            // Handle ordinals
	            if (entryPointName[0] == '#')
	            {
	                ushort ordinals;
	                if (ushort.TryParse(entryPointName.Substring(1), out ordinals))
	                    return NativeMethods.GetProcAddress(hMod, new IntPtr(ordinals));
	                return default(IntPtr);
	            }

	            // Just look for the unmangled name.
	            IntPtr pFunc = GetProcAddress(hMod, entryPointName);
	            if (pFunc != IntPtr.Zero || ((loadLibraryFlag & LoadLibraryFlag.NoMangle) == LoadLibraryFlag.NoMangle))
	                return pFunc;

	            // If the program wants the ANSI api or if Unicode APIs are unavailable.
	            // If it is unicode fcn, we are going
	            // to need to check for the 'W' API because it takes precedence over the
	            // unmangled one (on NT some APIs have unmangled ANSI exports).
	            bool isAnsi = (loadLibraryFlag & LoadLibraryFlag.Ansi) == LoadLibraryFlag.Ansi;
	            if (isAnsi)
	            {
	                string newEntryPointName = entryPointName + 'A';
	                pFunc = GetProcAddress(hMod, newEntryPointName);
	                if (pFunc != IntPtr.Zero)
	                    return pFunc;
	            }
	            else
	            {
	                string newEntryPointName = entryPointName + 'W';
	                pFunc = GetProcAddress(hMod, newEntryPointName);
	                if (pFunc != IntPtr.Zero)
	                    return pFunc;
	            }

	            // TODO: try mangled names only for __stdcalls 
	            //if (callingConvention == CallingConvention.StdCall) // also 32 bits X86
	            //{
	            //    string newEntryPointName = '_' + entryPointName + '@';
	            //}

	            return default(IntPtr);
	        }
	        
	        // TODO: For Perf, Consider to stackalloc instead of CoTaskMemAlloc
	        private static unsafe IntPtr GetProcAddress(IntPtr hMod, string entryPointName)
	        {
	            // the correct way is to use Utf8Encoding to convert String to UTF8 byte
	            // the reason why not use Utf8Encoding is that Utf8Encoding will bring a lot stuff to the app and also only few people may find the difference between Utf8 bytes
	            // and ansi bytes for exported function name
	            byte * pNative = McgMarshal.StringToAnsiString(entryPointName, true /*bestFit*/, false /*throwOnUnmappableChar*/);
	            if (pNative != null)
	            {
	                IntPtr pEntryPointName = new IntPtr(pNative);
	                IntPtr pProc = NativeMethods.GetProcAddress(hMod, pEntryPointName);
	                Marshal.FreeCoTaskMem(pEntryPointName);
	                return pProc;
	            }
	            return default(IntPtr);
	        }
	    }
	#endif

	#if MCG_WINRT_SUPPORTED
	    internal unsafe static global::System.IntPtr SystemUri2WindowsFoundationUri(global::System.Uri systemUri)
	    {
	        global::System.RuntimeTypeHandle classFactoryTypeHandle = typeof(global::System.Runtime.InteropServices.IUriRuntimeClassFactory).TypeHandle;
	        //[exclusiveto(Windows.Foundation.Uri)]
	        //[uuid(44A9796F-723E-4FDF-A218-033E75B0C084)]
	        //[version(0x06020000)]  
	        //interface IUriRuntimeClassFactory : IInspectable
	        //{  
	        //    HRESULT CreateUri([in] HSTRING uri, [out] [retval] Windows.Foundation.Uri** instance);
	        //    HRESULT CreateWithRelativeUri([in] HSTRING baseUri, [in] HSTRING relativeUri, [out] [retval] Windows.Foundation.Uri** instance);
	        //}
	        const int idx_CreateUri = 6; // 3 methods (IUnknown) + 3 methods (IInspectable) + 0 (the method index in IUriRuntimeClassFactory)

	        global::System.__ComObject uriRuntimeClassFactory = 
	            global::System.Runtime.InteropServices.McgMarshal.GetActivationFactory(
	                "Windows.Foundation.Uri", 
	                classFactoryTypeHandle
	            );
	        try
	        {
	            string uri = systemUri.OriginalString;
	            global::System.IntPtr instance;
	            fixed (char* pBuffer_uri = uri)
	            {
	                global::System.Runtime.InteropServices.HSTRING unsafe_uri = default(global::System.Runtime.InteropServices.HSTRING);
	                global::System.Runtime.InteropServices.HSTRING_HEADER hstring_header_uri;
	                global::System.Runtime.InteropServices.McgMarshal.StringToHStringReference(pBuffer_uri, uri, &(hstring_header_uri), &(unsafe_uri));

	                void* __pThis = ((void*)global::System.Runtime.InteropServices.McgMarshal.GetInterface(
	                                uriRuntimeClassFactory, 
	                                classFactoryTypeHandle
	                            ));

	                global::System.IntPtr __pTarget = (*(((global::System.IntPtr**)__pThis)))[idx_CreateUri];
	                int __result =  global::System.Runtime.InteropServices.WindowsRuntime.Intrinsics.StdCall__int__(
	                                    __pTarget, 
	                                    __pThis, 
	                                    unsafe_uri, 
	                                    &instance);

	                global::System.Diagnostics.DebugAnnotations.PreviousCallContainsDebuggerStepInCode();
	                global::System.GC.KeepAlive(uriRuntimeClassFactory);
	                if (__result < 0)
	                {
	                    throw global::System.Runtime.InteropServices.McgMarshal.GetExceptionForHR(__result, /* isWinRTScenario = */ true);
	                }
	                return instance;
	            }
	        }
	        catch(global::System.ArgumentException ex)
	        {
	            //
	            // Throwing out the same ArgumentException with the same message as Desktop CLR while keeping 
	            // the inner exception thrown from IUriRuntimeClassFactory.CreateUri
	            //
	            throw new global::System.ArgumentException(
	                "The given System.Uri cannot be converted into a Windows.Foundation.Uri. Please see http://go.microsoft.com/fwlink/?LinkID=215849 for details.", 
	                ex
	                );
	        }
	    }

	    internal unsafe static global::System.Uri WindowsFoundationUri2SystemUri(global::System.IntPtr windowsUri)
	    {
	        //[exclusiveto(Windows.Foundation.Uri)]  
	        //[uuid(9E365E57-48B2-4160-956F-C7385120BBFC)]  
	        //[version(0x06020000)]  
	        //interface IUriRuntimeClass : IInspectable
	        //{  
	        //    [propget] HRESULT AbsoluteUri([out] [retval] HSTRING* value);
	        //    [propget] HRESULT DisplayUri([out] [retval] HSTRING* value);
	        //    [propget] HRESULT Domain([out] [retval] HSTRING* value);
	        //    [propget] HRESULT Extension([out] [retval] HSTRING* value);
	        //    [propget] HRESULT Fragment([out] [retval] HSTRING* value);
	        //    [propget] HRESULT Host([out] [retval] HSTRING* value);
	        //    [propget] HRESULT Password([out] [retval] HSTRING* value);
	        //    [propget] HRESULT Path([out] [retval] HSTRING* value);
	        //    [propget] HRESULT Query([out] [retval] HSTRING* value);
	        //    [propget] HRESULT QueryParsed([out] [retval] Windows.Foundation.WwwFormUrlDecoder** ppWwwFormUrlDecoder);  
	        //    [propget] HRESULT RawUri([out] [retval] HSTRING* value);
	        //    [propget] HRESULT SchemeName([out] [retval] HSTRING* value);
	        //    [propget] HRESULT UserName([out] [retval] HSTRING* value);
	        //    [propget] HRESULT Port([out] [retval] INT32* value);
	        //    [propget] HRESULT Suspicious([out] [retval] boolean* value);
	        //    HRESULT Equals([in] Windows.Foundation.Uri* pUri, [out] [retval] boolean* value);
	        //    HRESULT CombineUri([in] HSTRING relativeUri, [out] [retval] Windows.Foundation.Uri** instance);
	        //}  
	        const int idx_get_RawUri = 16; // 3(IUknown) + 3(IInspectable) + 10th method in IUriRuntimeClass
	        global::System.RuntimeTypeHandle defaultInterfaceTypeHandle = typeof(global::System.Runtime.InteropServices.IUriRuntimeClass).TypeHandle;
	        global::System.Runtime.InteropServices.HSTRING unsafe_value__retval = default(global::System.Runtime.InteropServices.HSTRING);
	        void* __pThis = (void *)windowsUri;
	        string uri;

	        try
	        {
	            global::System.IntPtr __pTarget = (*(((global::System.IntPtr**)__pThis)))[idx_get_RawUri];
	            int __result = global::System.Runtime.InteropServices.WindowsRuntime.Intrinsics.StdCall__int__(
	                __pTarget, 
	                __pThis, 
	                &(unsafe_value__retval)
	            );

	            global::System.Diagnostics.DebugAnnotations.PreviousCallContainsDebuggerStepInCode();
	            
	            if (__result < 0)
	            {
	                throw global::System.Runtime.InteropServices.McgMarshal.GetExceptionForHR(__result, /* isWinRTScenario = */ true);
	            }
	            uri = global::System.Runtime.InteropServices.McgMarshal.HStringToString(unsafe_value__retval);
	        } 
	        finally
	        {
	            // Cleanup
	            global::System.Runtime.InteropServices.McgMarshal.FreeHString(unsafe_value__retval.handle);
	        }

	        if (uri == null) return null;
	        return new global::System.Uri(uri);
	    }
	    
	    internal unsafe static global::System.Uri WindowsFoundationUri2SystemUriForUnbox(global::System.__ComObject windowsUri)
	    {
	        global::System.RuntimeTypeHandle defaultInterfaceTypeHandle = typeof(global::System.Runtime.InteropServices.IUriRuntimeClass).TypeHandle;
	        global::System.IntPtr __pThis = global::System.Runtime.InteropServices.McgMarshal.GetInterface(
	            windowsUri, 
	            defaultInterfaceTypeHandle
	        );
	        global::System.Uri uri = WindowsFoundationUri2SystemUri(__pThis);
	        global::System.GC.KeepAlive(windowsUri);
	        return uri;
	    }

	    /// <summary>
	    /// System.Uri to Windows.Foundation.Uri in boxing
	    /// Used in IInspectable based marshalling
	    /// </summary>
	    internal static object BoxSystemUri(object target)
	    {
	        global::System.Uri systemUri = global::System.Runtime.InteropServices.McgMarshal.FastCast<global::System.Uri>(target);

	        // This throws if the uri cannot be created
	        global::System.IntPtr pUri = global::__Interop.McgHelpers.SystemUri2WindowsFoundationUri(systemUri);

	        try
	        {
	            // @TODO - This potentially can be optimized by skipping the RCW creation
	            return global::System.Runtime.InteropServices.McgMarshal.ComInterfaceToObject_NoUnboxing(
	                pUri, 
	                typeof(global::System.Runtime.InteropServices.__com_IInspectable).TypeHandle
	            ); 
	        }
	        finally
	        {
	            global::System.Runtime.InteropServices.McgMarshal.ComSafeRelease(pUri);
	        }
	    }

	    /// <summary>
	    /// Windows.Foundation.Uri to System.Uri in unboxing
	    /// Used in IInspectable based marshalling
	    /// </summary>
	    internal static object UnboxSystemUri(object target)
	    {
	        global::System.__ComObject windowsUri = (global::System.__ComObject) target;
	        return global::__Interop.McgHelpers.WindowsFoundationUri2SystemUriForUnbox(windowsUri);
	    }
	#endif

	    static global::System.Guid IID_IUnknown = new global::System.Guid(0x00000000, 0x0000, 0x0000, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46);

	    /// <summary>
	    /// Given a AddRef-ed pComPtr, return the add refed identity IUnknown and release the existing pComPtr
	    /// </summary>
	    /// <param name="pComPtr"></param>
	    internal static void GetIUnknownForFactoryReturn(ref global::System.IntPtr pComPtr)
	    {
	        global::System.IntPtr pUnk = global::System.Runtime.InteropServices.McgMarshal.ComQueryInterfaceNoThrow(pComPtr, ref IID_IUnknown);
	        global::System.Runtime.InteropServices.McgMarshal.ComRelease(pComPtr);
	        if (pUnk != default(global::System.IntPtr))
	        {
	            pComPtr = pUnk;
	        }
	        else
	        {
	            pComPtr = default(global::System.IntPtr);
	            throw new global::System.InvalidCastException("Failed to cast to IUnknown");
	        }
	    }

	    internal unsafe static int wcslen(char *str)
	    {
	        char* start = str;
	        while (*str != '\0')
	            str++;
	        
	        return (int) (str - start);
	    }

	    /// <summary>
	    /// CoTaskMemAlloc + ZeroMemory
	    /// @TODO - we can probably optimize the zero memory part later
	    /// </summary>
	    internal unsafe static void* CoTaskMemAllocAndZeroMemory(global::System.IntPtr size)
	    {
	        void *ptr = (void*)global::System.Runtime.InteropServices.PInvokeMarshal.CoTaskMemAlloc(new UIntPtr((void*)size));
	        if (ptr == null)
	            return ptr;

	        byte *pByte = (byte*)ptr;
	        long lSize = size.ToInt64();
	        while (lSize > 0)
	        {
	            lSize--;
	            (*pByte++) = 0;
	        }

	        return ptr;
	    }

	    /// <summary>
	    /// Allocate a buffer with enough size to store the unicode characters saved in source
	    /// Buffer is allocated with CoTaskMemAlloc
	    /// </summary>
	    internal unsafe static void *AllocUnicodeBuffer(string source)
	    {
	        if (source == null)
	            return null;

	        int byteLen = checked((source.Length + 1) * 2);

	        char* pBuf = (char*)global::System.Runtime.InteropServices.PInvokeMarshal.CoTaskMemAlloc(new global::System.UIntPtr((uint)byteLen));
	        if (pBuf == null)
	            throw new global::System.OutOfMemoryException();

	        return pBuf;
	    }

	    /// <summary>
	    /// Copy unicode characters in source into dest, and terminating with null
	    /// </summary>
	    internal unsafe static void CopyUnicodeString(string source, void* _dest)
	    {
	        if (source == null)
	            return;

	        char* dest = (char *)_dest;
	        fixed (char* pSource = source)
	        {
	            int len = source.Length;
	            char* src = pSource;

	            // Copy characters one by one, including the null terminator
	            for (int i = 0; i <= len; ++i)
	            {
	                *(dest++) = *(src++);
	            }
	        }
	    }

	    internal unsafe static ushort* ConvertStringToBSTR(
	            ushort* ptrToFirstCharInBSTR,
	            string strManaged)
	    {
	        if (strManaged == null)
	            return null;

	        if (ptrToFirstCharInBSTR == null)
	        {
	            // If caller don't provided buffer, allocate the buffer and create string using SysAllocStringLen
	            fixed (char* ch = strManaged)
	            {
	                return (ushort*)global::System.Runtime.InteropServices.ExternalInterop.SysAllocStringLen(
	                                    ch,
	                                    (uint)strManaged.Length
	                                );
	            }
	        }
	        else 
	        {
	            // If caller provided a buffer, construct the BSTR manually. 

	            // set length
	            *((int*)ptrToFirstCharInBSTR - 1) = checked(strManaged.Length * 2);

	            // copy characters from the managed string
	            fixed (char* ch = strManaged)
	            {
	                global::System.Runtime.InteropServices.InteropExtensions.Memcpy(
	                    (global::System.IntPtr)ptrToFirstCharInBSTR,
	                    (global::System.IntPtr)ch,
	                    (strManaged.Length + 1) * 2);
	            }

	            return ptrToFirstCharInBSTR;
	        }
	    }

	    internal unsafe static string ConvertBSTRToString(ushort* bstr)
	    {
	        if (bstr == null)
	            return null;
	        return new string((char*)bstr, 0, (int)global::System.Runtime.InteropServices.ExternalInterop.SysStringLen(bstr));
	    }

	    /// <summary>
	    /// Common HRESULT values 
	    /// </summary>
	    internal static class __HResults
	    {
	        internal const int S_OK = unchecked((int)0x00000000);
	        internal const int E_BOUNDS = unchecked((int)0x8000000B);
	        internal const int E_CHANGED_STATE = unchecked((int)0x8000000C);
	        internal const int E_NOTIMPL = unchecked((int)0x80004001);
	        internal const int E_FAIL = unchecked((int)0x80004005);
	        internal const int TYPE_E_TYPEMISMATCH = unchecked((int)0x80028CA0);
	        internal const int DISP_E_OVERFLOW = unchecked((int)0x8002000A);
	    }

	    internal static void AssertAndFailFast(bool condition)
	    {
	        if (condition == false)
	        {
	#if MCG_WINRT_SUPPORTED
	            if (global::System.Diagnostics.Debugger.IsAttached)
	            {
	                global::System.Diagnostics.Debugger.Break();
	            }
	#endif
	            global::System.Environment.FailFast("Assert failed");
	        }
	    }

	#if MCG_WINRT_SUPPORTED

	    [global::System.Runtime.CompilerServices.MethodImpl(
	        global::System.Runtime.CompilerServices.MethodImplOptions.NoInlining)]
	    internal static global::System.Collections.IEnumerator GetNonGenericEnumerator(global::System.__ComObject __this,
	        global::System.RuntimeTypeHandle targetInterfaceType)
	    {
	        return global::System.Runtime.InteropServices.McgMarshal.FastCast<global::System.Collections.IEnumerable>(global::System.Runtime.InteropServices.McgMarshal.GetDynamicAdapter(
	            __this,
	            typeof(global::System.Collections.IEnumerable).TypeHandle,
	            targetInterfaceType
	        )).GetEnumerator();
	    }

	    [global::System.Runtime.CompilerServices.MethodImpl(
	        global::System.Runtime.CompilerServices.MethodImplOptions.NoInlining)]
	    internal static object GetGenericEnumerator(global::System.__ComObject __this, 
	        global::System.RuntimeTypeHandle targetInterfaceType)
	    {
	        return global::System.Runtime.InteropServices.McgMarshal.FastCast<global::System.Collections.IEnumerable>(global::System.Runtime.InteropServices.McgMarshal.GetDynamicAdapter(
	            __this,
	            targetInterfaceType
	        )).GetEnumerator();
	    }

	    [global::System.Runtime.CompilerServices.MethodImpl(
	        global::System.Runtime.CompilerServices.MethodImplOptions.NoInlining)]
	    internal static int GetReadOnlyCollectionCount(global::System.__ComObject __this, 
	        global::System.RuntimeTypeHandle targetInterfaceType)
	    {
	        return global::System.Runtime.InteropServices.McgMarshal.FastCast<global::System.Runtime.InteropServices.WindowsRuntime.IReadOnlyCollectionAdapter>(global::System.Runtime.InteropServices.McgMarshal.GetDynamicAdapter(
	            __this,
	            targetInterfaceType
	        )).Count;
	    }

	    [global::System.Runtime.CompilerServices.MethodImpl(global::System.Runtime.CompilerServices.MethodImplOptions.NoInlining)]
	    internal static global::System.Exception CheckCopyTo(int count, global::System.Array array, int index)
	    {
	        if (array == null)
	            return new global::System.ArgumentNullException("array");

	        if (index < 0)
	            return new global::System.ArgumentOutOfRangeException("index");

	        // ICollection expects the destination array to be single-dimensional.
	        if (array.Rank != 1)
	            throw new global::System.ArgumentException("Multi-dimensional array not supported");

	        if (array.Length <= index && count > 0)
	            return new global::System.ArgumentException("Index out of array bounds");

	        if (array.Length - index < count)
	            return new global::System.ArgumentException("Insufficient space to copy collection");

	        return null;
	    }

	    public static void CopyMapTo<K,V>(global::System.__ComObject _this, int count, global::System.Collections.Generic.KeyValuePair<K, V>[] array, int arrayIndex)
	    {
	        global::System.Exception error = global::__Interop.McgHelpers.CheckCopyTo(count, array, arrayIndex);

	        if (error != null)
	        {
	            throw error;
	        }

	        global::System.Collections.Generic.IEnumerable<System.Collections.Generic.KeyValuePair<K, V>> iterator = _this as global::System.Collections.Generic.IEnumerable<System.Collections.Generic.KeyValuePair<K, V>>;
	        
	        foreach (System.Collections.Generic.KeyValuePair<K, V> mapping in iterator)
	        {
	            array[arrayIndex++] = mapping;
	        }
	    }

	    [global::System.Runtime.CompilerServices.MethodImpl(global::System.Runtime.CompilerServices.MethodImplOptions.NoInlining)]
	    public static bool MapContains<K,V>(global::System.__ComObject _this, global::System.Collections.Generic.KeyValuePair<K, V> item)
	    {
	        global::System.Collections.Generic.IDictionary<K, V> dictionary = _this as global::System.Collections.Generic.IDictionary<K, V>;

	        V value;

	        if (dictionary.TryGetValue(item.Key, out value))
	        {
	            return global::System.Runtime.InteropServices.McgMarshal.ComparerEquals<V>(value, item.Value); 
	        }
	        else
	        {
	            return false;
	        }
	    }

	    [global::System.Runtime.CompilerServices.MethodImpl(global::System.Runtime.CompilerServices.MethodImplOptions.NoInlining)]
	    public static bool MapRemove<K,V>(global::System.__ComObject _this, global::System.Collections.Generic.KeyValuePair<K, V> item)
	    {
	        global::System.Collections.Generic.IDictionary<K, V> dictionary = _this as global::System.Collections.Generic.IDictionary<K, V>;

	        V value;

	        if (dictionary.TryGetValue(item.Key, out value) && global::System.Runtime.InteropServices.McgMarshal.ComparerEquals<V>(value, item.Value))
	        {
	            dictionary.Remove(item.Key);
	            return true;         
	        }
	        return false;
	    }
	#endif
	}

	#endregion

	[global::System.Runtime.InteropServices.McgIntrinsics]
	internal unsafe static partial class Intrinsics
	{
		internal static int StdCall__1(
					global::System.IntPtr pfn, 
					void* pthis, 
					global::System.Runtime.InteropServices.HSTRING arg0, 
					global::System.IntPtr arg1, 
					void* arg2, 
					void* arg3)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static int StdCall__2(
					global::System.IntPtr pfn, 
					void* pthis, 
					void* arg0)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static int StdCall__3(
					global::System.IntPtr pfn, 
					void* pthis, 
					int arg0, 
					void* arg1, 
					void* arg2, 
					int arg3, 
					int arg4, 
					global::System.IntPtr arg5, 
					void* arg6, 
					void* arg7)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static global::System.IntPtr VirtualAddrOf<T>(
					object _this, 
					int __targetIndex)
		{
			return default(global::System.IntPtr);
		}

		internal static string HasThisCall__4(
					object __this, 
					global::System.IntPtr pfn)
		{
			// This method is implemented elsewhere in the toolchain
			return default(string);
		}

		internal static global::System.IntPtr AddrOf<T>(T ftn)
		{
			// This method is implemented elsewhere in the toolchain
			return default(global::System.IntPtr);
		}

		internal static int StdCall__5(
					global::System.IntPtr pfn, 
					void* pthis, 
					void* arg0, 
					global::System.Type__Impl.UnsafeType arg1, 
					void* arg2, 
					global::System.Runtime.InteropServices.HSTRING arg3, 
					void* arg4)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static object HasThisCall__6(
					object __this, 
					global::System.IntPtr pfn, 
					object arg0, 
					global::System.Type arg1, 
					object arg2, 
					string arg3)
		{
			// This method is implemented elsewhere in the toolchain
			return default(object);
		}

		internal static int StdCall__7(
					global::System.IntPtr pfn, 
					void* pthis, 
					global::Windows.Foundation.Point arg0)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static int StdCall__8(
					global::System.IntPtr pfn, 
					void* pthis, 
					void* arg0, 
					void* arg1)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static int StdCall__9(
					global::System.IntPtr pfn, 
					void* pthis, 
					global::System.Runtime.InteropServices.WindowsRuntime.EventRegistrationToken arg0)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static void HasThisCall__10<TArg0>(
					object __this, 
					global::System.IntPtr pfn, 
					object arg0, 
					TArg0 arg1)
		{
			// This method is implemented elsewhere in the toolchain
		}

		internal static int StdCall__11(
					global::System.IntPtr pfn, 
					void* pthis, 
					global::System.IntPtr arg0, 
					void* arg1, 
					void* arg2)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static int StdCall__12(
					global::System.IntPtr pfn, 
					void* pthis)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static int StdCall__13(
					global::System.IntPtr pfn, 
					void* pthis, 
					global::Windows.Foundation.Point arg0, 
					global::Windows.Foundation.Rect arg1, 
					void* arg2)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static int StdCall__14(
					global::System.IntPtr pfn, 
					void* pthis, 
					int arg0, 
					void* arg1)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static int StdCall__15(
					global::System.IntPtr pfn, 
					void* pthis, 
					global::Windows.Foundation.Point arg0, 
					void* arg1)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static int StdCall__16(
					global::System.IntPtr pfn, 
					void* pthis, 
					uint arg0, 
					void* arg1, 
					void* arg2)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static void HasThisCall__17<TArg0, TArg1>(
					object __this, 
					global::System.IntPtr pfn, 
					TArg0 arg0, 
					TArg1 arg1)
		{
			// This method is implemented elsewhere in the toolchain
		}

		internal static int StdCall__18(
					global::System.IntPtr pfn, 
					void* pthis, 
					double arg0)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static int StdCall__19(
					global::System.IntPtr pfn, 
					void* pthis, 
					int arg0)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static int StdCall__20(
					global::System.IntPtr pfn, 
					void* pthis, 
					global::Windows.UI.Xaml.Thickness arg0)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static int StdCall__21(
					global::System.IntPtr pfn, 
					void* pthis, 
					global::Windows.Foundation.Size arg0, 
					void* arg1)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static int StdCall__22(
					global::System.IntPtr pfn, 
					void* pthis, 
					global::System.Runtime.InteropServices.HSTRING arg0, 
					sbyte arg1, 
					void* arg2)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static int StdCall__23(
					global::System.IntPtr pfn, 
					void* pthis, 
					sbyte arg0)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static int StdCall__24(
					global::System.IntPtr pfn, 
					void* pthis, 
					global::System.Runtime.InteropServices.HSTRING arg0, 
					void* arg1)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static int StdCall__25(
					global::System.IntPtr pfn, 
					void* pthis, 
					void* arg0, 
					int arg1)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static int StdCall__26(
					global::System.IntPtr pfn, 
					void* pthis, 
					global::Windows.UI.Xaml.GridLength arg0)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static int StdCall__27(
					global::System.IntPtr pfn, 
					void* pthis, 
					void* arg0, 
					void* arg1, 
					void* arg2)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static int StdCall__28(
					global::System.IntPtr pfn, 
					void* pthis, 
					void* arg0, 
					uint arg1, 
					void* arg2)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static int StdCall__29(
					global::System.IntPtr pfn, 
					void* pthis, 
					global::System.Runtime.InteropServices.HSTRING arg0)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static int StdCall__30(
					global::System.IntPtr pfn, 
					void* pthis, 
					void* arg0, 
					void* arg1, 
					int arg2)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static void HasThisCall__31<TArg0>(
					object __this, 
					global::System.IntPtr pfn, 
					TArg0 arg0)
		{
			// This method is implemented elsewhere in the toolchain
		}

		internal static TResult HasThisCall__32<TResult>(
					object __this, 
					global::System.IntPtr pfn, 
					string arg0)
		{
			// This method is implemented elsewhere in the toolchain
			return default(TResult);
		}

		internal static TResult HasThisCall__33<TResult>(
					object __this, 
					global::System.IntPtr pfn)
		{
			// This method is implemented elsewhere in the toolchain
			return default(TResult);
		}

		internal static bool HasThisCall__34(
					object __this, 
					global::System.IntPtr pfn)
		{
			// This method is implemented elsewhere in the toolchain
			return default(bool);
		}

		internal static global::System.Type HasThisCall__35(
					object __this, 
					global::System.IntPtr pfn)
		{
			// This method is implemented elsewhere in the toolchain
			return default(global::System.Type);
		}

		internal static void HasThisCall__36(
					object __this, 
					global::System.IntPtr pfn, 
					object arg0, 
					object arg1)
		{
			// This method is implemented elsewhere in the toolchain
		}

		internal static void HasThisCall__37(
					object __this, 
					global::System.IntPtr pfn)
		{
			// This method is implemented elsewhere in the toolchain
		}

		internal static int StdCall__38(
					global::System.IntPtr pfn, 
					void* pthis, 
					int arg0, 
					void* arg1, 
					void* arg2)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static int StdCall__39(
					global::System.IntPtr pfn, 
					void* pthis, 
					global::System.Type__Impl.UnsafeType arg0, 
					void* arg1, 
					void* arg2)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static int StdCall__40(
					global::System.IntPtr pfn, 
					void* pthis, 
					global::System.Runtime.InteropServices.HSTRING arg0, 
					int arg1, 
					void* arg2)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static TResult HasThisCall__41<TResult>(
					object __this, 
					global::System.IntPtr pfn, 
					string arg0, 
					global::Windows.Storage.CreationCollisionOption arg1)
		{
			// This method is implemented elsewhere in the toolchain
			return default(TResult);
		}

		internal static int StdCall__42(
					global::System.IntPtr pfn, 
					void* pthis, 
					void* arg0, 
					global::System.Runtime.InteropServices.HSTRING arg1, 
					void* arg2)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static int StdCall__43(
					global::System.IntPtr pfn, 
					void* pthis, 
					void* arg0, 
					global::System.Runtime.InteropServices.HSTRING arg1, 
					int arg2, 
					void* arg3)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static TResult HasThisCall__44<TArg0, TResult>(
					object __this, 
					global::System.IntPtr pfn, 
					TArg0 arg0)
		{
			// This method is implemented elsewhere in the toolchain
			return default(TResult);
		}

		internal static TResult HasThisCall__45<TArg0, TResult>(
					object __this, 
					global::System.IntPtr pfn, 
					TArg0 arg0, 
					string arg1)
		{
			// This method is implemented elsewhere in the toolchain
			return default(TResult);
		}

		internal static TResult HasThisCall__46<TArg0, TResult>(
					object __this, 
					global::System.IntPtr pfn, 
					TArg0 arg0, 
					string arg1, 
					global::Windows.Storage.NameCollisionOption arg2)
		{
			// This method is implemented elsewhere in the toolchain
			return default(TResult);
		}

		internal static int StdCall__47(
					global::System.IntPtr pfn, 
					void* pthis, 
					ulong arg0)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static int StdCall__48(
					global::System.IntPtr pfn, 
					void* pthis, 
					ulong arg0, 
					void* arg1)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static ulong HasThisCall__49(
					object __this, 
					global::System.IntPtr pfn)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static void HasThisCall__50(
					object __this, 
					global::System.IntPtr pfn, 
					ulong arg0)
		{
			// This method is implemented elsewhere in the toolchain
		}

		internal static TResult HasThisCall__51<TResult>(
					object __this, 
					global::System.IntPtr pfn, 
					ulong arg0)
		{
			// This method is implemented elsewhere in the toolchain
			return default(TResult);
		}

		internal static int StdCall__52(
					global::System.IntPtr pfn, 
					void* pthis, 
					void* arg0, 
					uint arg1, 
					global::Windows.Storage.Streams.InputStreamOptions arg2, 
					void* arg3)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static int StdCall__53(
					global::System.IntPtr pfn, 
					void* pthis, 
					uint arg0)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static uint HasThisCall__54(
					object __this, 
					global::System.IntPtr pfn)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static void HasThisCall__55(
					object __this, 
					global::System.IntPtr pfn, 
					uint arg0)
		{
			// This method is implemented elsewhere in the toolchain
		}

		internal static int StdCall__56(
					global::System.IntPtr pfn, 
					void* pthis, 
					void* arg0, 
					uint arg1)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static void HasThisCall__57<TArg0>(
					object __this, 
					global::System.IntPtr pfn, 
					TArg0 arg0, 
					uint arg1)
		{
			// This method is implemented elsewhere in the toolchain
		}

		internal static void HasThisCall__58<TArg0>(
					object __this, 
					global::System.IntPtr pfn, 
					TArg0 arg0, 
					global::Windows.Foundation.AsyncStatus arg1)
		{
			// This method is implemented elsewhere in the toolchain
		}

		internal static int StdCall__59(
					global::System.IntPtr pfn, 
					void* pthis, 
					int arg0, 
					int arg1, 
					global::System.Guid arg2, 
					ulong arg3, 
					global::System.Runtime.InteropServices.HSTRING arg4, 
					ulong arg5)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static int StdCall__60(
					global::System.IntPtr pfn, 
					void* pthis, 
					int arg0, 
					int arg1, 
					global::System.Guid arg2, 
					ulong arg3, 
					int arg4)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static int StdCall__61(
					global::System.IntPtr pfn, 
					void* pthis, 
					int arg0, 
					int arg1, 
					int arg2)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static int StdCall__62(
					global::System.IntPtr pfn, 
					void* pthis, 
					global::System.Runtime.InteropServices.HSTRING arg0, 
					void* arg1, 
					void* arg2)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static int StdCall__63(
					global::System.IntPtr pfn, 
					void* pthis, 
					void* arg0, 
					global::System.IntPtr arg1, 
					uint arg2, 
					global::System.IntPtr arg3, 
					uint arg4, 
					void* arg5)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static int StdCall__64(
					global::System.IntPtr pfn, 
					void* pthis, 
					global::System.IntPtr arg0, 
					void* arg1, 
					global::System.IntPtr arg2, 
					uint arg3, 
					global::System.IntPtr arg4, 
					uint arg5)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static int StdCall__65(
					global::System.IntPtr pfn, 
					void* pthis, 
					global::System.IntPtr arg0)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static int StdCall__66(
					global::System.IntPtr pfn, 
					void* pthis, 
					global::Internal_WinRT_Interop.WinRTCallbacks_DispatcherQueuePriority__System_Private_WinRTInterop_CoreLib arg0, 
					void* arg1, 
					void* arg2)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static int StdCall__67(
					global::System.IntPtr pfn, 
					void* pthis, 
					int arg0, 
					void* arg1, 
					int arg2, 
					void* arg3)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static int StdCall__68(
					global::System.IntPtr pfn, 
					void* pthis, 
					void* arg0, 
					int arg1, 
					void* arg2)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static int StdCall__69(
					global::System.IntPtr pfn, 
					void* pthis, 
					void* arg0, 
					int arg1, 
					short arg2, 
					void* arg3, 
					global::System.IntPtr arg4, 
					global::System.IntPtr arg5, 
					void* arg6)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static int StdCall__70(
					global::System.IntPtr pfn, 
					void* pthis, 
					int arg0, 
					void* arg1, 
					void* arg2, 
					void* arg3, 
					void* arg4)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static int StdCall__71(
					global::System.IntPtr pfn, 
					void* pthis, 
					int arg0, 
					global::System_Runtime_InteropServices_ComTypes.INVOKEKIND__System_Private_Interop arg1, 
					global::System.IntPtr arg2, 
					global::System.IntPtr arg3, 
					global::System.IntPtr arg4)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static int StdCall__72(
					global::System.IntPtr pfn, 
					void* pthis, 
					int arg0, 
					global::System_Runtime_InteropServices_ComTypes.INVOKEKIND__System_Private_Interop arg1, 
					void* arg2)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static void StdCall__73(
					global::System.IntPtr pfn, 
					void* pthis, 
					global::System.IntPtr arg0)
		{
			// This method is implemented elsewhere in the toolchain
		}

		internal static int StdCall__74(
					global::System.IntPtr pfn, 
					void* pthis, 
					void* arg0, 
					int arg1, 
					short arg2, 
					void* arg3, 
					void* arg4, 
					void* arg5)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static int StdCall__75(
					global::System.IntPtr pfn, 
					void* pthis, 
					void* arg0, 
					int arg1, 
					void* arg2, 
					void* arg3)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static int StdCall__76(
					global::System.IntPtr pfn, 
					void* pthis, 
					void* arg0, 
					int arg1, 
					void* arg2, 
					void* arg3, 
					void* arg4)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static int StdCall__77(
					global::System.IntPtr pfn, 
					global::System.IntPtr arg0, 
					global::System.IntPtr arg1, 
					int arg2, 
					global::System.IntPtr arg3, 
					int arg4, 
					void* arg5, 
					void* arg6)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static bool Call__78(
					global::System.IntPtr pfn, 
					global::System.Net.Sockets.SafeCloseSocket__System_Net_Sockets arg0, 
					global::System.IntPtr arg1, 
					int arg2, 
					global::System.IntPtr arg3, 
					int arg4, 
					out int arg5, 
					global::System_Threading.NativeOverlapped__System_Private_CoreLib* arg6)
		{
			arg5 = 0;
			// This method is implemented elsewhere in the toolchain
			return default(bool);
		}

		internal static void StdCall__79(
					global::System.IntPtr pfn, 
					global::System.IntPtr arg0, 
					int arg1, 
					int arg2, 
					int arg3, 
					void* arg4, 
					void* arg5, 
					void* arg6, 
					void* arg7)
		{
			// This method is implemented elsewhere in the toolchain
		}

		internal static void Call__80(
					global::System.IntPtr pfn, 
					global::System.IntPtr arg0, 
					int arg1, 
					int arg2, 
					int arg3, 
					out global::System.IntPtr arg4, 
					out int arg5, 
					out global::System.IntPtr arg6, 
					out int arg7)
		{
			arg4 = default(global::System.IntPtr);
			arg5 = 0;
			arg6 = default(global::System.IntPtr);
			arg7 = 0;
			// This method is implemented elsewhere in the toolchain
		}

		internal static int StdCall__81(
					global::System.IntPtr pfn, 
					global::System.IntPtr arg0, 
					global::System.IntPtr arg1, 
					global::System.IntPtr arg2, 
					int arg3, 
					int arg4, 
					int arg5, 
					void* arg6, 
					void* arg7)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static bool Call__82(
					global::System.IntPtr pfn, 
					global::System.Net.Sockets.SafeCloseSocket__System_Net_Sockets arg0, 
					global::System.Net.Sockets.SafeCloseSocket__System_Net_Sockets arg1, 
					global::System.IntPtr arg2, 
					int arg3, 
					int arg4, 
					int arg5, 
					out int arg6, 
					global::System_Threading.NativeOverlapped__System_Private_CoreLib* arg7)
		{
			arg6 = 0;
			// This method is implemented elsewhere in the toolchain
			return default(bool);
		}

		internal static int StdCall__83(
					global::System.IntPtr pfn, 
					global::System.IntPtr arg0, 
					void* arg1, 
					int arg2, 
					int arg3)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static bool Call__84(
					global::System.IntPtr pfn, 
					global::System.Net.Sockets.SafeCloseSocket__System_Net_Sockets arg0, 
					global::System_Threading.NativeOverlapped__System_Private_CoreLib* arg1, 
					int arg2, 
					int arg3)
		{
			// This method is implemented elsewhere in the toolchain
			return default(bool);
		}

		internal static int StdCall__85(
					global::System.IntPtr pfn, 
					global::System.IntPtr arg0, 
					global::System.IntPtr arg1, 
					int arg2, 
					int arg3)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static bool Call__86(
					global::System.IntPtr pfn, 
					global::System.Net.Sockets.SafeCloseSocket__System_Net_Sockets arg0, 
					global::System.IntPtr arg1, 
					int arg2, 
					int arg3)
		{
			// This method is implemented elsewhere in the toolchain
			return default(bool);
		}

		internal static global::System_Net_Sockets.SocketError__System_Net_Primitives StdCall__87(
					global::System.IntPtr pfn, 
					global::System.IntPtr arg0, 
					global::System.IntPtr arg1, 
					void* arg2, 
					void* arg3, 
					global::System.IntPtr arg4)
		{
			// This method is implemented elsewhere in the toolchain
			return default(global::System_Net_Sockets.SocketError__System_Net_Primitives);
		}

		internal static global::System_Net_Sockets.SocketError__System_Net_Primitives Call__88(
					global::System.IntPtr pfn, 
					global::System.Net.Sockets.SafeCloseSocket__System_Net_Sockets arg0, 
					global::System.IntPtr arg1, 
					out int arg2, 
					global::System_Threading.NativeOverlapped__System_Private_CoreLib* arg3, 
					global::System.IntPtr arg4)
		{
			arg2 = 0;
			// This method is implemented elsewhere in the toolchain
			return default(global::System_Net_Sockets.SocketError__System_Net_Primitives);
		}

		internal static global::System_Net_Sockets.SocketError__System_Net_Primitives StdCall__89(
					global::System.IntPtr pfn, 
					global::System.IntPtr arg0, 
					global::System.IntPtr arg1, 
					void* arg2, 
					global::System.IntPtr arg3, 
					global::System.IntPtr arg4)
		{
			// This method is implemented elsewhere in the toolchain
			return default(global::System_Net_Sockets.SocketError__System_Net_Primitives);
		}

		internal static global::System_Net_Sockets.SocketError__System_Net_Primitives Call__90(
					global::System.IntPtr pfn, 
					global::System.IntPtr arg0, 
					global::System.IntPtr arg1, 
					out int arg2, 
					global::System.IntPtr arg3, 
					global::System.IntPtr arg4)
		{
			arg2 = 0;
			// This method is implemented elsewhere in the toolchain
			return default(global::System_Net_Sockets.SocketError__System_Net_Primitives);
		}

		internal static int StdCall__91(
					global::System.IntPtr pfn, 
					global::System.IntPtr arg0, 
					global::System.IntPtr arg1, 
					int arg2, 
					int arg3, 
					void* arg4, 
					global::System_Net_Sockets.TransmitFileOptions__System_Net_Sockets arg5)
		{
			// This method is implemented elsewhere in the toolchain
			return 0;
		}

		internal static bool Call__92(
					global::System.IntPtr pfn, 
					global::System.Net.Sockets.SafeCloseSocket__System_Net_Sockets arg0, 
					global::System.IntPtr arg1, 
					int arg2, 
					int arg3, 
					global::System_Threading.NativeOverlapped__System_Private_CoreLib* arg4, 
					global::System_Net_Sockets.TransmitFileOptions__System_Net_Sockets arg5)
		{
			// This method is implemented elsewhere in the toolchain
			return default(bool);
		}
	}

	[global::System.Runtime.InteropServices.McgIntrinsics]
	internal unsafe static partial class AddrOfIntrinsics
	{

		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget0(
					global::System.IntPtr a0, 
					global::System.IntPtr a1, 
					global::System.IntPtr a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget1(
					global::System.IntPtr a0, 
					global::System.IntPtr a1);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget2(
					global::System.IntPtr a0, 
					global::System.Runtime.InteropServices.HSTRING* a1);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget3(
					global::System.IntPtr a0, 
					void* a1, 
					global::System.Type__Impl.UnsafeType a2, 
					void* a3, 
					global::System.Runtime.InteropServices.HSTRING a4, 
					void** a5);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget4(
					global::System.IntPtr a0, 
					void* a1, 
					void* a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget5(
					global::System.IntPtr a0, 
					void* a1);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget6(
					global::System.IntPtr a0, 
					global::System.Type__Impl.UnsafeType a1, 
					void** a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget7(
					global::System.IntPtr a0, 
					global::System.Runtime.InteropServices.HSTRING a1, 
					void** a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget8(
					global::System.IntPtr a0, 
					uint* a1, 
					global::Windows.UI.Xaml.Markup.XmlnsDefinition__Impl.UnsafeType** a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget9(
					global::System.IntPtr a0, 
					void** a1);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget10(
					global::System.IntPtr a0, 
					sbyte* a1);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget11(
					global::System.IntPtr a0, 
					global::System.Type__Impl.UnsafeType* a1);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget12(
					global::System.IntPtr a0, 
					void* a1, 
					void* a2, 
					void* a3);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget13(global::System.IntPtr a0);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget14(
					global::System.IntPtr a0, 
					void* a1, 
					void** a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget15(
					global::System.IntPtr a0, 
					int a1, 
					void* a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget16(
					global::System.IntPtr a0, 
					int a1, 
					void* a2, 
					void** a3);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget17(
					global::System.IntPtr a0, 
					void* a1, 
					global::System.Runtime.InteropServices.WindowsRuntime.EventRegistrationToken* a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget18(
					global::System.IntPtr a0, 
					global::System.Runtime.InteropServices.WindowsRuntime.EventRegistrationToken a1);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget19(
					global::System.IntPtr a0, 
					global::System.Runtime.InteropServices.HSTRING a1, 
					global::Windows.Storage.CreationCollisionOption a2, 
					void** a3);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget20(
					global::System.IntPtr a0, 
					global::Windows.Storage.FileAccessMode a1, 
					void** a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget21(
					global::System.IntPtr a0, 
					void* a1, 
					global::System.Runtime.InteropServices.HSTRING a2, 
					void** a3);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget22(
					global::System.IntPtr a0, 
					void* a1, 
					global::System.Runtime.InteropServices.HSTRING a2, 
					global::Windows.Storage.NameCollisionOption a3, 
					void** a4);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget23(
					global::System.IntPtr a0, 
					ulong* a1);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget24(
					global::System.IntPtr a0, 
					ulong a1);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget25(
					global::System.IntPtr a0, 
					ulong a1, 
					void** a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget26(
					global::System.IntPtr a0, 
					void* a1, 
					uint a2, 
					global::Windows.Storage.Streams.InputStreamOptions a3, 
					void** a4);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget27(
					global::System.IntPtr a0, 
					uint* a1);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget28(
					global::System.IntPtr a0, 
					uint a1);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget29(
					global::System.IntPtr a0, 
					void* a1, 
					uint a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget30(
					global::System.IntPtr a0, 
					void* a1, 
					global::Windows.Foundation.AsyncStatus a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget31(
					global::System.IntPtr a0, 
					global::Windows.ApplicationModel.PackageVersion* a1);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget32(
					global::System.IntPtr a0, 
					global::System.IntPtr a1, 
					global::System.Guid* a2, 
					global::System.IntPtr* a3);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget33(
					global::System.IntPtr a0, 
					int a1);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget34(
					global::System.IntPtr a0, 
					global::System.IntPtr* a1);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget35(
					global::System.IntPtr a0, 
					global::System.Guid* a1, 
					global::System.IntPtr a2, 
					uint a3, 
					global::System.IntPtr a4, 
					uint a5, 
					global::System.Guid* a6);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget36(
					global::System.IntPtr a0, 
					global::System.Guid* a1, 
					global::System.IntPtr a2, 
					uint a3, 
					global::System.IntPtr a4, 
					uint a5, 
					uint* a6);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget37(
					global::System.IntPtr a0, 
					global::System.IntPtr a1, 
					global::System.Guid* a2, 
					global::System.IntPtr a3, 
					uint a4, 
					global::System.IntPtr a5, 
					uint a6);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget38(
					global::System.IntPtr a0, 
					global::System.Runtime.InteropServices.Variant* a1);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget39(
					global::System.IntPtr a0, 
					void* a1, 
					short* a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget40(
					global::System.IntPtr a0, 
					global::Internal_WinRT_Interop.WinRTCallbacks_DispatcherQueuePriority__System_Private_WinRTInterop_CoreLib a1, 
					void* a2, 
					short* a3);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget41(
					global::System.__ComObject a0, 
					object a1, 
					global::Windows.UI.Xaml.Input.KeyRoutedEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget42(
					global::System.__ComObject a0, 
					object a1, 
					global::Windows.UI.Xaml.RoutedEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget43(
					global::System.__ComObject a0, 
					object a1, 
					global::Windows.UI.Xaml.DragEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget44(
					global::System.__ComObject a0, 
					object a1, 
					global::Windows.UI.Xaml.Input.PointerRoutedEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget45(
					global::System.__ComObject a0, 
					object a1, 
					global::Windows.UI.Xaml.Input.TappedRoutedEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget46(
					global::System.__ComObject a0, 
					object a1, 
					global::Windows.UI.Xaml.Input.DoubleTappedRoutedEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget47(
					global::System.__ComObject a0, 
					object a1, 
					global::Windows.UI.Xaml.Input.HoldingRoutedEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget48(
					global::System.__ComObject a0, 
					object a1, 
					global::Windows.UI.Xaml.Input.RightTappedRoutedEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget49(
					global::System.__ComObject a0, 
					object a1, 
					global::Windows.UI.Xaml.Input.ManipulationStartingRoutedEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget50(
					global::System.__ComObject a0, 
					object a1, 
					global::Windows.UI.Xaml.Input.ManipulationInertiaStartingRoutedEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget51(
					global::System.__ComObject a0, 
					object a1, 
					global::Windows.UI.Xaml.Input.ManipulationStartedRoutedEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget52(
					global::System.__ComObject a0, 
					object a1, 
					global::Windows.UI.Xaml.Input.ManipulationDeltaRoutedEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget53(
					global::System.__ComObject a0, 
					object a1, 
					global::Windows.UI.Xaml.Input.ManipulationCompletedRoutedEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget54(
					global::System.__ComObject a0, 
					global::Windows.UI.Xaml.UIElement a1, 
					global::Windows.UI.Xaml.DragStartingEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget55(
					global::System.__ComObject a0, 
					global::Windows.UI.Xaml.UIElement a1, 
					global::Windows.UI.Xaml.DropCompletedEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget56(
					global::System.__ComObject a0, 
					global::Windows.UI.Xaml.UIElement a1, 
					global::Windows.UI.Xaml.Input.ContextRequestedEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget57(
					global::System.__ComObject a0, 
					global::Windows.UI.Xaml.UIElement a1, 
					global::Windows.UI.Xaml.RoutedEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget58(
					global::System.__ComObject a0, 
					global::Windows.UI.Xaml.UIElement a1, 
					global::Windows.UI.Xaml.Input.AccessKeyDisplayRequestedEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget59(
					global::System.__ComObject a0, 
					global::Windows.UI.Xaml.UIElement a1, 
					global::Windows.UI.Xaml.Input.AccessKeyDisplayDismissedEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget60(
					global::System.__ComObject a0, 
					global::Windows.UI.Xaml.UIElement a1, 
					global::Windows.UI.Xaml.Input.AccessKeyInvokedEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget61(
					global::System.__ComObject a0, 
					global::Windows.UI.Xaml.UIElement a1, 
					global::Windows.UI.Xaml.Input.GettingFocusEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget62(
					global::System.__ComObject a0, 
					global::Windows.UI.Xaml.UIElement a1, 
					global::Windows.UI.Xaml.Input.LosingFocusEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget63(
					global::System.__ComObject a0, 
					global::Windows.UI.Xaml.UIElement a1, 
					global::Windows.UI.Xaml.Input.NoFocusCandidateFoundEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget64(
					global::System.__ComObject a0, 
					global::Windows.UI.Xaml.UIElement a1, 
					global::Windows.UI.Xaml.Input.CharacterReceivedRoutedEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget65(
					global::System.__ComObject a0, 
					global::Windows.UI.Xaml.UIElement a1, 
					global::Windows.UI.Xaml.Input.ProcessKeyboardAcceleratorEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget66(
					global::System.__ComObject a0, 
					global::Windows.UI.Xaml.UIElement a1, 
					global::Windows.UI.Xaml.BringIntoViewRequestedEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget67(
					global::System.__ComObject a0, 
					object a1, 
					global::Windows.UI.Xaml.SizeChangedEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget68(
					global::System.__ComObject a0, 
					global::Windows.UI.Xaml.FrameworkElement a1, 
					global::Windows.UI.Xaml.DataContextChangedEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget69(
					global::System.__ComObject a0, 
					global::Windows.UI.Xaml.FrameworkElement a1, 
					object a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget70(
					global::System.__ComObject a0, 
					object a1, 
					global::Windows.UI.Xaml.DependencyPropertyChangedEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget71(
					global::System.__ComObject a0, 
					global::Windows.UI.Xaml.Controls.Control a1, 
					global::Windows.UI.Xaml.Controls.FocusEngagedEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget72(
					global::System.__ComObject a0, 
					global::Windows.UI.Xaml.Controls.Control a1, 
					global::Windows.UI.Xaml.Controls.FocusDisengagedEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget73(
					global::System.__ComObject a0, 
					global::Windows.Foundation.Collections.IObservableVector<object> a1, 
					global::Windows.Foundation.Collections.IVectorChangedEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget74(
					global::System.__ComObject a0, 
					object a1, 
					global::Windows.UI.Xaml.Controls.SelectionChangedEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget75(
					global::System.__ComObject a0, 
					object a1, 
					global::Windows.UI.Xaml.Controls.ItemClickEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget76(
					global::System.__ComObject a0, 
					object a1, 
					global::Windows.UI.Xaml.Controls.DragItemsStartingEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget77(
					global::System.__ComObject a0, 
					global::Windows.UI.Xaml.Controls.ListViewBase a1, 
					global::Windows.UI.Xaml.Controls.ContainerContentChangingEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget78(
					global::System.__ComObject a0, 
					global::Windows.UI.Xaml.Controls.ListViewBase a1, 
					global::Windows.UI.Xaml.Controls.DragItemsCompletedEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget79(
					global::System.__ComObject a0, 
					global::Windows.UI.Xaml.Controls.ListViewBase a1, 
					global::Windows.UI.Xaml.Controls.ChoosingItemContainerEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget80(
					global::System.__ComObject a0, 
					global::Windows.UI.Xaml.Controls.ListViewBase a1, 
					global::Windows.UI.Xaml.Controls.ChoosingGroupHeaderContainerEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget81(
					global::System.__ComObject a0, 
					object a1, 
					global::Windows.UI.Xaml.Controls.ContextMenuEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget82(
					global::System.__ComObject a0, 
					global::Windows.UI.Xaml.Controls.TextBlock a1, 
					global::Windows.UI.Xaml.Controls.IsTextTrimmedChangedEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget83(
					global::System.__ComObject a0, 
					object a1, 
					global::Windows.UI.Xaml.Controls.TextChangedEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget84(
					global::System.__ComObject a0, 
					object a1, 
					global::Windows.UI.Xaml.Controls.TextControlPasteEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget85(
					global::System.__ComObject a0, 
					global::Windows.UI.Xaml.Controls.TextBox a1, 
					global::Windows.UI.Xaml.Controls.TextCompositionStartedEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget86(
					global::System.__ComObject a0, 
					global::Windows.UI.Xaml.Controls.TextBox a1, 
					global::Windows.UI.Xaml.Controls.TextCompositionChangedEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget87(
					global::System.__ComObject a0, 
					global::Windows.UI.Xaml.Controls.TextBox a1, 
					global::Windows.UI.Xaml.Controls.TextCompositionEndedEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget88(
					global::System.__ComObject a0, 
					global::Windows.UI.Xaml.Controls.TextBox a1, 
					global::Windows.UI.Xaml.Controls.CandidateWindowBoundsChangedEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget89(
					global::System.__ComObject a0, 
					global::Windows.UI.Xaml.Controls.TextBox a1, 
					global::Windows.UI.Xaml.Controls.TextBoxTextChangingEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget90(
					global::System.__ComObject a0, 
					global::Windows.UI.Xaml.Controls.TextBox a1, 
					global::Windows.UI.Xaml.Controls.TextControlCopyingToClipboardEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget91(
					global::System.__ComObject a0, 
					global::Windows.UI.Xaml.Controls.TextBox a1, 
					global::Windows.UI.Xaml.Controls.TextControlCuttingToClipboardEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget92(
					global::System.__ComObject a0, 
					global::Windows.UI.Xaml.Controls.TextBox a1, 
					global::Windows.UI.Xaml.Controls.TextBoxBeforeTextChangingEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget93(
					global::System.__ComObject a0, 
					global::Windows.UI.Xaml.ApplicationInitializationCallbackParams a1);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget94(
					global::System.__ComObject a0, 
					object a1, 
					global::Windows.UI.Xaml.UnhandledExceptionEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget95(
					global::System.__ComObject a0, 
					object a1, 
					global::Windows.ApplicationModel.SuspendingEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget96(
					global::System.__ComObject a0, 
					object a1, 
					global::Windows.ApplicationModel.LeavingBackgroundEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget97(
					global::System.__ComObject a0, 
					object a1, 
					global::Windows.ApplicationModel.EnteredBackgroundEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget98(
					global::System.__ComObject a0, 
					global::Windows.Foundation.Collections.IObservableMap<string, string> a1, 
					global::Windows.Foundation.Collections.IMapChangedEventArgs<string> a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget99(global::System.__ComObject a0);

		#endif

		public delegate int AddrOfTarget100<T>(
					global::Windows.Foundation.AsyncOperationCompletedHandler<T> a0, 
					global::Windows.Foundation.IAsyncOperation<T> a1, 
					global::Windows.Foundation.AsyncStatus a2);


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget101(
					global::System.__ComObject a0, 
					global::Windows.Foundation.IAsyncOperation<global::Windows.Storage.IStorageItem> a1, 
					global::Windows.Foundation.AsyncStatus a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget102(
					global::System.__ComObject a0, 
					object a1, 
					global::Windows.Foundation.Diagnostics.TracingStatusChangedEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget103(
					global::System.__ComObject a0, 
					object a1, 
					global::Windows.UI.Xaml.Navigation.NavigationEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget104(
					global::System.__ComObject a0, 
					object a1, 
					global::Windows.UI.Xaml.Navigation.NavigatingCancelEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget105(
					global::System.__ComObject a0, 
					object a1, 
					global::Windows.UI.Xaml.Navigation.NavigationFailedEventArgs a2);

		#endif

		public delegate int AddrOfTarget106<T>(
					global::System.Collections.Generic.IList<T> a0, 
					global::System.Runtime.InteropServices.Toolbox.IList_Oper a1, 
					int a2, 
					ref object a3);

		public delegate object AddrOfTarget107<T>(global::System.Collections.Generic.IEnumerable<T> a0);

		public delegate int AddrOfTarget108<T>(
					global::Windows.Foundation.Collections.IIterator<T> a0, 
					global::System.Runtime.InteropServices.Toolbox.IIterator_Oper a1, 
					ref object a2, 
					int a3);

		public delegate int AddrOfTarget109<T>(
					global::System.Collections.Generic.IReadOnlyList<T> a0, 
					global::System.Runtime.InteropServices.Toolbox.IList_Oper a1, 
					int a2, 
					ref T a3);


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget110(
					global::System.__ComObject a0, 
					global::Windows.Foundation.IAsyncOperationWithProgress<global::Windows.Storage.Streams.IBuffer, uint> a1, 
					uint a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget111(
					global::System.__ComObject a0, 
					global::Windows.Foundation.IAsyncOperationWithProgress<global::Windows.Storage.Streams.IBuffer, uint> a1, 
					global::Windows.Foundation.AsyncStatus a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget112(
					global::System.__ComObject a0, 
					global::Windows.Foundation.IAsyncOperationWithProgress<uint, uint> a1, 
					uint a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget113(
					global::System.__ComObject a0, 
					global::Windows.Foundation.IAsyncOperationWithProgress<uint, uint> a1, 
					global::Windows.Foundation.AsyncStatus a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget114(
					global::System.__ComObject a0, 
					global::Windows.Foundation.IAsyncOperation<bool> a1, 
					global::Windows.Foundation.AsyncStatus a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget115(
					global::System.__ComObject a0, 
					global::Windows.Foundation.IAsyncOperation<global::Windows.Storage.Streams.IRandomAccessStream> a1, 
					global::Windows.Foundation.AsyncStatus a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget116(
					global::System.__ComObject a0, 
					global::Windows.Foundation.IAsyncOperation<global::Windows.Storage.StorageStreamTransaction> a1, 
					global::Windows.Foundation.AsyncStatus a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget117(
					global::System.__ComObject a0, 
					global::Windows.Foundation.IAsyncOperation<global::Windows.Storage.StorageFile> a1, 
					global::Windows.Foundation.AsyncStatus a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget118(
					global::System.__ComObject a0, 
					global::Windows.Foundation.IAsyncOperation<global::Windows.Storage.StorageFolder> a1, 
					global::Windows.Foundation.AsyncStatus a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget119(
					global::System.__ComObject a0, 
					global::Windows.Foundation.IAsyncOperation<global::System.Collections.Generic.IReadOnlyList<global::Windows.Storage.StorageFile>> a1, 
					global::Windows.Foundation.AsyncStatus a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget120(
					global::System.__ComObject a0, 
					global::Windows.Foundation.IAsyncOperation<global::System.Collections.Generic.IReadOnlyList<global::Windows.Storage.StorageFolder>> a1, 
					global::Windows.Foundation.AsyncStatus a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget121(
					global::System.__ComObject a0, 
					global::Windows.Foundation.IAsyncOperation<global::System.Collections.Generic.IReadOnlyList<global::Windows.Storage.IStorageItem>> a1, 
					global::Windows.Foundation.AsyncStatus a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget122(
					global::System.__ComObject a0, 
					object a1, 
					global::Windows.UI.Core.WindowActivatedEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget123(
					global::System.__ComObject a0, 
					object a1, 
					global::Windows.UI.Core.CoreWindowEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget124(
					global::System.__ComObject a0, 
					object a1, 
					global::Windows.UI.Core.WindowSizeChangedEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget125(
					global::System.__ComObject a0, 
					object a1, 
					global::Windows.UI.Core.VisibilityChangedEventArgs a2);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget126(
					global::System.IntPtr a0, 
					global::System.IntPtr a1, 
					int a2, 
					global::System.IntPtr a3, 
					int a4, 
					int* a5, 
					global::System_Threading.NativeOverlapped__System_Private_CoreLib* a6);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget127(
					global::System.IntPtr a0, 
					int a1, 
					int a2, 
					int a3, 
					global::System.IntPtr* a4, 
					int* a5, 
					global::System.IntPtr* a6, 
					int* a7);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget128(
					global::System.IntPtr a0, 
					global::System.IntPtr a1, 
					global::System.IntPtr a2, 
					int a3, 
					int a4, 
					int a5, 
					int* a6, 
					global::System_Threading.NativeOverlapped__System_Private_CoreLib* a7);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget129(
					global::System.IntPtr a0, 
					global::System_Threading.NativeOverlapped__System_Private_CoreLib* a1, 
					int a2, 
					int a3);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget130(
					global::System.IntPtr a0, 
					global::System.IntPtr a1, 
					int a2, 
					int a3);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate global::System_Net_Sockets.SocketError__System_Net_Primitives AddrOfTarget131(
					global::System.IntPtr a0, 
					global::System.IntPtr a1, 
					int* a2, 
					global::System_Threading.NativeOverlapped__System_Private_CoreLib* a3, 
					global::System.IntPtr a4);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate global::System_Net_Sockets.SocketError__System_Net_Primitives AddrOfTarget132(
					global::System.IntPtr a0, 
					global::System.IntPtr a1, 
					int* a2, 
					global::System.IntPtr a3, 
					global::System.IntPtr a4);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget133(
					global::System.IntPtr a0, 
					global::System.IntPtr a1, 
					int a2, 
					int a3, 
					global::System_Threading.NativeOverlapped__System_Private_CoreLib* a4, 
					global::System_Net_Sockets.TransmitFileOptions__System_Net_Sockets a5);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate object AddrOfTarget134(global::System.__ComObject a0);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate object AddrOfTarget135(object a0);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget136(
					ref global::Windows.UI.Xaml.Markup.XmlnsDefinition a0, 
					out global::Windows.UI.Xaml.Markup.XmlnsDefinition__Impl.UnsafeType a1);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget137(
					ref global::Windows.UI.Xaml.Markup.XmlnsDefinition__Impl.UnsafeType a0, 
					out global::Windows.UI.Xaml.Markup.XmlnsDefinition a1);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget138(ref global::Windows.UI.Xaml.Markup.XmlnsDefinition__Impl.UnsafeType a0);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget139(
					ref global::_.Interop_Kernel32_COMMPROP__System_IO_Ports a0, 
					out global::_.Interop_Kernel32_COMMPROP__System_IO_Ports__Impl.UnsafeType a1);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget140(
					ref global::_.Interop_Kernel32_COMMPROP__System_IO_Ports__Impl.UnsafeType a0, 
					out global::_.Interop_Kernel32_COMMPROP__System_IO_Ports a1);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget141(
					ref global::_.Interop_Winsock_WSAData__System_Net_NameResolution a0, 
					out global::_.Interop_Winsock_WSAData__System_Net_NameResolution__Impl.UnsafeType a1);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget142(
					ref global::_.Interop_Winsock_WSAData__System_Net_NameResolution__Impl.UnsafeType a0, 
					out global::_.Interop_Winsock_WSAData__System_Net_NameResolution a1);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget143(
					ref global::_.Interop_Winsock_IPv6MulticastRequest__System_Net_Sockets a0, 
					out global::_.Interop_Winsock_IPv6MulticastRequest__System_Net_Sockets__Impl.UnsafeType a1);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget144(
					ref global::_.Interop_Winsock_IPv6MulticastRequest__System_Net_Sockets__Impl.UnsafeType a0, 
					out global::_.Interop_Winsock_IPv6MulticastRequest__System_Net_Sockets a1);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget145(
					global::_.Interop_Advapi32_TokenPrivileges__System_Diagnostics_Process a0, 
					out global::_.Interop_Advapi32_TokenPrivileges__System_Diagnostics_Process__Impl.UnsafeType a1);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget146(
					ref global::_.Interop_Advapi32_TokenPrivileges__System_Diagnostics_Process__Impl.UnsafeType a0, 
					global::_.Interop_Advapi32_TokenPrivileges__System_Diagnostics_Process a1);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget147(
					ref global::_.Interop_UNICODE_STRING__System_Security_Principal_Windows a0, 
					out global::_.Interop_UNICODE_STRING__System_Security_Principal_Windows__Impl.UnsafeType a1);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget148(
					ref global::_.Interop_UNICODE_STRING__System_Security_Principal_Windows__Impl.UnsafeType a0, 
					out global::_.Interop_UNICODE_STRING__System_Security_Principal_Windows a1);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget149(ref global::_.Interop_UNICODE_STRING__System_Security_Principal_Windows__Impl.UnsafeType a0);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget150(
					global::_.Interop_Advapi32_PERF_DATA_BLOCK__System_Diagnostics_Process a0, 
					out global::_.Interop_Advapi32_PERF_DATA_BLOCK__System_Diagnostics_Process__Impl.UnsafeType a1);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget151(
					ref global::_.Interop_Advapi32_PERF_DATA_BLOCK__System_Diagnostics_Process__Impl.UnsafeType a0, 
					global::_.Interop_Advapi32_PERF_DATA_BLOCK__System_Diagnostics_Process a1);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate void AddrOfTarget152(ref global::_.Interop_Advapi32_PERF_DATA_BLOCK__System_Diagnostics_Process__Impl.UnsafeType a0);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget153(
					global::_.Interop_Advapi32_SYSTEMTIME__System_Diagnostics_Process a0, 
					out global::_.Interop_Advapi32_SYSTEMTIME__System_Diagnostics_Process__Impl.UnsafeType a1);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget154(
					ref global::_.Interop_Advapi32_SYSTEMTIME__System_Diagnostics_Process__Impl.UnsafeType a0, 
					global::_.Interop_Advapi32_SYSTEMTIME__System_Diagnostics_Process a1);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget155(
					global::_.Interop_Advapi32_PERF_OBJECT_TYPE__System_Diagnostics_Process a0, 
					out global::_.Interop_Advapi32_PERF_OBJECT_TYPE__System_Diagnostics_Process__Impl.UnsafeType a1);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget156(
					ref global::_.Interop_Advapi32_PERF_OBJECT_TYPE__System_Diagnostics_Process__Impl.UnsafeType a0, 
					global::_.Interop_Advapi32_PERF_OBJECT_TYPE__System_Diagnostics_Process a1);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget157(
					global::_.Interop_Advapi32_PERF_COUNTER_DEFINITION__System_Diagnostics_Process a0, 
					out global::_.Interop_Advapi32_PERF_COUNTER_DEFINITION__System_Diagnostics_Process__Impl.UnsafeType a1);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget158(
					ref global::_.Interop_Advapi32_PERF_COUNTER_DEFINITION__System_Diagnostics_Process__Impl.UnsafeType a0, 
					global::_.Interop_Advapi32_PERF_COUNTER_DEFINITION__System_Diagnostics_Process a1);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget159(
					global::_.Interop_Advapi32_PERF_INSTANCE_DEFINITION__System_Diagnostics_Process a0, 
					out global::_.Interop_Advapi32_PERF_INSTANCE_DEFINITION__System_Diagnostics_Process__Impl.UnsafeType a1);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget160(
					ref global::_.Interop_Advapi32_PERF_INSTANCE_DEFINITION__System_Diagnostics_Process__Impl.UnsafeType a0, 
					global::_.Interop_Advapi32_PERF_INSTANCE_DEFINITION__System_Diagnostics_Process a1);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget161(
					global::_.Interop_Advapi32_PERF_COUNTER_BLOCK__System_Diagnostics_Process a0, 
					out global::_.Interop_Advapi32_PERF_COUNTER_BLOCK__System_Diagnostics_Process__Impl.UnsafeType a1);

		#endif


		#if false
		[global::Internal.PreInitializedAddrOfDelegate]
		public delegate int AddrOfTarget162(
					ref global::_.Interop_Advapi32_PERF_COUNTER_BLOCK__System_Diagnostics_Process__Impl.UnsafeType a0, 
					global::_.Interop_Advapi32_PERF_COUNTER_BLOCK__System_Diagnostics_Process a1);

		#endif
	}
}

namespace Mcg
{
	//
	// The RS.Get contain the set of GetString functions that provides the localization infrastructure, 
	// it is used with the RS.cs that provides the string set.
	//
	namespace System
	{
	    internal static partial class SR
	    {
	        /// <summary>
	        /// This function is responsible to provide the string localization. 
	        /// It is called throught the functions with the default strings in the global::Mcg.System.SR.cs file. 
	        /// The localization infrastructure is in the interop.dll, provided by the ResourceManager.GetString function. 
	        /// The whole path is:
	        /// 
	        ///   (Templates\global::Mcg.System.SR.cs) global::Mcg.System.SR.Arg_Localizable 
	        ///     +--> (Templates\global::Mcg.System.SR.Get.cs) global::Mcg.System.SR.GetResourceString 
	        ///            +--> (contracts\Internal.MCG\Internal.MCG.cs) System.Runtime.CompilerServices.McgResource.GetResourceString 
	        ///                   +--> (Interop\System\Runtime\CompilerServices\McgResource.cs) System.Runtime.CompilerServices.McgResource.GetResourceString
	        ///                          +--> (Common\System\global::Mcg.System.SR.cs) global::Mcg.System.SR.GetResourceString 
	        ///                                 +--> ResourceManager.GetString
	        /// </summary>
	        /// <param name="resourceKey">String with the key that represent the invalid string</param>
	        /// <param name="defaultString">default string used if the localized string was not provided</param>
	        /// <returns>The localized string</returns>
	        internal static string GetResourceString(string resourceKey, string defaultString)
	        {
	#if !MCG_WINRT_SUPPORTED
	            return defaultString; 
	#else
	            return global::System.Runtime.CompilerServices.McgResource.GetResourceString(resourceKey, defaultString); 
	#endif
	        }

	        internal static string Format(string resourceId, params object[] args)
	        {
	            if (args != null)
	            {
	#if !MCG_WINRT_SUPPORTED
	                string reportStr = string.Empty;
	                foreach (object item in args)
	                {
	                    reportStr = string.Concat(reportStr, " | ", item.ToString());
	                }
	                reportStr = string.Concat(resourceId, reportStr);
	                return reportStr;
	#else
	                return string.Format(resourceId, args);
	#endif
	            }

	            return resourceId;
	        }

	        // For back compat - this is the old GetString method from SG used by MCG code
	        // Keep this for now to avoid massive renames and potential merge conflicts
	        // @TODO - Get rid of this
	        internal static string GetString(string resourceId, params object[] args)
	        {
	            return Format(resourceId, args);
	        }
	    }
	}

	// Do not edit this file manually it is auto-generated during the build based on the .resx file for this project.
	namespace System
	{
	    internal static partial class SR
	    {
	#pragma warning disable 0414
	        private const string s_resourcesName = "FxResources.System.Private.Interop.SR";
	#pragma warning restore 0414

	#if !DEBUGRESOURCES
	        internal static string Arg_DllNotFoundException {
	              get { return SR.GetResourceString("Arg_DllNotFoundException", null); }
	        }
	        internal static string Arg_InvalidANSIString {
	              get { return SR.GetResourceString("Arg_InvalidANSIString", null); }
	        }
	        internal static string Arg_InvalidComObjectException {
	              get { return SR.GetResourceString("Arg_InvalidComObjectException", null); }
	        }
	        internal static string Arg_InvalidHandle {
	              get { return SR.GetResourceString("Arg_InvalidHandle", null); }
	        }
	        internal static string Arg_InvalidOleVariantTypeException {
	              get { return SR.GetResourceString("Arg_InvalidOleVariantTypeException", null); }
	        }
	        internal static string Arg_VariantTypeNotSupported {
	              get { return SR.GetResourceString("Arg_VariantTypeNotSupported", null); }
	        }
	        internal static string Arg_InvalidThreshold {
	              get { return SR.GetResourceString("Arg_InvalidThreshold", null); }
	        }
	        internal static string Arg_MarshalDirectiveException {
	              get { return SR.GetResourceString("Arg_MarshalDirectiveException", null); }
	        }
	        internal static string Arg_MustBeDecimal {
	              get { return SR.GetResourceString("Arg_MustBeDecimal", null); }
	        }
	        internal static string Arg_MustBeInt32 {
	              get { return SR.GetResourceString("Arg_MustBeInt32", null); }
	        }
	        internal static string Arg_MustBeStringPtrNotAtom {
	              get { return SR.GetResourceString("Arg_MustBeStringPtrNotAtom", null); }
	        }
	        internal static string Arg_NeedNonNegNumRequired {
	              get { return SR.GetResourceString("Arg_NeedNonNegNumRequired", null); }
	        }
	        internal static string Arg_NotIsomorphic {
	              get { return SR.GetResourceString("Arg_NotIsomorphic", null); }
	        }
	        internal static string Arg_SafeArrayRankMismatchException {
	              get { return SR.GetResourceString("Arg_SafeArrayRankMismatchException", null); }
	        }
	        internal static string Arg_SafeArrayTypeMismatchException {
	              get { return SR.GetResourceString("Arg_SafeArrayTypeMismatchException", null); }
	        }
	        internal static string Arg_SizeOfNoTypeSizeInfo {
	              get { return SR.GetResourceString("Arg_SizeOfNoTypeSizeInfo", null); }
	        }
	        internal static string Arg_SizeOfNonValueType {
	              get { return SR.GetResourceString("Arg_SizeOfNonValueType", null); }
	        }
	        internal static string Argument_AddingDuplicate {
	              get { return SR.GetResourceString("Argument_AddingDuplicate", null); }
	        }
	        internal static string Argument_NeedNonGenericType {
	              get { return SR.GetResourceString("Argument_NeedNonGenericType", null); }
	        }
	        internal static string Argument_ObjNotComObject {
	              get { return SR.GetResourceString("Argument_ObjNotComObject", null); }
	        }
	        internal static string ArgumentNull_Buffer {
	              get { return SR.GetResourceString("ArgumentNull_Buffer", null); }
	        }
	        internal static string ArgumentOutOfRange_NeedNonNegNum {
	              get { return SR.GetResourceString("ArgumentOutOfRange_NeedNonNegNum", null); }
	        }
	        internal static string Null_HString {
	              get { return SR.GetResourceString("Null_HString", null); }
	        }
	        internal static string BadMarshalField_Null_HString {
	              get { return SR.GetResourceString("BadMarshalField_Null_HString", null); }
	        }
	        internal static string ArrayWithOffsetOverflow {
	              get { return SR.GetResourceString("ArrayWithOffsetOverflow", null); }
	        }
	        internal static string InvalidOperation_HCCountOverflow {
	              get { return SR.GetResourceString("InvalidOperation_HCCountOverflow", null); }
	        }
	        internal static string StructArrayTooLarge {
	              get { return SR.GetResourceString("StructArrayTooLarge", null); }
	        }
	        internal static string WrongSizeArrayInNStruct {
	              get { return SR.GetResourceString("WrongSizeArrayInNStruct", null); }
	        }
	        internal static string CustomPropertyProvider_DataBindingError {
	              get { return SR.GetResourceString("CustomPropertyProvider_DataBindingError", null); }
	        }
	        internal static string CustomPropertyProvider_MissingMetadata {
	              get { return SR.GetResourceString("CustomPropertyProvider_MissingMetadata", null); }
	        }
	        internal static string Arg_GetMethNotFnd {
	              get { return SR.GetResourceString("Arg_GetMethNotFnd", null); }
	        }
	        internal static string Arg_SetMethNotFnd {
	              get { return SR.GetResourceString("Arg_SetMethNotFnd", null); }
	        }
	        internal static string Arg_MethodAccessException_WithMethodName {
	              get { return SR.GetResourceString("Arg_MethodAccessException_WithMethodName", null); }
	        }
	        internal static string Arg_RemovedTypeInstantiated {
	              get { return SR.GetResourceString("Arg_RemovedTypeInstantiated", null); }
	        }
	        internal static string Arg_NotImplementedInNonCoreApiSet {
	              get { return SR.GetResourceString("Arg_NotImplementedInNonCoreApiSet", null); }
	        }
	        internal static string Arg_DelegateTypeNotRecognized {
	              get { return SR.GetResourceString("Arg_DelegateTypeNotRecognized", null); }
	        }
	        internal static string Arg_NoMarshalCreatedObjectUsedOutOfTreadContext {
	              get { return SR.GetResourceString("Arg_NoMarshalCreatedObjectUsedOutOfTreadContext", null); }
	        }
	        internal static string Arg_UnexpectedTypeKind {
	              get { return SR.GetResourceString("Arg_UnexpectedTypeKind", null); }
	        }
	        internal static string Arg_UnrecognizedTypeName {
	              get { return SR.GetResourceString("Arg_UnrecognizedTypeName", null); }
	        }
	        internal static string Arg_InvalidCustomTypeNameValue {
	              get { return SR.GetResourceString("Arg_InvalidCustomTypeNameValue", null); }
	        }
	        internal static string Arg_InteropMarshalUnmappableChar {
	              get { return SR.GetResourceString("Arg_InteropMarshalUnmappableChar", null); }
	        }
	        internal static string Argument_MustHaveLayoutOrBeBlittable {
	              get { return SR.GetResourceString("Argument_MustHaveLayoutOrBeBlittable", null); }
	        }
	        internal static string TypeNameMarshalling_MissingMetadata {
	              get { return SR.GetResourceString("TypeNameMarshalling_MissingMetadata", null); }
	        }
	        internal static string Excep_EnumNotStarted {
	              get { return SR.GetResourceString("Excep_EnumNotStarted", null); }
	        }
	        internal static string Excep_EnumEnded {
	              get { return SR.GetResourceString("Excep_EnumEnded", null); }
	        }
	        internal static string Excep_EnumFailedVersion {
	              get { return SR.GetResourceString("Excep_EnumFailedVersion", null); }
	        }
	        internal static string Excep_NotSupported {
	              get { return SR.GetResourceString("Excep_NotSupported", null); }
	        }
	        internal static string Excep_CollectionBackingListTooLarge {
	              get { return SR.GetResourceString("Excep_CollectionBackingListTooLarge", null); }
	        }
	        internal static string Excep_KeyNotFound {
	              get { return SR.GetResourceString("Excep_KeyNotFound", null); }
	        }
	        internal static string Excep_KeyCollectionSet {
	              get { return SR.GetResourceString("Excep_KeyCollectionSet", null); }
	        }
	        internal static string Excep_ValueCollectionSet {
	              get { return SR.GetResourceString("Excep_ValueCollectionSet", null); }
	        }
	        internal static string Excep_InsufficientSpaceToCopyCollection {
	              get { return SR.GetResourceString("Excep_InsufficientSpaceToCopyCollection", null); }
	        }
	        internal static string Excep_IndexOutOfArrayBounds {
	              get { return SR.GetResourceString("Excep_IndexOutOfArrayBounds", null); }
	        }
	        internal static string Excep_CannotRemoveFromEmptyCollection {
	              get { return SR.GetResourceString("Excep_CannotRemoveFromEmptyCollection", null); }
	        }
	        internal static string Excep_IndexLargerThanMaxValue {
	              get { return SR.GetResourceString("Excep_IndexLargerThanMaxValue", null); }
	        }
	        internal static string Excep_IndexOutOfRange {
	              get { return SR.GetResourceString("Excep_IndexOutOfRange", null); }
	        }
	        internal static string Excep_AddingDuplicate {
	              get { return SR.GetResourceString("Excep_AddingDuplicate", null); }
	        }
	        internal static string Excep_FromHResult {
	              get { return SR.GetResourceString("Excep_FromHResult", null); }
	        }
	        internal static string Excep_InvalidMarshalAs_Param {
	              get { return SR.GetResourceString("Excep_InvalidMarshalAs_Param", null); }
	        }
	        internal static string Excep_InvalidMarshalAs_Field {
	              get { return SR.GetResourceString("Excep_InvalidMarshalAs_Field", null); }
	        }
	        internal static string Excep_InvalidMarshalAs_Return {
	              get { return SR.GetResourceString("Excep_InvalidMarshalAs_Return", null); }
	        }
	        internal static string Excep_InvalidComObject_NoRCW_Wrapper {
	              get { return SR.GetResourceString("Excep_InvalidComObject_NoRCW_Wrapper", null); }
	        }
	        internal static string StructMarshalling_MissingInteropData {
	              get { return SR.GetResourceString("StructMarshalling_MissingInteropData", null); }
	        }
	        internal static string DelegateMarshalling_MissingInteropData {
	              get { return SR.GetResourceString("DelegateMarshalling_MissingInteropData", null); }
	        }
	        internal static string ComTypeMarshalling_MissingInteropData {
	              get { return SR.GetResourceString("ComTypeMarshalling_MissingInteropData", null); }
	        }
	        internal static string Not_Enough_Thunks {
	              get { return SR.GetResourceString("Not_Enough_Thunks", null); }
	        }
	        internal static string Arg_NativeToManagedCall {
	              get { return SR.GetResourceString("Arg_NativeToManagedCall", null); }
	        }
	        internal static string Arg_NeedsDefaultCtor {
	              get { return SR.GetResourceString("Arg_NeedsDefaultCtor", null); }
	        }
	        internal static string Arg_OutSafeHandleAsFieldNotSupported {
	              get { return SR.GetResourceString("Arg_OutSafeHandleAsFieldNotSupported", null); }
	        }
	        internal static string PropertyValue_InvalidCoersion {
	              get { return SR.GetResourceString("PropertyValue_InvalidCoersion", null); }
	        }
	        internal static string PropertyValue_InvalidCast {
	              get { return SR.GetResourceString("PropertyValue_InvalidCast", null); }
	        }
	        internal static string Arg_MustBeDelegateType {
	              get { return SR.GetResourceString("Arg_MustBeDelegateType", null); }
	        }
	        internal static string Arg_CriticalHandleCannotBeAbstract {
	              get { return SR.GetResourceString("Arg_CriticalHandleCannotBeAbstract", null); }
	        }
	        internal static string Arg_CriticalHandleMustHaveDefaultCtor {
	              get { return SR.GetResourceString("Arg_CriticalHandleMustHaveDefaultCtor", null); }
	        }
	        internal static string Arg_CriticalHandleReverse {
	              get { return SR.GetResourceString("Arg_CriticalHandleReverse", null); }
	        }
	        internal static string Arg_OutCriticalHandleAsFieldNotSupported {
	              get { return SR.GetResourceString("Arg_OutCriticalHandleAsFieldNotSupported", null); }
	        }
	        internal static string Argument_OffsetOfFieldNotFound {
	              get { return SR.GetResourceString("Argument_OffsetOfFieldNotFound", null); }
	        }
	        internal static string Argument_StructMustNotBeValueClass {
	              get { return SR.GetResourceString("Argument_StructMustNotBeValueClass", null); }
	        }
	        internal static string Argument_NeedNonGenericObject {
	              get { return SR.GetResourceString("Argument_NeedNonGenericObject", null); }
	        }
	        internal static string InvalidCast_WinRT {
	              get { return SR.GetResourceString("InvalidCast_WinRT", null); }
	        }
	        internal static string InvalidCast_Com {
	              get { return SR.GetResourceString("InvalidCast_Com", null); }
	        }
	        internal static string MissingMetadataType {
	              get { return SR.GetResourceString("MissingMetadataType", null); }
	        }
	        internal static string DirectUI_Empty {
	              get { return SR.GetResourceString("DirectUI_Empty", null); }
	        }
	        internal static string PInvoke_GetProcAddress_NoName {
	              get { return SR.GetResourceString("PInvoke_GetProcAddress_NoName", null); }
	        }
	        internal static string PInvoke_LoadLib {
	              get { return SR.GetResourceString("PInvoke_LoadLib", null); }
	        }
	        internal static string PInvoke_GetProcAddress {
	              get { return SR.GetResourceString("PInvoke_GetProcAddress", null); }
	        }
	#else
	        internal static string Arg_DllNotFoundException {
	              get { return SR.GetResourceString("Arg_DllNotFoundException", @"Dll was not found."); }
	        }
	        internal static string Arg_InvalidANSIString {
	              get { return SR.GetResourceString("Arg_InvalidANSIString", @"The ANSI string passed in could not be converted from the default ANSI code page to Unicode."); }
	        }
	        internal static string Arg_InvalidComObjectException {
	              get { return SR.GetResourceString("Arg_InvalidComObjectException", @"Attempt has been made to use a COM object that does not have a backing class factory."); }
	        }
	        internal static string Arg_InvalidHandle {
	              get { return SR.GetResourceString("Arg_InvalidHandle", @"Invalid handle."); }
	        }
	        internal static string Arg_InvalidOleVariantTypeException {
	              get { return SR.GetResourceString("Arg_InvalidOleVariantTypeException", @"Specified OLE variant was invalid."); }
	        }
	        internal static string Arg_VariantTypeNotSupported {
	              get { return SR.GetResourceString("Arg_VariantTypeNotSupported", @"Marshal for the specified variant type {0} not supported."); }
	        }
	        internal static string Arg_InvalidThreshold {
	              get { return SR.GetResourceString("Arg_InvalidThreshold", @"maximumThreshold cannot be less than initialThreshold."); }
	        }
	        internal static string Arg_MarshalDirectiveException {
	              get { return SR.GetResourceString("Arg_MarshalDirectiveException", @"Marshaling directives are invalid."); }
	        }
	        internal static string Arg_MustBeDecimal {
	              get { return SR.GetResourceString("Arg_MustBeDecimal", @"Object must be of type Decimal."); }
	        }
	        internal static string Arg_MustBeInt32 {
	              get { return SR.GetResourceString("Arg_MustBeInt32", @"Object must be of type Int32."); }
	        }
	        internal static string Arg_MustBeStringPtrNotAtom {
	              get { return SR.GetResourceString("Arg_MustBeStringPtrNotAtom", @"The pointer passed in as a String must not be in the bottom 64K of the process's address space."); }
	        }
	        internal static string Arg_NeedNonNegNumRequired {
	              get { return SR.GetResourceString("Arg_NeedNonNegNumRequired", @"Non-negative number required."); }
	        }
	        internal static string Arg_NotIsomorphic {
	              get { return SR.GetResourceString("Arg_NotIsomorphic", @"Object contains non-primitive or non-blittable data."); }
	        }
	        internal static string Arg_SafeArrayRankMismatchException {
	              get { return SR.GetResourceString("Arg_SafeArrayRankMismatchException", @"Specified array was not of the expected rank."); }
	        }
	        internal static string Arg_SafeArrayTypeMismatchException {
	              get { return SR.GetResourceString("Arg_SafeArrayTypeMismatchException", @"Specified array was not of the expected type."); }
	        }
	        internal static string Arg_SizeOfNoTypeSizeInfo {
	              get { return SR.GetResourceString("Arg_SizeOfNoTypeSizeInfo", @"Marshal.SizeOf may only be used with blittable types and types used in the generic SizeOf<T> overload methods."); }
	        }
	        internal static string Arg_SizeOfNonValueType {
	              get { return SR.GetResourceString("Arg_SizeOfNonValueType", @"Marshal.SizeOf may only be used with value types."); }
	        }
	        internal static string Argument_AddingDuplicate {
	              get { return SR.GetResourceString("Argument_AddingDuplicate", @"An item with the same key has already been added."); }
	        }
	        internal static string Argument_NeedNonGenericType {
	              get { return SR.GetResourceString("Argument_NeedNonGenericType", @"The specified Type must not be a generic type definition."); }
	        }
	        internal static string Argument_ObjNotComObject {
	              get { return SR.GetResourceString("Argument_ObjNotComObject", @"The object's type must be __ComObject or derived from __ComObject."); }
	        }
	        internal static string ArgumentNull_Buffer {
	              get { return SR.GetResourceString("ArgumentNull_Buffer", @"Buffer cannot be null."); }
	        }
	        internal static string ArgumentOutOfRange_NeedNonNegNum {
	              get { return SR.GetResourceString("ArgumentOutOfRange_NeedNonNegNum", @"Non-negative number required."); }
	        }
	        internal static string Null_HString {
	              get { return SR.GetResourceString("Null_HString", @"Null strings may not be marshaled in Windows Runtime arguments."); }
	        }
	        internal static string BadMarshalField_Null_HString {
	              get { return SR.GetResourceString("BadMarshalField_Null_HString", @"Null strings may not be marshaled in Windows Runtime fields."); }
	        }
	        internal static string ArrayWithOffsetOverflow {
	              get { return SR.GetResourceString("ArrayWithOffsetOverflow", @"ArrayWithOffset: offset exceeds array size."); }
	        }
	        internal static string InvalidOperation_HCCountOverflow {
	              get { return SR.GetResourceString("InvalidOperation_HCCountOverflow", @"Handle collector count overflows or underflows."); }
	        }
	        internal static string StructArrayTooLarge {
	              get { return SR.GetResourceString("StructArrayTooLarge", @"Array size exceeds addressing limitations."); }
	        }
	        internal static string WrongSizeArrayInNStruct {
	              get { return SR.GetResourceString("WrongSizeArrayInNStruct", @"Type could not be marshaled because the length of an embedded array instance does not match the declared length in the layout."); }
	        }
	        internal static string CustomPropertyProvider_DataBindingError {
	              get { return SR.GetResourceString("CustomPropertyProvider_DataBindingError", @"Failed to bind to property '{0}'.  {1}"); }
	        }
	        internal static string CustomPropertyProvider_MissingMetadata {
	              get { return SR.GetResourceString("CustomPropertyProvider_MissingMetadata", @"Failed to bind to property '{0}'.  {1}"); }
	        }
	        internal static string Arg_GetMethNotFnd {
	              get { return SR.GetResourceString("Arg_GetMethNotFnd", @"Property Get method not found."); }
	        }
	        internal static string Arg_SetMethNotFnd {
	              get { return SR.GetResourceString("Arg_SetMethNotFnd", @"Property Set method not found."); }
	        }
	        internal static string Arg_MethodAccessException_WithMethodName {
	              get { return SR.GetResourceString("Arg_MethodAccessException_WithMethodName", @"Attempt to access the method '{0}' on type '{1}' failed."); }
	        }
	        internal static string Arg_RemovedTypeInstantiated {
	              get { return SR.GetResourceString("Arg_RemovedTypeInstantiated", @"A type that was removed by MCG dependency reduction has been instantiated."); }
	        }
	        internal static string Arg_NotImplementedInNonCoreApiSet {
	              get { return SR.GetResourceString("Arg_NotImplementedInNonCoreApiSet", @"{0} is not implemented for non-CORE_API_SET builds."); }
	        }
	        internal static string Arg_DelegateTypeNotRecognized {
	              get { return SR.GetResourceString("Arg_DelegateTypeNotRecognized", @"Delegate type is not recognized."); }
	        }
	        internal static string Arg_NoMarshalCreatedObjectUsedOutOfTreadContext {
	              get { return SR.GetResourceString("Arg_NoMarshalCreatedObjectUsedOutOfTreadContext", @"The Windows Runtime Object can only be used in the threading context where it was created, because it implements INoMarshal or has MarshalingBehaviorAttribute(MarshalingType.None) set."); }
	        }
	        internal static string Arg_UnexpectedTypeKind {
	              get { return SR.GetResourceString("Arg_UnexpectedTypeKind", @"Unexpected TypeKind."); }
	        }
	        internal static string Arg_UnrecognizedTypeName {
	              get { return SR.GetResourceString("Arg_UnrecognizedTypeName", @"Unrecognized type name."); }
	        }
	        internal static string Arg_InvalidCustomTypeNameValue {
	              get { return SR.GetResourceString("Arg_InvalidCustomTypeNameValue", @"Invalid custom TypeName value."); }
	        }
	        internal static string Arg_InteropMarshalUnmappableChar {
	              get { return SR.GetResourceString("Arg_InteropMarshalUnmappableChar", @"Cannot marshal: Encountered unmappable character."); }
	        }
	        internal static string Argument_MustHaveLayoutOrBeBlittable {
	              get { return SR.GetResourceString("Argument_MustHaveLayoutOrBeBlittable", @"The specified structure '{0}' must be blittable or have layout information."); }
	        }
	        internal static string TypeNameMarshalling_MissingMetadata {
	              get { return SR.GetResourceString("TypeNameMarshalling_MissingMetadata", @"Failed to marshal System.Type instance using metadata information. {0}"); }
	        }
	        internal static string Excep_EnumNotStarted {
	              get { return SR.GetResourceString("Excep_EnumNotStarted", @"Enum Not Started"); }
	        }
	        internal static string Excep_EnumEnded {
	              get { return SR.GetResourceString("Excep_EnumEnded", @"Enum ended"); }
	        }
	        internal static string Excep_EnumFailedVersion {
	              get { return SR.GetResourceString("Excep_EnumFailedVersion", @"Collection was modified; enumeration operation may not execute."); }
	        }
	        internal static string Excep_NotSupported {
	              get { return SR.GetResourceString("Excep_NotSupported", @"Not supported exception."); }
	        }
	        internal static string Excep_CollectionBackingListTooLarge {
	              get { return SR.GetResourceString("Excep_CollectionBackingListTooLarge", @"Collection backing list too large"); }
	        }
	        internal static string Excep_KeyNotFound {
	              get { return SR.GetResourceString("Excep_KeyNotFound", @"The given key was not present in the dictionary."); }
	        }
	        internal static string Excep_KeyCollectionSet {
	              get { return SR.GetResourceString("Excep_KeyCollectionSet", @"Key collection set."); }
	        }
	        internal static string Excep_ValueCollectionSet {
	              get { return SR.GetResourceString("Excep_ValueCollectionSet", @"Value collection set."); }
	        }
	        internal static string Excep_InsufficientSpaceToCopyCollection {
	              get { return SR.GetResourceString("Excep_InsufficientSpaceToCopyCollection", @"Insufficient space to copy collection."); }
	        }
	        internal static string Excep_IndexOutOfArrayBounds {
	              get { return SR.GetResourceString("Excep_IndexOutOfArrayBounds", @"Index out of array bounds."); }
	        }
	        internal static string Excep_CannotRemoveFromEmptyCollection {
	              get { return SR.GetResourceString("Excep_CannotRemoveFromEmptyCollection", @"Cannot remove from empty collection."); }
	        }
	        internal static string Excep_IndexLargerThanMaxValue {
	              get { return SR.GetResourceString("Excep_IndexLargerThanMaxValue", @"Index larger than max value."); }
	        }
	        internal static string Excep_IndexOutOfRange {
	              get { return SR.GetResourceString("Excep_IndexOutOfRange", @"The specified index is outside the current index range of this collection."); }
	        }
	        internal static string Excep_AddingDuplicate {
	              get { return SR.GetResourceString("Excep_AddingDuplicate", @"Adding duplicate."); }
	        }
	        internal static string Excep_FromHResult {
	              get { return SR.GetResourceString("Excep_FromHResult", @"Exception from HRESULT:"); }
	        }
	        internal static string Excep_InvalidMarshalAs_Param {
	              get { return SR.GetResourceString("Excep_InvalidMarshalAs_Param", @"Incompatible MarshalAs detected in parameter named '{0}'. Please refer to MCG's warning message for more information."); }
	        }
	        internal static string Excep_InvalidMarshalAs_Field {
	              get { return SR.GetResourceString("Excep_InvalidMarshalAs_Field", @"Incompatible MarshalAs detected in field named '{0}'. Please refer to MCG's warning message for more information."); }
	        }
	        internal static string Excep_InvalidMarshalAs_Return {
	              get { return SR.GetResourceString("Excep_InvalidMarshalAs_Return", @"Incompatible MarshalAs detected in return value. Please refer to MCG's warning message for more information."); }
	        }
	        internal static string Excep_InvalidComObject_NoRCW_Wrapper {
	              get { return SR.GetResourceString("Excep_InvalidComObject_NoRCW_Wrapper", @"COM object that has been separated from its underlying RCW cannot be used."); }
	        }
	        internal static string StructMarshalling_MissingInteropData {
	              get { return SR.GetResourceString("StructMarshalling_MissingInteropData", @"{0} is missing structure marshalling data. To enable structure marshalling data, add a MarshalStructure directive to the application rd.xml file. For more information, please visit http://go.microsoft.com/fwlink/?LinkID=393965"); }
	        }
	        internal static string DelegateMarshalling_MissingInteropData {
	              get { return SR.GetResourceString("DelegateMarshalling_MissingInteropData", @"{0} is missing delegate marshalling data. To enable delegate marshalling data, add a MarshalDelegate directive to the application rd.xml file. For more information, please visit http://go.microsoft.com/fwlink/?LinkID=393965"); }
	        }
	        internal static string ComTypeMarshalling_MissingInteropData {
	              get { return SR.GetResourceString("ComTypeMarshalling_MissingInteropData", @"{0} is missing interop type marshalling data. To enable interop type marshalling data, add a MarshalObject directive to the application rd.xml file. For more information, please visit http://go.microsoft.com/fwlink/?LinkID=393965"); }
	        }
	        internal static string Not_Enough_Thunks {
	              get { return SR.GetResourceString("Not_Enough_Thunks", @"The maximum number of live delegates have been marshaled to function pointers. More aggressively freeing delegate instances that have been marshaled may resolve this problem. Please notify Microsoft that you have encountered this error."); }
	        }
	        internal static string Arg_NativeToManagedCall {
	              get { return SR.GetResourceString("Arg_NativeToManagedCall", @"Function has a parameter or return value of SafeHandle. Marshalling between a Windows HANDLE and .NET SafeHandle is not supported when a method is called from native code."); }
	        }
	        internal static string Arg_NeedsDefaultCtor {
	              get { return SR.GetResourceString("Arg_NeedsDefaultCtor", @"'{0}' does not have a default constructor. Subclasses of SafeHandle must have a default constructor to support marshaling a Windows HANDLE into managed code."); }
	        }
	        internal static string Arg_OutSafeHandleAsFieldNotSupported {
	              get { return SR.GetResourceString("Arg_OutSafeHandleAsFieldNotSupported", @"Marshalling a Windows HANDLE to .NET SafeHandle within a structure field is not currently supported."); }
	        }
	        internal static string PropertyValue_InvalidCoersion {
	              get { return SR.GetResourceString("PropertyValue_InvalidCoersion", @"Object in an IPropertyValue is of type '{0}' with value '{1}', which cannot be converted to a '{2}'."); }
	        }
	        internal static string PropertyValue_InvalidCast {
	              get { return SR.GetResourceString("PropertyValue_InvalidCast", @"Object in an IPropertyValue is of type '{0}', which cannot be converted to a '{1}'."); }
	        }
	        internal static string Arg_MustBeDelegateType {
	              get { return SR.GetResourceString("Arg_MustBeDelegateType", @"Type must derive from Delegate."); }
	        }
	        internal static string Arg_CriticalHandleCannotBeAbstract {
	              get { return SR.GetResourceString("Arg_CriticalHandleCannotBeAbstract", @"'{0}' is abstract. CriticalHandle types must not be abstract to support marshaling CriticalHandles into managed code."); }
	        }
	        internal static string Arg_CriticalHandleMustHaveDefaultCtor {
	              get { return SR.GetResourceString("Arg_CriticalHandleMustHaveDefaultCtor", @"'{0}' does not have a default constructor. CriticalHandle types must have a default constructor to support marshaling CriticalHandles into managed code."); }
	        }
	        internal static string Arg_CriticalHandleReverse {
	              get { return SR.GetResourceString("Arg_CriticalHandleReverse", @"CriticalHandle types cannot be used in signatures of methods called from native code."); }
	        }
	        internal static string Arg_OutCriticalHandleAsFieldNotSupported {
	              get { return SR.GetResourceString("Arg_OutCriticalHandleAsFieldNotSupported", @"Marshalling a Windows HANDLE to .NET CriticalHandle within a structure field is not currently supported."); }
	        }
	        internal static string Argument_OffsetOfFieldNotFound {
	              get { return SR.GetResourceString("Argument_OffsetOfFieldNotFound", @"Field passed in is not a marshaled member of the type '{0}'."); }
	        }
	        internal static string Argument_StructMustNotBeValueClass {
	              get { return SR.GetResourceString("Argument_StructMustNotBeValueClass", @"The structure must not be a value class."); }
	        }
	        internal static string Argument_NeedNonGenericObject {
	              get { return SR.GetResourceString("Argument_NeedNonGenericObject", @"The specified object must not be an instance of a generic type."); }
	        }
	        internal static string InvalidCast_WinRT {
	              get { return SR.GetResourceString("InvalidCast_WinRT", @"Unable to cast object of type '{0}' to type '{1}'."); }
	        }
	        internal static string InvalidCast_Com {
	              get { return SR.GetResourceString("InvalidCast_Com", @"Unable to cast COM object of type '{0}' to interface type '{1}'. This operation failed because the QueryInterface call on the COM component for the interface with IID '{2}' failed due to the following error: {3}."); }
	        }
	        internal static string MissingMetadataType {
	              get { return SR.GetResourceString("MissingMetadataType", @"Unknown (Missing metadata for type)"); }
	        }
	        internal static string DirectUI_Empty {
	              get { return SR.GetResourceString("DirectUI_Empty", @"Empty."); }
	        }
	        internal static string PInvoke_GetProcAddress_NoName {
	              get { return SR.GetResourceString("PInvoke_GetProcAddress_NoName", @"A library name must be specified in a DllImport attribute applied to non-IJW methods."); }
	        }
	        internal static string PInvoke_LoadLib {
	              get { return SR.GetResourceString("PInvoke_LoadLib", @"Unable to load DLL '{0}': {1}"); }
	        }
	        internal static string PInvoke_GetProcAddress {
	              get { return SR.GetResourceString("PInvoke_GetProcAddress", @"Unable to find an entry point named '{0}' in DLL '{1}'."); }
	        }

	#endif
	        internal static Type ResourceType {
	              get { return typeof(FxResources.System.Private.Interop.SR); }
	        }
	    }
	}
	namespace FxResources.System.Private.Interop
	{
	    // The type of this class is used to create the ResourceManager instance as the type name matches the name of the embedded resources file
	    internal static class SR
	    {
	    }
	}
}

namespace System.Runtime.InteropServices
{
	[global::System.AttributeUsage((System.AttributeTargets.Method | System.AttributeTargets.Class))]
	internal class McgIntrinsicsAttribute : global::System.Attribute
	{
	}
}

