//
//  BTConnectViewController.swift
//  Inventory_ATx88
//
//  Created by 류은주 on 2017. 12. 7..
//  Copyright © 2017년 류은주. All rights reserved.
//

import UIKit

class BTConnectViewController: UIViewController, CBCentralManagerDelegate, CBPeripheralDelegate, UITableViewDataSource,  UITableViewDelegate, EADeviceInitializeDelegate, EAReaderDelegate
{

    @IBOutlet weak var btTableView: UITableView!
    @IBOutlet weak var searchstopItem: UIBarButtonItem!
    
    
    
    fileprivate let data = NSMutableData()
    
    //    var devicename: String?
    var HUD = MBProgressHUD()
    
    var appDelegate = UIApplication.shared.delegate as! AppDelegate
    
    var mQueue: DispatchQueue?
    var peripheralArray: NSMutableArray = []
    var mDevice = EADeviceBluetoothLe()
    weak var readerDelegate: EAReaderDelegate?
    var wrongdeviceflag = 0;
    
    var devicetype: Int = 0
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        // Uncomment the following line to preserve selection between presentations
        
        let center = NotificationCenter.default
        center.addObserver(self, selector: #selector(self.bluetoothDisconnected), name: NSNotification.Name.init(rawValue: "BluetoothDisconnected"), object: nil)
        let wrongnoti = NotificationCenter.default
        wrongnoti.addObserver(self, selector: #selector(self.wrongdeviceconnected), name: NSNotification.Name.init(rawValue: "wrongdeviceconnected"), object: nil)
        
    }
    
    override func viewDidAppear(_ animated: Bool) {
        super.viewDidAppear(animated)
        //        peripheralArray.removeAllObjects()
        //        mQueue = DispatchQueue(label: "com.atid.bluetooth")
        //        appDelegate.mCentralManager = CBCentralManager(delegate: self, queue: mQueue)
    }
    
    override func viewWillDisappear(_ animated: Bool) {
        super.viewDidAppear(animated)
        appDelegate.mCentralManager?.stopScan()
        NotificationCenter.default.removeObserver(self, name: NSNotification.Name(rawValue: "BluetoothDisconnected"), object: nil)
        NotificationCenter.default.removeObserver(self, name: NSNotification.Name(rawValue: "wrongdeviceconnected"), object: nil)
    }
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }
    
    func centralManagerDidUpdateState(_ central: CBCentralManager) {
        if central.state == .poweredOff {
            NotificationCenter.default.post(name: NSNotification.Name("BluetoothDisconnected"), object: self)
        }
        
        guard central.state  == .poweredOn else {
            // In a real app, you'd deal with all the states correctly
            return
        }
        // The state must be CBCentralManagerStatePoweredOn...
        // ... so start scanning
        scan()
    }
    
    /** Scan for peripherals - specifically for our service's 128bit CBUUID
     */
    func scan() {
        
        appDelegate.mCentralManager?.scanForPeripherals(withServices: nil, options: [
            CBCentralManagerScanOptionAllowDuplicatesKey : NSNumber(value: true as Bool)
            ]
        )
        
        print("Scanning started")
    }
    
    func centralManager(_ central: CBCentralManager, didDiscover peripheral: CBPeripheral, advertisementData: [String : Any], rssi RSSI: NSNumber) {
        
        if (( peripheral.name?.range(of: "AT188") != nil) || ( peripheral.name?.range(of: "AT388") != nil) || ( peripheral.name?.range(of: "ATS100") != nil)||( peripheral.name?.range(of: "ATS200") != nil)||( peripheral.name?.range(of: "AT188NP") != nil) ) {
            // Ok, it's in range - have we already seen it?
            
            if appDelegate.mPeripheral != peripheral {
                // Save a local copy of the peripheral, so CoreBluetooth doesn't get rid of it
                
                // And connect
                print("Discover to peripheral \(peripheral)")
                
                if peripheralArray.count < 1 {
                    peripheralArray.addObjects(from: [peripheral])
                    DispatchQueue.main.async(execute: {() -> Void in
                        self.btTableView.reloadData()
                    })
                } else {
                    var check = 0
                    for i in 0...peripheralArray.count-1{
                        if peripheral.name == (peripheralArray[i] as AnyObject).name{
                            check = 1
                        }
                    }
                    
                    if check == 0 {
                        peripheralArray.addObjects(from: [peripheral])
                        DispatchQueue.main.async(execute: {() -> Void in
                            self.btTableView.reloadData()
                        })
                    }
                }
            }
        }
    }
    
    func centralManager(_ central: CBCentralManager, didConnect peripheral: CBPeripheral) {
        print("Peripheral Connected")
        
        data.length = 0
        
        mDevice = EADeviceBluetoothLe(peripheral: peripheral, delegate: self as EADeviceInitializeDelegate)
        // Stop scanning
        appDelegate.mCentralManager?.stopScan()
        
        print("Scanning stopped")
        
        
    }
    
    func centralManager(_ central: CBCentralManager, didDisconnectPeripheral peripheral: CBPeripheral, error: Error?) {
        DispatchQueue.main.async(execute: {() -> Void in
            NotificationCenter.default.post(name: NSNotification.Name("BluetoothDisconnected"), object: self)
        })
        print("Disconnect Success")
        //        viewinitial()
        //        viewmode(mode: false)
    }
    func peripheral(_ peripheral: CBPeripheral, didUpdateValueFor characteristic: CBCharacteristic, error: Error?) {
        guard error == nil else {
            print("Error discovering services: \(error!.localizedDescription)")
            return
        }
        
        guard let stringFromData = NSString(data: characteristic.value!, encoding: String.Encoding.utf8.rawValue) else {
            print("Invalid data")
            return
        }
        
        // Have we got everything we need?
        if stringFromData.isEqual(to: "EOM") {
            // We have, so show the data,
            //            textView.text = String(data: data.copy() as! Data, encoding: String.Encoding.utf8)
            
            // Cancel our subscription to the characteristic
            peripheral.setNotifyValue(false, for: characteristic)
            
            // and disconnect from the peripehral
            appDelegate.mCentralManager?.cancelPeripheralConnection(peripheral)
        } else {
            // Otherwise, just add the data on to what we already have
            data.append(characteristic.value!)
            
            // Log it
            print("Received: \(stringFromData)")
        }
    }
    
    /** The peripheral letting us know whether our subscribe/unsubscribe happened or not
     */
    func peripheral(_ peripheral: CBPeripheral, didUpdateNotificationStateFor characteristic: CBCharacteristic, error: Error?) {
        print("Error changing notification state: \(String(describing: error?.localizedDescription))")
        
        // Exit if it's not the transfer characteristic
        //        guard characteristic.uuid.isEqual(transferCharacteristicUUID) else {
        //            return
        //        }
        
        // Notification has started
        if (characteristic.isNotifying) {
            print("Notification began on \(characteristic)")
        } else { // Notification has stopped
            print("Notification stopped on (\(characteristic))  Disconnecting")
            appDelegate.mCentralManager?.cancelPeripheralConnection(peripheral)
        }
    }
    func didCompleteInitialize(_ error: Error!) {
        appDelegate.mReader = EAReader(device: mDevice, delegate: readerDelegate)
        print("didCompleteInitialize finish")
        appDelegate.mReader?.setDelegate(self)
        
        DispatchQueue.main.async(execute: {() -> Void in
            if(self.wrongdeviceflag == 0){
                self.peripheralArray.removeAllObjects()
                self.appDelegate.connectflag = true
                //                if ( self.appDelegate.devicename?.range(of: "ATS100") != nil) {
                //                    self.buttonNotiData = ["Beep", "Vibrate", "Ligth(Not Support)"]
                //                } else {
                //                    self.buttonNotiData = ["Beep", "Vibrate", "Ligth"]
                //                }
                self.performSegue(withIdentifier: "InventoryView", sender: nil)
                
            }else {
                self.wrongdeviceflag = 0;
                self.disconnect()
            }
            //            self.viewWillAppear(true)
            self.HUD.hide(true)
        })
    }
    
    
    // MARK: - Table view data source
    
    func numberOfSections(in tableView: UITableView) -> Int {
        // #warning Incomplete implementation, return the number of sections
        return 1
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        // #warning Incomplete implementation, return the number of rows
        return peripheralArray.count
    }
    
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "BTCell", for: indexPath)
        
        // Configure the cell...
        cell.textLabel?.text = (peripheralArray[indexPath.item] as AnyObject).name
        return cell
    }
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        appDelegate.mCentralManager?.stopScan()
        appDelegate.mCentralManager?.connect(peripheralArray[indexPath.item] as! CBPeripheral, options: nil)
        appDelegate.mPeripheral = peripheralArray[indexPath.item] as? CBPeripheral
        appDelegate.devicename = (peripheralArray[indexPath.item] as AnyObject).name
        
        DispatchQueue.main.async(execute: {() -> Void in
            self.searchstopItem.title = "Search"
            self.HUD = MBProgressHUD.showAdded(to: self.view, animated: true);
            self.HUD.labelText = "Connecting..."
            self.HUD.show(true)
        })
    }
    @IBAction func searchstopTapped(_ sender: UIBarButtonItem) {
        if searchstopItem.title == "Search" {
            peripheralArray.removeAllObjects()
            mQueue = DispatchQueue(label: "com.atid.bluetooth")
            appDelegate.mCentralManager = CBCentralManager(delegate: self, queue: mQueue)
            //            self.performSegue(withIdentifier: "BTConnect", sender: nil)
            DispatchQueue.main.async(execute: {() -> Void in
                self.searchstopItem.title = "Stop"
            })
        } else {
            appDelegate.mCentralManager?.stopScan()
            
            DispatchQueue.main.async(execute: {() -> Void in
                self.searchstopItem.title = "Search"
            })
        }
    }
    
    func disconnect() {
        if appDelegate.mReader != nil {
            appDelegate.mReader?.disconnect()
            appDelegate.mReader = nil
        }
        
        // cc 종료 확인 필요........
        //        if appDelegate.mPeripheral != nil {
        appDelegate.mCentralManager?.cancelPeripheralConnection(appDelegate.mPeripheral!)
        appDelegate.mPeripheral = nil
        //        }
    }
    @objc func bluetoothDisconnected(_ notification: Notification){
        HUD.hide(true)
        HUD.removeFromSuperview()
        appDelegate.connectflag = false
        appDelegate.mReader = nil
        appDelegate.mPeripheral = nil
        self.peripheralArray.removeAllObjects()
        btTableView.reloadData()
        
        let dialog = UIAlertController(title: "Connect State", message: "BT Disconnected!!!", preferredStyle: .alert)
        let action = UIAlertAction(title: "OK", style: UIAlertAction.Style.default)
        dialog.addAction(action)
        self.present(dialog, animated: true, completion: nil)
    }
    @objc func wrongdeviceconnected(_ notification: Notification) {
        
        wrongdeviceflag = 1
    }
}
