//
//  AppDelegate.swift
//  Inventory_EAReader
//
//  Created by 류은주 on 2017. 12. 7..
//  Copyright © 2017년 류은주. All rights reserved.
//

import UIKit

let DATA_TARGET = ["S0", "S1", "S2", "S3", "SL"]
let DATA_ACTION = ["AB", "AN", "NB", "MN", "BA", "BN", "NA", "NM"]
let DATA_BANK = ["Reserved", "EPC", "TID", "User"]
let DATA_BIT = ["0", "16", "32", "48", "64", "80", "96", "112", "128", "144", "160", "176", "192", "208", "224", "240"]
let DATA_WORD = ["0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15"]
let DATA_SELECT_FLAG = ["SL", "~SL", "All"]
let DATA_INVENTORY_SESSION = ["S0", "S1", "S2", "S3"]
let DATA_SESSION_FLAG = ["A Only", "B Only", "A or B"]

@UIApplicationMain
class AppDelegate: UIResponder, UIApplicationDelegate {

    var window: UIWindow?
    
    var mPeripheral: CBPeripheral?
    var mCentralManager: CBCentralManager?
    
    var mReader : EAReader?
    
    var batterystateThread: Thread?
    
    var backgraoundTaskIdentifier: UIBackgroundTaskIdentifier = UIBackgroundTaskIdentifier.invalid
    
    var aryTags = [AnyHashable]()
    var mapTags = [AnyHashable: Any]()
    
    var devicename: String?
    
    var connectFlag = false


    func application(_ application: UIApplication, didFinishLaunchingWithOptions launchOptions: [UIApplication.LaunchOptionsKey: Any]?) -> Bool {
        // Override point for customization after application launch.
        return true
    }

    func applicationWillResignActive(_ application: UIApplication) {
        // Sent when the application is about to move from active to inactive state. This can occur for certain types of temporary interruptions (such as an incoming phone call or SMS message) or when the user quits the application and it begins the transition to the background state.
        // Use this method to pause ongoing tasks, disable timers, and invalidate graphics rendering callbacks. Games should use this method to pause the game.
    }

    func applicationDidEnterBackground(_ application: UIApplication) {
        // Use this method to release shared resources, save user data, invalidate timers, and store enough application state information to restore your application to its current state in case it is terminated later.
        // If your application supports background execution, this method is called instead of applicationWillTerminate: when the user quits.
        self.backgraoundTaskIdentifier = UIApplication.shared.beginBackgroundTask(withName: "batterycheck",
                                                                                  expirationHandler: {print("Background task is expire now")})
    }

    func applicationWillEnterForeground(_ application: UIApplication) {
        // Called as part of the transition from the background to the active state; here you can undo many of the changes made on entering the background.
    }

    func applicationDidBecomeActive(_ application: UIApplication) {
        // Restart any tasks that were paused (or not yet started) while the application was inactive. If the application was previously in the background, optionally refresh the user interface.
        UIApplication.shared.isIdleTimerDisabled = true
        batterystateThread = Thread(target: self, selector: #selector(self.batteryCheckThread), object: nil)
        batterystateThread?.start()
        if self.backgraoundTaskIdentifier != UIBackgroundTaskIdentifier.invalid{
            UIApplication.shared.endBackgroundTask(self.backgraoundTaskIdentifier)
            self.backgraoundTaskIdentifier = UIBackgroundTaskIdentifier.invalid
        }
    }

    func applicationWillTerminate(_ application: UIApplication) {
        // Called when the application is about to terminate. Save data if appropriate. See also applicationDidEnterBackground:.
        
        batterystateThread?.cancel()
    }
    
    @objc func batteryCheckThread(){
        while Thread.current.isCancelled == false {
            DispatchQueue.main.async(execute: {() -> Void in
                if(self.connectFlag == true){
                _ = self.mReader?.batteryStatus()
                }
            })
            Thread.sleep(forTimeInterval: 15)
        }
    }

}

