//
//  SymbolZSettingViewController.swift
//  Barcode_ATIDReader
//
//  Created by 류은주 on 2018. 2. 20..
//  Copyright © 2018년 류은주. All rights reserved.
//
let PICKER_VIEW_SUPPLEMENTALS = 0
let PICKER_VIEW_AIM_ID = 1
let PICKER_VIEW_UPCA_PREAMBLE = 2
let PICKER_VIEW_UPCE_PREAMBLE = 3
let PICKER_VIEW_UPCE1_PREAMBLE = 4
let PICKER_VIEW_COUPON_REPORT = 5
let PICKER_VIEW_ISBT = 6
let PICKER_VIEW_CODE11 = 7
let PICKER_VIEW_KOREAN_INVERSE = 8
let PICKER_VIEW_AUSTRALIA_FORMAT = 9
let PICKER_VIEW_GS1_DATABAR_SEC = 10
let PICKER_VIEW_UPC_COMPOSITE = 11
let PICKER_VIEW_COMPOSITE_BEEP = 12
let PICKER_VIEW_DATA_MATRIX_INVERSE = 13
let PICKER_VIEW_DECODE_MIRROR = 14

import UIKit

class SymbolZSettingViewController: UIViewController,  UITableViewDataSource, UITableViewDelegate, UIPickerViewDelegate, UIPickerViewDataSource, EAReaderDelegate {
    
    @IBOutlet weak var symbolZTableView: UITableView!
    @IBOutlet weak var symbolSettingPickerView: UIPickerView!
    @IBOutlet weak var pickerViewTopView: UIView!
    
    var upcEANItems : NSArray?
    var picker_aimID : NSArray?
    var picker_preamble : NSArray?
    var picker_coupon : NSArray?
    var picker_supplementals : NSArray?
    var picker_ISBTConcatenation : NSArray?
    var picker_i2of5Sec : NSArray?
    var picker_code11CheckDigit : NSArray?
    var koreanInverse : NSArray?
    var australiaFormat : NSArray?
    var gs1databar_sec : NSArray?
    var upccomposit : NSArray?
    var compositebeep : NSArray?
    var decodemirror = [Any]()
    
    var selectedSymbol : Int?
    var symbolParamData : NSArray?
    
    var topviewflag = 0

    
    var appDelegate = UIApplication.shared.delegate as! AppDelegate
    
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
        
        let center = NotificationCenter.default
        center.addObserver(self, selector: #selector(self.bluetoothDisconnected), name: NSNotification.Name.init(rawValue: "BluetoothDisconnected"), object: nil)
        
        
        picker_aimID = ["Separate", "Combined", "Separate Transmissions"]
        picker_preamble = ["No Preamble", "System Character", "System Character & Country Code"]
        picker_coupon = ["Old Coupon Symbols", "New Coupon Symbols", "Both Coupon Formats"]
        picker_supplementals = ["Ignore Supplementals", "Decode UPC/EAN/JAN Only With Supplementals", "Autodiscriminate UPC/EAN/JAN Supplementals", "Enable Smart Supplemental Mode", "Enable 378/379 Supplemental Mode", "Enable 978/979 Supplemental Mode", "Enable 414/419/434/439 Supplemental Mode", "Enable 977 Supplemental Mode", "Enable 491 Supplemental Mode"]
        picker_ISBTConcatenation = ["Disable", "Enable", "Autodiscriminate"]
        picker_i2of5Sec = ["Level 0", "Level 1", "Level 2", "Level 3"]
        picker_code11CheckDigit = ["Disable", "One Check Digit", "Two Check Digits"]
        koreanInverse = ["Regular", "Inverse Only", "Inverse Autodetect"]
        australiaFormat = ["Autodiscriminate", "Raw Format", "Alphanumeric Encoding", "Numeric Encoding"]
        gs1databar_sec = ["Level 1", "Level 2", "Level 3", "Level 4"]
        upccomposit = ["UPC Never Linked", "UPC Always Linked", "Autodiscriminate UPC Composites"]
        compositebeep = ["Single Beep After Both are Decoded", "Beep as Each Code Type is Decoded", "Double Beep After Both are Decoded"]
        decodemirror = ["Never", "Always", "Auto"]

    }
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        var paramData = [Any]()
        if selectedSymbol! < 5 {
            paramData = [ParamNameBooklandEAN.rawValue, ParamNameBooklandISBNFormat.rawValue, ParamNameDecodeUPCEANSupply.rawValue, ParamNameUPCEANSupplyRedundancy.rawValue, ParamNameDecodeUPCEANSupplyAIMID.rawValue, ParamNameTransmitUPCACheckDigit.rawValue, ParamNameTransmitUPCECheckDigit.rawValue, ParamNameTransmitUPCE1CheckDigit.rawValue, ParamNameUPCAPreamble.rawValue, ParamNameUPCEPreamble.rawValue, ParamNameUPCE1Preamble.rawValue, ParamNameConvertUPCEtoA.rawValue, ParamNameConvertUPCE1toA.rawValue, ParamNameEAN8Extend.rawValue, ParamNameUCCCouponExtendCode.rawValue, ParamNameCouponReport.rawValue, ParamNameISSNEAN.rawValue, ParamNameUPCReduecedQuietZone.rawValue]
        } else if selectedSymbol == 5 {
            paramData = [ParamNameCode128Length1.rawValue, ParamNameCode128Length2.rawValue, ParamNameGS1128.rawValue, ParamNameISBT128.rawValue, ParamNameISBTConcatenation.rawValue, ParamNameCheckISBTTable.rawValue, ParamNameISBTConcatenationRedundancy.rawValue, ParamNamecode128ReducedQuietZone.rawValue, ParamNameIgnoreCode128.rawValue]
        } else if selectedSymbol == 6 {
            paramData = [ParamNameTriopticCode39.rawValue, ParamNameConvertCode39toCode32.rawValue, ParamNameCode32Prefix.rawValue, ParamNameCode39Length1.rawValue, ParamNameCode39Length2.rawValue, ParamNameCode39CheckDigitVerification.rawValue, ParamNameTransmitCode39CheckDigit.rawValue, ParamNameCode39FullASCIIConversion.rawValue, ParamNameBufferCode39.rawValue, ParamNameCode39QuietZone.rawValue]
        } else if selectedSymbol == 7 {
            paramData = [ParamNameCode93Length1.rawValue, ParamNameCode93Length2.rawValue]
        } else if selectedSymbol == 8 {
            paramData = [ParamNameCode11Length1.rawValue, ParamNameCode11Length2.rawValue, ParamNameCode11CheckDigitVerification.rawValue, ParamNameTransmitCode11CheckDigit.rawValue]
        } else if selectedSymbol == 9 {
            paramData = [ParamNameI2of5Length1.rawValue, ParamNameI2of5Length2.rawValue, ParamNameI2of5CheckDigitVerification.rawValue, ParamNameTransmitI2of5CheckDigit.rawValue, ParamNameConvertI2of5toEAN13.rawValue,     //                     [NSNumber numberWithInt:ParamNameI2of5SecurityLevel],
                ParamNameI2of5QuietZone.rawValue]
        } else if selectedSymbol == 10 {
            paramData = [ParamNameD2of5Length1.rawValue, ParamNameD2of5Length2.rawValue]
        } else if selectedSymbol == 11 {
            paramData = [ParamNameCodabarLength1.rawValue, ParamNameCodabarLength2.rawValue, ParamNameCLSIEditing.rawValue, ParamNameNOTISEditing.rawValue, ParamNameCodabarCharDetection.rawValue]
        } else if selectedSymbol == 12 {
            paramData = [ParamNameMSILength1.rawValue, ParamNameMSILength2.rawValue, ParamNameMSICheckDigit.rawValue, ParamNameTransmitMSICheckDigit.rawValue, ParamNameMSICheckDigitAlgorithm.rawValue]
        } else if selectedSymbol == 14 {
            paramData = [ParamNameM2of5Length1.rawValue, ParamNameM2of5Length2.rawValue, ParamNameM2of5CheckDigit.rawValue, ParamNameTransmitM2of5CheckDigit.rawValue]
        } else if selectedSymbol == 16 {
            paramData = [ParamNameGS1DatabarLimited.rawValue, ParamNameGS1DatabarLimitedSecurityLevel.rawValue, ParamNameGS1DatabarExpanded.rawValue, ParamNameConvertGS1DatabarToUPCEAN.rawValue]
        } else if selectedSymbol == 17 {
            if appDelegate.mReader?.barcodedeviceget() == 2 {
                paramData = [ParamNameUPCCompositeMode.rawValue, ParamNameCompositeBeepMode.rawValue, ParamNameGS1128EmulMode.rawValue]
            }
            else {
                paramData = [ParamNameTransmitUSPostalCheckDigit.rawValue]
            }
        } else if selectedSymbol == 18 {
            if appDelegate.mReader?.barcodedeviceget() == 2 {
                paramData = [ParamNameInverse1D.rawValue]
            }
            else {
                paramData = [ParamNameTransmitUKPostalCheckDigit.rawValue]
            }
        } else if selectedSymbol == 20 {
            paramData = [ParamNameAustraliaPostFormat.rawValue]
        } else if selectedSymbol == 24 {
            paramData = [ParamNameGS1DatabarLimited.rawValue, ParamNameGS1DatabarLimitedSecurityLevel.rawValue, ParamNameGS1DatabarExpanded.rawValue, ParamNameConvertGS1DatabarToUPCEAN.rawValue]
        } else if (selectedSymbol == 25) || (selectedSymbol == 26) || (selectedSymbol == 27) {
            paramData = [ParamNameUPCCompositeMode.rawValue, ParamNameCompositeBeepMode.rawValue, ParamNameGS1128EmulMode.rawValue]
        } else if selectedSymbol == 31 {
            paramData = [ParamNameDataMatrixInverse.rawValue, ParamNameDecodeMirrorImages.rawValue]
        } else if selectedSymbol == 33 {
            paramData = [ParamNameQRInverse.rawValue]
        } else if selectedSymbol == 35 {
            paramData = [ParamNameAztecInverse.rawValue]
        } else if selectedSymbol == 36 {
            paramData = [ParamNameHanXinInverse.rawValue]
        } else if selectedSymbol == 37 {
            paramData = [ParamNameInverse1D.rawValue]
        }
        symbolParamData = appDelegate.mReader?.getBarcodeParam(paramData)! as NSArray?
//        for paramValue: EAParamValue in symbolParamData {
//            print("\(EAParamName.msg(paramValue.paramName))")
//        }
//        tmpArray = [AnyHashable]()
//        for i in 0..<symbolParamData.count {
//            var paramValue = symbolParamData[i] as? EAParamValue
//            tmpArray.append("\(paramValue.value)")
//            print(" tmpArray [\(i)] = \(paramValue.value)")
//        }

    }
    
    override func viewWillDisappear(_ animated: Bool) {
        super.viewWillDisappear(animated)
        NotificationCenter.default.removeObserver(self, name: NSNotification.Name(rawValue: "BluetoothDisconnected"), object: nil)
    }
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }
    

    /*
    // MARK: - Navigation

    // In a storyboard-based application, you will often want to do a little preparation before navigation
    override func prepare(for segue: UIStoryboardSegue, sender: Any?) {
        // Get the new view controller using segue.destinationViewController.
        // Pass the selected object to the new view controller.
    }
    */

    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return (symbolParamData?.count)!
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell : SymbolSettingTableViewCell = tableView.dequeueReusableCell(withIdentifier: "SymbolCell", for: indexPath) as! SymbolSettingTableViewCell
       
        let paramValue = symbolParamData![indexPath.row] as? EAParamValue
        cell.symbolItem.text = EAParamName.msg((paramValue?.paramName)!)
        if selectedSymbol! < 5 {
            if (indexPath.row == 0) || (indexPath.row > 4) && (indexPath.row < 8) || (indexPath.row > 10) && (indexPath.row < 15) || (indexPath.row == 16) || (indexPath.row == 17) {
                if paramValue?.value == 0 {
                    cell.symbolItemValue.text = "Disable"
                }
                else {
                    cell.symbolItemValue.text = "Enable"
                }
            } else if indexPath.row == 1 {
                if paramValue?.value == 0 {
                    cell.symbolItemValue.text = "ISBN-10"
                } else {
                    cell.symbolItemValue.text = "ISBN-13"
                }
            } else if indexPath.row == 2 {
                cell.symbolItemValue.text = picker_supplementals?[Int(paramValue!.value)] as? String
            } else if indexPath.row == 4 {
                cell.symbolItemValue.text = picker_aimID?[Int(paramValue!.value)] as? String
            } else if (indexPath.row > 7) && (indexPath.row < 11) {
                cell.symbolItemValue.text = picker_preamble?[Int(paramValue!.value)] as? String
            } else if indexPath.row == 15 {
                cell.symbolItemValue.text = picker_coupon?[Int(paramValue!.value)] as? String
            } else {
                cell.symbolItemValue.text = "\(String(describing: paramValue!.value))"
            }
        }else if selectedSymbol == 5 {
            if (indexPath.row == 0) || (indexPath.row == 1) || (indexPath.row == 6) {
                cell.symbolItemValue.text = "\(String(describing: paramValue!.value))"
            }
            else if indexPath.row == 4 {
                cell.symbolItemValue.text = picker_ISBTConcatenation?[Int(paramValue!.value)] as? String
            }
            else {
                if paramValue?.value == 0 {
                    cell.symbolItemValue.text = "Disable"
                }
                else {
                    cell.symbolItemValue.text = "Enable"
                }
            }
        } else if selectedSymbol == 6 {
            if (indexPath.row == 3) || (indexPath.row == 4) {
                cell.symbolItemValue.text = "\(String(describing: paramValue!.value))"
            }
            else {
                if paramValue?.value == 0 {
                    cell.symbolItemValue.text = "Disable"
                }
                else {
                    cell.symbolItemValue.text = "Enable"
                }
            }
        } else if (selectedSymbol == 7) || (selectedSymbol == 10) {
            cell.symbolItemValue.text = "\(String(describing: paramValue!.value))"
        } else if selectedSymbol == 8 {
            if (indexPath.row == 0) || (indexPath.row == 1) {
                cell.symbolItemValue.text = "\(String(describing: paramValue!.value))"
            }
            else if indexPath.row == 2 {
                cell.symbolItemValue.text = picker_code11CheckDigit?[Int(paramValue!.value)] as? String
            }
            else {
                if paramValue?.value == 0 {
                    cell.symbolItemValue.text = "Disable"
                }
                else {
                    cell.symbolItemValue.text = "Enable"
                }
            }
        } else if selectedSymbol == 9 {
            if (indexPath.row == 0) || (indexPath.row == 1) {
                cell.symbolItemValue.text = "\(String(describing: paramValue!.value))"
            }
            else {
                if paramValue?.value == 0 {
                    cell.symbolItemValue.text = "Disable"
                }
                else {
                    cell.symbolItemValue.text = "Enable"
                }
            }
        } else if selectedSymbol == 11 {
            if (indexPath.row == 0) || (indexPath.row == 1) {
                cell.symbolItemValue.text = "\(String(describing: paramValue!.value))"
            } else if indexPath.row == 4 {
                if paramValue?.value == 0 {
                    cell.symbolItemValue.text = "Upper Case"
                } else {
                    cell.symbolItemValue.text = "Lower Case"
                }
            }  else {
                if paramValue?.value == 0 {
                    cell.symbolItemValue.text = "Disable"
                } else {
                    cell.symbolItemValue.text = "Enable"
                }
            }
        } else if selectedSymbol == 12 {
            if (indexPath.row == 0) || (indexPath.row == 1) {
                cell.symbolItemValue.text = "\(String(describing: paramValue!.value))"
            } else if indexPath.row == 2 {
                if paramValue?.value == 0 {
                    cell.symbolItemValue.text = "One"
                } else {
                    cell.symbolItemValue.text = "Two"
                }
            } else if indexPath.row == 3 {
                if paramValue?.value == 0 {
                    cell.symbolItemValue.text = "Disable"
                } else {
                    cell.symbolItemValue.text = "Enable"
                }
            } else {
                if paramValue?.value == 0 {
                    cell.symbolItemValue.text = "Mod10/11"
                } else {
                    cell.symbolItemValue.text = "Mod10/10"
                }
            }
        } else if selectedSymbol == 14 {
            if (indexPath.row == 0) || (indexPath.row == 1) {
                cell.symbolItemValue.text = "\(String(describing: paramValue!.value))"
            } else {
                if paramValue?.value == 0 {
                    cell.symbolItemValue.text = "Disable"
                } else {
                    cell.symbolItemValue.text = "Enable"
                }
            }
        } else if selectedSymbol == 16 {
            if indexPath.row == 1 {
                cell.symbolItemValue.text = gs1databar_sec?[Int(paramValue!.value) - 1] as? String
            } else {
                if paramValue?.value == 0 {
                    cell.symbolItemValue.text = "Disable"
                } else {
                    cell.symbolItemValue.text = "Enable"
                }
            }
        } else if selectedSymbol == 17 {
            if appDelegate.mReader?.barcodedeviceget() == 2 {
                if indexPath.row == 0 {
                    cell.symbolItemValue.text = upccomposit?[Int(paramValue!.value)] as? String
                } else if indexPath.row == 1 {
                    cell.symbolItemValue.text = compositebeep?[Int(paramValue!.value)] as? String
                } else {
                    if paramValue?.value == 0 {
                        cell.symbolItemValue.text = "Disable"
                    } else {
                        cell.symbolItemValue.text = "Enable"
                    }
                }
            } else {
                if paramValue?.value == 0 {
                    cell.symbolItemValue.text = "Disable"
                } else {
                    cell.symbolItemValue.text = "Enable"
                }
            }
        } else if selectedSymbol == 18 {
            if appDelegate.mReader?.barcodedeviceget() == 2 {
                cell.symbolItemValue.text = koreanInverse?[Int(paramValue!.value)] as? String
            }
            else {
                if paramValue?.value == 0 {
                    cell.symbolItemValue.text = "Disable"
                }
                else {
                    cell.symbolItemValue.text = "Enable"
                }
            }
        } else if selectedSymbol == 20 {
            cell.symbolItemValue.text = australiaFormat?[Int(paramValue!.value)] as? String
        } else if selectedSymbol == 24 {
            if indexPath.row == 1 {
                cell.symbolItemValue.text = gs1databar_sec?[Int(paramValue!.value) - 1] as? String
            } else {
                if paramValue?.value == 0 {
                    cell.symbolItemValue.text = "Disable"
                } else {
                    cell.symbolItemValue.text = "Enable"
                }
            }
        } else if (selectedSymbol == 25) || (selectedSymbol == 26) || (selectedSymbol == 27) {
            if indexPath.row == 0 {
                cell.symbolItemValue.text = upccomposit?[Int(paramValue!.value)] as? String
            } else if indexPath.row == 1 {
                cell.symbolItemValue.text = compositebeep?[Int(paramValue!.value)] as? String
            } else {
                if paramValue?.value == 0 {
                    cell.symbolItemValue.text = "Disable"
                } else {
                    cell.symbolItemValue.text = "Enable"
                }
            }
        } else if selectedSymbol == 31 {
            if indexPath.row == 0 {
                cell.symbolItemValue.text = koreanInverse?[Int(paramValue!.value)] as? String
            }
            else {
                cell.symbolItemValue.text = decodemirror[Int(paramValue!.value)] as? String
            }
        } else if (selectedSymbol == 33) || (selectedSymbol == 35) || (selectedSymbol == 36) {
            cell.symbolItemValue.text = koreanInverse?[Int(paramValue!.value)] as? String
        } else if (selectedSymbol == 37) || (selectedSymbol == 28) {
            cell.symbolItemValue.text = koreanInverse?[Int(paramValue!.value)] as? String
        }
        return cell
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        let paramValue = symbolParamData?[indexPath.row] as? EAParamValue
        if selectedSymbol! < 5 {
            if (indexPath.row == 0) || (indexPath.row == 1) || (indexPath.row > 4) && (indexPath.row < 8) || (indexPath.row > 10) && (indexPath.row < 15) || (indexPath.row == 16) || (indexPath.row == 17) {
                
                if paramValue?.value == 0 {
                    paramValue?.value = 1
                }
                else {
                    paramValue?.value = 0
                }
            } else if (indexPath.row == 2) || (indexPath.row == 4) || (indexPath.row == 15) || (indexPath.row > 7) && (indexPath.row < 11) {
                if indexPath.row == 2 {
                    symbolSettingPickerView.tag = PICKER_VIEW_SUPPLEMENTALS
                }
                else if indexPath.row == 4 {
                    symbolSettingPickerView.tag = PICKER_VIEW_AIM_ID
                }
                else if indexPath.row == 15 {
                    symbolSettingPickerView.tag = PICKER_VIEW_COUPON_REPORT
                }
                else if (indexPath.row > 7) && (indexPath.row < 11) {
                    symbolSettingPickerView.tag = PICKER_VIEW_UPCA_PREAMBLE
                }
                topviewflag = indexPath.row
                symbolSettingPickerView.reloadAllComponents()
                symbolSettingPickerView.selectRow(Int(paramValue!.value), inComponent: 0, animated: false)
                symbolSettingPickerView.isHidden = false
                pickerViewTopView.isHidden = false
            } else if indexPath.row == 3 {
                let alert = UIAlertController(title: "Redundancy:", message: "Please enter UPC/EAN/JAN Supplemental Redundancy", preferredStyle: .alert)
                alert.addTextField(configurationHandler: {(_ textField: UITextField) -> Void in
                    textField.keyboardType = .numberPad
                })
                let ok = UIAlertAction(title: "OK", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                    let textField: UITextField? = alert.textFields?.first
                    let paramValue = self.symbolParamData![indexPath.row] as? EAParamValue
                    paramValue?.value = UInt32(Int32(Int(textField!.text ?? "") ?? 0))
                    self.symbolZTableView.reloadData()
                    alert.dismiss(animated: true) {() -> Void in }
                })
                let cancel = UIAlertAction(title: "Cancel", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                    alert.dismiss(animated: true) {() -> Void in }
                })
                alert.addAction(cancel)
                alert.addAction(ok)
                
                DispatchQueue.main.async(execute: {() -> Void in
                    self.present(alert, animated: true) {() -> Void in }
                })
            }
            else {
                //        cell.detailvalue.text = [NSString stringWithFormat:@"%d",paramValue.value];
            }
        } else if selectedSymbol == 5 {
            if (indexPath.row == 0) || (indexPath.row == 1) || (indexPath.row == 6) {
                let alert = UIAlertController(title: "Code128:", message: "Please enter a number to set", preferredStyle: .alert)
                alert.addTextField(configurationHandler: {(_ textField: UITextField) -> Void in
                    textField.keyboardType = .numberPad
                })
                let ok = UIAlertAction(title: "OK", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                    let textField: UITextField? = alert.textFields?.first
                    let paramValue = self.symbolParamData![indexPath.row] as? EAParamValue
                    paramValue?.value = UInt32(Int32(Int(textField!.text ?? "") ?? 0))
                    self.symbolZTableView.reloadData()
                    alert.dismiss(animated: true) {() -> Void in }
                })
                let cancel = UIAlertAction(title: "Cancel", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                    alert.dismiss(animated: true) {() -> Void in }
                })
                alert.addAction(cancel)
                alert.addAction(ok)
                
                DispatchQueue.main.async(execute: {() -> Void in
                    self.present(alert, animated: true) {() -> Void in }
                })
            } else if indexPath.row == 4 {
                symbolSettingPickerView.tag = PICKER_VIEW_ISBT
                topviewflag = indexPath.row
                symbolSettingPickerView.reloadAllComponents()
                symbolSettingPickerView.selectRow(Int(paramValue!.value), inComponent: 0, animated: false)
                symbolSettingPickerView.isHidden = false
                pickerViewTopView.isHidden = false
            } else {
                if paramValue?.value == 0 {
                    paramValue?.value = 1
                } else {
                    paramValue?.value = 0
                }
            }
        } else if selectedSymbol == 6 {
            if (indexPath.row == 3) || (indexPath.row == 4) {
                let alert = UIAlertController(title: "Code 39:", message: "Please enter a number to set(2 to 55)", preferredStyle: .alert)
                alert.addTextField(configurationHandler: {(_ textField: UITextField) -> Void in
                    textField.keyboardType = .numberPad
                })
                let ok = UIAlertAction(title: "OK", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                    let textField: UITextField? = alert.textFields?.first
                    let paramValue = self.symbolParamData![indexPath.row] as? EAParamValue
                    paramValue?.value = UInt32(Int32(Int(textField!.text ?? "") ?? 0))
                    self.symbolZTableView.reloadData()
                    alert.dismiss(animated: true) {() -> Void in }
                })
                let cancel = UIAlertAction(title: "Cancel", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                    alert.dismiss(animated: true) {() -> Void in }
                })
                alert.addAction(cancel)
                alert.addAction(ok)
                
                DispatchQueue.main.async(execute: {() -> Void in
                    self.present(alert, animated: true) {() -> Void in }
                })
            }
            else {
                if paramValue?.value == 0 {
                    paramValue?.value = 1
                }
                else {
                    paramValue?.value = 0
                }
            }
        } else if selectedSymbol == 7 {
            let alert = UIAlertController(title: "Code 93:", message: "Please enter a number to set(4 to 55)", preferredStyle: .alert)
            alert.addTextField(configurationHandler: {(_ textField: UITextField) -> Void in
                textField.keyboardType = .numberPad
            })
            let ok = UIAlertAction(title: "OK", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                let textField: UITextField? = alert.textFields?.first
                let paramValue = self.symbolParamData![indexPath.row] as? EAParamValue
                paramValue?.value = UInt32(Int32(Int(textField!.text ?? "") ?? 0))
                self.symbolZTableView.reloadData()
                alert.dismiss(animated: true) {() -> Void in }
            })
            let cancel = UIAlertAction(title: "Cancel", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                alert.dismiss(animated: true) {() -> Void in }
            })
            alert.addAction(cancel)
            alert.addAction(ok)
            
            DispatchQueue.main.async(execute: {() -> Void in
                self.present(alert, animated: true) {() -> Void in }
            })
        } else if selectedSymbol == 8 {
            if (indexPath.row == 0) || (indexPath.row == 1) {
                let alert = UIAlertController(title: "Code 11:", message: "Please enter a number to set(4 to 55)", preferredStyle: .alert)
                alert.addTextField(configurationHandler: {(_ textField: UITextField) -> Void in
                    textField.keyboardType = .numberPad
                })
                let ok = UIAlertAction(title: "OK", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                    let textField: UITextField? = alert.textFields?.first
                    let paramValue = self.symbolParamData![indexPath.row] as? EAParamValue
                    paramValue?.value = UInt32(Int32(Int(textField!.text ?? "") ?? 0))
                    self.symbolZTableView.reloadData()
                    alert.dismiss(animated: true) {() -> Void in }
                })
                let cancel = UIAlertAction(title: "Cancel", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                    alert.dismiss(animated: true) {() -> Void in }
                })
                alert.addAction(cancel)
                alert.addAction(ok)
                
                DispatchQueue.main.async(execute: {() -> Void in
                    self.present(alert, animated: true) {() -> Void in }
                })
            } else if indexPath.row == 2 {
                symbolSettingPickerView.tag = PICKER_VIEW_CODE11
                topviewflag = indexPath.row
                symbolSettingPickerView.reloadAllComponents()
                symbolSettingPickerView.selectRow(Int(paramValue!.value), inComponent: 0, animated: false)
                symbolSettingPickerView.isHidden = false
                pickerViewTopView.isHidden = false
            }  else {
                if paramValue?.value == 0 {
                    paramValue?.value = 1
                } else {
                    paramValue?.value = 0
                }
            }
        } else if selectedSymbol == 9 {
            if (indexPath.row == 0) || (indexPath.row == 1) {
                let alert = UIAlertController(title: "Interleaved 2 of 5:", message: "Please enter a number to set(0 to 55)", preferredStyle: .alert)
                alert.addTextField(configurationHandler: {(_ textField: UITextField) -> Void in
                    textField.keyboardType = .numberPad
                })
                let ok = UIAlertAction(title: "OK", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                    let textField: UITextField? = alert.textFields?.first
                    let paramValue = self.symbolParamData![indexPath.row] as? EAParamValue
                    paramValue?.value = UInt32(Int32(Int(textField!.text ?? "") ?? 0))
                    self.symbolZTableView.reloadData()
                    alert.dismiss(animated: true) {() -> Void in }
                })
                let cancel = UIAlertAction(title: "Cancel", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                    alert.dismiss(animated: true) {() -> Void in }
                })
                alert.addAction(cancel)
                alert.addAction(ok)
                
                DispatchQueue.main.async(execute: {() -> Void in
                    self.present(alert, animated: true) {() -> Void in }
                })
            }
            else {
                if paramValue?.value == 0 {
                    paramValue?.value = 1
                }
                else {
                    paramValue?.value = 0
                }
            }
        } else if selectedSymbol == 10 {
            let alert = UIAlertController(title: "Discrete 2 of 5:", message: "Please enter Discrete 2 of 5 length(0 to 55)", preferredStyle: .alert)
            alert.addTextField(configurationHandler: {(_ textField: UITextField) -> Void in
                textField.keyboardType = .numberPad
            })
            let ok = UIAlertAction(title: "OK", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                let textField: UITextField? = alert.textFields?.first
                let paramValue = self.symbolParamData![indexPath.row] as? EAParamValue
                paramValue?.value = UInt32(Int32(Int(textField!.text ?? "") ?? 0))
                self.symbolZTableView.reloadData()
                alert.dismiss(animated: true) {() -> Void in }
            })
            let cancel = UIAlertAction(title: "Cancel", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                alert.dismiss(animated: true) {() -> Void in }
            })
            alert.addAction(cancel)
            alert.addAction(ok)
            
            DispatchQueue.main.async(execute: {() -> Void in
                self.present(alert, animated: true) {() -> Void in }
            })
        } else if selectedSymbol == 11 {
            if (indexPath.row == 0) || (indexPath.row == 1) {
                let alert = UIAlertController(title: "CodarBar:", message: "Please enter a number to set(5 to 55)", preferredStyle: .alert)
                alert.addTextField(configurationHandler: {(_ textField: UITextField) -> Void in
                    textField.keyboardType = .numberPad
                })
                let ok = UIAlertAction(title: "OK", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                    let textField: UITextField? = alert.textFields?.first
                    let paramValue = self.symbolParamData![indexPath.row] as? EAParamValue
                    paramValue?.value = UInt32(Int32(Int(textField!.text ?? "") ?? 0))
                    self.symbolZTableView.reloadData()
                    alert.dismiss(animated: true) {() -> Void in }
                })
                let cancel = UIAlertAction(title: "Cancel", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                    alert.dismiss(animated: true) {() -> Void in }
                })
                alert.addAction(cancel)
                alert.addAction(ok)
                
                DispatchQueue.main.async(execute: {() -> Void in
                    self.present(alert, animated: true) {() -> Void in }
                })
            }
            else {
                if paramValue?.value == 0 {
                    paramValue?.value = 1
                }
                else {
                    paramValue?.value = 0
                }
            }
        } else if selectedSymbol == 12 {
            if (indexPath.row == 0) || (indexPath.row == 1) {
                let alert = UIAlertController(title: "MSI:", message: "Please enter a number to set(4 to 55)", preferredStyle: .alert)
                alert.addTextField(configurationHandler: {(_ textField: UITextField) -> Void in
                    textField.keyboardType = .numberPad
                })
                let ok = UIAlertAction(title: "OK", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                    let textField: UITextField? = alert.textFields?.first
                    let paramValue = self.symbolParamData![indexPath.row] as? EAParamValue
                    paramValue?.value = UInt32(Int32(Int(textField!.text ?? "") ?? 0))
                    self.symbolZTableView.reloadData()
                    alert.dismiss(animated: true) {() -> Void in }
                })
                let cancel = UIAlertAction(title: "Cancel", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                    alert.dismiss(animated: true) {() -> Void in }
                })
                alert.addAction(cancel)
                alert.addAction(ok)
                
                DispatchQueue.main.async(execute: {() -> Void in
                    self.present(alert, animated: true) {() -> Void in }
                })
            }
            else {
                if paramValue?.value == 0 {
                    paramValue?.value = 1
                }
                else {
                    paramValue?.value = 0
                }
            }
        } else if selectedSymbol == 14 {
            if (indexPath.row == 0) || (indexPath.row == 1) {
                let alert = UIAlertController(title: "Matrix 2 of 5:", message: "Please enter a number to set", preferredStyle: .alert)
                alert.addTextField(configurationHandler: {(_ textField: UITextField) -> Void in
                    textField.keyboardType = .numberPad
                })
                let ok = UIAlertAction(title: "OK", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                    let textField: UITextField? = alert.textFields?.first
                    let paramValue = self.symbolParamData![indexPath.row] as? EAParamValue
                    paramValue?.value = UInt32(Int32(Int(textField!.text ?? "") ?? 0))
                    self.symbolZTableView.reloadData()
                    alert.dismiss(animated: true) {() -> Void in }
                })
                let cancel = UIAlertAction(title: "Cancel", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                    alert.dismiss(animated: true) {() -> Void in }
                })
                alert.addAction(cancel)
                alert.addAction(ok)
                
                DispatchQueue.main.async(execute: {() -> Void in
                    self.present(alert, animated: true) {() -> Void in }
                })
            }
            else {
                if paramValue?.value == 0 {
                    paramValue?.value = 1
                }
                else {
                    paramValue?.value = 0
                }
            }
        } else if selectedSymbol == 16 {
            if indexPath.row == 1 {
                symbolSettingPickerView.tag = PICKER_VIEW_GS1_DATABAR_SEC
                topviewflag = indexPath.row
                symbolSettingPickerView.reloadAllComponents()
                symbolSettingPickerView.selectRow(Int(paramValue!.value) - 1, inComponent: 0, animated: false)
                symbolSettingPickerView.isHidden = false
                pickerViewTopView.isHidden = false
            }
            else {
                if paramValue?.value == 0 {
                    paramValue?.value = 1
                }
                else {
                    paramValue?.value = 0
                }
            }
        }else if selectedSymbol == 17 {
            if appDelegate.mReader?.barcodedeviceget() == 2 {
                if indexPath.row == 0 {
                    symbolSettingPickerView.tag = PICKER_VIEW_UPC_COMPOSITE
                    topviewflag = indexPath.row
                    symbolSettingPickerView.reloadAllComponents()
                    symbolSettingPickerView.selectRow(Int(paramValue!.value), inComponent: 0, animated: false)
                    symbolSettingPickerView.isHidden = false
                    pickerViewTopView.isHidden = false
                } else if indexPath.row == 1 {
                    symbolSettingPickerView.tag = PICKER_VIEW_COMPOSITE_BEEP
                    topviewflag = indexPath.row
                    symbolSettingPickerView.reloadAllComponents()
                    symbolSettingPickerView.selectRow(Int(paramValue!.value), inComponent: 0, animated: false)
                    symbolSettingPickerView.isHidden = false
                    pickerViewTopView.isHidden = false
                } else {
                    if paramValue?.value == 0 {
                        paramValue?.value = 1
                    } else {
                        paramValue?.value = 0
                    }
                }
            } else {
                if paramValue?.value == 0 {
                    paramValue?.value = 1
                } else {
                    paramValue?.value = 0
                }
            }
        } else if selectedSymbol == 18 {
            let paramValue = symbolParamData?[indexPath.row] as? EAParamValue
            if appDelegate.mReader?.barcodedeviceget() == 2 {
                symbolSettingPickerView.tag = PICKER_VIEW_KOREAN_INVERSE
                topviewflag = indexPath.row
                symbolSettingPickerView.reloadAllComponents()
                symbolSettingPickerView.selectRow(Int(paramValue!.value), inComponent: 0, animated: false)
                symbolSettingPickerView.isHidden = false
                pickerViewTopView.isHidden = false
            } else {
                if paramValue?.value == 0 {
                    paramValue?.value = 1
                } else {
                    paramValue?.value = 0
                }
            }
        } else if selectedSymbol == 20 {
            symbolSettingPickerView.tag = PICKER_VIEW_AUSTRALIA_FORMAT
            topviewflag = indexPath.row
            symbolSettingPickerView.reloadAllComponents()
            symbolSettingPickerView.selectRow(Int(paramValue!.value), inComponent: 0, animated: false)
            symbolSettingPickerView.isHidden = false
            pickerViewTopView.isHidden = false
        }  else if selectedSymbol == 24 {
            if indexPath.row == 1 {
                symbolSettingPickerView.tag = PICKER_VIEW_GS1_DATABAR_SEC
                topviewflag = indexPath.row
                symbolSettingPickerView.reloadAllComponents()
                symbolSettingPickerView.selectRow(Int(paramValue!.value) - 1, inComponent: 0, animated: false)
                symbolSettingPickerView.isHidden = false
                pickerViewTopView.isHidden = false
            } else {
                if paramValue?.value == 0 {
                    paramValue?.value = 1
                } else {
                    paramValue?.value = 0
                }
            }
        } else if (selectedSymbol == 25) || (selectedSymbol == 26) || (selectedSymbol == 27) {
            if indexPath.row == 0 {
                symbolSettingPickerView.tag = PICKER_VIEW_UPC_COMPOSITE
                topviewflag = indexPath.row
                symbolSettingPickerView.reloadAllComponents()
                symbolSettingPickerView.selectRow(Int(paramValue!.value), inComponent: 0, animated: false)
                symbolSettingPickerView.isHidden = false
                pickerViewTopView.isHidden = false
            } else if indexPath.row == 1 {
                symbolSettingPickerView.tag = PICKER_VIEW_COMPOSITE_BEEP
                topviewflag = indexPath.row
                symbolSettingPickerView.reloadAllComponents()
                symbolSettingPickerView.selectRow(Int(paramValue!.value), inComponent: 0, animated: false)
                symbolSettingPickerView.isHidden = false
                pickerViewTopView.isHidden = false
            } else {
                if paramValue?.value == 0 {
                    paramValue?.value = 1
                } else {
                    paramValue?.value = 0
                }
            }
        } else if selectedSymbol == 31 {
            if indexPath.row == 0 {
                symbolSettingPickerView.tag = PICKER_VIEW_DATA_MATRIX_INVERSE
                topviewflag = indexPath.row
                symbolSettingPickerView.reloadAllComponents()
                symbolSettingPickerView.selectRow(Int(paramValue!.value), inComponent: 0, animated: false)
                symbolSettingPickerView.isHidden = false
                pickerViewTopView.isHidden = false
            }
            else if indexPath.row == 1 {
                symbolSettingPickerView.tag = PICKER_VIEW_DECODE_MIRROR
                topviewflag = indexPath.row
                symbolSettingPickerView.reloadAllComponents()
                symbolSettingPickerView.selectRow(Int(paramValue!.value), inComponent: 0, animated: false)
                symbolSettingPickerView.isHidden = false
                pickerViewTopView.isHidden = false
            }
        } else {
            symbolSettingPickerView.tag = PICKER_VIEW_KOREAN_INVERSE
            topviewflag = indexPath.row
            symbolSettingPickerView.reloadAllComponents()
            symbolSettingPickerView.selectRow(Int(paramValue!.value), inComponent: 0, animated: false)
            symbolSettingPickerView.isHidden = false
            pickerViewTopView.isHidden = false
        }
 
        symbolZTableView.reloadData()
    }
    
    func numberOfComponents(in pickerView: UIPickerView) -> Int {
        return 1
    }
    
    func pickerView(_ pickerView: UIPickerView, numberOfRowsInComponent component: Int) -> Int {
        if symbolSettingPickerView.tag == PICKER_VIEW_AIM_ID {
            return picker_aimID!.count
        } else if symbolSettingPickerView.tag == PICKER_VIEW_ISBT {
            return picker_ISBTConcatenation!.count
        } else if symbolSettingPickerView.tag == PICKER_VIEW_CODE11 {
            return picker_code11CheckDigit!.count
        } else if symbolSettingPickerView.tag == PICKER_VIEW_SUPPLEMENTALS {
            return picker_supplementals!.count
        } else if symbolSettingPickerView.tag == PICKER_VIEW_UPCA_PREAMBLE {
            return picker_preamble!.count
        } else if pickerView.tag == PICKER_VIEW_KOREAN_INVERSE {
            return koreanInverse!.count
        } else if pickerView.tag == PICKER_VIEW_AUSTRALIA_FORMAT {
            return australiaFormat!.count
        } else if pickerView.tag == PICKER_VIEW_GS1_DATABAR_SEC {
            return gs1databar_sec!.count
        } else if pickerView.tag == PICKER_VIEW_UPC_COMPOSITE {
            return upccomposit!.count
        } else if pickerView.tag == PICKER_VIEW_COMPOSITE_BEEP {
            return compositebeep!.count
        } else if pickerView.tag == PICKER_VIEW_DECODE_MIRROR {
            return decodemirror.count
        } else if pickerView.tag == PICKER_VIEW_DATA_MATRIX_INVERSE {
            return koreanInverse!.count
        } else {
            return picker_preamble!.count
        }
    }
    func pickerView(_ pickerView: UIPickerView, titleForRow row: Int, forComponent component: Int) -> String? {
        if symbolSettingPickerView.tag == PICKER_VIEW_SUPPLEMENTALS {
            return picker_supplementals?[row] as? String
        } else if symbolSettingPickerView.tag == PICKER_VIEW_AIM_ID {
            return picker_aimID?[row] as? String
        } else if symbolSettingPickerView.tag == PICKER_VIEW_COUPON_REPORT {
            return picker_coupon?[row] as? String
        } else if symbolSettingPickerView.tag == PICKER_VIEW_UPCA_PREAMBLE {
            return picker_preamble?[row] as? String
        } else if symbolSettingPickerView.tag == PICKER_VIEW_ISBT {
            return picker_ISBTConcatenation?[row] as? String
        } else if symbolSettingPickerView.tag == PICKER_VIEW_CODE11 {
            return picker_code11CheckDigit?[row] as? String
        } else if symbolSettingPickerView.tag == PICKER_VIEW_KOREAN_INVERSE {
            return koreanInverse?[row] as? String
        } else if symbolSettingPickerView.tag == PICKER_VIEW_AUSTRALIA_FORMAT {
            return australiaFormat?[row] as? String
        } else if symbolSettingPickerView.tag == PICKER_VIEW_GS1_DATABAR_SEC {
            return gs1databar_sec?[row] as? String
        } else if symbolSettingPickerView.tag == PICKER_VIEW_UPC_COMPOSITE {
            return upccomposit?[row] as? String
        } else if symbolSettingPickerView.tag == PICKER_VIEW_COMPOSITE_BEEP {
            return compositebeep?[row] as? String
        } else if symbolSettingPickerView.tag == PICKER_VIEW_DECODE_MIRROR {
            return decodemirror[row] as? String
        } else if symbolSettingPickerView.tag == PICKER_VIEW_DATA_MATRIX_INVERSE {
            return koreanInverse?[row] as? String
        } else {
            return picker_preamble?[row] as? String
        }
    }
    func pickerView(_ pickerView: UIPickerView, viewForRow row: Int, forComponent component: Int, reusing view: UIView?) -> UIView {
        var retval = (view as? Any) as? UILabel
        if retval == nil {
            retval = UILabel(frame: CGRect(x: 0.0, y: 0.0, width: pickerView.rowSize(forComponent: component).width, height: pickerView.rowSize(forComponent: component).height))
        }
        retval?.isOpaque = false
        retval?.backgroundColor = UIColor.clear
        retval?.font = UIFont.systemFont(ofSize: 15)
        
        if component == 0 {
            retval?.textAlignment = NSTextAlignment.center
            if pickerView.tag == PICKER_VIEW_SUPPLEMENTALS {
                retval?.text = picker_supplementals?[row] as? String
            } else if pickerView.tag == PICKER_VIEW_AIM_ID {
                retval?.text = picker_aimID?[row] as? String
            } else if pickerView.tag == PICKER_VIEW_COUPON_REPORT {
                retval?.text = picker_coupon?[row] as? String
            } else if symbolSettingPickerView.tag == PICKER_VIEW_ISBT {
                retval?.text = picker_ISBTConcatenation?[row] as? String
            } else if symbolSettingPickerView.tag == PICKER_VIEW_CODE11 {
                retval?.text = picker_code11CheckDigit?[row] as? String
            } else if pickerView.tag == PICKER_VIEW_UPCA_PREAMBLE {
                retval?.text = picker_preamble?[row] as? String
            } else if pickerView.tag == PICKER_VIEW_KOREAN_INVERSE {
                retval?.text = koreanInverse?[row] as? String
            } else if pickerView.tag == PICKER_VIEW_AUSTRALIA_FORMAT {
                retval?.text = australiaFormat?[row] as? String
            } else  if pickerView.tag == PICKER_VIEW_GS1_DATABAR_SEC {
                retval?.text = gs1databar_sec?[row] as? String
            } else if pickerView.tag == PICKER_VIEW_UPC_COMPOSITE {
                retval?.text = upccomposit?[row] as? String
            } else if pickerView.tag == PICKER_VIEW_COMPOSITE_BEEP {
                retval?.text = compositebeep?[row] as? String
            } else if pickerView.tag == PICKER_VIEW_DECODE_MIRROR {
                retval?.text = decodemirror[row] as? String
            } else if pickerView.tag == PICKER_VIEW_DATA_MATRIX_INVERSE {
                retval?.text = koreanInverse?[row] as? String
            } else {
                retval?.text = picker_preamble?[row] as? String
            }

        } else {
            retval?.textAlignment = NSTextAlignment.left
            retval?.text = " .\(row)"
        }
        return retval!
    }
    @IBAction func pickerViewTopViewCancel(_ sender: UIButton) {
        symbolSettingPickerView.isHidden = true
        pickerViewTopView.isHidden = true
    }
    @IBAction func pickerViewTopViewOK(_ sender: UIButton) {
        let paramValue = symbolParamData![topviewflag] as? EAParamValue
        let idx: Int = symbolSettingPickerView.selectedRow(inComponent: 0)
        paramValue?.value = UInt32(idx)
        symbolZTableView.reloadData()
        symbolSettingPickerView.isHidden = true
        pickerViewTopView.isHidden = true
    }
    @IBAction func saveBtnTapped(_ sender: UIButton) {
        let res = appDelegate.mReader?.setBarcodeParam(symbolParamData as! [Any])
        if res == ResultNoError {
            let dialog = UIAlertController(title: "Success", message: "Saved successfully", preferredStyle: .alert)
            let action = UIAlertAction(title: "OK", style: UIAlertActionStyle.default)
            dialog.addAction(action)
            self.present(dialog, animated: true, completion: nil)
        } else {
            let dialog = UIAlertController(title: "Error", message: "Failed to save", preferredStyle: .alert)
            let action = UIAlertAction(title: "OK", style: UIAlertActionStyle.default)
            dialog.addAction(action)
            self.present(dialog, animated: true, completion: nil)
            symbolZTableView.reloadData()
        }
    }
    @objc func bluetoothDisconnected(_ notification: Notification){
        DispatchQueue.main.async(execute: {() -> Void in
            self.appDelegate.mPeripheral = nil
            self.performSegue(withIdentifier: "Barcode", sender: nil)
        })
    }
}
