/*
 * Decompiled with CFR 0.152.
 */
package device.common;

import android.os.Handler;
import device.common.IDecodeStateCallback;

public abstract class DecodeStateCallback {
    private final Object mLock = new Object();
    private Transport mTransport;
    Handler mHandler;

    public DecodeStateCallback() {
    }

    public void setHandler(Handler handler) {
        this.mHandler = handler;
    }

    public DecodeStateCallback(Handler handler) {
        this.mHandler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDecodeStateCallback getDecodeStateCallback() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mTransport == null) {
                this.mTransport = new Transport(this);
            }
            return this.mTransport;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDecodeStateCallback releaseDecodeStateCallback() {
        Object object = this.mLock;
        synchronized (object) {
            Transport oldTransport = this.mTransport;
            if (oldTransport != null) {
                oldTransport.releaseDecodeStateCallback();
                this.mTransport = null;
            }
            return oldTransport;
        }
    }

    public boolean deliverSelfNotification() {
        return false;
    }

    public void onChangedState(int state) {
    }

    public final void dispatchChangedState(int state) {
        if (this.mHandler == null) {
            this.onChangedState(state);
        } else {
            this.mHandler.post((Runnable)new NotificationRunnable(state));
        }
    }

    private static final class Transport
    extends IDecodeStateCallback.Stub {
        private DecodeStateCallback mDecodeStateCallback;

        public Transport(DecodeStateCallback decodeStateCallback) {
            this.mDecodeStateCallback = decodeStateCallback;
        }

        @Override
        public void onChangedState(int state) {
            DecodeStateCallback decodeStateCallback = this.mDecodeStateCallback;
            if (decodeStateCallback != null) {
                decodeStateCallback.dispatchChangedState(state);
            }
        }

        public void releaseDecodeStateCallback() {
            this.mDecodeStateCallback = null;
        }
    }

    private final class NotificationRunnable
    implements Runnable {
        private final int mState;

        public NotificationRunnable(int state) {
            this.mState = state;
        }

        @Override
        public void run() {
            DecodeStateCallback.this.onChangedState(this.mState);
        }
    }
}

