/*
 * Decompiled with CFR 0.152.
 */
package device.sdk;

import android.os.IPowerManager;
import android.os.RemoteException;
import device.common.IDeviceService;
import device.sdk.DeviceServer;

public class Information {
    private static final String TAG = Information.class.getSimpleName();
    private final IPowerManager sPowerManager = DeviceServer.getIPowerManager();
    private final IDeviceService sDeviceService = DeviceServer.getIDeviceService();

    public String getHardwareRevision() throws RemoteException {
        return this.sDeviceService.getHardwareRevision();
    }

    public String getAndroidVersion() throws RemoteException {
        return this.sDeviceService.getAndroidVersion();
    }

    public String getKernelVersion() throws RemoteException {
        return this.sDeviceService.getKernelVersion();
    }

    public String getBuildNumber() throws RemoteException {
        return this.sDeviceService.getBuildNumber();
    }

    public String getSDKVersion() throws RemoteException {
        return this.sDeviceService.getSDKVersion();
    }

    public String getManufacturer() throws RemoteException {
        return this.sDeviceService.getManufacturer();
    }

    public String getModelName() throws RemoteException {
        return this.sDeviceService.getModelName();
    }

    public String getProcessorInfo() throws RemoteException {
        return this.sDeviceService.getProcessorInfo();
    }

    public String getSerialNumber() throws RemoteException {
        return this.sDeviceService.getSerialNumber();
    }

    public String getPartNumber() throws RemoteException {
        return this.sDeviceService.getPartNumber();
    }

    public String getModelNumber() throws RemoteException {
        return this.sDeviceService.getModelNumber();
    }

    public String getManufactureDate() throws RemoteException {
        return this.sDeviceService.getManufactureDate();
    }

    private static String convertVersionFormat(byte[] version) {
        String[] months = new String[]{"", "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
        byte[] buffer = new byte[24];
        int i = 0;
        int j = 0;
        byte[] majorBytes = String.format("%02d", version[j++]).getBytes();
        Object[] objectArray = new Object[1];
        int n = ++j;
        ++j;
        objectArray[0] = version[n];
        byte[] minorBytes = String.format("%02d", objectArray).getBytes();
        ++j;
        buffer[i++] = majorBytes[0];
        buffer[i++] = majorBytes[1];
        buffer[i++] = 46;
        buffer[i++] = minorBytes[0];
        buffer[i++] = minorBytes[1];
        buffer[i++] = 32;
        if (version[j] != 0) {
            buffer[i++] = version[j++];
            buffer[i++] = version[j++];
            buffer[i++] = 32;
        } else {
            j += 2;
        }
        buffer[i++] = 40;
        byte[] yearBytes = String.format("%04d", (version[j++] & 0xFF) + ((version[j++] & 0xFF) << 8)).getBytes();
        byte month = version[j++];
        byte[] dayBytes = String.format("%02d", version[++j]).getBytes();
        byte[] monthBytes = 1 <= month && month <= 12 ? months[month].getBytes() : "XXX".getBytes();
        buffer[i++] = monthBytes[0];
        buffer[i++] = monthBytes[1];
        buffer[i++] = monthBytes[2];
        buffer[i++] = 32;
        buffer[i++] = dayBytes[0];
        buffer[i++] = dayBytes[1];
        buffer[i++] = 32;
        buffer[i++] = yearBytes[0];
        buffer[i++] = yearBytes[1];
        buffer[i++] = yearBytes[2];
        buffer[i++] = yearBytes[3];
        buffer[i++] = 41;
        buffer[i++] = 0;
        return new String(buffer);
    }

    public String getXloaderImageVersion() throws RemoteException {
        return this.sDeviceService.getXloaderImageVersion();
    }

    public String getBootloaderImageVersion() throws RemoteException {
        return this.sDeviceService.getBootloaderImageVersion();
    }

    public String getKernelImageVersion() throws RemoteException {
        return this.sDeviceService.getKernelImageVersion();
    }

    public String getRecoveryImageVersion() throws RemoteException {
        return this.sDeviceService.getRecoveryImageVersion();
    }

    public String getAndroidImageVersion() throws RemoteException {
        return this.sDeviceService.getAndroidImageVersion();
    }

    public int getMajorNumber() throws RemoteException {
        return this.sDeviceService.getMajorNumber();
    }

    public String getDeviceName() throws RemoteException {
        return this.sDeviceService.getDeviceName();
    }

    public String getModuleName(int index) throws RemoteException {
        return this.sDeviceService.getModuleName(index);
    }

    public int getCameraType() throws RemoteException {
        return this.sDeviceService.getCameraType();
    }

    public int getCameraSecondType() throws RemoteException {
        return this.sDeviceService.getCameraSecondType();
    }

    public int getDisplayType() throws RemoteException {
        return this.sDeviceService.getDisplayType();
    }

    public int getKeyboardType() throws RemoteException {
        return this.sDeviceService.getKeyboardType();
    }

    public int getNandType() throws RemoteException {
        return this.sDeviceService.getNandType();
    }

    public int getScannerType() throws RemoteException {
        return this.sDeviceService.getScannerType();
    }

    public int getTouchType() throws RemoteException {
        return this.sDeviceService.getTouchType();
    }

    public int getRfidType() throws RemoteException {
        return this.sDeviceService.getRfidType();
    }

    public int getBluetoothType() throws RemoteException {
        return this.sDeviceService.getBluetoothType();
    }

    public int getGpsType() throws RemoteException {
        return this.sDeviceService.getGpsType();
    }

    public int getPhoneType() throws RemoteException {
        return this.sDeviceService.getPhoneType();
    }

    public int getWifiType() throws RemoteException {
        return this.sDeviceService.getWifiType();
    }

    public int getSensorAccelerometerType() throws RemoteException {
        return this.sDeviceService.getSensorAccelerometerType();
    }

    public int getSensorLightType() throws RemoteException {
        return this.sDeviceService.getSensorLightType();
    }

    public int getSensorProximityType() throws RemoteException {
        return this.sDeviceService.getSensorProximityType();
    }

    public int getSensorCpuTemperatureType() throws RemoteException {
        return this.sDeviceService.getSensorCpuTemperatureType();
    }

    public int getSensorGyroscopeType() throws RemoteException {
        return this.sDeviceService.getSensorGyroscopeType();
    }

    public int getSensorMagneticFieldType() throws RemoteException {
        return this.sDeviceService.getSensorMagneticFieldType();
    }

    public int getSensorPressureType() throws RemoteException {
        return this.sDeviceService.getSensorPressureType();
    }

    public int getMsrType() throws RemoteException {
        return this.sDeviceService.getMsrType();
    }

    public int getBluetoothStatus() throws RemoteException {
        return this.sDeviceService.getBluetoothStatus();
    }

    public int getGpsStatus() throws RemoteException {
        return this.sDeviceService.getGpsStatus();
    }

    public int getPhoneStatus() throws RemoteException {
        return this.sDeviceService.getPhoneStatus();
    }

    public int getWifiStatus() throws RemoteException {
        return this.sDeviceService.getWifiStatus();
    }

    public String getTouchFirmwareVersion() throws RemoteException {
        return this.sDeviceService.getTouchFirmwareVersion();
    }

    public String getCameraFirmwareVersion(String cameraModule) throws RemoteException {
        return this.sDeviceService.getCameraFirmwareVersion(cameraModule);
    }

    public String getRfidFirmwareVersion() throws RemoteException {
        return this.sDeviceService.getRfidFirmwareVersion();
    }

    public String getRfidSerialNumber() throws RemoteException {
        return this.sDeviceService.getRfidSerialNumber();
    }

    public String getRfidSamInfo(int index) throws RemoteException {
        return this.sDeviceService.getRfidSamInfo(index);
    }

    public String getBluetoothDriverVersion() throws RemoteException {
        return this.sDeviceService.getBluetoothDriverVersion();
    }

    public String getBluetoothMacAddress() throws RemoteException {
        return this.sDeviceService.getBluetoothMacAddress();
    }

    public String getWifiDriverVersion() throws RemoteException {
        return this.sDeviceService.getWifiDriverVersion();
    }

    public String getWifiFirmwareVersion() throws RemoteException {
        return this.sDeviceService.getWifiFirmwareVersion();
    }

    public String getWifiConfigurationDataVersion() throws RemoteException {
        return this.sDeviceService.getWifiConfigurationDataVersion();
    }

    public String getWifiMacAddress() throws RemoteException {
        return this.sDeviceService.getWifiMacAddress();
    }

    public String getWifiIpAddress() throws RemoteException {
        return this.sDeviceService.getWifiIpAddress();
    }

    public String getMainBatteryStatus() throws RemoteException {
        return this.sDeviceService.getMainBatteryStatus();
    }

    public String getBackupBatteryStatus() throws RemoteException {
        return this.sDeviceService.getBackupBatteryStatus();
    }

    public String getBatterySerialNumber() throws RemoteException {
        return this.sDeviceService.getBatterySerialNumber();
    }

    public String getChargingMainBatteryFromUsbFlag() throws RemoteException {
        return this.sDeviceService.getChargingMainBatteryFromUsbFlag();
    }

    public String getChargingBackupBatteryFromMainBatteryFlag() throws RemoteException {
        return this.sDeviceService.getChargingBackupBatteryFromMainBatteryFlag();
    }

    public String getLowBatteryWarningLevel() throws RemoteException {
        return this.sDeviceService.getLowBatteryWarningLevel();
    }

    public String getCriticalBatteryWarningLevel() throws RemoteException {
        return this.sDeviceService.getCriticalBatteryWarningLevel();
    }

    public int getScannerClass(int scanner) throws RemoteException {
        return this.sDeviceService.getScannerClass(scanner);
    }

    public String getScannerName(int scanner) throws RemoteException {
        return this.sDeviceService.getScannerName(scanner);
    }

    public String getScannerClassName(int scanner) throws RemoteException {
        return this.sDeviceService.getScannerClassName(scanner);
    }
}

