/*
 * Decompiled with CFR 0.152.
 */
package device.sdk;

import android.os.RemoteException;
import device.common.ISamService;
import device.sdk.DeviceServer;

public class SamManager {
    private static final String TAG = "SamManager";
    private static ISamService sSamService;

    public SamManager() {
        sSamService = DeviceServer.getISamService();
    }

    public void setEnabled(boolean enabled) {
        try {
            sSamService.samSetPowerOn(enabled);
            if (enabled) {
                sSamService.samOpenPort();
            } else {
                sSamService.samClosePort();
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public boolean isEnabled() {
        boolean ret = false;
        try {
            ret = sSamService.samGetPowerStatus();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public int sendAtrCommand() {
        int ret = 0;
        try {
            ret = sSamService.sam_CommandAtr();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public int GetAtrResponse(byte[] req_buf) {
        int ret = 0;
        try {
            ret = sSamService.sam_get_atr_response(req_buf);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public int sendApduCommand(byte[] apdu, int apduLength, byte[] response, int responseLength) {
        int ret = 0;
        try {
            ret = sSamService.sam_CommandApdu(apdu, apduLength, response, responseLength);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public int sendPowerDownCommand() {
        int ret = 0;
        try {
            ret = sSamService.sam_CommandPowerdown();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public int sendDirectCommand(byte cmd, byte[] pdata, int datalen, byte[] pRESP, int pRespLen) {
        int ret = 0;
        try {
            ret = sSamService.sam_direct_command(cmd, pdata, datalen, pRESP, pRespLen);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return ret;
    }

    @Deprecated
    public int DeviceSamSetPowerOn(boolean on) {
        int ret = 0;
        try {
            ret = sSamService.samSetPowerOn(on);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return ret;
    }

    @Deprecated
    public boolean DeviceSamGetPowerStatus() {
        boolean ret = false;
        try {
            ret = sSamService.samGetPowerStatus();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return ret;
    }

    @Deprecated
    public int DeviceSamOpenFort() {
        int ret = 0;
        try {
            ret = sSamService.samOpenPort();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return ret;
    }

    @Deprecated
    public int DeviceSamCloseFort() {
        int ret = 0;
        try {
            ret = sSamService.samClosePort();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return ret;
    }

    @Deprecated
    public int DeviceSamCommandAtr() {
        int ret = 0;
        try {
            ret = sSamService.sam_CommandAtr();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return ret;
    }

    @Deprecated
    public int DeviceSam_CommandApdu(byte[] pAPDU, int apduLen, byte[] pRESP, int respLen) {
        int ret = 0;
        try {
            ret = sSamService.sam_CommandApdu(pAPDU, apduLen, pRESP, respLen);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return ret;
    }

    @Deprecated
    public int DeviceSam_CommandPowerdown() {
        int ret = 0;
        try {
            ret = sSamService.sam_CommandPowerdown();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return ret;
    }
}

