/*
 * Decompiled with CFR 0.152.
 */
package device.common.rfid;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import device.common.rfid.RecvPacket;

public interface IRFIDCallback
extends IInterface {
    public void onNotifyDataWriteFail() throws RemoteException;

    public void onNotifyReceivedPacket(RecvPacket var1) throws RemoteException;

    public void onNotifyChangedState(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IRFIDCallback {
        private static final String DESCRIPTOR = "device.common.rfid.IRFIDCallback";
        static final int TRANSACTION_onNotifyDataWriteFail = 1;
        static final int TRANSACTION_onNotifyReceivedPacket = 2;
        static final int TRANSACTION_onNotifyChangedState = 3;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IRFIDCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IRFIDCallback) {
                return (IRFIDCallback)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    data.enforceInterface(DESCRIPTOR);
                    this.onNotifyDataWriteFail();
                    return true;
                }
                case 2: {
                    data.enforceInterface(DESCRIPTOR);
                    RecvPacket _arg0 = 0 != data.readInt() ? (RecvPacket)RecvPacket.CREATOR.createFromParcel(data) : null;
                    this.onNotifyReceivedPacket(_arg0);
                    return true;
                }
                case 3: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    this.onNotifyChangedState(_arg0);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private static class Proxy
        implements IRFIDCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public void onNotifyDataWriteFail() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onNotifyReceivedPacket(RecvPacket recvPacket) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (recvPacket != null) {
                        _data.writeInt(1);
                        recvPacket.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onNotifyChangedState(int state) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(state);
                    this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }
}

