/*
 * Decompiled with CFR 0.152.
 */
package device.common.rfid;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import device.common.rfid.AntPower;
import device.common.rfid.AntSelect;
import device.common.rfid.BattEvent;
import device.common.rfid.ChannelState;
import device.common.rfid.CustomIntentConfig;
import device.common.rfid.IRFIDCallback;
import device.common.rfid.ModeOfInvent;
import device.common.rfid.ParamOfInvent;
import device.common.rfid.ReportFormatOfInvent;
import device.common.rfid.ReportFormatOfInvent_ext;
import device.common.rfid.SelConfig;
import device.common.rfid.StatusEvent;
import device.common.rfid.TxCycle;

public interface IRFIDService
extends IInterface {
    public void connectBluetooth(String var1, String var2) throws RemoteException;

    public void disconnectBluetooth() throws RemoteException;

    public int open(int var1) throws RemoteException;

    public void close() throws RemoteException;

    public boolean isOpened() throws RemoteException;

    public boolean isTryingConnect() throws RemoteException;

    public int cmdDisconnectDevice() throws RemoteException;

    public int updateFirmware(byte[] var1, String var2, int var3) throws RemoteException;

    public int cmdOpenInterface1() throws RemoteException;

    public int cmdOpenInterface2() throws RemoteException;

    public int cmdStartInventory() throws RemoteException;

    public int cmdStartInventory_ext(int var1, int var2, int var3) throws RemoteException;

    public int cmdStopOperation() throws RemoteException;

    public int cmdHeartBeat(int var1) throws RemoteException;

    public int cmdGetSelectMask(SelConfig var1) throws RemoteException;

    public int cmdSetSelectMask(SelConfig var1) throws RemoteException;

    public int cmdSetSession(int var1) throws RemoteException;

    public int cmdSetQValue(int var1) throws RemoteException;

    public int cmdSetInventoryTarget(int var1) throws RemoteException;

    public int cmdSetInventParam(ParamOfInvent var1) throws RemoteException;

    public int cmdGetInventParam(ParamOfInvent var1) throws RemoteException;

    public int cmdSetOpMode(ModeOfInvent var1) throws RemoteException;

    public int cmdGetOpMode(ModeOfInvent var1) throws RemoteException;

    public int cmdReadTag(int var1, int var2, int var3, String var4) throws RemoteException;

    public int cmdWriteTag(int var1, int var2, int var3, String var4, String var5) throws RemoteException;

    public int cmdLockTag(int var1, int var2, String var3) throws RemoteException;

    public int cmdKillTag(String var1) throws RemoteException;

    public String cmdGetFwVersion() throws RemoteException;

    public int cmdSetDefaultParameter() throws RemoteException;

    public int cmdGetParameter(String var1, String var2) throws RemoteException;

    public int cmdGetTimer() throws RemoteException;

    public int cmdSetTimer(int var1) throws RemoteException;

    public int cmdGetTxPower() throws RemoteException;

    public int cmdSetTxPower(int var1) throws RemoteException;

    public int cmdGetMaxPower() throws RemoteException;

    public int cmdGetTxCycle(TxCycle var1) throws RemoteException;

    public int cmdSetTxCycle(TxCycle var1) throws RemoteException;

    public String cmdGetAllChannel() throws RemoteException;

    public int cmdGetChannelState(ChannelState var1) throws RemoteException;

    public int cmdSetChannelState(ChannelState var1) throws RemoteException;

    public int cmdSetCountry(int var1) throws RemoteException;

    public int cmdGetCountry() throws RemoteException;

    public int cmdPermLockTag(int var1, int var2, String var3) throws RemoteException;

    public int cmdPauseTx() throws RemoteException;

    public int cmdGetConnectStateReport() throws RemoteException;

    public int cmdSetConnectStateReport(int var1) throws RemoteException;

    public int cmdGetInventoryReportFormat(ReportFormatOfInvent var1) throws RemoteException;

    public int cmdSetInventoryReportFormat(ReportFormatOfInvent var1) throws RemoteException;

    public int cmdSetDislink() throws RemoteException;

    public int cmdUploadTagData(int var1, int var2) throws RemoteException;

    public int cmdClearTagData() throws RemoteException;

    public int cmdGetReaderStateReport(StatusEvent var1) throws RemoteException;

    public int cmdSetReaderStateReport(StatusEvent var1) throws RemoteException;

    public int cmdGetStatusWord() throws RemoteException;

    public int cmdGetBuzzerVolume() throws RemoteException;

    public int cmdSetBuzzerVolume(int var1) throws RemoteException;

    public int cmdGetVibration() throws RemoteException;

    public int cmdSetVibration(int var1) throws RemoteException;

    public int cmdSetTriggerMode(int var1) throws RemoteException;

    public int cmdGetBatteryLevel() throws RemoteException;

    public int cmdGetBatteryEvent(BattEvent var1) throws RemoteException;

    public int cmdSetBatteryEvent(BattEvent var1) throws RemoteException;

    public int cmdSetReportBatteryState(int var1) throws RemoteException;

    public int cmdGetBatteryState() throws RemoteException;

    public int cmdGetChargingState() throws RemoteException;

    public int cmdSetBTConfig(int var1, String var2) throws RemoteException;

    public String cmdGetBTMacAddress() throws RemoteException;

    public void sendTextCommand(String var1) throws RemoteException;

    public String cmdGetBTDeviceName() throws RemoteException;

    public int cmdSetClearReport(int var1) throws RemoteException;

    public String cmdGetOemInfo() throws RemoteException;

    public int cmdGetTagFocus() throws RemoteException;

    public int cmdSetTagFocus(int var1) throws RemoteException;

    public int cmdGetFastID() throws RemoteException;

    public int cmdSetFastID(int var1) throws RemoteException;

    public int cmdGetLBTState() throws RemoteException;

    public int cmdSetLBTState(int var1) throws RemoteException;

    public int cmdGetLinkProfile() throws RemoteException;

    public int cmdSetLinkProfile(int var1) throws RemoteException;

    public int cmdSetSingleTagSearch(int var1, String var2, int var3, int var4) throws RemoteException;

    public int cmdSetMultiTagSearch() throws RemoteException;

    public int cmdSetMultiTagList(int var1, int var2, String var3) throws RemoteException;

    public int cmdGetMultiTagList() throws RemoteException;

    public int cmdGetMultiTagList_ext(int var1) throws RemoteException;

    public int cmdClearMultiTagList(int var1, int var2) throws RemoteException;

    public int cmdClearAllMultiTagList() throws RemoteException;

    public int cmdWildcardTagSearch(int var1, String var2) throws RemoteException;

    public int cmdGetDataFormat() throws RemoteException;

    public int cmdSetDataFormat(int var1) throws RemoteException;

    public int cmdGetTxDataFormat() throws RemoteException;

    public int cmdSetTxDataFormat(int var1) throws RemoteException;

    public String cmdGetPrefix() throws RemoteException;

    public int cmdSetPrefix(String var1) throws RemoteException;

    public String cmdGetSuffix() throws RemoteException;

    public int cmdSetSuffix(String var1) throws RemoteException;

    public String cmdGetSuffix1() throws RemoteException;

    public int cmdSetSuffix1(String var1) throws RemoteException;

    public String cmdGetSuffix2() throws RemoteException;

    public int cmdSetSuffix2(String var1) throws RemoteException;

    public int cmdGetLcdOff() throws RemoteException;

    public int cmdSetLcdOff(int var1) throws RemoteException;

    public int cmdSetDataCase(int var1) throws RemoteException;

    public int cmdBlockWrite(int var1, int var2, int var3, String var4, String var5, int var6) throws RemoteException;

    public int cmdBlockErase(int var1, int var2, int var3, String var4, int var5) throws RemoteException;

    public int cmdGetResultType() throws RemoteException;

    public void cmdSetResultType(int var1) throws RemoteException;

    public int cmdGetTerminatorType() throws RemoteException;

    public void cmdSetTerminatorType(int var1) throws RemoteException;

    public void cmdSetBTDefault() throws RemoteException;

    public int cmdGetInventoryReportFormat_ext(ReportFormatOfInvent_ext var1) throws RemoteException;

    public int cmdSetInventoryReportFormat_ext(ReportFormatOfInvent_ext var1) throws RemoteException;

    public int cmdSetDeviceBaudrate(int var1) throws RemoteException;

    public int cmdGetAntSelect(AntSelect var1) throws RemoteException;

    public int cmdSetAntSelect(AntSelect var1) throws RemoteException;

    public int cmdGetAntPower(AntPower var1) throws RemoteException;

    public int cmdSetAntPower(AntPower var1) throws RemoteException;

    public String cmdGetAvailableRegion() throws RemoteException;

    public int cmdSetRegion(String var1) throws RemoteException;

    public void cmdGetCustomIntentConfig(CustomIntentConfig var1) throws RemoteException;

    public void cmdSetCustomIntentConfig(CustomIntentConfig var1) throws RemoteException;

    public boolean RegisterRFIDCallback(IRFIDCallback var1) throws RemoteException;

    public boolean UnregisterRFIDCallback(IRFIDCallback var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IRFIDService {
        private static final String DESCRIPTOR = "device.common.rfid.IRFIDService";
        static final int TRANSACTION_connectBluetooth = 1;
        static final int TRANSACTION_disconnectBluetooth = 2;
        static final int TRANSACTION_open = 3;
        static final int TRANSACTION_close = 4;
        static final int TRANSACTION_isOpened = 5;
        static final int TRANSACTION_isTryingConnect = 6;
        static final int TRANSACTION_cmdDisconnectDevice = 7;
        static final int TRANSACTION_updateFirmware = 8;
        static final int TRANSACTION_cmdOpenInterface1 = 9;
        static final int TRANSACTION_cmdOpenInterface2 = 10;
        static final int TRANSACTION_cmdStartInventory = 11;
        static final int TRANSACTION_cmdStartInventory_ext = 12;
        static final int TRANSACTION_cmdStopOperation = 13;
        static final int TRANSACTION_cmdHeartBeat = 14;
        static final int TRANSACTION_cmdGetSelectMask = 15;
        static final int TRANSACTION_cmdSetSelectMask = 16;
        static final int TRANSACTION_cmdSetSession = 17;
        static final int TRANSACTION_cmdSetQValue = 18;
        static final int TRANSACTION_cmdSetInventoryTarget = 19;
        static final int TRANSACTION_cmdSetInventParam = 20;
        static final int TRANSACTION_cmdGetInventParam = 21;
        static final int TRANSACTION_cmdSetOpMode = 22;
        static final int TRANSACTION_cmdGetOpMode = 23;
        static final int TRANSACTION_cmdReadTag = 24;
        static final int TRANSACTION_cmdWriteTag = 25;
        static final int TRANSACTION_cmdLockTag = 26;
        static final int TRANSACTION_cmdKillTag = 27;
        static final int TRANSACTION_cmdGetFwVersion = 28;
        static final int TRANSACTION_cmdSetDefaultParameter = 29;
        static final int TRANSACTION_cmdGetParameter = 30;
        static final int TRANSACTION_cmdGetTimer = 31;
        static final int TRANSACTION_cmdSetTimer = 32;
        static final int TRANSACTION_cmdGetTxPower = 33;
        static final int TRANSACTION_cmdSetTxPower = 34;
        static final int TRANSACTION_cmdGetMaxPower = 35;
        static final int TRANSACTION_cmdGetTxCycle = 36;
        static final int TRANSACTION_cmdSetTxCycle = 37;
        static final int TRANSACTION_cmdGetAllChannel = 38;
        static final int TRANSACTION_cmdGetChannelState = 39;
        static final int TRANSACTION_cmdSetChannelState = 40;
        static final int TRANSACTION_cmdSetCountry = 41;
        static final int TRANSACTION_cmdGetCountry = 42;
        static final int TRANSACTION_cmdPermLockTag = 43;
        static final int TRANSACTION_cmdPauseTx = 44;
        static final int TRANSACTION_cmdGetConnectStateReport = 45;
        static final int TRANSACTION_cmdSetConnectStateReport = 46;
        static final int TRANSACTION_cmdGetInventoryReportFormat = 47;
        static final int TRANSACTION_cmdSetInventoryReportFormat = 48;
        static final int TRANSACTION_cmdSetDislink = 49;
        static final int TRANSACTION_cmdUploadTagData = 50;
        static final int TRANSACTION_cmdClearTagData = 51;
        static final int TRANSACTION_cmdGetReaderStateReport = 52;
        static final int TRANSACTION_cmdSetReaderStateReport = 53;
        static final int TRANSACTION_cmdGetStatusWord = 54;
        static final int TRANSACTION_cmdGetBuzzerVolume = 55;
        static final int TRANSACTION_cmdSetBuzzerVolume = 56;
        static final int TRANSACTION_cmdGetVibration = 57;
        static final int TRANSACTION_cmdSetVibration = 58;
        static final int TRANSACTION_cmdSetTriggerMode = 59;
        static final int TRANSACTION_cmdGetBatteryLevel = 60;
        static final int TRANSACTION_cmdGetBatteryEvent = 61;
        static final int TRANSACTION_cmdSetBatteryEvent = 62;
        static final int TRANSACTION_cmdSetReportBatteryState = 63;
        static final int TRANSACTION_cmdGetBatteryState = 64;
        static final int TRANSACTION_cmdGetChargingState = 65;
        static final int TRANSACTION_cmdSetBTConfig = 66;
        static final int TRANSACTION_cmdGetBTMacAddress = 67;
        static final int TRANSACTION_sendTextCommand = 68;
        static final int TRANSACTION_cmdGetBTDeviceName = 69;
        static final int TRANSACTION_cmdSetClearReport = 70;
        static final int TRANSACTION_cmdGetOemInfo = 71;
        static final int TRANSACTION_cmdGetTagFocus = 72;
        static final int TRANSACTION_cmdSetTagFocus = 73;
        static final int TRANSACTION_cmdGetFastID = 74;
        static final int TRANSACTION_cmdSetFastID = 75;
        static final int TRANSACTION_cmdGetLBTState = 76;
        static final int TRANSACTION_cmdSetLBTState = 77;
        static final int TRANSACTION_cmdGetLinkProfile = 78;
        static final int TRANSACTION_cmdSetLinkProfile = 79;
        static final int TRANSACTION_cmdSetSingleTagSearch = 80;
        static final int TRANSACTION_cmdSetMultiTagSearch = 81;
        static final int TRANSACTION_cmdSetMultiTagList = 82;
        static final int TRANSACTION_cmdGetMultiTagList = 83;
        static final int TRANSACTION_cmdGetMultiTagList_ext = 84;
        static final int TRANSACTION_cmdClearMultiTagList = 85;
        static final int TRANSACTION_cmdClearAllMultiTagList = 86;
        static final int TRANSACTION_cmdWildcardTagSearch = 87;
        static final int TRANSACTION_cmdGetDataFormat = 88;
        static final int TRANSACTION_cmdSetDataFormat = 89;
        static final int TRANSACTION_cmdGetTxDataFormat = 90;
        static final int TRANSACTION_cmdSetTxDataFormat = 91;
        static final int TRANSACTION_cmdGetPrefix = 92;
        static final int TRANSACTION_cmdSetPrefix = 93;
        static final int TRANSACTION_cmdGetSuffix = 94;
        static final int TRANSACTION_cmdSetSuffix = 95;
        static final int TRANSACTION_cmdGetSuffix1 = 96;
        static final int TRANSACTION_cmdSetSuffix1 = 97;
        static final int TRANSACTION_cmdGetSuffix2 = 98;
        static final int TRANSACTION_cmdSetSuffix2 = 99;
        static final int TRANSACTION_cmdGetLcdOff = 100;
        static final int TRANSACTION_cmdSetLcdOff = 101;
        static final int TRANSACTION_cmdSetDataCase = 102;
        static final int TRANSACTION_cmdBlockWrite = 103;
        static final int TRANSACTION_cmdBlockErase = 104;
        static final int TRANSACTION_cmdGetResultType = 105;
        static final int TRANSACTION_cmdSetResultType = 106;
        static final int TRANSACTION_cmdGetTerminatorType = 107;
        static final int TRANSACTION_cmdSetTerminatorType = 108;
        static final int TRANSACTION_cmdSetBTDefault = 109;
        static final int TRANSACTION_cmdGetInventoryReportFormat_ext = 110;
        static final int TRANSACTION_cmdSetInventoryReportFormat_ext = 111;
        static final int TRANSACTION_cmdSetDeviceBaudrate = 112;
        static final int TRANSACTION_cmdGetAntSelect = 113;
        static final int TRANSACTION_cmdSetAntSelect = 114;
        static final int TRANSACTION_cmdGetAntPower = 115;
        static final int TRANSACTION_cmdSetAntPower = 116;
        static final int TRANSACTION_cmdGetAvailableRegion = 117;
        static final int TRANSACTION_cmdSetRegion = 118;
        static final int TRANSACTION_cmdGetCustomIntentConfig = 119;
        static final int TRANSACTION_cmdSetCustomIntentConfig = 120;
        static final int TRANSACTION_RegisterRFIDCallback = 121;
        static final int TRANSACTION_UnregisterRFIDCallback = 122;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IRFIDService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IRFIDService) {
                return (IRFIDService)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    this.connectBluetooth(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 2: {
                    data.enforceInterface(DESCRIPTOR);
                    this.disconnectBluetooth();
                    reply.writeNoException();
                    return true;
                }
                case 3: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _result = this.open(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 4: {
                    data.enforceInterface(DESCRIPTOR);
                    this.close();
                    reply.writeNoException();
                    return true;
                }
                case 5: {
                    data.enforceInterface(DESCRIPTOR);
                    boolean _result = this.isOpened();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 6: {
                    data.enforceInterface(DESCRIPTOR);
                    boolean _result = this.isTryingConnect();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 7: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.cmdDisconnectDevice();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 8: {
                    data.enforceInterface(DESCRIPTOR);
                    byte[] _arg0 = data.createByteArray();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _result = this.updateFirmware(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 9: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.cmdOpenInterface1();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 10: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.cmdOpenInterface2();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 11: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.cmdStartInventory();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 12: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _result = this.cmdStartInventory_ext(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 13: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.cmdStopOperation();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 14: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _result = this.cmdHeartBeat(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 15: {
                    data.enforceInterface(DESCRIPTOR);
                    SelConfig _arg0 = new SelConfig();
                    int _result = this.cmdGetSelectMask(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    if (_arg0 != null) {
                        reply.writeInt(1);
                        _arg0.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 16: {
                    data.enforceInterface(DESCRIPTOR);
                    SelConfig _arg0 = 0 != data.readInt() ? (SelConfig)SelConfig.CREATOR.createFromParcel(data) : null;
                    int _result = this.cmdSetSelectMask(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 17: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _result = this.cmdSetSession(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 18: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _result = this.cmdSetQValue(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 19: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _result = this.cmdSetInventoryTarget(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 20: {
                    data.enforceInterface(DESCRIPTOR);
                    ParamOfInvent _arg0 = 0 != data.readInt() ? (ParamOfInvent)ParamOfInvent.CREATOR.createFromParcel(data) : null;
                    int _result = this.cmdSetInventParam(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 21: {
                    data.enforceInterface(DESCRIPTOR);
                    ParamOfInvent _arg0 = new ParamOfInvent();
                    int _result = this.cmdGetInventParam(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    if (_arg0 != null) {
                        reply.writeInt(1);
                        _arg0.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 22: {
                    data.enforceInterface(DESCRIPTOR);
                    ModeOfInvent _arg0 = 0 != data.readInt() ? (ModeOfInvent)ModeOfInvent.CREATOR.createFromParcel(data) : null;
                    int _result = this.cmdSetOpMode(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 23: {
                    data.enforceInterface(DESCRIPTOR);
                    ModeOfInvent _arg0 = new ModeOfInvent();
                    int _result = this.cmdGetOpMode(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    if (_arg0 != null) {
                        reply.writeInt(1);
                        _arg0.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 24: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    int _result = this.cmdReadTag(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 25: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    String _arg4 = data.readString();
                    int _result = this.cmdWriteTag(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 26: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    int _result = this.cmdLockTag(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 27: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    int _result = this.cmdKillTag(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 28: {
                    data.enforceInterface(DESCRIPTOR);
                    String _result = this.cmdGetFwVersion();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 29: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.cmdSetDefaultParameter();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 30: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _result = this.cmdGetParameter(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 31: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.cmdGetTimer();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 32: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _result = this.cmdSetTimer(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 33: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.cmdGetTxPower();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 34: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _result = this.cmdSetTxPower(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 35: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.cmdGetMaxPower();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 36: {
                    data.enforceInterface(DESCRIPTOR);
                    TxCycle _arg0 = new TxCycle();
                    int _result = this.cmdGetTxCycle(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    if (_arg0 != null) {
                        reply.writeInt(1);
                        _arg0.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 37: {
                    data.enforceInterface(DESCRIPTOR);
                    TxCycle _arg0 = 0 != data.readInt() ? (TxCycle)TxCycle.CREATOR.createFromParcel(data) : null;
                    int _result = this.cmdSetTxCycle(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 38: {
                    data.enforceInterface(DESCRIPTOR);
                    String _result = this.cmdGetAllChannel();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 39: {
                    data.enforceInterface(DESCRIPTOR);
                    ChannelState _arg0 = new ChannelState();
                    int _result = this.cmdGetChannelState(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    if (_arg0 != null) {
                        reply.writeInt(1);
                        _arg0.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 40: {
                    data.enforceInterface(DESCRIPTOR);
                    ChannelState _arg0 = 0 != data.readInt() ? (ChannelState)ChannelState.CREATOR.createFromParcel(data) : null;
                    int _result = this.cmdSetChannelState(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 41: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _result = this.cmdSetCountry(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 42: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.cmdGetCountry();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 43: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    int _result = this.cmdPermLockTag(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 44: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.cmdPauseTx();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 45: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.cmdGetConnectStateReport();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 46: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _result = this.cmdSetConnectStateReport(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 47: {
                    data.enforceInterface(DESCRIPTOR);
                    ReportFormatOfInvent _arg0 = new ReportFormatOfInvent();
                    int _result = this.cmdGetInventoryReportFormat(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    if (_arg0 != null) {
                        reply.writeInt(1);
                        _arg0.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 48: {
                    data.enforceInterface(DESCRIPTOR);
                    ReportFormatOfInvent _arg0 = 0 != data.readInt() ? (ReportFormatOfInvent)ReportFormatOfInvent.CREATOR.createFromParcel(data) : null;
                    int _result = this.cmdSetInventoryReportFormat(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 49: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.cmdSetDislink();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 50: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _result = this.cmdUploadTagData(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 51: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.cmdClearTagData();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 52: {
                    data.enforceInterface(DESCRIPTOR);
                    StatusEvent _arg0 = new StatusEvent();
                    int _result = this.cmdGetReaderStateReport(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    if (_arg0 != null) {
                        reply.writeInt(1);
                        _arg0.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 53: {
                    data.enforceInterface(DESCRIPTOR);
                    StatusEvent _arg0 = 0 != data.readInt() ? (StatusEvent)StatusEvent.CREATOR.createFromParcel(data) : null;
                    int _result = this.cmdSetReaderStateReport(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 54: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.cmdGetStatusWord();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 55: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.cmdGetBuzzerVolume();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 56: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _result = this.cmdSetBuzzerVolume(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 57: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.cmdGetVibration();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 58: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _result = this.cmdSetVibration(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 59: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _result = this.cmdSetTriggerMode(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 60: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.cmdGetBatteryLevel();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 61: {
                    data.enforceInterface(DESCRIPTOR);
                    BattEvent _arg0 = new BattEvent();
                    int _result = this.cmdGetBatteryEvent(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    if (_arg0 != null) {
                        reply.writeInt(1);
                        _arg0.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 62: {
                    data.enforceInterface(DESCRIPTOR);
                    BattEvent _arg0 = 0 != data.readInt() ? (BattEvent)BattEvent.CREATOR.createFromParcel(data) : null;
                    int _result = this.cmdSetBatteryEvent(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 63: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _result = this.cmdSetReportBatteryState(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 64: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.cmdGetBatteryState();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 65: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.cmdGetChargingState();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 66: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _result = this.cmdSetBTConfig(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 67: {
                    data.enforceInterface(DESCRIPTOR);
                    String _result = this.cmdGetBTMacAddress();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 68: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    this.sendTextCommand(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 69: {
                    data.enforceInterface(DESCRIPTOR);
                    String _result = this.cmdGetBTDeviceName();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 70: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _result = this.cmdSetClearReport(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 71: {
                    data.enforceInterface(DESCRIPTOR);
                    String _result = this.cmdGetOemInfo();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 72: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.cmdGetTagFocus();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 73: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _result = this.cmdSetTagFocus(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 74: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.cmdGetFastID();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 75: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _result = this.cmdSetFastID(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 76: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.cmdGetLBTState();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 77: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _result = this.cmdSetLBTState(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 78: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.cmdGetLinkProfile();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 79: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _result = this.cmdSetLinkProfile(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 80: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _result = this.cmdSetSingleTagSearch(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 81: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.cmdSetMultiTagSearch();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 82: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    int _result = this.cmdSetMultiTagList(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 83: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.cmdGetMultiTagList();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 84: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _result = this.cmdGetMultiTagList_ext(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 85: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _result = this.cmdClearMultiTagList(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 86: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.cmdClearAllMultiTagList();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 87: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _result = this.cmdWildcardTagSearch(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 88: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.cmdGetDataFormat();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 89: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _result = this.cmdSetDataFormat(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 90: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.cmdGetTxDataFormat();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 91: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _result = this.cmdSetTxDataFormat(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 92: {
                    data.enforceInterface(DESCRIPTOR);
                    String _result = this.cmdGetPrefix();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 93: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    int _result = this.cmdSetPrefix(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 94: {
                    data.enforceInterface(DESCRIPTOR);
                    String _result = this.cmdGetSuffix();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 95: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    int _result = this.cmdSetSuffix(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 96: {
                    data.enforceInterface(DESCRIPTOR);
                    String _result = this.cmdGetSuffix1();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 97: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    int _result = this.cmdSetSuffix1(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 98: {
                    data.enforceInterface(DESCRIPTOR);
                    String _result = this.cmdGetSuffix2();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 99: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    int _result = this.cmdSetSuffix2(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 100: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.cmdGetLcdOff();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 101: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _result = this.cmdSetLcdOff(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 102: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _result = this.cmdSetDataCase(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 103: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    String _arg4 = data.readString();
                    int _arg5 = data.readInt();
                    int _result = this.cmdBlockWrite(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 104: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    int _arg4 = data.readInt();
                    int _result = this.cmdBlockErase(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 105: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.cmdGetResultType();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 106: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    this.cmdSetResultType(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 107: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.cmdGetTerminatorType();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 108: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    this.cmdSetTerminatorType(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 109: {
                    data.enforceInterface(DESCRIPTOR);
                    this.cmdSetBTDefault();
                    reply.writeNoException();
                    return true;
                }
                case 110: {
                    data.enforceInterface(DESCRIPTOR);
                    ReportFormatOfInvent_ext _arg0 = new ReportFormatOfInvent_ext();
                    int _result = this.cmdGetInventoryReportFormat_ext(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    if (_arg0 != null) {
                        reply.writeInt(1);
                        _arg0.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 111: {
                    data.enforceInterface(DESCRIPTOR);
                    ReportFormatOfInvent_ext _arg0 = 0 != data.readInt() ? (ReportFormatOfInvent_ext)ReportFormatOfInvent_ext.CREATOR.createFromParcel(data) : null;
                    int _result = this.cmdSetInventoryReportFormat_ext(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 112: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _result = this.cmdSetDeviceBaudrate(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 113: {
                    data.enforceInterface(DESCRIPTOR);
                    AntSelect _arg0 = new AntSelect();
                    int _result = this.cmdGetAntSelect(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    if (_arg0 != null) {
                        reply.writeInt(1);
                        _arg0.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 114: {
                    data.enforceInterface(DESCRIPTOR);
                    AntSelect _arg0 = 0 != data.readInt() ? (AntSelect)AntSelect.CREATOR.createFromParcel(data) : null;
                    int _result = this.cmdSetAntSelect(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 115: {
                    data.enforceInterface(DESCRIPTOR);
                    AntPower _arg0 = new AntPower();
                    int _result = this.cmdGetAntPower(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    if (_arg0 != null) {
                        reply.writeInt(1);
                        _arg0.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 116: {
                    data.enforceInterface(DESCRIPTOR);
                    AntPower _arg0 = 0 != data.readInt() ? (AntPower)AntPower.CREATOR.createFromParcel(data) : null;
                    int _result = this.cmdSetAntPower(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 117: {
                    data.enforceInterface(DESCRIPTOR);
                    String _result = this.cmdGetAvailableRegion();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 118: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    int _result = this.cmdSetRegion(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 119: {
                    data.enforceInterface(DESCRIPTOR);
                    CustomIntentConfig _arg0 = new CustomIntentConfig();
                    this.cmdGetCustomIntentConfig(_arg0);
                    reply.writeNoException();
                    if (_arg0 != null) {
                        reply.writeInt(1);
                        _arg0.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 120: {
                    data.enforceInterface(DESCRIPTOR);
                    CustomIntentConfig _arg0 = 0 != data.readInt() ? (CustomIntentConfig)CustomIntentConfig.CREATOR.createFromParcel(data) : null;
                    this.cmdSetCustomIntentConfig(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 121: {
                    data.enforceInterface(DESCRIPTOR);
                    IRFIDCallback _arg0 = IRFIDCallback.Stub.asInterface(data.readStrongBinder());
                    boolean _result = this.RegisterRFIDCallback(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 122: {
                    data.enforceInterface(DESCRIPTOR);
                    IRFIDCallback _arg0 = IRFIDCallback.Stub.asInterface(data.readStrongBinder());
                    boolean _result = this.UnregisterRFIDCallback(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private static class Proxy
        implements IRFIDService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void connectBluetooth(String macAddress, String deviceName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(macAddress);
                    _data.writeString(deviceName);
                    this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            @Override
            public void disconnectBluetooth() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int open(int openDevice) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(openDevice);
                    this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            @Override
            public void close() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isOpened() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isTryingConnect() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdDisconnectDevice() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int updateFirmware(byte[] fwData, String fileName, int fileSize) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeByteArray(fwData);
                    _data.writeString(fileName);
                    _data.writeInt(fileSize);
                    this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdOpenInterface1() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdOpenInterface2() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdStartInventory() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdStartInventory_ext(int f_s, int f_m, int t_o) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(f_s);
                    _data.writeInt(f_m);
                    _data.writeInt(t_o);
                    this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdStopOperation() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdHeartBeat(int value) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(value);
                    this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdGetSelectMask(SelConfig selConfig) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                    if (0 != _reply.readInt()) {
                        selConfig.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdSetSelectMask(SelConfig selConfig) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (selConfig != null) {
                        _data.writeInt(1);
                        selConfig.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdSetSession(int session) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(session);
                    this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdSetQValue(int q) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(q);
                    this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdSetInventoryTarget(int m_ab) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(m_ab);
                    this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdSetInventParam(ParamOfInvent paramOfInvent) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (paramOfInvent != null) {
                        _data.writeInt(1);
                        paramOfInvent.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdGetInventParam(ParamOfInvent paramOfInvent) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                    if (0 != _reply.readInt()) {
                        paramOfInvent.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdSetOpMode(ModeOfInvent moi) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (moi != null) {
                        _data.writeInt(1);
                        moi.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdGetOpMode(ModeOfInvent moi) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                    if (0 != _reply.readInt()) {
                        moi.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdReadTag(int w_count, int mem, int w_offset, String ACS_PWD) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(w_count);
                    _data.writeInt(mem);
                    _data.writeInt(w_offset);
                    _data.writeString(ACS_PWD);
                    this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdWriteTag(int w_count, int mem, int w_offset, String ACS_PWD, String wordPattern) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(w_count);
                    _data.writeInt(mem);
                    _data.writeInt(w_offset);
                    _data.writeString(ACS_PWD);
                    _data.writeString(wordPattern);
                    this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdLockTag(int lockMask, int lockEnable, String ACS_PWD) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(lockMask);
                    _data.writeInt(lockEnable);
                    _data.writeString(ACS_PWD);
                    this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdKillTag(String killPwd) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(killPwd);
                    this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String cmdGetFwVersion() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdSetDefaultParameter() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdGetParameter(String cmd, String p) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(cmd);
                    _data.writeString(p);
                    this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdGetTimer() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdSetTimer(int time) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(time);
                    this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdGetTxPower() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdSetTxPower(int pwr) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(pwr);
                    this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdGetMaxPower() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdGetTxCycle(TxCycle txCycle) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                    if (0 != _reply.readInt()) {
                        txCycle.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdSetTxCycle(TxCycle txCycle) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (txCycle != null) {
                        _data.writeInt(1);
                        txCycle.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String cmdGetAllChannel() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(38, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdGetChannelState(ChannelState channelState) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(39, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                    if (0 != _reply.readInt()) {
                        channelState.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdSetChannelState(ChannelState channelState) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (channelState != null) {
                        _data.writeInt(1);
                        channelState.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(40, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdSetCountry(int code) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(code);
                    this.mRemote.transact(41, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdGetCountry() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(42, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdPermLockTag(int lockMask, int lockEnable, String ACS_PWD) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(lockMask);
                    _data.writeInt(lockEnable);
                    _data.writeString(ACS_PWD);
                    this.mRemote.transact(43, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdPauseTx() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(44, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdGetConnectStateReport() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(45, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdSetConnectStateReport(int f_link) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(f_link);
                    this.mRemote.transact(46, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdGetInventoryReportFormat(ReportFormatOfInvent reportFormatOfInvent) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(47, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                    if (0 != _reply.readInt()) {
                        reportFormatOfInvent.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdSetInventoryReportFormat(ReportFormatOfInvent reportFormatOfInvent) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (reportFormatOfInvent != null) {
                        _data.writeInt(1);
                        reportFormatOfInvent.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(48, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdSetDislink() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(49, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdUploadTagData(int index, int count) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(index);
                    _data.writeInt(count);
                    this.mRemote.transact(50, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdClearTagData() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(51, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdGetReaderStateReport(StatusEvent statusEvent) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(52, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                    if (0 != _reply.readInt()) {
                        statusEvent.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdSetReaderStateReport(StatusEvent statusEvent) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (statusEvent != null) {
                        _data.writeInt(1);
                        statusEvent.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(53, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdGetStatusWord() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(54, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdGetBuzzerVolume() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(55, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdSetBuzzerVolume(int volume) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(volume);
                    this.mRemote.transact(56, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdGetVibration() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(57, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdSetVibration(int on) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(on);
                    this.mRemote.transact(58, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdSetTriggerMode(int mode) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(mode);
                    this.mRemote.transact(59, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdGetBatteryLevel() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(60, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdGetBatteryEvent(BattEvent battEvent) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(61, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                    if (0 != _reply.readInt()) {
                        battEvent.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdSetBatteryEvent(BattEvent battEvent) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (battEvent != null) {
                        _data.writeInt(1);
                        battEvent.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(62, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdSetReportBatteryState(int f_report) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(f_report);
                    this.mRemote.transact(63, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdGetBatteryState() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(64, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdGetChargingState() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(65, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdSetBTConfig(int PinCode, String LocalName) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(PinCode);
                    _data.writeString(LocalName);
                    this.mRemote.transact(66, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String cmdGetBTMacAddress() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(67, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendTextCommand(String sCmd) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(sCmd);
                    this.mRemote.transact(68, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String cmdGetBTDeviceName() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(69, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdSetClearReport(int enable) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(enable);
                    this.mRemote.transact(70, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String cmdGetOemInfo() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(71, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdGetTagFocus() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(72, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdSetTagFocus(int enable) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(enable);
                    this.mRemote.transact(73, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdGetFastID() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(74, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdSetFastID(int enable) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(enable);
                    this.mRemote.transact(75, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdGetLBTState() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(76, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdSetLBTState(int lbt) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(lbt);
                    this.mRemote.transact(77, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdGetLinkProfile() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(78, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdSetLinkProfile(int profile) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(profile);
                    this.mRemote.transact(79, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdSetSingleTagSearch(int length, String ACS_EPC, int threshold, int step) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(length);
                    _data.writeString(ACS_EPC);
                    _data.writeInt(threshold);
                    _data.writeInt(step);
                    this.mRemote.transact(80, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdSetMultiTagSearch() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(81, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdSetMultiTagList(int index, int length, String ACS_EPC) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(index);
                    _data.writeInt(length);
                    _data.writeString(ACS_EPC);
                    this.mRemote.transact(82, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdGetMultiTagList() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(83, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdGetMultiTagList_ext(int index) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(index);
                    this.mRemote.transact(84, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdClearMultiTagList(int index, int length) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(index);
                    _data.writeInt(length);
                    this.mRemote.transact(85, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdClearAllMultiTagList() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(86, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdWildcardTagSearch(int length, String ACS_EPC) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(length);
                    _data.writeString(ACS_EPC);
                    this.mRemote.transact(87, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdGetDataFormat() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(88, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdSetDataFormat(int index) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(index);
                    this.mRemote.transact(89, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdGetTxDataFormat() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(90, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdSetTxDataFormat(int index) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(index);
                    this.mRemote.transact(91, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String cmdGetPrefix() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(92, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdSetPrefix(String prefix) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(prefix);
                    this.mRemote.transact(93, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String cmdGetSuffix() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(94, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdSetSuffix(String suffix) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(suffix);
                    this.mRemote.transact(95, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String cmdGetSuffix1() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(96, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdSetSuffix1(String suffix1) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(suffix1);
                    this.mRemote.transact(97, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String cmdGetSuffix2() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(98, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdSetSuffix2(String suffix2) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(suffix2);
                    this.mRemote.transact(99, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdGetLcdOff() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(100, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdSetLcdOff(int lcdOff) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(lcdOff);
                    this.mRemote.transact(101, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdSetDataCase(int datacase) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(datacase);
                    this.mRemote.transact(102, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdBlockWrite(int length, int membank, int offset, String writeData, String password, int blockMode) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(length);
                    _data.writeInt(membank);
                    _data.writeInt(offset);
                    _data.writeString(writeData);
                    _data.writeString(password);
                    _data.writeInt(blockMode);
                    this.mRemote.transact(103, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdBlockErase(int length, int membank, int offset, String password, int blockMode) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(length);
                    _data.writeInt(membank);
                    _data.writeInt(offset);
                    _data.writeString(password);
                    _data.writeInt(blockMode);
                    this.mRemote.transact(104, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdGetResultType() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(105, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cmdSetResultType(int resultType) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(resultType);
                    this.mRemote.transact(106, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdGetTerminatorType() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(107, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cmdSetTerminatorType(int terminatorType) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(terminatorType);
                    this.mRemote.transact(108, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            @Override
            public void cmdSetBTDefault() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(109, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdGetInventoryReportFormat_ext(ReportFormatOfInvent_ext reportFormatOfInvent_ext) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(110, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                    if (0 != _reply.readInt()) {
                        reportFormatOfInvent_ext.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdSetInventoryReportFormat_ext(ReportFormatOfInvent_ext reportFormatOfInvent_ext) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (reportFormatOfInvent_ext != null) {
                        _data.writeInt(1);
                        reportFormatOfInvent_ext.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(111, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdSetDeviceBaudrate(int baudrate) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(baudrate);
                    this.mRemote.transact(112, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdGetAntSelect(AntSelect antSelect) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(113, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                    if (0 != _reply.readInt()) {
                        antSelect.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdSetAntSelect(AntSelect antSelect) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (antSelect != null) {
                        _data.writeInt(1);
                        antSelect.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(114, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdGetAntPower(AntPower antPower) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(115, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                    if (0 != _reply.readInt()) {
                        antPower.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdSetAntPower(AntPower antPower) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (antPower != null) {
                        _data.writeInt(1);
                        antPower.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(116, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String cmdGetAvailableRegion() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(117, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cmdSetRegion(String region) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(region);
                    this.mRemote.transact(118, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cmdGetCustomIntentConfig(CustomIntentConfig customIntentConfig) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(119, _data, _reply, 0);
                    _reply.readException();
                    if (0 != _reply.readInt()) {
                        customIntentConfig.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cmdSetCustomIntentConfig(CustomIntentConfig customIntentConfig) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (customIntentConfig != null) {
                        _data.writeInt(1);
                        customIntentConfig.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(120, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean RegisterRFIDCallback(IRFIDCallback callback) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.mRemote.transact(121, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean UnregisterRFIDCallback(IRFIDCallback callback) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.mRemote.transact(122, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }
}

