/*
 * Decompiled with CFR 0.152.
 */
package device.sdk;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.IPackageDeleteObserver;
import android.net.wifi.WifiConfiguration;
import android.os.Environment;
import android.os.RemoteException;
import device.sdk.DeviceServer;
import java.io.File;
import java.util.List;

public class Control {
    public static final int DELETE_KEEP_DATA = 1;
    public static final int DELETE_ALL_USERS = 2;
    public static final int DELETE_SYSTEM_APP = 4;
    public static final int DONT_KILL_APP = 1;
    public static final int DELETE_SUCCEEDED = 1;
    public static final int DELETE_FAILED_INTERNAL_ERROR = -1;
    public static final int DELETE_FAILED_DEVICE_POLICY_MANAGER = -2;
    public static final int DELETE_FAILED_USER_RESTRICTED = -3;
    public static final int DELETE_FAILED_OWNER_BLOCKED = -4;
    public static final int DELETE_FAILED_ABORTED = -5;
    public static final int COMPONENT_ENABLED_STATE_DEFAULT = 0;
    public static final int COMPONENT_ENABLED_STATE_ENABLED = 1;
    public static final int COMPONENT_ENABLED_STATE_DISABLED = 2;
    public static final int COMPONENT_ENABLED_STATE_DISABLED_USER = 3;
    public static final int COMPONENT_ENABLED_STATE_DISABLED_UNTIL_USED = 4;
    public static final int SOUND_DIALPAD = 0;
    public static final int SOUND_SCREEN_LOCKING = 1;
    public static final int SOUND_CHARGING = 2;
    public static final int SOUND_DOCKING = 3;
    public static final int SOUND_TOUCH = 4;
    public static final int SOUND_VIBRATE_ON_TOUCH = 5;
    public static final int SOUND_DOCK_AUDIO_MEDIA = 6;
    public static final int SOUND_EMERGENCY = 7;
    public static final int EMERGENCY_TONE_SILENT = 0;
    public static final int EMERGENCY_TONE_ALERT = 1;
    public static final int EMERGENCY_TONE_VIBRATE = 2;
    public static final int DOCK_AUDIO_MEDIA_DISABLED = 0;
    public static final int DOCK_AUDIO_MEDIA_ENABLED = 1;
    private static final String TAG = Control.class.getSimpleName();
    private static Control mInstance = null;

    public static Control getInstance() {
        if (mInstance == null) {
            mInstance = new Control();
        }
        return mInstance;
    }

    @Deprecated
    public String getExpansion5vPower() throws RemoteException {
        return DeviceServer.getIDeviceService().getExpansion5vPower();
    }

    @Deprecated
    public void setExpansion5vPower(boolean enabled) throws RemoteException {
        DeviceServer.getIDeviceService().setExpansion5vPower(enabled);
    }

    @Deprecated
    public String getExpansion3p3vPower() throws RemoteException {
        return DeviceServer.getIDeviceService().getExpansion3p3vPower();
    }

    @Deprecated
    public void setExpansion3p3vPower(boolean enabled) throws RemoteException {
        DeviceServer.getIDeviceService().setExpansion3p3vPower(enabled);
    }

    @Deprecated
    public String getExpansionGpio() throws RemoteException {
        return DeviceServer.getIDeviceService().getExpansionGpio();
    }

    @Deprecated
    public void setExpansionGpio(boolean enabled) throws RemoteException {
        DeviceServer.getIDeviceService().setExpansionGpio(enabled);
    }

    @Deprecated
    public String getGpsPower() throws RemoteException {
        return DeviceServer.getIDeviceService().getGpsPower();
    }

    @Deprecated
    public void setGpsPower(boolean enabled) throws RemoteException {
        DeviceServer.getIDeviceService().setGpsPower(enabled);
    }

    @Deprecated
    public String getStyluspenMode() throws RemoteException {
        return DeviceServer.getIDeviceService().getStyluspenMode();
    }

    @Deprecated
    public void setStyluspenMode(boolean enabled) throws RemoteException {
        DeviceServer.getIDeviceService().setStyluspenMode(enabled);
    }

    public boolean getNavigationBarHide() throws RemoteException {
        return DeviceServer.getIDeviceService().getNavigationBarHide();
    }

    public void setNavigationBarHide(boolean enabled) throws RemoteException {
        DeviceServer.getIDeviceService().setNavigationBarHide(enabled);
    }

    public boolean getOnlyHardKeyboardEnabled() throws RemoteException {
        return DeviceServer.getIDeviceService().getOnlyHardKeyboardEnabled();
    }

    public void setOnlyHardKeyboardEnabled(boolean enabled) throws RemoteException {
        DeviceServer.getIDeviceService().setOnlyHardKeyboardEnabled(enabled);
    }

    public byte[] getCustomerMfgData() throws RemoteException {
        return DeviceServer.getIDeviceService().getCustomerMfgData();
    }

    public boolean setCustomerMfgData(byte[] data) throws RemoteException {
        return DeviceServer.getIDeviceService().setCustomerMfgData(data);
    }

    public String getCustomerMfgStringData() throws RemoteException {
        return DeviceServer.getIDeviceService().getCustomerMfgStringData();
    }

    public boolean setCustomerMfgStringData(String data) throws RemoteException {
        return DeviceServer.getIDeviceService().setCustomerMfgStringData(data);
    }

    public boolean getAdbEnabled() throws RemoteException {
        return DeviceServer.getIDeviceService().getAdbEnabled();
    }

    public void setAdbEnabled(boolean enabled) throws RemoteException {
        DeviceServer.getIDeviceService().setAdbEnabled(enabled);
    }

    public int getVibrateIntensity() {
        try {
            return DeviceServer.getIDeviceService().getVibrateIntensity();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public void setVibrateIntensity(int level) {
        try {
            DeviceServer.getIDeviceService().setVibrateIntensity(level);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public boolean getKeyboardBacklightEnabled() {
        try {
            return DeviceServer.getIDeviceService().getKeyboardBacklightEnabled();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setKeyboardBacklightEnabled(boolean enabled) {
        try {
            DeviceServer.getIDeviceService().setKeyboardBacklightEnabled(enabled);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public int getTouchSensitivityValue() {
        try {
            return DeviceServer.getIDeviceService().getTouchSensitivityValue();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 1;
        }
    }

    public void setTouchSensitivityValue(int sensitivity) {
        try {
            DeviceServer.getIDeviceService().setTouchSensitivityValue(sensitivity);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public boolean getVibrateOnTouchEnabled() {
        try {
            return DeviceServer.getIDeviceService().getVibrateOnTouchEnabled();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setVibrateOnTouchEnabled(boolean enabled) {
        try {
            DeviceServer.getIDeviceService().setVibrateOnTouchEnabled(enabled);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void setGpsAlwaysOn(boolean enabled) {
        try {
            DeviceServer.getIDeviceService().setGpsAlwaysOn(enabled);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void setGpsAlwaysOff(boolean enabled) {
        try {
            DeviceServer.getIDeviceService().setGpsAlwaysOff(enabled);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void setDataEnabled(boolean enabled) {
        try {
            DeviceServer.getIDeviceService().setDataEnabled(enabled);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public String getNtpServer() {
        try {
            return DeviceServer.getIDeviceService().getNtpServer();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return "";
        }
    }

    public void setNtpServer(String address) {
        try {
            DeviceServer.getIDeviceService().setNtpServer(address);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void lockNow(boolean go2sleep) {
        try {
            DeviceServer.getIDeviceService().lockNow(go2sleep);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public String getHostname() {
        try {
            return DeviceServer.getIDeviceService().getHostname();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return "";
        }
    }

    public boolean setHostname(String hostname) {
        try {
            return DeviceServer.getIDeviceService().setHostname(hostname);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setEnable11d(boolean enable) {
        try {
            DeviceServer.getIDeviceService().setEnable11d(enable);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public boolean getEnable11d() {
        try {
            return DeviceServer.getIDeviceService().getEnable11d();
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public void set24GHzChannelList(int[] channelList) {
        try {
            DeviceServer.getIDeviceService().set24GHzChannelList(channelList);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public int[] get24GHzChannelList() {
        try {
            return DeviceServer.getIDeviceService().get24GHzChannelList();
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public void set5GHzChannelList(int[] channelList) {
        try {
            DeviceServer.getIDeviceService().set5GHzChannelList(channelList);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public int[] get5GHzChannelList() {
        try {
            return DeviceServer.getIDeviceService().get5GHzChannelList();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public void setCountryCode(String country, boolean persist) {
        try {
            DeviceServer.getIDeviceService().setCountryCode(country, persist);
        }
        catch (RemoteException e) {
            return;
        }
    }

    public String getCountryCode() {
        try {
            return DeviceServer.getIDeviceService().getCountryCode();
        }
        catch (RemoteException e) {
            return "";
        }
    }

    public void setWLANPowerSaveMode(boolean enable) {
        try {
            DeviceServer.getIDeviceService().setWLANPowerSaveMode(enable);
        }
        catch (RemoteException e) {
            return;
        }
    }

    public boolean getWLANPowerSaveMode() {
        try {
            return DeviceServer.getIDeviceService().getWLANPowerSaveMode();
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public void setCCXSupporting(boolean enable) {
        try {
            DeviceServer.getIDeviceService().setCCXSupporting(enable);
        }
        catch (RemoteException e) {
            return;
        }
    }

    public boolean getCCXSupporting() {
        try {
            return DeviceServer.getIDeviceService().getCCXSupporting();
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public void setSendDeauthBeforeConnect(boolean enable) {
        try {
            DeviceServer.getIDeviceService().setSendDeauthBeforeConnect(enable);
        }
        catch (RemoteException e) {
            return;
        }
    }

    public boolean getSendDeauthBeforeConnect() {
        try {
            return DeviceServer.getIDeviceService().getSendDeauthBeforeConnect();
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public void setBackgroundScanTrigger(int level) {
        try {
            DeviceServer.getIDeviceService().setBackgroundScanTrigger(level);
        }
        catch (RemoteException e) {
            return;
        }
    }

    public int getBackgroundScanTrigger() {
        try {
            return DeviceServer.getIDeviceService().getBackgroundScanTrigger();
        }
        catch (RemoteException e) {
            return 0;
        }
    }

    public void setRoamingTrigger(int level) {
        try {
            DeviceServer.getIDeviceService().setRoamingTrigger(level);
        }
        catch (RemoteException e) {
            return;
        }
    }

    public int getRoamingTrigger() {
        try {
            return DeviceServer.getIDeviceService().getRoamingTrigger();
        }
        catch (RemoteException e) {
            return 0;
        }
    }

    public void setInternetAccessCheck(boolean enable) {
        try {
            DeviceServer.getIDeviceService().setInternetAccessCheck(enable);
        }
        catch (RemoteException e) {
            return;
        }
    }

    public boolean getInternetAccessCheck() {
        try {
            return DeviceServer.getIDeviceService().getInternetAccessCheck();
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public void setKeepAliveMode(boolean enable) {
        try {
            DeviceServer.getIDeviceService().setKeepAliveMode(enable);
        }
        catch (RemoteException e) {
            return;
        }
    }

    public boolean getKeepAliveMode() {
        try {
            return DeviceServer.getIDeviceService().getKeepAliveMode();
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public int getFrequencyBand() {
        try {
            return DeviceServer.getIDeviceService().getFrequencyBand();
        }
        catch (RemoteException e) {
            return 0;
        }
    }

    public boolean addWifiSsidsToWhiteList(List<String> ssid) {
        try {
            return DeviceServer.getIDeviceService().addWifiSsidsToWhiteList(ssid);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean clearWifiSsidsFromWhiteList() {
        try {
            return DeviceServer.getIDeviceService().clearWifiSsidsFromWhiteList();
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public List<String> getWifiSsidsFromWhiteLists() {
        try {
            return DeviceServer.getIDeviceService().getWifiSsidsFromWhiteLists();
        }
        catch (RemoteException e) {
            List<String> temp = null;
            return temp;
        }
    }

    public boolean removeWifiSsidsFromWhiteList(List<String> ssid) {
        try {
            return DeviceServer.getIDeviceService().removeWifiSsidsFromWhiteList(ssid);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public void setFrequencyBand(int band, boolean persist) {
        try {
            DeviceServer.getIDeviceService().setFrequencyBand(band, persist);
            return;
        }
        catch (RemoteException e) {
            return;
        }
    }

    public void setEnabledScreenCapture(boolean enabled) {
        try {
            DeviceServer.getIDeviceService().setEnabledScreenCapture(enabled);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public boolean isEnabledScreenCapture() {
        try {
            return DeviceServer.getIDeviceService().isEnabledScreenCapture();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return true;
        }
    }

    public boolean isRestricted() {
        try {
            return DeviceServer.getIDeviceService().isRestricted();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setUserRestriction(String key, boolean value) {
        try {
            DeviceServer.getIDeviceService().setUserRestriction(key, value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public boolean hasUserRestriction(String restrictionKey) {
        try {
            return DeviceServer.getIDeviceService().hasUserRestriction(restrictionKey);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setNonMarketAppsAllowed(boolean enabled) {
        try {
            return DeviceServer.getIDeviceService().setNonMarketAppsAllowed(enabled);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isNonMarketAppsAllowed() {
        try {
            return DeviceServer.getIDeviceService().isNonMarketAppsAllowed();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setNonMarketAppsAllowedOption(boolean enabled) {
        try {
            DeviceServer.getIDeviceService().setNonMarketAppsAllowedOption(enabled);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public boolean isNonMarketAppsAllowedOption() {
        try {
            return DeviceServer.getIDeviceService().isNonMarketAppsAllowedOption();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return true;
        }
    }

    public int setNfcEnabled(boolean enabled) {
        try {
            return DeviceServer.getIDeviceService().setNfcEnabled(enabled);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int getNfcEnabled() {
        try {
            return DeviceServer.getIDeviceService().getNfcEnabled();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public void setNfcEnabledOption(boolean enabled) {
        try {
            DeviceServer.getIDeviceService().setNfcEnabledOption(enabled);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public boolean isNfcEnabledOption() {
        try {
            return DeviceServer.getIDeviceService().isNfcEnabledOption();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return true;
        }
    }

    public int getScreenBrightnessMax() {
        try {
            return DeviceServer.getIDeviceService().getScreenBrightnessMax();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int getScreenBrightness() {
        try {
            return DeviceServer.getIDeviceService().getScreenBrightness();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public void setScreenBrightness(boolean tracking, int value) {
        try {
            DeviceServer.getIDeviceService().setScreenBrightness(tracking, value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public boolean areAllRotationsAllowed() {
        try {
            return DeviceServer.getIDeviceService().areAllRotationsAllowed();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return true;
        }
    }

    public boolean isRotationLockToggleVisible() {
        try {
            return DeviceServer.getIDeviceService().isRotationLockToggleVisible();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getRotationLockOrientation() {
        try {
            return DeviceServer.getIDeviceService().getRotationLockOrientation();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean isRotationLocked() {
        try {
            return DeviceServer.getIDeviceService().isRotationLocked();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setRotationLock(boolean locked) {
        try {
            DeviceServer.getIDeviceService().setRotationLock(locked);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public int getScreenOffTimeout() {
        try {
            return DeviceServer.getIDeviceService().getScreenOffTimeout();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setScreenOffTimeout(int timeout) {
        try {
            return DeviceServer.getIDeviceService().setScreenOffTimeout(timeout);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isEnabledStayAwake() {
        try {
            return DeviceServer.getIDeviceService().isEnabledStayAwake();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setEnabledStayAwake(boolean enabled) {
        try {
            DeviceServer.getIDeviceService().setEnabledStayAwake(enabled);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public String getMockLocationApp() {
        try {
            return DeviceServer.getIDeviceService().getMockLocationApp();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return "";
        }
    }

    public boolean setMockLocationApp(String packageName) {
        try {
            return DeviceServer.getIDeviceService().setMockLocationApp(packageName);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isUninstallBlocked(String packageName) {
        try {
            return DeviceServer.getIDeviceService().isUninstallBlocked(packageName);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setUninstallBlocked(String packageName, boolean uninstallBlocked) {
        try {
            DeviceServer.getIDeviceService().setUninstallBlocked(packageName, uninstallBlocked);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public boolean isApplicationHidden(String packageName) {
        try {
            return DeviceServer.getIDeviceService().isApplicationHidden(packageName);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setApplicationHidden(String packageName, boolean hidden) {
        try {
            return DeviceServer.getIDeviceService().setApplicationHidden(packageName, hidden);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setApplicationEnabledSetting(String packageName, int newState) {
        try {
            DeviceServer.getIDeviceService().setApplicationEnabledSetting(packageName, newState);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void deletePackage(String packageName, IPackageDeleteObserver observer, int flags) {
        try {
            DeviceServer.getIDeviceService().deletePackage(packageName, observer, flags);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public boolean isStreamAffectedByRingerMode(int streamType) {
        try {
            return DeviceServer.getIDeviceService().isStreamAffectedByRingerMode(streamType);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getRingerModeInternal() {
        try {
            return DeviceServer.getIDeviceService().getRingerModeInternal();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 2;
        }
    }

    public int getStreamMaxVolume(int streamType) {
        try {
            return DeviceServer.getIDeviceService().getStreamMaxVolume(streamType);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int getStreamVolume(int streamType) {
        try {
            return DeviceServer.getIDeviceService().getStreamVolume(streamType);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int getLastAudibleStreamVolume(int streamType) {
        try {
            return DeviceServer.getIDeviceService().getLastAudibleStreamVolume(streamType);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean isStreamMute(int streamType) {
        try {
            return DeviceServer.getIDeviceService().isStreamMute(streamType);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void adjustStreamVolume(int streamType, int direction, int flags) {
        try {
            DeviceServer.getIDeviceService().adjustStreamVolume(streamType, direction, flags);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void setStreamVolume(int streamType, int index, int flags) {
        try {
            DeviceServer.getIDeviceService().setStreamVolume(streamType, index, flags);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public boolean isVolumeFixed() {
        try {
            return DeviceServer.getIDeviceService().isVolumeFixed();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getEnabledOtherSounds(int soundType) {
        try {
            return DeviceServer.getIDeviceService().getEnabledOtherSounds(soundType);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public void setEnabledOtherSounds(int soundType, int value) {
        try {
            DeviceServer.getIDeviceService().setEnabledOtherSounds(soundType, value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public boolean isAirplaneModeOn() {
        try {
            return DeviceServer.getIDeviceService().isAirplaneModeOn();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setAirplaneModeOn(boolean enabling) {
        try {
            DeviceServer.getIDeviceService().setAirplaneModeOn(enabling);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public int getWifiSleepPolicy() {
        try {
            return DeviceServer.getIDeviceService().getWifiSleepPolicy();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 2;
        }
    }

    public void setWifiSleepPolicy(int sleepPolicy) {
        try {
            DeviceServer.getIDeviceService().setWifiSleepPolicy(sleepPolicy);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getWifiState() {
        try {
            return DeviceServer.getIDeviceService().getWifiState();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 4;
        }
    }

    public boolean setWifiEnabled(boolean enabled) {
        try {
            return DeviceServer.getIDeviceService().setWifiEnabled(enabled);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getWifiApState() {
        try {
            return DeviceServer.getIDeviceService().getWifiApState();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 14;
        }
    }

    public boolean isWifiApEnabled() {
        try {
            return DeviceServer.getIDeviceService().isWifiApEnabled();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setWifiApEnabled(WifiConfiguration wifiConfig, boolean enabled) {
        try {
            return DeviceServer.getIDeviceService().setWifiApEnabled(wifiConfig, enabled);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean writeBytesToSystemFile(String dest, byte[] buffer) {
        try {
            return DeviceServer.getIDeviceService().writeBytesToSystemFile(dest, buffer);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int osImageUpgrade(Context context, int pathType, String filename) {
        String path;
        int RESULT_CODE_ERROR_INVALID_PARAMETER = -1;
        boolean RESULT_CODE_SUCCESS = false;
        int RESULT_CODE_ERROR_SDCARD_NOT_MOUNT = 6;
        int RESULT_CODE_ERROR_NO_VALID_FILENAME = 7;
        int RESULT_CODE_ERROR_MULTIPLE_VALID_FILENAMES = 8;
        int RESULT_CODE_ERROR_BATTERY_CAPACITY_NOT_ENOUGH = 9;
        int RESULT_CODE_ERROR_FAILED_COPY_FILES = 10;
        int RESULT_CODE_ERROR_FREE_SPACE_NOT_ENOUGH = 11;
        String PHONE_STORAGE = "/storage/emulated/0/";
        String SD_CARD_STORAGE = "/storage/sdcard1/";
        boolean FILE_PATH_PHONE_STORAGE = false;
        boolean FILE_PATH_SDCARD_STORAGE = true;
        if (context == null) {
            return -1;
        }
        int resultCode = 0;
        switch (pathType) {
            case 0: {
                path = new String("/storage/emulated/0/");
                break;
            }
            case 1: {
                path = new String("/storage/sdcard1/");
                if (this.isMountedExternalSdCard()) break;
                resultCode = 6;
                break;
            }
            default: {
                return -1;
            }
        }
        if (filename.isEmpty() || filename == null) {
            int numberOfUpgradableFile = this.getNumberOfValidFile(new File(path));
            if (numberOfUpgradableFile <= 0) {
                resultCode = 7;
            } else if (numberOfUpgradableFile >= 2) {
                resultCode = 8;
            } else if (numberOfUpgradableFile == 1) {
                filename = this.getValidFile(new File(path));
            }
        } else if (!this.isFileExists(new File(path), filename)) {
            resultCode = 7;
        }
        if (!this.isEnoughBatteryCapacity(context)) {
            resultCode = 9;
        }
        Intent intent = new Intent("android.settings.SDCARD_UPGRADE_SETTINGS");
        intent.putExtra("path", new String(path + filename));
        intent.putExtra("bypass", true);
        intent.setFlags(0x10000000);
        context.startActivity(intent);
        return resultCode;
    }

    private boolean isMountedExternalSdCard() {
        File externalPath = new File("/storage/sdcard1/");
        return externalPath.exists() && Environment.getStorageState((File)externalPath).equals("mounted");
    }

    private String getMajorNumber() {
        try {
            return String.valueOf(DeviceServer.getIDeviceService().getMajorNumber());
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return "";
        }
    }

    private int getNumberOfValidFile(File filepath) {
        int index = 0;
        String keyword = this.getMajorNumber();
        if (keyword.isEmpty() || keyword == null) {
            return index;
        }
        File[] files = filepath.listFiles();
        if (files == null) {
            return index;
        }
        if (files.length > 0) {
            for (File file : files) {
                try {
                    String fileNamePrefix = file.getName().substring(0, keyword.length());
                    if (!fileNamePrefix.equalsIgnoreCase(keyword) || file.getName().indexOf(".PFU") <= -1) continue;
                    ++index;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return index;
    }

    private String getValidFile(File filepath) {
        String validFilename = null;
        String keyword = this.getMajorNumber();
        File[] files = filepath.listFiles();
        if (files.length > 0) {
            for (File file : files) {
                try {
                    String fileNamePrefix = file.getName().substring(0, keyword.length());
                    if (!fileNamePrefix.equalsIgnoreCase(keyword) || file.getName().indexOf(".PFU") <= -1) continue;
                    validFilename = file.getName();
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return validFilename;
    }

    private boolean isFileExists(File filepath, String filename) {
        boolean isExists = false;
        File[] files = filepath.listFiles();
        if (files == null) {
            return isExists;
        }
        if (files.length > 0) {
            for (File file : files) {
                try {
                    if (!file.getName().equals(filename) || file.getName().indexOf(".PFU") <= -1) continue;
                    filename = file.getName();
                    isExists = true;
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return isExists;
    }

    private boolean isEnoughBatteryCapacity(Context context) {
        Intent batteryStatus = context.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
        int level = batteryStatus.getIntExtra("level", -1);
        int scale = batteryStatus.getIntExtra("scale", -1);
        int plugged = batteryStatus.getIntExtra("plugged", -1);
        int batteryPercent = level * 100 / scale;
        return batteryPercent > 20 || plugged == 1;
    }

    public boolean isEnabledOtherSoundsAll() {
        try {
            return DeviceServer.getIDeviceService().isEnabledOtherSoundsAll();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setEnabledOtherSoundsAll(boolean enabled) {
        try {
            DeviceServer.getIDeviceService().setEnabledOtherSoundsAll(enabled);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void setAutoJoin(boolean enable) {
        try {
            DeviceServer.getIDeviceService().setAutoJoin(enable);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public boolean isAutoJoin() {
        try {
            return DeviceServer.getIDeviceService().isAutoJoin();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return true;
        }
    }

    public void reboot(boolean confirm, String reason, boolean wait) {
        try {
            DeviceServer.getIDeviceService().reboot(confirm, reason, wait);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public int getReconnectionInterval() {
        try {
            return DeviceServer.getIDeviceService().getReconnectionInterval();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean setReconnectionInterval(int reconnectionInterval) {
        try {
            return DeviceServer.getIDeviceService().setReconnectionInterval(reconnectionInterval);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void saveWifiConfig(WifiConfiguration config) {
        try {
            DeviceServer.getIDeviceService().saveWifiConfig(config);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void setEnableFOTAClientMenu(int enabled) {
        try {
            String model = DeviceServer.getIDeviceService().getModelName();
            if (model.equalsIgnoreCase("PM45")) {
                return;
            }
            DeviceServer.getIDeviceService().setEnableFOTAClientMenu(enabled);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public int getEnableFOTAClientMenu() {
        int enabled = 1;
        try {
            String model = DeviceServer.getIDeviceService().getModelName();
            if (model.equalsIgnoreCase("PM45")) {
                return enabled;
            }
            enabled = DeviceServer.getIDeviceService().getEnableFOTAClientMenu();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return enabled;
    }

    public void setEnableAirplaneModeMenu(int enabled) {
        try {
            DeviceServer.getIDeviceService().setEnableAirplaneModeMenu(enabled);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public int getEnableAirplaneModeMenu() {
        try {
            return DeviceServer.getIDeviceService().getEnableAirplaneModeMenu();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 1;
        }
    }

    public boolean setUsbPriority(int usbType) {
        try {
            return DeviceServer.getIDeviceService().setUsbPriority(usbType);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getUsbPriority() {
        try {
            return DeviceServer.getIDeviceService().getUsbPriority();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean isRestrictedMtp() {
        try {
            return DeviceServer.getIDeviceService().isRestrictedMtp();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setRestrictedMtp(boolean enabled) {
        try {
            return DeviceServer.getIDeviceService().setRestrictedMtp(enabled);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setDhcpNtpServer(boolean enabled) {
        try {
            DeviceServer.getIDeviceService().setDhcpNtpServer(enabled ? 1 : 0);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public boolean getDhcpNtpServer() {
        try {
            return DeviceServer.getIDeviceService().getDhcpNtpServer() == 1;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setMediaTransferRestriction(boolean enable) {
        try {
            return DeviceServer.getIDeviceService().setMediaTransferRestriction(enable);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isMediaTransferRestriction() {
        try {
            return DeviceServer.getIDeviceService().isMediaTransferRestriction();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setUsbDebuggingRestriction(boolean enable) {
        try {
            return DeviceServer.getIDeviceService().setUsbDebuggingRestriction(enable);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isUsbDebuggingRestriction() {
        try {
            return DeviceServer.getIDeviceService().isUsbDebuggingRestriction();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setMediaMountRestriction(boolean enable) {
        try {
            return DeviceServer.getIDeviceService().setMediaMountRestriction(enable);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isMediaMountRestriction() {
        try {
            return DeviceServer.getIDeviceService().isMediaMountRestriction();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

