/*
 * Decompiled with CFR 0.152.
 */
package device.sdk;

import android.os.RemoteException;
import device.sdk.DeviceServer;

public class Information {
    private static final String TAG = Information.class.getSimpleName();
    private static Information mInstance = null;

    public static Information getInstance() {
        if (mInstance == null) {
            mInstance = new Information();
        }
        return mInstance;
    }

    public String getHardwareRevision() throws RemoteException {
        return DeviceServer.getIDeviceService().getHardwareRevision();
    }

    public String getAndroidVersion() throws RemoteException {
        return DeviceServer.getIDeviceService().getAndroidVersion();
    }

    public String getKernelVersion() throws RemoteException {
        return DeviceServer.getIDeviceService().getKernelVersion();
    }

    public String getBuildNumber() throws RemoteException {
        return DeviceServer.getIDeviceService().getBuildNumber();
    }

    public String getSDKVersion() throws RemoteException {
        return DeviceServer.getIDeviceService().getSDKVersion();
    }

    public String getManufacturer() throws RemoteException {
        return DeviceServer.getIDeviceService().getManufacturer();
    }

    public String getModelName() throws RemoteException {
        return DeviceServer.getIDeviceService().getModelName();
    }

    public String getProcessorInfo() throws RemoteException {
        return DeviceServer.getIDeviceService().getProcessorInfo();
    }

    public String getSerialNumber() throws RemoteException {
        return DeviceServer.getIDeviceService().getSerialNumber();
    }

    public String getPartNumber() throws RemoteException {
        return DeviceServer.getIDeviceService().getPartNumber();
    }

    @Deprecated
    public String getModelNumber() throws RemoteException {
        return DeviceServer.getIDeviceService().getModelNumber();
    }

    public String getManufactureDate() throws RemoteException {
        return DeviceServer.getIDeviceService().getManufactureDate();
    }

    private static String convertVersionFormat(byte[] version) {
        String[] months = new String[]{"", "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
        byte[] buffer = new byte[24];
        int i = 0;
        int j = 0;
        byte[] majorBytes = String.format("%02d", version[j++]).getBytes();
        Object[] objectArray = new Object[1];
        int n = ++j;
        ++j;
        objectArray[0] = version[n];
        byte[] minorBytes = String.format("%02d", objectArray).getBytes();
        ++j;
        buffer[i++] = majorBytes[0];
        buffer[i++] = majorBytes[1];
        buffer[i++] = 46;
        buffer[i++] = minorBytes[0];
        buffer[i++] = minorBytes[1];
        buffer[i++] = 32;
        if (version[j] != 0) {
            buffer[i++] = version[j++];
            buffer[i++] = version[j++];
            buffer[i++] = 32;
        } else {
            j += 2;
        }
        buffer[i++] = 40;
        byte[] yearBytes = String.format("%04d", (version[j++] & 0xFF) + ((version[j++] & 0xFF) << 8)).getBytes();
        byte month = version[j++];
        byte[] dayBytes = String.format("%02d", version[++j]).getBytes();
        byte[] monthBytes = 1 <= month && month <= 12 ? months[month].getBytes() : "XXX".getBytes();
        buffer[i++] = monthBytes[0];
        buffer[i++] = monthBytes[1];
        buffer[i++] = monthBytes[2];
        buffer[i++] = 32;
        buffer[i++] = dayBytes[0];
        buffer[i++] = dayBytes[1];
        buffer[i++] = 32;
        buffer[i++] = yearBytes[0];
        buffer[i++] = yearBytes[1];
        buffer[i++] = yearBytes[2];
        buffer[i++] = yearBytes[3];
        buffer[i++] = 41;
        buffer[i++] = 0;
        return new String(buffer);
    }

    @Deprecated
    public String getXloaderImageVersion() throws RemoteException {
        return DeviceServer.getIDeviceService().getXloaderImageVersion();
    }

    @Deprecated
    public String getBootloaderImageVersion() throws RemoteException {
        return DeviceServer.getIDeviceService().getBootloaderImageVersion();
    }

    @Deprecated
    public String getKernelImageVersion() throws RemoteException {
        return DeviceServer.getIDeviceService().getKernelImageVersion();
    }

    @Deprecated
    public String getRecoveryImageVersion() throws RemoteException {
        return DeviceServer.getIDeviceService().getRecoveryImageVersion();
    }

    public String getAndroidImageVersion() throws RemoteException {
        return DeviceServer.getIDeviceService().getAndroidImageVersion();
    }

    public int getMajorNumber() throws RemoteException {
        return DeviceServer.getIDeviceService().getMajorNumber();
    }

    public String getDeviceName() throws RemoteException {
        return DeviceServer.getIDeviceService().getDeviceName();
    }

    public String getModuleName(int index) throws RemoteException {
        return DeviceServer.getIDeviceService().getModuleName(index);
    }

    public int getCameraType() throws RemoteException {
        return DeviceServer.getIDeviceService().getCameraType();
    }

    public int getCameraSecondType() throws RemoteException {
        return DeviceServer.getIDeviceService().getCameraSecondType();
    }

    public int getDisplayType() throws RemoteException {
        return DeviceServer.getIDeviceService().getDisplayType();
    }

    public int getKeyboardType() throws RemoteException {
        return DeviceServer.getIDeviceService().getKeyboardType();
    }

    public int getNandType() throws RemoteException {
        return DeviceServer.getIDeviceService().getNandType();
    }

    public int getScannerType() throws RemoteException {
        return DeviceServer.getIDeviceService().getScannerType();
    }

    public int getTouchType() throws RemoteException {
        return DeviceServer.getIDeviceService().getTouchType();
    }

    public int getRfidType() throws RemoteException {
        return DeviceServer.getIDeviceService().getRfidType();
    }

    public int getBluetoothType() throws RemoteException {
        return DeviceServer.getIDeviceService().getBluetoothType();
    }

    public int getGpsType() throws RemoteException {
        return DeviceServer.getIDeviceService().getGpsType();
    }

    public int getPhoneType() throws RemoteException {
        return DeviceServer.getIDeviceService().getPhoneType();
    }

    public int getWifiType() throws RemoteException {
        return DeviceServer.getIDeviceService().getWifiType();
    }

    public int getSensorAccelerometerType() throws RemoteException {
        return DeviceServer.getIDeviceService().getSensorAccelerometerType();
    }

    public int getSensorLightType() throws RemoteException {
        return DeviceServer.getIDeviceService().getSensorLightType();
    }

    public int getSensorProximityType() throws RemoteException {
        return DeviceServer.getIDeviceService().getSensorProximityType();
    }

    public int getSensorCpuTemperatureType() throws RemoteException {
        return DeviceServer.getIDeviceService().getSensorCpuTemperatureType();
    }

    public int getSensorGyroscopeType() throws RemoteException {
        return DeviceServer.getIDeviceService().getSensorGyroscopeType();
    }

    public int getSensorMagneticFieldType() throws RemoteException {
        return DeviceServer.getIDeviceService().getSensorMagneticFieldType();
    }

    public int getSensorPressureType() throws RemoteException {
        return DeviceServer.getIDeviceService().getSensorPressureType();
    }

    public int getMsrType() throws RemoteException {
        return DeviceServer.getIDeviceService().getMsrType();
    }

    @Deprecated
    public int getBluetoothStatus() throws RemoteException {
        return DeviceServer.getIDeviceService().getBluetoothStatus();
    }

    @Deprecated
    public int getGpsStatus() throws RemoteException {
        return DeviceServer.getIDeviceService().getGpsStatus();
    }

    @Deprecated
    public int getPhoneStatus() throws RemoteException {
        return DeviceServer.getIDeviceService().getPhoneStatus();
    }

    @Deprecated
    public int getWifiStatus() throws RemoteException {
        return DeviceServer.getIDeviceService().getWifiStatus();
    }

    public String getTouchFirmwareVersion() throws RemoteException {
        return DeviceServer.getIDeviceService().getTouchFirmwareVersion();
    }

    public String getCameraFirmwareVersion(String cameraModule) throws RemoteException {
        return DeviceServer.getIDeviceService().getCameraFirmwareVersion(cameraModule);
    }

    public String getRfidFirmwareVersion() throws RemoteException {
        return DeviceServer.getIDeviceService().getRfidFirmwareVersion();
    }

    public String getRfidSerialNumber() throws RemoteException {
        return DeviceServer.getIDeviceService().getRfidSerialNumber();
    }

    public String getRfidSamInfo(int index) throws RemoteException {
        return DeviceServer.getIDeviceService().getRfidSamInfo(index);
    }

    public String getBluetoothDriverVersion() throws RemoteException {
        return DeviceServer.getIDeviceService().getBluetoothDriverVersion();
    }

    public String getBluetoothMacAddress() throws RemoteException {
        return DeviceServer.getIDeviceService().getBluetoothMacAddress();
    }

    public String getWifiDriverVersion() throws RemoteException {
        return DeviceServer.getIDeviceService().getWifiDriverVersion();
    }

    public String getWifiFirmwareVersion() throws RemoteException {
        return DeviceServer.getIDeviceService().getWifiFirmwareVersion();
    }

    public String getWifiConfigurationDataVersion() throws RemoteException {
        return DeviceServer.getIDeviceService().getWifiConfigurationDataVersion();
    }

    public String getWifiMacAddress() throws RemoteException {
        return DeviceServer.getIDeviceService().getWifiMacAddress();
    }

    public String getWifiIpAddress() throws RemoteException {
        return DeviceServer.getIDeviceService().getWifiIpAddress();
    }

    public String getMainBatteryStatus() throws RemoteException {
        return DeviceServer.getIDeviceService().getMainBatteryStatus();
    }

    public String getBackupBatteryStatus() throws RemoteException {
        return DeviceServer.getIDeviceService().getBackupBatteryStatus();
    }

    @Deprecated
    public String getBatterySerialNumber() throws RemoteException {
        return DeviceServer.getIDeviceService().getBatterySerialNumber();
    }

    public String getChargingMainBatteryFromUsbFlag() throws RemoteException {
        return DeviceServer.getIDeviceService().getChargingMainBatteryFromUsbFlag();
    }

    public String getChargingBackupBatteryFromMainBatteryFlag() throws RemoteException {
        return DeviceServer.getIDeviceService().getChargingBackupBatteryFromMainBatteryFlag();
    }

    public String getLowBatteryWarningLevel() throws RemoteException {
        return DeviceServer.getIDeviceService().getLowBatteryWarningLevel();
    }

    public String getCriticalBatteryWarningLevel() throws RemoteException {
        return DeviceServer.getIDeviceService().getCriticalBatteryWarningLevel();
    }

    public int getScannerClass(int scanner) throws RemoteException {
        return DeviceServer.getIDeviceService().getScannerClass(scanner);
    }

    public String getScannerName(int scanner) throws RemoteException {
        return DeviceServer.getIDeviceService().getScannerName(scanner);
    }

    public String getScannerClassName(int scanner) throws RemoteException {
        return DeviceServer.getIDeviceService().getScannerClassName(scanner);
    }
}

