/*
 * Decompiled with CFR 0.152.
 */
package device.sdk;

import android.os.RemoteException;
import device.common.HiJackData;
import device.common.HijackingKeys;
import device.sdk.DeviceServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class KeyManager {
    private static final String TAG = KeyManager.class.getSimpleName();
    private static KeyManager mInstance = null;
    public static final int KEYCODE_SOFTKEY_LOCK = 1008;
    public static final int KEYPAD_MODE_NORMAL = 0;
    public static final int KEYPAD_MODE_NUMBER = 1;
    public static final int KEYPAD_MODE_LOWERCASE = 2;
    public static final int KEYPAD_MODE_UPPERCASE = 3;
    public static final int KEYPAD_MODE_FUNCTION = 4;

    public static KeyManager getInstance() {
        if (mInstance == null) {
            mInstance = new KeyManager();
        }
        return mInstance;
    }

    private native int checkKCMapFile(String var1);

    private static byte[] getBytesFromFile(String path) {
        try {
            File file = new File(path);
            FileInputStream is = new FileInputStream(file);
            long length = file.length();
            byte[] bytes = new byte[(int)length];
            if (length > Integer.MAX_VALUE) {
                bytes = null;
            } else {
                int numRead = 0;
                for (int offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
                }
            }
            ((InputStream)is).close();
            return bytes;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getCurrentKCMapFile() throws RemoteException {
        return DeviceServer.getIHiJackService().getCurrentKCMapFile();
    }

    public int changeKCMapFile(String path) throws RemoteException {
        int result = this.checkKCMapFile(path);
        if (result == 0) {
            result = DeviceServer.getIHiJackService().changeKCMapFile(path, KeyManager.getBytesFromFile(path));
        }
        return result;
    }

    public boolean removeKCMapFile() throws RemoteException {
        return DeviceServer.getIHiJackService().removeKCMapFile();
    }

    public HijackingKeys[] getHijackingKeys() throws RemoteException {
        return DeviceServer.getIHiJackService().getHijackingKeys();
    }

    public int setAllHiJackData(HiJackData[] dataList) throws RemoteException {
        return DeviceServer.getIHiJackService().setAllHiJackData(dataList);
    }

    public HiJackData[] getAllHiJackData() throws RemoteException {
        return DeviceServer.getIHiJackService().getAllHiJackData();
    }

    public void useUnifiedKeycode(boolean enabled) throws RemoteException {
        DeviceServer.getIHiJackService().useUnifiedKeycode(enabled);
    }

    public boolean isUsingUnifiedKeycode() throws RemoteException {
        return DeviceServer.getIHiJackService().isUsingUnifiedKeycode();
    }

    public boolean changeKCMapFileToDefault() throws RemoteException {
        return DeviceServer.getIHiJackService().changeKCMapFileToDefault();
    }

    public boolean isDirectInputStyle() throws RemoteException {
        return DeviceServer.getIHiJackService().isDirectInputStyle();
    }

    public boolean setDirectInputStyle(boolean enable) throws RemoteException {
        return DeviceServer.getIHiJackService().setDirectInputStyle(enable);
    }

    public boolean isKeyControlMode() throws RemoteException {
        return DeviceServer.getIHiJackService().isKeyControlMode();
    }

    public boolean setKeyControlMode(boolean enable) throws RemoteException {
        return DeviceServer.getIHiJackService().setKeyControlMode(enable);
    }

    public int getKeypadMode() throws RemoteException {
        return DeviceServer.getIHiJackService().getKeypadMode();
    }

    public boolean setKeypadMode(int mode) throws RemoteException {
        return DeviceServer.getIHiJackService().setKeypadMode(mode);
    }

    static {
        System.loadLibrary("jni_keymanager");
    }
}

