/*
 * Decompiled with CFR 0.152.
 */
package device.sdk;

import android.util.Log;
import device.common.rfid.AntPower;
import device.common.rfid.AntSelect;
import device.common.rfid.BattEvent;
import device.common.rfid.ChannelState;
import device.common.rfid.CustomIntentConfig;
import device.common.rfid.ModeOfInvent;
import device.common.rfid.ParamOfInvent;
import device.common.rfid.RFIDCallback;
import device.common.rfid.ReportFormatOfInvent;
import device.common.rfid.ReportFormatOfInvent_ext;
import device.common.rfid.SelConfig;
import device.common.rfid.StatusEvent;
import device.common.rfid.TxCycle;
import device.sdk.DeviceServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class RFIDManager {
    private static final String TAG = RFIDManager.class.getSimpleName();
    private static RFIDManager mInstance = null;

    public static RFIDManager getInstance() {
        if (mInstance == null) {
            mInstance = new RFIDManager();
        }
        return mInstance;
    }

    public boolean RegisterRFIDCallback(RFIDCallback callback) {
        try {
            return DeviceServer.getIRFIDService().RegisterRFIDCallback(callback.getRFIDCallback());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean UnregisterRFIDCallback(RFIDCallback callback) {
        try {
            return DeviceServer.getIRFIDService().UnregisterRFIDCallback(callback.getRFIDCallback());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void ConnectBTDevice(String macAddress, String deviceName) {
        try {
            DeviceServer.getIRFIDService().connectBluetooth(macAddress, deviceName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void DisconnectBTDevice() {
        try {
            DeviceServer.getIRFIDService().disconnectBluetooth();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int Open(int openDevice) {
        try {
            return DeviceServer.getIRFIDService().open(openDevice);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public void Close() {
        try {
            DeviceServer.getIRFIDService().close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean IsOpened() {
        try {
            return DeviceServer.getIRFIDService().isOpened();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Deprecated
    public int SetBtConfig(int pinCode, String localName) {
        try {
            return DeviceServer.getIRFIDService().cmdSetBTConfig(pinCode, localName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public String GetBtDevice() {
        try {
            return DeviceServer.getIRFIDService().cmdGetBTDeviceName();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String GetBtMacAddr() {
        try {
            return DeviceServer.getIRFIDService().cmdGetBTMacAddress();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Deprecated
    public int UploadData(int memIndex, int dataCount) {
        return -8;
    }

    @Deprecated
    public int ClearData() {
        return -8;
    }

    public int SetDefaultConfig() {
        try {
            return DeviceServer.getIRFIDService().cmdSetDefaultParameter();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public String GetFwVersion() {
        try {
            return DeviceServer.getIRFIDService().cmdGetFwVersion();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Deprecated
    public int PowerOff() {
        return -8;
    }

    @Deprecated
    public int GetAutoPowerOffTimeout() {
        return -8;
    }

    @Deprecated
    public int SetAutoPowerOffTimeout() {
        return -8;
    }

    public int GetTimer() {
        try {
            return DeviceServer.getIRFIDService().cmdGetTimer();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int SetTimer(int time) {
        try {
            return DeviceServer.getIRFIDService().cmdSetTimer(time);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int GetBuzzerVol() {
        try {
            return DeviceServer.getIRFIDService().cmdGetBuzzerVolume();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int SetBuzzerVol(int volume) {
        try {
            return DeviceServer.getIRFIDService().cmdSetBuzzerVolume(volume);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int GetBattLevel() {
        try {
            return DeviceServer.getIRFIDService().cmdGetBatteryLevel();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int GetBattEvent(BattEvent battEvent) {
        try {
            return DeviceServer.getIRFIDService().cmdGetBatteryEvent(battEvent);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int SetBattEvent(BattEvent battEvent) {
        try {
            return DeviceServer.getIRFIDService().cmdSetBatteryEvent(battEvent);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int GetConnectStateEvent() {
        try {
            return DeviceServer.getIRFIDService().cmdGetConnectStateReport();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int SetConnectStateEvent(int f_link) {
        try {
            return DeviceServer.getIRFIDService().cmdSetConnectStateReport(f_link);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int GetReaderStateEvent(StatusEvent statusEvent) {
        try {
            return DeviceServer.getIRFIDService().cmdGetReaderStateReport(statusEvent);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int SetReaderStateEvent(StatusEvent statusEvent) {
        try {
            return DeviceServer.getIRFIDService().cmdSetReaderStateReport(statusEvent);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int StartInventory() {
        try {
            return DeviceServer.getIRFIDService().cmdStartInventory();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Deprecated
    public int StartInventory_ext(int single, int mode, int timeout) {
        try {
            return DeviceServer.getIRFIDService().cmdStartInventory_ext(single, mode, timeout);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int Stop() {
        try {
            return DeviceServer.getIRFIDService().cmdStopOperation();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int GetInventoryReportFormat(ReportFormatOfInvent reportFormatOfInvent) {
        try {
            return DeviceServer.getIRFIDService().cmdGetInventoryReportFormat(reportFormatOfInvent);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int SetInventoryReportFormat(ReportFormatOfInvent reportFormatOfInvent) {
        try {
            return DeviceServer.getIRFIDService().cmdSetInventoryReportFormat(reportFormatOfInvent);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int GetSelMask(SelConfig selConfig) {
        try {
            return DeviceServer.getIRFIDService().cmdGetSelectMask(selConfig);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int SetSelMask(SelConfig selConfig) {
        try {
            return DeviceServer.getIRFIDService().cmdSetSelectMask(selConfig);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int ReadTag(int length, int membank, int offset, String ACS_PWD) {
        try {
            return DeviceServer.getIRFIDService().cmdReadTag(length, membank, offset, ACS_PWD);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int WriteTag(int length, int membank, int offset, String ACS_PWD, String writeData) {
        try {
            return DeviceServer.getIRFIDService().cmdWriteTag(length, membank, offset, ACS_PWD, writeData);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int KillTag(String killPwd) {
        try {
            return DeviceServer.getIRFIDService().cmdKillTag(killPwd);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int LockTag(int lockMask, int lockEnable, String ACS_PWD) {
        try {
            return DeviceServer.getIRFIDService().cmdLockTag(lockMask, lockEnable, ACS_PWD);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int PermaLockTag(int lockMask, int lockEnable, String ACS_PWD) {
        try {
            return DeviceServer.getIRFIDService().cmdPermLockTag(lockMask, lockEnable, ACS_PWD);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int GetInventoryParam(ParamOfInvent paramOfInvent) {
        try {
            return DeviceServer.getIRFIDService().cmdGetInventParam(paramOfInvent);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int SetInventoryParam(ParamOfInvent paramOfInvent) {
        try {
            return DeviceServer.getIRFIDService().cmdSetInventParam(paramOfInvent);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int GetTxPower() {
        try {
            return DeviceServer.getIRFIDService().cmdGetTxPower();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int SetTxPower(int pwr) {
        try {
            return DeviceServer.getIRFIDService().cmdSetTxPower(pwr);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int GetMaxPower() {
        try {
            return DeviceServer.getIRFIDService().cmdGetMaxPower();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int GetTxCycle(TxCycle txCycle) {
        try {
            return DeviceServer.getIRFIDService().cmdGetTxCycle(txCycle);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int SetTxCycle(TxCycle txCycle) {
        try {
            return DeviceServer.getIRFIDService().cmdSetTxCycle(txCycle);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public String GetAllChannel() {
        try {
            return DeviceServer.getIRFIDService().cmdGetAllChannel();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public int GetChannelState(ChannelState channelState) {
        try {
            return DeviceServer.getIRFIDService().cmdGetChannelState(channelState);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int SetChannelState(ChannelState channelState) {
        try {
            return DeviceServer.getIRFIDService().cmdSetChannelState(channelState);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Deprecated
    public int GetLBTState() {
        try {
            return DeviceServer.getIRFIDService().cmdGetLBTState();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Deprecated
    public int SetLBTState(int lbt) {
        try {
            return DeviceServer.getIRFIDService().cmdSetLBTState(lbt);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int GetLinkProfile() {
        try {
            return DeviceServer.getIRFIDService().cmdGetLinkProfile();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int SetLinkProfile(int profile) {
        try {
            return DeviceServer.getIRFIDService().cmdSetLinkProfile(profile);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Deprecated
    public String GetOemInfo() {
        try {
            return DeviceServer.getIRFIDService().cmdGetOemInfo();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Deprecated
    public int GetLocalDataCnt() {
        return -8;
    }

    public int GetVibState() {
        try {
            return DeviceServer.getIRFIDService().cmdGetVibration();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int SetVibState(int on) {
        try {
            return DeviceServer.getIRFIDService().cmdSetVibration(on);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Deprecated
    public int SetAutomodeTimeout() {
        return -8;
    }

    public int SetTriggerMode(int mode) {
        try {
            return DeviceServer.getIRFIDService().cmdSetTriggerMode(mode);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int GetBatteryState() {
        try {
            return DeviceServer.getIRFIDService().cmdGetBatteryState();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int GetChargingState() {
        try {
            return DeviceServer.getIRFIDService().cmdGetChargingState();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int SingleSearch(int length, String tagId, int threshold, int step) {
        try {
            return DeviceServer.getIRFIDService().cmdSetSingleTagSearch(length, tagId, threshold, step);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int MultiSearch() {
        try {
            return DeviceServer.getIRFIDService().cmdSetMultiTagSearch();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int WildcardSearch(int length, String tagId) {
        try {
            return DeviceServer.getIRFIDService().cmdWildcardTagSearch(length, tagId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int GetSearchList() {
        try {
            return DeviceServer.getIRFIDService().cmdGetMultiTagList();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int GetSearchList_ext(int index) {
        try {
            return DeviceServer.getIRFIDService().cmdGetMultiTagList_ext(index);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int SetSearchList(int index, int length, String tagId) {
        try {
            return DeviceServer.getIRFIDService().cmdSetMultiTagList(index, length, tagId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int ClearSearchList(int index, int cnt) {
        try {
            return DeviceServer.getIRFIDService().cmdClearMultiTagList(index, cnt);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int ClearAllSearchList() {
        try {
            return DeviceServer.getIRFIDService().cmdClearAllMultiTagList();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int BlockWrite(int length, int membank, int offset, String writeData, String password, int blockMode) {
        try {
            return DeviceServer.getIRFIDService().cmdBlockWrite(length, membank, offset, writeData, password, blockMode);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int BlockErase(int length, int membank, int offset, String password, int blockMode) {
        try {
            return DeviceServer.getIRFIDService().cmdBlockErase(length, membank, offset, password, blockMode);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int GetTagFocus() {
        try {
            return DeviceServer.getIRFIDService().cmdGetTagFocus();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int SetTagFocus(int enable) {
        try {
            return DeviceServer.getIRFIDService().cmdSetTagFocus(enable);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int GetFastID() {
        try {
            return DeviceServer.getIRFIDService().cmdGetFastID();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int SetFastID(int enable) {
        try {
            return DeviceServer.getIRFIDService().cmdSetFastID(enable);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int GetDataFormat() {
        try {
            return DeviceServer.getIRFIDService().cmdGetDataFormat();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int SetDataFormat(int index) {
        try {
            return DeviceServer.getIRFIDService().cmdSetDataFormat(index);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int GetTxDataFormat() {
        try {
            return DeviceServer.getIRFIDService().cmdGetTxDataFormat();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int SetTxDataFormat(int index) {
        try {
            return DeviceServer.getIRFIDService().cmdSetTxDataFormat(index);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public String GetPrefix() {
        try {
            return DeviceServer.getIRFIDService().cmdGetPrefix();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public int SetPrefix(String prefix) {
        try {
            return DeviceServer.getIRFIDService().cmdSetPrefix(prefix);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public String GetSuffix() {
        try {
            return DeviceServer.getIRFIDService().cmdGetSuffix();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public int SetSuffix(String suffix) {
        try {
            return DeviceServer.getIRFIDService().cmdSetSuffix(suffix);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Deprecated
    public String GetSuffix1() {
        try {
            return DeviceServer.getIRFIDService().cmdGetSuffix1();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Deprecated
    public int SetSuffix1(String suffix1) {
        try {
            return DeviceServer.getIRFIDService().cmdSetSuffix1(suffix1);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Deprecated
    public String GetSuffix2() {
        try {
            return DeviceServer.getIRFIDService().cmdGetSuffix2();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Deprecated
    public int SetSuffix2(String suffix2) {
        try {
            return DeviceServer.getIRFIDService().cmdSetSuffix2(suffix2);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Deprecated
    public int GetLcdOff() {
        try {
            return DeviceServer.getIRFIDService().cmdGetLcdOff();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Deprecated
    public int SetLcdOff(int lcdOff) {
        try {
            return DeviceServer.getIRFIDService().cmdSetLcdOff(lcdOff);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int SetDataCase(int datacase) {
        try {
            return DeviceServer.getIRFIDService().cmdSetDataCase(datacase);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int GetOperationMode(ModeOfInvent moi) {
        try {
            return DeviceServer.getIRFIDService().cmdGetOpMode(moi);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int SetOperationMode(ModeOfInvent moi) {
        try {
            return DeviceServer.getIRFIDService().cmdSetOpMode(moi);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int GetResultType() {
        try {
            return DeviceServer.getIRFIDService().cmdGetResultType();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public void SetResultType(int resultType) {
        try {
            DeviceServer.getIRFIDService().cmdSetResultType(resultType);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int GetTerminatorType() {
        try {
            return DeviceServer.getIRFIDService().cmdGetTerminatorType();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public void SetTerminatorType(int teminatorType) {
        try {
            DeviceServer.getIRFIDService().cmdSetTerminatorType(teminatorType);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    public void SetBtDefault() {
        try {
            DeviceServer.getIRFIDService().cmdSetBTDefault();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int GetInventoryReportFormat_ext(ReportFormatOfInvent_ext reportFormatOfInvent_ext) {
        try {
            return DeviceServer.getIRFIDService().cmdGetInventoryReportFormat_ext(reportFormatOfInvent_ext);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int SetInventoryReportFormat_ext(ReportFormatOfInvent_ext reportFormatOfInvent_ext) {
        try {
            return DeviceServer.getIRFIDService().cmdSetInventoryReportFormat_ext(reportFormatOfInvent_ext);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int SetDeviceBaudrate(int baudrate) {
        try {
            return DeviceServer.getIRFIDService().cmdSetDeviceBaudrate(baudrate);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int GetAntSelect(AntSelect antSelect) {
        try {
            return DeviceServer.getIRFIDService().cmdGetAntSelect(antSelect);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int SetAntSelect(AntSelect antSelect) {
        try {
            return DeviceServer.getIRFIDService().cmdSetAntSelect(antSelect);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int GetAntPower(AntPower antPower) {
        try {
            return DeviceServer.getIRFIDService().cmdGetAntPower(antPower);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int SetAntPower(AntPower antPower) {
        try {
            return DeviceServer.getIRFIDService().cmdSetAntPower(antPower);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public String GetAvailableRegion() {
        try {
            return DeviceServer.getIRFIDService().cmdGetAvailableRegion();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public int SetRegion(String region) {
        try {
            return DeviceServer.getIRFIDService().cmdSetRegion(region);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public void GetCustomIntentConfig(CustomIntentConfig customIntentConfig) {
        try {
            DeviceServer.getIRFIDService().cmdGetCustomIntentConfig(customIntentConfig);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void SetCustomIntentConfig(CustomIntentConfig customIntentConfig) {
        try {
            DeviceServer.getIRFIDService().cmdSetCustomIntentConfig(customIntentConfig);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int UpdateFirmware(File fwFile) throws IOException, FileNotFoundException {
        int iRet = 0;
        Log.d((String)TAG, (String)("FW File : " + fwFile));
        try {
            if (fwFile == null || !fwFile.exists()) {
                Log.e((String)TAG, (String)"RFID Firmware update:: file does not exist");
                return -9;
            }
            String fileName = fwFile.getName();
            int fileSize = (int)fwFile.length();
            Log.d((String)TAG, (String)("File name : " + fileName));
            Log.d((String)TAG, (String)("File size : " + fileSize));
            FileInputStream fis = new FileInputStream(fwFile);
            byte[] fwData = new byte[fis.available()];
            fis.read(fwData, 0, fileSize);
            iRet = DeviceServer.getIRFIDService().updateFirmware(fwData, fileName, fileSize);
            fis.close();
            return iRet;
        }
        catch (Exception e) {
            e.printStackTrace();
            return iRet;
        }
    }
}

