/*
 * Decompiled with CFR 0.152.
 */
package device.sdk;

import android.media.AudioSystem;
import android.os.Binder;
import android.os.RemoteException;
import android.util.Log;
import device.common.IMsrResultCallback;
import device.common.MsrResult;
import device.common.MsrResultCallback;
import device.sdk.DeviceServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class MsrManager {
    private static final String TAG = MsrManager.class.getSimpleName();
    private static MSR_Module mMsrModule = MSR_Module.MMD1000;
    private static MsrManager mInstance = null;

    public static MsrManager getInstance() {
        if (mInstance == null) {
            mInstance = new MsrManager();
        }
        return mInstance;
    }

    public MsrManager() {
        try {
            if (DeviceServer.getIDeviceService().getMsrType() == 2) {
                mMsrModule = MSR_Module.PM1100;
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private byte[] SendCommand(byte msgType, byte RC, byte[] Data, byte function) {
        try {
            byte[] returnArray = new byte[9 + Data.length];
            int LLHL = Data.length + 2;
            returnArray[0] = 2;
            returnArray[1] = 79;
            returnArray[2] = function;
            returnArray[3] = (byte)LLHL;
            returnArray[4] = (byte)(LLHL >> 8);
            returnArray[5] = msgType;
            returnArray[6] = RC;
            for (int i = 0; i < Data.length; ++i) {
                returnArray[i + 7] = Data[i];
            }
            returnArray[returnArray.length - 2] = 3;
            byte LRC = returnArray[0];
            for (int i = 1; i < returnArray.length - 1; ++i) {
                LRC = (byte)(LRC ^ returnArray[i]);
            }
            returnArray[returnArray.length - 1] = LRC;
            return DeviceServer.getIMsrService().msr_Command(returnArray);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private byte[] SendCommand(byte msgType, byte RC, byte[] Data) {
        return this.SendCommand(msgType, RC, Data, (byte)48);
    }

    public boolean AtrOn(AtrOnMode atrMode) {
        byte[] data = atrMode == AtrOnMode.ISO ? new byte[]{0} : new byte[]{1};
        byte[] revArray = this.SendCommand((byte)-126, (byte)0, data);
        if (revArray != null) {
            try {
                if (revArray[5] == -126 && revArray[6] == 0) {
                    return true;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public void PowerDown() {
        this.SendCommand((byte)-124, (byte)0, new byte[0]);
    }

    public CardInsertState GetCardInserted() {
        byte[] revArray = this.SendCommand((byte)-128, (byte)0, new byte[0]);
        if (revArray != null) {
            try {
                if (revArray[5] == -128 && revArray[7] == 1) {
                    return CardInsertState.ICC_DETECT;
                }
            }
            catch (Exception e) {
                return CardInsertState.DETECT_FAIL;
            }
        }
        return CardInsertState.DETECT_FAIL;
    }

    public CardInsertState cardDetectPolling(int pollingTime) {
        byte[] data = new byte[]{(byte)(pollingTime >> 24), (byte)(pollingTime >> 16), (byte)(pollingTime >> 8), (byte)pollingTime};
        byte[] revArray = this.SendCommand((byte)-127, (byte)0, data);
        if (revArray != null) {
            try {
                if (revArray[5] == -127 && revArray[6] == 0) {
                    return CardInsertState.ICC_DETECT;
                }
                if (revArray[5] == -127 && revArray[6] == 1) {
                    return CardInsertState.DETECT_FAIL;
                }
                if (revArray[5] == -127 && revArray[6] == 2) {
                    return CardInsertState.USER_FAIL;
                }
            }
            catch (Exception e) {
                return CardInsertState.DETECT_FAIL;
            }
        }
        return CardInsertState.DETECT_FAIL;
    }

    public boolean setSystemTime(short year, short month, short dayOfWeek, short day, short hour, short minute, short second, short milliSeconds) {
        byte[] data = new byte[]{(byte)(year >> 8), (byte)year, (byte)(month >> 8), (byte)month, (byte)(dayOfWeek >> 8), (byte)dayOfWeek, (byte)(day >> 8), (byte)day, (byte)(hour >> 8), (byte)hour, (byte)(minute >> 8), (byte)minute, (byte)(second >> 8), (byte)second, (byte)(milliSeconds >> 8), (byte)milliSeconds};
        byte[] revArray = this.SendCommand((byte)3, (byte)0, data);
        if (revArray != null) {
            try {
                if (revArray[5] == 3 && revArray[6] == 1) {
                    return true;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public void paymentTransactionStart(byte firstbyte, int pay, short year, short month, short dayOfWeek, short day, short hour, short minute, short second, short milliSeconds) {
        byte[] data = new byte[]{firstbyte, (byte)(pay >> 24), (byte)(pay >> 16), (byte)(pay >> 8), (byte)pay, (byte)(year >> 8), (byte)year, (byte)(month >> 8), (byte)month, (byte)(dayOfWeek >> 8), (byte)dayOfWeek, (byte)(day >> 8), (byte)day, (byte)(hour >> 8), (byte)hour, (byte)(minute >> 8), (byte)minute, (byte)(second >> 8), (byte)second, (byte)(milliSeconds >> 8), (byte)milliSeconds};
        byte[] revArray = this.SendCommand((byte)-123, (byte)0, data);
        this.SecretDeviceMsrStartRead();
    }

    public byte[] SendAPDU(byte[] Data) {
        byte[] revArray = this.SendCommand((byte)-125, (byte)0, Data);
        if (revArray != null) {
            try {
                if (revArray[5] == -125 && revArray[6] == 0) {
                    byte[] ReusultArray = new byte[revArray.length - 9];
                    for (int i = 0; i < ReusultArray.length; ++i) {
                        ReusultArray[i] = revArray[7 + i];
                    }
                    return ReusultArray;
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public int DeviceMsrOpen(MsrResultCallback callback) {
        int ret = 0;
        MsrResultCallbackWrapper wrapper = new MsrResultCallbackWrapper(callback);
        try {
            if (DeviceServer.getIDeviceService().getMsrType() == 2) {
                AudioSystem.setMasterVolume((float)0.5f);
            }
            ret = DeviceServer.getIMsrService().msr_Open(wrapper);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public int DeviceMsrClose() {
        int ret = 0;
        try {
            if (DeviceServer.getIDeviceService().getMsrType() == 2) {
                AudioSystem.setMasterVolume((float)1.0f);
            }
            ret = DeviceServer.getIMsrService().msr_Close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public int DeviceMsrStartRead() {
        int ret = 0;
        try {
            if (mMsrModule == MSR_Module.PM1100) {
                this.SendCommand((byte)-123, (byte)0, new byte[0], (byte)49);
            }
            ret = DeviceServer.getIMsrService().msr_StartRead();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public int DeviceMsrStartRead(int mode) {
        int ret = 0;
        try {
            if (mMsrModule == MSR_Module.PM1100) {
                byte[] txmode = new byte[]{};
                if (mode == 11) {
                    txmode = new byte[]{17};
                } else if (mode == 13) {
                    txmode = new byte[]{19};
                }
                this.SendCommand((byte)-123, (byte)0, txmode, (byte)49);
            }
            ret = DeviceServer.getIMsrService().msr_StartRead();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    private int SecretDeviceMsrStartRead() {
        int ret = 0;
        try {
            ret = DeviceServer.getIMsrService().msr_StartRead();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public int DeviceMsrStopRead() {
        int ret = 0;
        try {
            ret = DeviceServer.getIMsrService().msr_StopRead();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public boolean updateFirmware(File fwFile) throws IOException, FileNotFoundException {
        try {
            if (DeviceServer.getIDeviceService().getMsrType() != 2) {
                Log.e((String)TAG, (String)"This is not supported");
                return false;
            }
            if (fwFile == null || !fwFile.exists()) {
                Log.e((String)TAG, (String)"MSR Firmware update:: file is not exists");
                return false;
            }
            if (!DeviceServer.getIMsrService().msr_startFirmwareUpdate()) {
                Log.e((String)TAG, (String)"MSR Firmware update:: start fail!");
                return false;
            }
            boolean percent = false;
            boolean transferred = false;
            long fileSize = fwFile.length();
            FileInputStream fis = new FileInputStream(fwFile);
            int i = 0;
            byte[] buffer = new byte[4096];
            while ((i = fis.read(buffer, 0, 4096)) >= 0) {
                boolean result = DeviceServer.getIMsrService().msr_sendFirmwareData(buffer, i);
                if (result) continue;
                Log.e((String)TAG, (String)"MSR Firmware update:: send data fail!");
                break;
            }
            fis.close();
            if (!DeviceServer.getIMsrService().msr_endFirmwareUpdate()) {
                Log.e((String)TAG, (String)"MSR Firmware update:: end fail!");
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public String getFirmwareVersion() {
        String firmware = "";
        try {
            firmware = DeviceServer.getIMsrService().getFirmwareVersion();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return firmware;
    }

    public MsrResult DeviceMsrGetData(int read_track) {
        MsrResult result = null;
        try {
            result = DeviceServer.getIMsrService().msr_GetData(read_track);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean setPublicKey(String pemKey) {
        try {
            return DeviceServer.getIMsrService().setPublicKey(pemKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setPublicKey(File pemFile) throws IOException {
        int MAX_LENGTH = 262144;
        FileInputStream fis = new FileInputStream(pemFile);
        int length = fis.available();
        String pemKey = null;
        if (length <= 262144) {
            byte[] bytes = new byte[length];
            fis.read(bytes);
            pemKey = new String(bytes, "UTF-8");
            if (pemKey != null && !pemKey.isEmpty()) {
                pemKey = pemKey.replaceAll("(-+BEGIN PUBLIC KEY-+\\r?\\n|-+END PUBLIC KEY-+\\r?\\n?)", "");
            }
        }
        fis.close();
        if (pemKey != null && !pemKey.isEmpty()) {
            return this.setPublicKey(pemKey);
        }
        return false;
    }

    public boolean setUsedEncryption(byte[] ksn, byte[] initKey) {
        try {
            if (DeviceServer.getIDeviceService().getMsrType() == 1) {
                return DeviceServer.getIMsrService().msr_UseEncryption(ksn, initKey);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public byte[] getEncryptionData() {
        try {
            if (DeviceServer.getIDeviceService().getMsrType() == 1) {
                return DeviceServer.getIMsrService().msr_getEncryptionData();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public int rdiIsEnabled() {
        try {
            return DeviceServer.getIMsrService().msr_rdi_is_enabled();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int rdiSetEnable(int enable) {
        try {
            return DeviceServer.getIMsrService().msr_rdi_enable(enable);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int rdiWrite(byte[] byteArrays, int lenght) {
        try {
            return DeviceServer.getIMsrService().msr_rdi_write(byteArrays, lenght);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int rdiRead(byte[] data, int length) {
        try {
            return DeviceServer.getIMsrService().msr_rdi_read(data, length);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int rdiNelem() {
        try {
            return DeviceServer.getIMsrService().msr_rdi_nelem();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int rdiClear() {
        try {
            return DeviceServer.getIMsrService().msr_rdi_clear();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int rdiOpenK() {
        if (!this.checkSystemUid()) {
            return -3;
        }
        try {
            return DeviceServer.getIMsrService().msr_rdi_open();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int rdiOpen() {
        try {
            return DeviceServer.getIMsrService().msr_rdi_open();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int rdiClose() {
        try {
            return DeviceServer.getIMsrService().msr_rdi_close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean checkSystemUid() {
        int uid = Binder.getCallingUid();
        boolean systemUidFlag = false;
        if (uid != 1000) {
            systemUidFlag = false;
            throw new SecurityException(" SecurityException ");
        }
        systemUidFlag = true;
        return systemUidFlag;
    }

    public int setTxMode(int txmode, int allTerror, int ksnRes) {
        try {
            return DeviceServer.getIMsrService().setTxMode(txmode, allTerror, ksnRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int getTxMode() {
        try {
            return DeviceServer.getIMsrService().getTxMode();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    private static class MsrResultCallbackWrapper
    extends IMsrResultCallback.Stub {
        private MsrResultCallback mCallback;

        public MsrResultCallbackWrapper(MsrResultCallback callback) {
            this.mCallback = callback;
        }

        @Override
        public void onResult(int cmd, int status) {
            Log.v((String)TAG, (String)"Msrmanager  onResult () ");
        }

        @Override
        public void onResultData(int cmd, int status, byte[] data, byte[] track1Buf, byte[] track2Buf, byte[] track3Buf) {
            this.mCallback.onResult(cmd, status);
            this.mCallback.onResultData(cmd, status, data);
            this.mCallback.onResultTrackData(cmd, status, track1Buf, track2Buf, track3Buf);
        }
    }

    public static enum CardInsertState {
        ICC_DETECT,
        DETECT_FAIL,
        USER_FAIL;

    }

    public static enum AtrOnMode {
        ISO,
        EMV;

    }

    private static enum MSR_Module {
        MMD1000,
        PM1100;

    }
}

