/*
 * Decompiled with CFR 0.152.
 */
package device.sdk;

import android.os.RemoteException;
import device.sdk.DeviceServer;

public class SamManager {
    private static final String TAG = SamManager.class.getSimpleName();
    private static SamManager mInstance = null;

    public static SamManager getInstance() {
        if (mInstance == null) {
            mInstance = new SamManager();
        }
        return mInstance;
    }

    public void setEnabled(boolean enabled) {
        try {
            DeviceServer.getISamService().samSetPowerOn(enabled);
            if (enabled) {
                DeviceServer.getISamService().samOpenPort();
            } else {
                DeviceServer.getISamService().samClosePort();
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public boolean isEnabled() {
        boolean ret = false;
        try {
            ret = DeviceServer.getISamService().samGetPowerStatus();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public int sendAtrCommand() {
        int ret = 0;
        try {
            ret = DeviceServer.getISamService().sam_CommandAtr();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public int GetAtrResponse(byte[] req_buf) {
        int ret = 0;
        try {
            ret = DeviceServer.getISamService().sam_get_atr_response(req_buf);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public int sendApduCommand(byte[] apdu, int apduLength, byte[] response, int responseLength) {
        int ret = 0;
        try {
            ret = DeviceServer.getISamService().sam_CommandApdu(apdu, apduLength, response, responseLength);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public int sendPowerDownCommand() {
        int ret = 0;
        try {
            ret = DeviceServer.getISamService().sam_CommandPowerdown();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public int sendDirectCommand(byte cmd, byte[] pdata, int datalen, byte[] pRESP, int pRespLen) {
        int ret = 0;
        try {
            ret = DeviceServer.getISamService().sam_direct_command(cmd, pdata, datalen, pRESP, pRespLen);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public int getTimeoutDelay() {
        int ret = 0;
        try {
            ret = DeviceServer.getISamService().get_timeout_delay();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public void setTimeoutDelay(int delay) {
        try {
            DeviceServer.getISamService().set_timeout_delay(delay);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public int set_sam_slot(int slot) {
        int ret = 0;
        try {
            ret = DeviceServer.getISamService().set_sam_slot(slot);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public int get_sam_slot() {
        int ret = 0;
        try {
            ret = DeviceServer.getISamService().get_sam_slot();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return ret;
    }

    @Deprecated
    public int DeviceSamSetPowerOn(boolean on) {
        int ret = 0;
        try {
            ret = DeviceServer.getISamService().samSetPowerOn(on);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return ret;
    }

    @Deprecated
    public boolean DeviceSamGetPowerStatus() {
        boolean ret = false;
        try {
            ret = DeviceServer.getISamService().samGetPowerStatus();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return ret;
    }

    @Deprecated
    public int DeviceSamOpenFort() {
        int ret = 0;
        try {
            ret = DeviceServer.getISamService().samOpenPort();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return ret;
    }

    @Deprecated
    public int DeviceSamCloseFort() {
        int ret = 0;
        try {
            ret = DeviceServer.getISamService().samClosePort();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return ret;
    }

    @Deprecated
    public int DeviceSamCommandAtr() {
        int ret = 0;
        try {
            ret = DeviceServer.getISamService().sam_CommandAtr();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return ret;
    }

    @Deprecated
    public int DeviceSam_CommandApdu(byte[] pAPDU, int apduLen, byte[] pRESP, int respLen) {
        int ret = 0;
        try {
            ret = DeviceServer.getISamService().sam_CommandApdu(pAPDU, apduLen, pRESP, respLen);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return ret;
    }

    @Deprecated
    public int DeviceSam_CommandPowerdown() {
        int ret = 0;
        try {
            ret = DeviceServer.getISamService().sam_CommandPowerdown();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return ret;
    }
}

