/*
 * Decompiled with CFR 0.152.
 */
package device.common;

import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import device.common.ISerialService;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.Arrays;

public class SerialPort {
    private static final String TAG = SerialPort.class.getSimpleName();
    private ISerialService mSerialService = ISerialService.Stub.asInterface(ServiceManager.getService((String)"SerialService"));
    private String mPath;
    private int mBaudrate;
    private int mFlags;
    private boolean mHwFlow;
    private ParcelFileDescriptor mParcelFd;

    public SerialPort(File device, int baudrate, int flags) throws IOException {
        this(device.getAbsolutePath(), baudrate, flags);
    }

    public SerialPort(String path, int baudrate, int flags) throws IOException {
        this(path, baudrate, flags, false);
    }

    public SerialPort(File device, int baudrate, int flags, boolean hwflow) throws IOException {
        this(device.getAbsolutePath(), baudrate, flags, hwflow);
    }

    public SerialPort(String path, int baudrate, int flags, boolean hwflow) throws IOException {
        this.mPath = path;
        this.mBaudrate = baudrate;
        this.mFlags = flags;
        this.mHwFlow = hwflow;
        try {
            boolean result = this.mSerialService.open(path, baudrate, flags, hwflow);
            if (!result) {
                Log.e((String)TAG, (String)"Open fail");
                throw new IOException();
            }
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"Open fail :: RemoteException");
            e.printStackTrace();
            throw new IOException();
        }
        if (this.mParcelFd != null) {
            try {
                this.mParcelFd.close();
                this.mParcelFd = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void closePort() {
        try {
            this.mSerialService.close(this.mPath);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        if (this.mParcelFd != null) {
            try {
                this.mParcelFd.close();
                this.mParcelFd = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public FileDescriptor getFileDescriptor() {
        if (this.mParcelFd == null) {
            try {
                this.mParcelFd = this.mSerialService.getParcelFileDescriptor(this.mPath);
                if (this.mParcelFd != null) {
                    Log.i((String)TAG, (String)"mParcelFd is not null");
                    return this.mParcelFd.getFileDescriptor();
                }
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        } else {
            return this.mParcelFd.getFileDescriptor();
        }
        Log.i((String)TAG, (String)"mParcelFd is null");
        return null;
    }

    public int read(byte[] buffer) throws IOException {
        if (buffer != null && buffer.length > 0) {
            try {
                return this.mSerialService.read(this.mPath, buffer, buffer.length);
            }
            catch (RemoteException e) {
                e.printStackTrace();
                return -1;
            }
        }
        throw new IOException("Invalid byte array");
    }

    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    public void write(byte[] buffer, int offset, int length) throws IOException {
        Arrays.checkOffsetAndCount((int)buffer.length, (int)offset, (int)length);
        try {
            if (!this.mSerialService.write(this.mPath, buffer, offset, length)) {
                throw new IOException("Failed the writing to this serial port : " + this.mPath);
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void sendBreak() {
        try {
            this.mSerialService.sendBreak(this.mPath);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }
}

