/*
 * Decompiled with CFR 0.152.
 */
package device.common.rfid;

import android.os.Handler;
import device.common.rfid.IRFIDCallback;
import device.common.rfid.RecvPacket;

public abstract class RFIDCallback {
    private final Object mLock = new Object();
    private Transport mTransport;
    Handler mHandler;

    public RFIDCallback() {
    }

    public void setHandler(Handler handler) {
        this.mHandler = handler;
    }

    public RFIDCallback(Handler handler) {
        this.mHandler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRFIDCallback getRFIDCallback() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mTransport == null) {
                this.mTransport = new Transport(this);
            }
            return this.mTransport;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRFIDCallback RFIDCallback() {
        Object object = this.mLock;
        synchronized (object) {
            Transport oldTransport = this.mTransport;
            if (oldTransport != null) {
                oldTransport.releaseRFIDCallback();
                this.mTransport = null;
            }
            return oldTransport;
        }
    }

    public boolean deliverSelfNotification() {
        return false;
    }

    public void onNotifyDataWriteFail() {
    }

    public void onNotifyReceivedPacket(RecvPacket recvPacket) {
    }

    public void onNotifyChangedState(int state) {
    }

    public final void dispatchonNotifyDataWriteFail() {
        if (this.mHandler == null) {
            this.onNotifyDataWriteFail();
        } else {
            this.mHandler.post((Runnable)new NotificationRunnable_onNotifyDataWriteFail());
        }
    }

    public final void dispatchonNotifyReceivedPacket(RecvPacket recvPacket) {
        if (this.mHandler == null) {
            this.onNotifyReceivedPacket(recvPacket);
        } else {
            this.mHandler.post((Runnable)new NotificationRunnable_onNotifyReceivedPacket(recvPacket));
        }
    }

    public final void dispatchonNotifyChangedState(int state) {
        if (this.mHandler == null) {
            this.onNotifyChangedState(state);
        } else {
            this.mHandler.post((Runnable)new NotificationRunnable_onNotifyChangedState(state));
        }
    }

    private static final class Transport
    extends IRFIDCallback.Stub {
        private RFIDCallback mRFIDCallback;

        public Transport(RFIDCallback RFIDCallback2) {
            this.mRFIDCallback = RFIDCallback2;
        }

        @Override
        public void onNotifyDataWriteFail() {
            RFIDCallback rfidCallback = this.mRFIDCallback;
            if (rfidCallback != null) {
                rfidCallback.dispatchonNotifyDataWriteFail();
            }
        }

        @Override
        public void onNotifyReceivedPacket(RecvPacket recvPacket) {
            RFIDCallback rfidCallback = this.mRFIDCallback;
            if (rfidCallback != null) {
                rfidCallback.dispatchonNotifyReceivedPacket(recvPacket);
            }
        }

        @Override
        public void onNotifyChangedState(int state) {
            RFIDCallback rfidCallback = this.mRFIDCallback;
            if (rfidCallback != null) {
                rfidCallback.dispatchonNotifyChangedState(state);
            }
        }

        public void releaseRFIDCallback() {
            this.mRFIDCallback = null;
        }
    }

    private final class NotificationRunnable_onNotifyChangedState
    implements Runnable {
        private final int mState;

        public NotificationRunnable_onNotifyChangedState(int state) {
            this.mState = state;
        }

        @Override
        public void run() {
            RFIDCallback.this.onNotifyChangedState(this.mState);
        }
    }

    private final class NotificationRunnable_onNotifyReceivedPacket
    implements Runnable {
        private final RecvPacket mPacket;

        public NotificationRunnable_onNotifyReceivedPacket(RecvPacket recvPacket) {
            this.mPacket = recvPacket;
        }

        @Override
        public void run() {
            RFIDCallback.this.onNotifyReceivedPacket(this.mPacket);
        }
    }

    private final class NotificationRunnable_onNotifyDataWriteFail
    implements Runnable {
        @Override
        public void run() {
            RFIDCallback.this.onNotifyDataWriteFail();
        }
    }
}

