/*
 * Decompiled with CFR 0.152.
 */
package device.common;

import java.util.TreeMap;

public enum KeyCode {
    Key0(7, 48),
    Key1(8, 49),
    KeyExclamationPoint(8, 33, true),
    Key2(9, 50),
    Key3(10, 51),
    Key4(11, 52),
    Key5(12, 53),
    Key6(13, 54),
    Key7(14, 55),
    Key8(15, 56),
    Key9(16, 57),
    KeyA(29, 65, true),
    KeyALower(29, 97),
    KeyApostrophe(75, 39),
    KeyAt(77, 64),
    KeyB(30, 66, true),
    KeyBLower(30, 98),
    KeyBackspace(67, 8),
    KeyBackHardKey(4, 0),
    KeyBackSlash(73, 92),
    KeyVerticalBar(73, 124, true),
    KeyC(31, 67, true),
    KeyCLower(31, 99),
    KeyComma(55, 44),
    KeyD(32, 68, true),
    KeyDLower(32, 100),
    KeyE(33, 69, true),
    KeyELower(33, 101),
    KeyEnter(66, 13),
    KeyEquals(70, 61),
    KeyF(34, 70, true),
    KeyFLower(34, 102),
    KeyF1(4143, 0),
    KeyF2(4144, 0),
    KeyF3(4145, 0),
    KeyF4(4146, 0),
    KeyF5(4147, 0),
    KeyF6(4148, 0),
    KeyF7(4149, 0),
    KeyF8(4150, 0),
    KeyF9(4151, 0),
    KeyF10(4152, 0),
    KeyF11(4153, 0),
    KeyF12(4154, 0),
    KeyG(35, 71, true),
    KeyGLower(35, 103),
    KeyGrave(68, 96),
    KeyWiggle(68, 126, true),
    KeyH(36, 72, true),
    KeyHLower(36, 104),
    KeyI(37, 73, true),
    KeyILower(37, 105),
    KeyJ(38, 74, true),
    KeyJLower(38, 106),
    KeyK(39, 75, true),
    KeyKLower(39, 107),
    KeyL(40, 76, true),
    KeyLLower(40, 108),
    KeyLeftBracket(71, 91),
    KeyLeftBrace(71, 123, true),
    KeyM(41, 77, true),
    KeyMLower(41, 109),
    KeyMenuHardKey(82, 0),
    KeyMinus(69, 45),
    KeyUnderscore(69, 95, true),
    KeyN(42, 78, true),
    KeyNLower(42, 110),
    KeyO(43, 79, true),
    KeyOLower(43, 111),
    KeyP(44, 80, true),
    KeyPLower(44, 112),
    KeyPeriod(56, 46),
    KeyPlus(81, 43),
    KeyPound(18, 35),
    KeyQ(45, 81, true),
    KeyQLower(45, 113),
    KeyR(46, 82, true),
    KeyRLower(46, 114),
    KeyRightBracket(72, 93),
    KeyRightBrace(72, 125, true),
    KeyS(47, 83, true),
    KeySLower(47, 115),
    KeySemicolon(74, 59),
    KeyColon(74, 58, true),
    KeySlash(76, 47),
    KeyQuestionMark(76, 63, true),
    KeySpace(62, 32),
    KeyStar(17, 42),
    KeyT(48, 84, true),
    KeyTLower(48, 116),
    KeyTab(61, 9),
    KeyU(49, 85, true),
    KeyULower(49, 117),
    KeyV(50, 86, true),
    KeyVLower(50, 118),
    KeyW(51, 87, true),
    KeyWLower(51, 119),
    KeyX(52, 88, true),
    KeyXLower(52, 120),
    KeyY(53, 89, true),
    KeyYLower(53, 121),
    KeyZ(54, 90, true),
    KeyZLower(54, 122),
    KeyUnknown(0, 0);

    private static final TreeMap<Integer, KeyCode> androidKeyCodeMap;
    private static final TreeMap<Integer, KeyCode> unicodeCharMap;
    private final int androidKeyCode;
    private final int unicodeChar;
    private final boolean hasShift;

    private KeyCode(int androidKey, int unicode, boolean shift) {
        this.androidKeyCode = androidKey;
        this.unicodeChar = unicode;
        this.hasShift = shift;
    }

    private KeyCode(int androidKey, int unicode) {
        this(androidKey, unicode, false);
    }

    public int getAndroidKeyCode() {
        return this.androidKeyCode;
    }

    public int getUnicodeChar() {
        return this.unicodeChar;
    }

    public boolean hasShiftKey() {
        return this.hasShift;
    }

    public boolean isUpperCase() {
        return this.unicodeChar >= 65 && this.unicodeChar <= 90;
    }

    public boolean isLowerCase() {
        return this.unicodeChar >= 97 && this.unicodeChar <= 122;
    }

    public boolean isAlpha() {
        return this.isUpperCase() || this.isLowerCase();
    }

    public boolean isNumber() {
        return this.unicodeChar >= 48 && this.unicodeChar <= 57;
    }

    public KeyCode toUpper() {
        if (!this.isLowerCase()) {
            return this;
        }
        return KeyCode.findByUnicodeChar(this.unicodeChar - 32);
    }

    public KeyCode toLower() {
        if (!this.isUpperCase()) {
            return this;
        }
        return KeyCode.findByUnicodeChar(this.unicodeChar + 32);
    }

    public static KeyCode findByAndroidKeyCode(int androidKeyCode, boolean hasShift) {
        if (androidKeyCodeMap.containsKey(androidKeyCode)) {
            KeyCode key = androidKeyCodeMap.get(androidKeyCode);
            if (hasShift) {
                return key.toUpper();
            }
            return key;
        }
        return KeyUnknown;
    }

    public static KeyCode findByUnicodeChar(int unicodeChar) {
        if (unicodeCharMap.containsKey(unicodeChar)) {
            return unicodeCharMap.get(unicodeChar);
        }
        return KeyUnknown;
    }

    static {
        androidKeyCodeMap = new TreeMap();
        unicodeCharMap = new TreeMap();
        for (KeyCode key : KeyCode.values()) {
            androidKeyCodeMap.put(key.androidKeyCode, key);
            if (key.unicodeChar <= 0) continue;
            unicodeCharMap.put(key.unicodeChar, key);
        }
        unicodeCharMap.put(0, KeyUnknown);
    }
}

