/*
 * Decompiled with CFR 0.152.
 */
package device.sdk;

import android.os.RemoteException;
import device.common.HiJackData;
import device.common.HijackingKeys;
import device.common.IHiJackService;
import device.sdk.DeviceServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class KeyManager {
    public static final int KEYCODE_SOFTKEY_LOCK = 288;
    private static final String TAG = KeyManager.class.getSimpleName();
    private static IHiJackService sHiJackService;

    public KeyManager() {
        sHiJackService = DeviceServer.getIHiJackService();
    }

    private native int checkKCMapFile(String var1);

    private static byte[] getBytesFromFile(String path) {
        try {
            File file = new File(path);
            FileInputStream is = new FileInputStream(file);
            long length = file.length();
            byte[] bytes = new byte[(int)length];
            if (length > Integer.MAX_VALUE) {
                bytes = null;
            } else {
                int numRead = 0;
                for (int offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
                }
            }
            ((InputStream)is).close();
            return bytes;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getCurrentKCMapFile() throws RemoteException {
        return sHiJackService.getCurrentKCMapFile();
    }

    public int changeKCMapFile(String path) throws RemoteException {
        int result = this.checkKCMapFile(path);
        if (result == 0) {
            result = sHiJackService.changeKCMapFile(path, KeyManager.getBytesFromFile(path));
        }
        return result;
    }

    public boolean removeKCMapFile() throws RemoteException {
        return sHiJackService.removeKCMapFile();
    }

    public HijackingKeys[] getHijackingKeys() throws RemoteException {
        return sHiJackService.getHijackingKeys();
    }

    public int setAllHiJackData(HiJackData[] dataList) throws RemoteException {
        return sHiJackService.setAllHiJackData(dataList);
    }

    public HiJackData[] getAllHiJackData() throws RemoteException {
        return sHiJackService.getAllHiJackData();
    }

    public int getRestrictInputMode() throws RemoteException {
        return sHiJackService.getRestrictInputMode();
    }

    public void setRestrictInputMode(int Mode) throws RemoteException {
        sHiJackService.setRestrictInputMode(Mode);
    }

    static {
        System.loadLibrary("device_sdk_keymanager");
    }
}

