/*
 * Decompiled with CFR 0.152.
 */
package com.atid.lib.types;

import com.atid.lib.types.IEnumType;
import java.util.Locale;

public enum ResultCode implements IEnumType
{
    NoError(0, "No Error"),
    OtherError(1, "Other Error"),
    Undefined(2, "Undefined"),
    MemoryOverrun(3, "Memory Overrun"),
    MemoryLocked(4, "Memory Locked"),
    InsufficientPower(11, "Insufficient Power"),
    NonSpecificError(15, "Non-Specific Error"),
    InvalidModule(16384, "Invalid Module Object"),
    NotSupported(16385, "Not Supported"),
    InOperation(16386, "In Operation"),
    OutOfRange(16387, "Out of Range"),
    NotSupportedBeep(16400, "Not Supported Beep Function"),
    NotSupportedVibrate(16401, "Not Supported Vibration Function"),
    NotSupportedLight(16402, "Not Supported Light Function"),
    NotSupportedNormalMode(16403, "Not Supported Normal Mode"),
    NotSupportedBarcodeMode(16404, "Not Supported Barcode Mode"),
    NotSupportedKeyMode(16405, "Not Supported Key Mode"),
    InvalidResponse(20480, "Invalid Response"),
    InvalidResponseIndex(20481, "Invalid Response Index"),
    InvalidParameter(20482, "Invalid Parameter"),
    InvalidResponseData(20483, "Invalid Response Data"),
    InvalidResponseExParam(20484, "Invalid Response Extend Parameter"),
    FailedParameter(20485, "Failed to process Parameter"),
    NotFoundParameter(20486, "Not Found Parameter"),
    SendFail(24576, "Send Failed"),
    ReceiveFail(24577, "Receive Failed"),
    SendTimeout(24578, "Send Timeout"),
    ReceiveTimeout(24579, "Receive Timeout"),
    InvalidSendPacket(24580, "Invalid Send Packet"),
    InvalidReceivePacket(24581, "Invalid Receive Packet"),
    ConnectFail(24582, "Connection Failed"),
    Timeout(28672, "Timeout"),
    UnknownError(32766, "Unknown Error"),
    SystemError(Short.MAX_VALUE, "System Error"),
    HandleMismatch(61441, "Handle mismatch"),
    CRCError(61442, "CRC error on tag response"),
    NoTagReply(61443, "No tag reply"),
    InvalidPassword(61444, "Invalid password"),
    ZeroKillPassword(61445, "Zero kill password"),
    TagLost(61446, "Tag lost"),
    CommandFormatError(61447, "Command format error"),
    ReadCountInvalid(61448, "Read count invalid"),
    OutOfRetries(61449, "Out of retries"),
    ParamError(65531, "Parameter error"),
    BusyDevice(65532, "Busy Device"),
    InvalidCommand(65533, "Invalid command"),
    LowBattery(65534, "Low battery"),
    OperationFailed(65535, "Operation failed");

    private final int mCode;
    private final String mMessage;
    private static final ResultCode[] mItems;

    static {
        mItems = ResultCode.values();
    }

    private ResultCode(int code, String msg) {
        this.mCode = code;
        this.mMessage = msg;
    }

    @Override
    public int getCode() {
        return this.mCode;
    }

    public String getMessage() {
        return this.mMessage;
    }

    @Override
    public String toString() {
        return String.format(Locale.US, "%04X:%s", this.mCode, this.mMessage);
    }

    public static ResultCode valueOf(String string) {
        return Enum.valueOf(ResultCode.class, string);
    }
}

