/*
 * Decompiled with CFR 0.152.
 */
package com.atid.lib.module.rfid.uhf.atm;

import android.util.Pair;
import com.atid.lib.device.IReader;
import com.atid.lib.diagnostics.ATException;
import com.atid.lib.module.rfid.uhf.ATRfidUhf;
import com.atid.lib.module.rfid.uhf.module.ATModuleRfidUhf;
import com.atid.lib.module.rfid.uhf.module.atm.ATModuleRfidUhfATM;
import com.atid.lib.module.rfid.uhf.params.EpcMaskParam;
import com.atid.lib.module.rfid.uhf.params.FreqTableList;
import com.atid.lib.module.rfid.uhf.params.Lock6bParam;
import com.atid.lib.module.rfid.uhf.params.Lock6cParam;
import com.atid.lib.module.rfid.uhf.params.Mask6cPattern;
import com.atid.lib.module.rfid.uhf.params.PermaLock6cParam;
import com.atid.lib.module.rfid.uhf.params.PowerRange;
import com.atid.lib.module.rfid.uhf.params.SelectMask6cParam;
import com.atid.lib.module.rfid.uhf.types.AlgorithmType;
import com.atid.lib.module.rfid.uhf.types.BankType;
import com.atid.lib.module.rfid.uhf.types.GlobalBandType;
import com.atid.lib.module.rfid.uhf.types.Mask6cAction;
import com.atid.lib.module.rfid.uhf.types.Mask6cTarget;
import com.atid.lib.module.rfid.uhf.types.SelectFlag;
import com.atid.lib.module.rfid.uhf.types.SessionFlag;
import com.atid.lib.module.rfid.uhf.types.SessionTarget;
import com.atid.lib.types.ActionState;
import com.atid.lib.types.ActionType;
import com.atid.lib.types.ModuleRfidUhfType;
import com.atid.lib.types.ResultCode;
import com.atid.lib.util.ActionUtil;
import com.atid.lib.util.StringUtil;
import com.atid.lib.util.diagnotics.ATLog;
import java.util.ArrayList;

public class ATRfidUhfATM
extends ATRfidUhf
implements ATModuleRfidUhf.IModuleRfidUhfEventListener {
    private static int REGION_FCC_MAX_TX_ON_OFF_CYCLE = 400;
    private static int REGION_FCC_MAX_TX_ON_TIME = 400;
    private static int REGION_FCC_MIN_TX_ON_TIME = 50;
    private static int REGION_FCC_MAX_TX_OFF_TIME = 400;
    private static int REGION_FCC_MIN_TX_OFF_TIME = 0;
    private static int REGION_ETSI_MAX_TX_ON_TIME = 4000;
    private static int REGION_ETSI_MIN_TX_ON_TIME = 50;
    private static int REGION_ETSI_MAX_TX_OFF_TIME = 4000;
    private static int REGION_ETSI_MIN_TX_OFF_TIME = 100;
    private static int REGION_JAPAN_MAX_TX_ON_TIME = 4000;
    private static int REGION_JAPAN_MIN_TX_ON_TIME = 50;
    private static int REGION_JAPAN_MAX_TX_OFF_TIME = 4000;
    private static int REGION_JAPAN_MIN_TX_OFF_TIME = 50;
    private volatile PowerRange mPowerRange;
    private volatile String mVersion;
    private volatile boolean mIsContinuousMode;
    private volatile GlobalBandType mGlobalBand;
    private volatile int mTxOnTime;
    private volatile int mTxOffTime;

    public ATRfidUhfATM(ModuleRfidUhfType type, IReader reader) {
        super(reader);
        this.TAG = ATRfidUhfATM.class.getSimpleName();
        this.mModule = new ATModuleRfidUhfATM(reader, type, reader.getProtocol(), this);
        this.mPowerRange = null;
        this.mVersion = "";
        this.mIsContinuousMode = true;
        this.mGlobalBand = GlobalBandType.Korea;
        this.mTxOnTime = 0;
        this.mTxOffTime = 0;
    }

    @Override
    public boolean initMoudle() {
        try {
            Pair<Integer, Integer> res = ((ATModuleRfidUhfATM)this.mModule).getPowerGainRange();
            this.mPowerRange = new PowerRange((Integer)res.first, (Integer)res.second);
        }
        catch (ATException e) {
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. initReader() - Failed to get power range", (Object[])new Object[0]);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultCode inventory6c() {
        try {
            this.assertAction();
        }
        catch (ATException e) {
            ATLog.e((String)this.TAG, (String)"ERROR. inventory6c() - Failed to assert action");
            return this.mReader.getLastError();
        }
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            this.mReader.setAction(ActionState.Inventory6c);
            this.mReader.setLastError(((ATModuleRfidUhfATM)this.mModule).inventory());
            if (this.mReader.getLastError() != ResultCode.NoError) {
                ATLog.e((String)this.TAG, (String)"ERROR. inventory6c() - Failed to start inventory");
                this.mReader.checkError();
                return this.mReader.getLastError();
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. inventory6c()");
        return ResultCode.NoError;
    }

    @Override
    public ResultCode inventory6b() {
        ATLog.e((String)this.TAG, (String)"ERROR. inventory6b() - Failed to not supported method");
        return ResultCode.NotSupported;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultCode readMemory6c(BankType bank, int offset, int length, String password) {
        try {
            this.assertAction();
        }
        catch (ATException e) {
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. readMemory6c(%s, %d, %d, [%s]) - Failed to assert action", (Object[])new Object[]{bank, offset, length, password});
            return this.mReader.getLastError();
        }
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                this.setAction(ActionState.ReadMemory6c, password);
            }
            catch (ATException e) {
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. readMemory6c(%s, %d, %d, [%s]) - Failed to set action", (Object[])new Object[]{bank, offset, length, password});
                return this.mReader.getLastError();
            }
            this.mReader.setLastError(((ATModuleRfidUhfATM)this.mModule).readMemory(bank.getCode(), offset, length));
            if (this.mReader.getLastError() != ResultCode.NoError) {
                ATLog.e((String)this.TAG, (String)"ERROR. readMemory6c(%s, %d, %d, [%s]) - Failed to start read memory", (Object[])new Object[]{bank, offset, length, password});
                return this.checkError();
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. readMemory6c(%s, %d, %d, [%s])", (Object[])new Object[]{bank, offset, length, password});
        return ResultCode.NoError;
    }

    @Override
    public ResultCode readMemory6b(int offset, int length, String password) {
        password = StringUtil.getNull((String)password);
        ATLog.e((String)this.TAG, (String)"ERROR. readMemory6b() - Failed to not supported method");
        return ResultCode.NotSupported;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultCode writeMemory6c(BankType bank, int offset, String data, String password) {
        try {
            this.assertAction();
        }
        catch (ATException e) {
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. writeMemory6c(%s, %d, [%s], [%s]) - Failed to assert action", (Object[])new Object[]{bank, offset, data, password});
            return this.mReader.getLastError();
        }
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                this.setAction(ActionState.WriteMemory6c, password);
            }
            catch (ATException e) {
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. writeMemory6c(%s, %d, [%s], [%s]) - Failed to set action", (Object[])new Object[]{bank, offset, data, password});
                return this.mReader.getLastError();
            }
            this.mReader.setLastError(((ATModuleRfidUhfATM)this.mModule).writeMemory(bank.getCode(), offset, data));
            if (this.mReader.getLastError() != ResultCode.NoError) {
                ATLog.e((String)this.TAG, (String)"ERROR. writeMemory6c(%s, %d, [%s], [%s]) - Failed to start write memory", (Object[])new Object[]{bank, offset, data, password});
                return this.checkError();
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. writeMemory6c(%s, %d, [%s], [%s])", (Object[])new Object[]{bank, offset, data, password});
        return ResultCode.NoError;
    }

    @Override
    public ResultCode writememory6b(int offet, String data, String password) {
        password = StringUtil.getNull((String)password);
        ATLog.e((String)this.TAG, (String)"ERROR. writememory6b() - Failed to not supported method");
        return ResultCode.NotSupported;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultCode lock6c(Lock6cParam param, String password) {
        int lock = param.getLock();
        int unlock = param.getUnlock();
        int mask = lock | unlock;
        try {
            this.assertAction();
        }
        catch (ATException e) {
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. lock6c([%s], [%s]) - Failed to assert action", (Object[])new Object[]{param, password});
            return this.mReader.getLastError();
        }
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                this.setAction(ActionState.Lock, password);
            }
            catch (ATException e) {
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. lock6c([%s], [%s]) - Failed to set action", (Object[])new Object[]{param, password});
                return this.mReader.getLastError();
            }
            this.mReader.setLastError(((ATModuleRfidUhfATM)this.mModule).lock(lock, mask));
            if (this.mReader.getLastError() != ResultCode.NoError) {
                ATLog.e((String)this.TAG, (String)"ERROR. lock6c([%s], [%s]) - Fialed to start lock", (Object[])new Object[]{param, password});
                return this.checkError();
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. lock6c([%s], [%s])", (Object[])new Object[]{param, password});
        return ResultCode.NoError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultCode permaLock6c(PermaLock6cParam param, String password) {
        int lock = param.getPermalock();
        try {
            this.assertAction();
        }
        catch (ATException e) {
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. permaLock6c([%s], [%s]) - Failed to assert action", (Object[])new Object[]{param, password});
            return this.mReader.getLastError();
        }
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                this.setAction(ActionState.PermaLock, password);
            }
            catch (ATException e) {
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. permaLock6c([%s], [%s]) - Failed to set action", (Object[])new Object[]{param, password});
                return this.mReader.getLastError();
            }
            this.mReader.setLastError(((ATModuleRfidUhfATM)this.mModule).permaLock(lock, lock));
            if (this.mReader.getLastError() != ResultCode.NoError) {
                ATLog.e((String)this.TAG, (String)"ERROR. permaLock6c([%s], [%s]) - Fialed to start lock", (Object[])new Object[]{param, password});
                return this.checkError();
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. permaLock6c([%s], [%s])", (Object[])new Object[]{param, password});
        return ResultCode.NoError;
    }

    @Override
    public ResultCode lock6b(Lock6bParam param, String password) {
        password = StringUtil.getNull((String)password);
        ATLog.e((String)this.TAG, (String)"ERROR. lock6b() - Failed to not supported method");
        return ResultCode.NotSupported;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultCode kill6c(String password) {
        try {
            this.assertAction();
        }
        catch (ATException e) {
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. kill6c([%s]) - Failed to assert action", (Object[])new Object[]{password});
            return this.mReader.getLastError();
        }
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                this.setAction(ActionState.Kill, password);
            }
            catch (ATException e) {
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. kill6c([%s]) - Failed to set action", (Object[])new Object[]{password});
                return this.mReader.getLastError();
            }
            this.mReader.setLastError(((ATModuleRfidUhfATM)this.mModule).kill(password));
            if (this.mReader.getLastError() != ResultCode.NoError) {
                ATLog.e((String)this.TAG, (String)"ERROR. kill6c([%s]) - Failed to start kill", (Object[])new Object[]{password});
                return this.checkError();
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. kill6c([%s])", (Object[])new Object[]{password});
        return ResultCode.NoError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultCode stop() {
        try {
            this.assertModule();
        }
        catch (ATException e) {
            ATLog.e((String)this.TAG, (String)"ERROR. stop() - Failed to assert module");
            return this.mReader.getLastError();
        }
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            this.mReader.setLastError(((ATModuleRfidUhfATM)this.mModule).stopAction());
            if (this.mReader.getLastError() != ResultCode.NoError) {
                ATLog.e((String)this.TAG, (String)"ERROR. stop() - Failed to stop action");
                this.mReader.checkError();
                return this.mReader.getLastError();
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. stop()");
        return ResultCode.NoError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getVersion() throws ATException {
        if (StringUtil.isNullOrEmpty((String)this.mVersion)) {
            this.assertAction();
            ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
            synchronized (aTModuleRfidUhf) {
                try {
                    this.mVersion = ((ATModuleRfidUhfATM)this.mModule).getVersion();
                }
                catch (ATException e) {
                    this.setException(e);
                    ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getVersion() - Failed to get rfid uhf version [%s]", (Object[])new Object[]{this.mReader.getLastError()});
                    throw e;
                }
                this.mReader.resetError();
            }
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getVersion() - [%s]", (Object[])new Object[]{this.mVersion});
        return this.mVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PowerRange getPowerRange() throws ATException {
        if (this.mPowerRange == null) {
            this.assertAction();
            ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
            synchronized (aTModuleRfidUhf) {
                try {
                    Pair<Integer, Integer> res = ((ATModuleRfidUhfATM)this.mModule).getPowerGainRange();
                    this.mPowerRange = new PowerRange((Integer)res.first, (Integer)res.second);
                }
                catch (ATException e) {
                    this.setException(e);
                    ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getPowerRange() - Failed to get power [%s]", (Object[])new Object[]{this.mReader.getLastError()});
                    throw e;
                }
                this.mReader.resetError();
            }
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getPowerRange() - [%s]", (Object[])new Object[]{this.mPowerRange});
        return this.mPowerRange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPower() throws ATException {
        int power = 0;
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                power = ((ATModuleRfidUhfATM)this.mModule).getPowerGain();
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getPower() - Failed to get power [%s]", (Object[])new Object[]{this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getPower() - [%d]", (Object[])new Object[]{power});
        return power;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPower(int power) throws ATException {
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                ((ATModuleRfidUhfATM)this.mModule).setPowerGain(power);
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setPower(%d) - Failed to set power [%s]", (Object[])new Object[]{power, this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setPower(%d)", (Object[])new Object[]{power});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getContinuousMode() throws ATException {
        boolean enabled = false;
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                enabled = ((ATModuleRfidUhfATM)this.mModule).getContinuousMode() > 0;
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setContinuousMode() - Failed to get continuous mode [%s]", (Object[])new Object[]{this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setContinuousMode() - [%s]", (Object[])new Object[]{enabled});
        return enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setContinuousMode(boolean enabled) throws ATException {
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                ((ATModuleRfidUhfATM)this.mModule).setContinuousMode(enabled ? 1 : 0);
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setContinuousMode(%s) - Failed to set continuous mode [%s]", (Object[])new Object[]{enabled, this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setContinuousMode(%s)", (Object[])new Object[]{enabled});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAccessPassword() throws ATException {
        String password = "";
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                password = ((ATModuleRfidUhfATM)this.mModule).getAccessPassword();
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getAccessPassword() - Failed to get access password [%s]", (Object[])new Object[]{this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getAccessPassword() - [%s]", (Object[])new Object[]{password});
        return password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAccessPassword(String password) throws ATException {
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                ((ATModuleRfidUhfATM)this.mModule).setAccessPassword(password);
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setAccessPassword([%s]) - Failed to set access password [%s]", (Object[])new Object[]{password, this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setAccessPassword([%s])", (Object[])new Object[]{password});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GlobalBandType getGlobalBand() throws ATException {
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                int region = ((ATModuleRfidUhfATM)this.mModule).getRegion();
                this.mGlobalBand = GlobalBandType.valueOf(region);
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getGlobalBand() - Failed to get global band [%s]", (Object[])new Object[]{this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getGlobalBand() - [%s]", (Object[])new Object[]{this.mGlobalBand});
        return this.mGlobalBand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setGlobalBand(GlobalBandType band) throws ATException {
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                ((ATModuleRfidUhfATM)this.mModule).setRegion(band.getCode());
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setGlobalBand(%s) - Failed to set global band [%s]", (Object[])new Object[]{band, this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setGlobalBand(%s)", (Object[])new Object[]{band});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getReportRssi() throws ATException {
        boolean enabled = false;
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                enabled = ((ATModuleRfidUhfATM)this.mModule).getReportRssi() > 0;
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getReportRssi() - Failed to get report rssi [%s]", (Object[])new Object[]{this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getReportRssi() - [%s]", (Object[])new Object[]{enabled});
        return enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setReportRssi(boolean enabled) throws ATException {
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                ((ATModuleRfidUhfATM)this.mModule).setReportRssi(enabled ? 1 : 0);
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setReportRssi(%s) - Failed to set report rssi [%s]", (Object[])new Object[]{enabled, this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setReportRssi(%s)", (Object[])new Object[]{enabled});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOperationTime() throws ATException {
        int time = 0;
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                time = ((ATModuleRfidUhfATM)this.mModule).getOperationTime();
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getOperationTime() - Failed to get operation time [%s]", (Object[])new Object[]{this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getOperationTime() - [%d]", (Object[])new Object[]{time});
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOperationTime(int time) throws ATException {
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                ((ATModuleRfidUhfATM)this.mModule).setOperationTime(time);
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setOperationTime(%d) - Failed to set operation time [%s]", (Object[])new Object[]{time, this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setOperationTime(%d)", (Object[])new Object[]{time});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInventoryTime() throws ATException {
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                this.mTxOnTime = ((ATModuleRfidUhfATM)this.mModule).getInventoryTime();
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getInventoryTime() - Failed to get inventory time [%s]", (Object[])new Object[]{this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getInventoryTime() - [%d]", (Object[])new Object[]{this.mTxOnTime});
        return this.mTxOnTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInventoryTime(int time) throws ATException {
        if (this.mGlobalBand == GlobalBandType.Japan125mW || this.mGlobalBand == GlobalBandType.Japan1W || this.mGlobalBand == GlobalBandType.Japan250mW) {
            if (time < REGION_JAPAN_MIN_TX_ON_TIME || time > REGION_JAPAN_MAX_TX_ON_TIME) {
                ATLog.e((String)this.TAG, (String)"ERROR. setInventoryTime(%d) - The input value is out of range.[%d ~ %d]", (Object[])new Object[]{time, REGION_JAPAN_MIN_TX_ON_TIME, REGION_JAPAN_MAX_TX_ON_TIME});
                throw new ATException(ResultCode.OutOfRange);
            }
        } else if (this.mGlobalBand == GlobalBandType.Europe || this.mGlobalBand == GlobalBandType.India) {
            if (time < REGION_ETSI_MIN_TX_ON_TIME || time > REGION_ETSI_MAX_TX_ON_TIME) {
                ATLog.e((String)this.TAG, (String)"ERROR. setInventoryTime(%d) - The input value is out of range.[%d ~ %d]", (Object[])new Object[]{time, REGION_ETSI_MIN_TX_ON_TIME, REGION_ETSI_MAX_TX_ON_TIME});
                throw new ATException(ResultCode.OutOfRange);
            }
        } else {
            if (time < REGION_FCC_MIN_TX_ON_TIME || time > REGION_FCC_MAX_TX_ON_TIME) {
                ATLog.e((String)this.TAG, (String)"ERROR. setInventoryTime(%d) - The input value is out of range.[%d ~ %d]", (Object[])new Object[]{time, REGION_FCC_MIN_TX_ON_TIME, REGION_FCC_MAX_TX_ON_TIME});
                throw new ATException(ResultCode.OutOfRange);
            }
            if (time + this.mTxOffTime > REGION_FCC_MAX_TX_ON_OFF_CYCLE) {
                ATLog.e((String)this.TAG, (String)"ERROR. setInventoryTime(%d) - The input value is exceed total inventory/idle time value [%d]", (Object[])new Object[]{time, REGION_FCC_MAX_TX_ON_OFF_CYCLE});
                ATLog.e((String)this.TAG, (String)"ERROR. setInventoryTime(%d) - Inventory Time [%d] , Idle Time [%d]", (Object[])new Object[]{time, time, this.mTxOffTime});
                throw new ATException(ResultCode.OutOfRange);
            }
        }
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                ((ATModuleRfidUhfATM)this.mModule).setInventoryTime(time);
                this.mTxOnTime = time;
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setInventoryTime(%d) - Failed to set inventory time [%s]", (Object[])new Object[]{time, this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setInventoryTime(%d)", (Object[])new Object[]{time});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getIdleTime() throws ATException {
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                this.mTxOffTime = ((ATModuleRfidUhfATM)this.mModule).getIdleTime();
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getIdleTime() - Failed to get idle time [%s]", (Object[])new Object[]{this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getIdleTime() - [%d]", (Object[])new Object[]{this.mTxOffTime});
        return this.mTxOffTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIdleTime(int time) throws ATException {
        if (this.mGlobalBand == GlobalBandType.Japan125mW || this.mGlobalBand == GlobalBandType.Japan1W || this.mGlobalBand == GlobalBandType.Japan250mW) {
            if (time < REGION_JAPAN_MIN_TX_OFF_TIME || time > REGION_JAPAN_MAX_TX_OFF_TIME) {
                ATLog.e((String)this.TAG, (String)"ERROR. setIdleTime(%d) - The input value is out of range.[%d ~ %d]", (Object[])new Object[]{time, REGION_JAPAN_MIN_TX_OFF_TIME, REGION_JAPAN_MAX_TX_OFF_TIME});
                throw new ATException(ResultCode.OutOfRange);
            }
        } else if (this.mGlobalBand == GlobalBandType.Europe || this.mGlobalBand == GlobalBandType.India) {
            if (time < REGION_ETSI_MIN_TX_OFF_TIME || time > REGION_ETSI_MAX_TX_OFF_TIME) {
                ATLog.e((String)this.TAG, (String)"ERROR. setIdleTime(%d) - The input value is out of range.[%d ~ %d]", (Object[])new Object[]{time, REGION_ETSI_MIN_TX_OFF_TIME, REGION_ETSI_MAX_TX_OFF_TIME});
                throw new ATException(ResultCode.OutOfRange);
            }
        } else {
            if (time < REGION_FCC_MIN_TX_OFF_TIME || time > REGION_FCC_MAX_TX_OFF_TIME) {
                ATLog.e((String)this.TAG, (String)"ERROR. setIdleTime(%d) - The input value is out of range.[%d ~ %d]", (Object[])new Object[]{time, REGION_FCC_MIN_TX_OFF_TIME, REGION_FCC_MAX_TX_OFF_TIME});
                throw new ATException(ResultCode.OutOfRange);
            }
            if (this.mTxOnTime + time > REGION_FCC_MAX_TX_ON_OFF_CYCLE) {
                ATLog.e((String)this.TAG, (String)"ERROR. setIdleTime(%d) - The input value is exceed total inventory/idle time value [%d]", (Object[])new Object[]{time, REGION_FCC_MAX_TX_ON_OFF_CYCLE});
                ATLog.e((String)this.TAG, (String)"ERROR. setIdleTime(%d) - Inventory Time [%d] , Idle Time [%d]", (Object[])new Object[]{time, this.mTxOnTime, time});
                throw new ATException(ResultCode.OutOfRange);
            }
        }
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                ((ATModuleRfidUhfATM)this.mModule).setIdleTime(time);
                this.mTxOffTime = time;
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setIdleTime(%d) - Failed to set idle time [%s]", (Object[])new Object[]{time, this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setIdleTime(%d)", (Object[])new Object[]{time});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLimitTagCount() throws ATException {
        int count = 0;
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                count = ((ATModuleRfidUhfATM)this.mModule).getLimitTagCount();
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getLimitTagCount() - Failed to get limit tag count [%s]", (Object[])new Object[]{this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getLimitTagCount() - [%d]", (Object[])new Object[]{count});
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLimitTagCount(int count) throws ATException {
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                ((ATModuleRfidUhfATM)this.mModule).setLimitTagCount(count);
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setLimitTagCount(%d) - Failed to set limit tag count [%s]", (Object[])new Object[]{count, this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setLimitTagCount(%d)", (Object[])new Object[]{count});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSameTagReportTime() throws ATException {
        int time = 0;
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                time = ((ATModuleRfidUhfATM)this.mModule).getTagReportTime();
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getSameTagReportTime() - Failed to get same tag report time [%s]", (Object[])new Object[]{this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getSameTagReportTime() - [%d]", (Object[])new Object[]{time});
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSameTagReportTime(int time) throws ATException {
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                ((ATModuleRfidUhfATM)this.mModule).setTagReportTime(time);
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setSameTagReportTime(%d) - Failed to set same tag report time [%s]", (Object[])new Object[]{time, this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setSameTagReportTime(%d)", (Object[])new Object[]{time});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getReportMode() throws ATException {
        boolean enabled = false;
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                enabled = ((ATModuleRfidUhfATM)this.mModule).getReportMode() > 0;
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getReportMode() - Failed to get report mode [%s]", (Object[])new Object[]{this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getReportMode() - [%s]", (Object[])new Object[]{enabled});
        return enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setReportMode(boolean enabled) throws ATException {
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                ((ATModuleRfidUhfATM)this.mModule).setReportMode(enabled ? 1 : 0);
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setReportMode(%s) - Failed to set report mode [%s]", (Object[])new Object[]{enabled, this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setReportMode(%s)", (Object[])new Object[]{enabled});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getReadTidLength() throws ATException {
        int length = 0;
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                length = ((ATModuleRfidUhfATM)this.mModule).getTidReadLength();
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getReadTidLength() - Failed to get read tid length [%s]", (Object[])new Object[]{this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getReadTidLength() - [%d]", (Object[])new Object[]{length});
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setReadTidLength(int length) throws ATException {
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                ((ATModuleRfidUhfATM)this.mModule).setTidReadLength(length);
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setReadTidLength(%d) - Failed to set read tid length [%s]", (Object[])new Object[]{length, this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setReadTidLength(%d)", (Object[])new Object[]{length});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AlgorithmType getAlgorithmType() throws ATException {
        AlgorithmType type = AlgorithmType.FixedQ;
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                type = AlgorithmType.valueOf(((ATModuleRfidUhfATM)this.mModule).getAlgorithm());
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getAlgorithmType() - Failed to get algorithm type [%s]", (Object[])new Object[]{this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getAlgorithmType() - [%s]", (Object[])new Object[]{type});
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAlgorithmType(AlgorithmType type) throws ATException {
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                ((ATModuleRfidUhfATM)this.mModule).setAlgorithm(type.getCode());
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setAlgorithmType(%s) - Failed to set algorithm type [%s]", (Object[])new Object[]{type, this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setAlgorithmType(%s)", (Object[])new Object[]{type});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getStartQ() throws ATException {
        int value = 0;
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                value = ((ATModuleRfidUhfATM)this.mModule).getStartQ();
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getStartQ() - Failed to get start Q [%s]", (Object[])new Object[]{this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getStartQ() - [%d]", (Object[])new Object[]{value});
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStartQ(int value) throws ATException {
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                ((ATModuleRfidUhfATM)this.mModule).setStartQ(value);
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setStartQ(%d) - Failed to set start Q [%s]", (Object[])new Object[]{value, this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setStartQ(%d)", (Object[])new Object[]{value});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMinQ() throws ATException {
        int value = 0;
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                value = ((ATModuleRfidUhfATM)this.mModule).getMinQ();
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getMinQ() - Failed to get min Q [%s]", (Object[])new Object[]{this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getMinQ() - [%d]", (Object[])new Object[]{value});
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMinQ(int value) throws ATException {
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                ((ATModuleRfidUhfATM)this.mModule).setMinQ(value);
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setMinQ(%d) - Failed to set min Q [%s]", (Object[])new Object[]{value, this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setMinQ(%d)", (Object[])new Object[]{value});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxQ() throws ATException {
        int value = 0;
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                value = ((ATModuleRfidUhfATM)this.mModule).getMaxQ();
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getMaxQ() - Failed to get max Q [%s]", (Object[])new Object[]{this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getMaxQ() - [%d]", (Object[])new Object[]{value});
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxQ(int value) throws ATException {
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                ((ATModuleRfidUhfATM)this.mModule).setMaxQ(value);
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setMaxQ(%d) - Failed to set max Q [%s]", (Object[])new Object[]{value, this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setMaxQ(%d)", (Object[])new Object[]{value});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FreqTableList getFreqTable() throws ATException {
        long list = 0L;
        long mask = 0L;
        FreqTableList table = null;
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                list = ((ATModuleRfidUhfATM)this.mModule).getFreqTable();
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getFreqTable() - Failed to get frequency table [%s]", (Object[])new Object[]{this.mReader.getLastError()});
                throw e;
            }
            try {
                mask = ((ATModuleRfidUhfATM)this.mModule).getFreqTableMask();
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getFreqTable() - Failed to get frequency mask table [%s]", (Object[])new Object[]{this.mReader.getLastError()});
                throw e;
            }
            table = new FreqTableList(list, mask);
            int i = 0;
            while (i < table.getCount()) {
                try {
                    table.setFrequency(i, ((ATModuleRfidUhfATM)this.mModule).getFreqValue(table.getSlot(i)));
                }
                catch (ATException e) {
                    this.mReader.setLastError(e.getCode());
                    this.mReader.checkError();
                    ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getFreqTable() - Failed to get frequency [%s]", (Object[])new Object[]{this.mReader.getLastError()});
                    throw e;
                }
                ++i;
            }
            table.sort();
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getFreqTable() - [%s]", (Object[])new Object[]{table.toString()});
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFreqTable(FreqTableList table) throws ATException {
        if (this.mGlobalBand != GlobalBandType.Japan125mW && this.mGlobalBand != GlobalBandType.Japan250mW && this.mGlobalBand != GlobalBandType.Japan1W) {
            ResultCode result = ResultCode.InvalidParameter;
            ATLog.e((String)this.TAG, (String)"ERROR. setFreqTable(%d) - [%s : %s]", (Object[])new Object[]{table.toString(), result, this.mGlobalBand.toString()});
            throw new ATException(result);
        }
        long list = table.getTable();
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                ((ATModuleRfidUhfATM)this.mModule).setFreqTable(list);
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setFreqTable([%s]) - Failed to set frequency table [%s]", (Object[])new Object[]{table.toString(), this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setFreqTable([%s])", (Object[])new Object[]{table.toString()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SelectFlag getSelectFlag() throws ATException {
        SelectFlag flag = SelectFlag.All;
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                flag = SelectFlag.valueOf(((ATModuleRfidUhfATM)this.mModule).getSelectFalg());
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getSelectFlag() - Failed to get select flag [%s]", (Object[])new Object[]{this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getSelectFlag() - [%s]", (Object[])new Object[]{flag});
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSelectFlag(SelectFlag flag) throws ATException {
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                ((ATModuleRfidUhfATM)this.mModule).setSelectFlag(flag.getCode());
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setSelectFlag(%s) - Failed to set select flag [%s]", (Object[])new Object[]{flag, this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setSelectFlag(%s)", (Object[])new Object[]{flag});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SessionFlag getSessionFlag() throws ATException {
        SessionFlag flag = SessionFlag.AB;
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                flag = SessionFlag.valueOf(((ATModuleRfidUhfATM)this.mModule).getSessionFalg());
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getSessionFlag() - Failed to get session flag [%s]", (Object[])new Object[]{this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getSessionFlag() - [%s]", (Object[])new Object[]{flag});
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSessionFlag(SessionFlag flag) throws ATException {
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                ((ATModuleRfidUhfATM)this.mModule).setSessionFlag(flag.getCode());
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setSessionFlag(%s) - Failed to set session flag [%s]", (Object[])new Object[]{flag, this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setSessionFlag(%s)", (Object[])new Object[]{flag});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SessionTarget getSessionTarget() throws ATException {
        SessionTarget type = SessionTarget.S0;
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                type = SessionTarget.valueOf(((ATModuleRfidUhfATM)this.mModule).getSessionTarget());
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getSessionTarget() - Failed to get session target [%s]", (Object[])new Object[]{this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getSessionTarget() - [%s]", (Object[])new Object[]{type});
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSessionTarget(SessionTarget target) throws ATException {
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                ((ATModuleRfidUhfATM)this.mModule).setSessionTarget(target.getCode());
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setSessionTarget(%s) - Failed to set session target [%s]", (Object[])new Object[]{target, this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setSessionTarget(%s)", (Object[])new Object[]{target});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getSelectMask6cEnabled(int index) throws ATException {
        boolean enabled = false;
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                enabled = ((ATModuleRfidUhfATM)this.mModule).getMask6cUsed(index) > 0;
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getSelectMask6cEnabled(%d) - Failed to get mask 6c enabled [%s]", (Object[])new Object[]{index, this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getSelectMask6cEnabled(%d) - [%s]", (Object[])new Object[]{index, enabled});
        return enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSelectMask6cEnabled(int index, boolean enabled) throws ATException {
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                ((ATModuleRfidUhfATM)this.mModule).setMask6cUsed(index, enabled ? 1 : 0);
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setSelectMask6cEnabled(%d, %s) - Failed to set mask 6c enabled [%s]", (Object[])new Object[]{index, enabled, this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setSelectMask6cEnabled(%d, %s)", (Object[])new Object[]{index, enabled});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Mask6cTarget getSelectMask6cTarget(int index) throws ATException {
        Mask6cTarget target = Mask6cTarget.SL;
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                target = Mask6cTarget.valueOf(((ATModuleRfidUhfATM)this.mModule).getMask6cTarget(index));
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getSelectMask6cTarget(%d) - Failed to get mask 6c target [%s]", (Object[])new Object[]{index, this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getSelectMask6cTarget(%d) - [%s]", (Object[])new Object[]{index, target});
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSelectMask6cTarget(int index, Mask6cTarget target) throws ATException {
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                ((ATModuleRfidUhfATM)this.mModule).setMask6cTarget(index, target.getCode());
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setSelectMask6cTarget(%d, %s) - Failed to set mask 6c target [%s]", (Object[])new Object[]{index, target, this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setSelectMask6cTarget(%d, %s)", (Object[])new Object[]{index, target});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Mask6cAction getSelectMask6cAction(int index) throws ATException {
        Mask6cAction action = Mask6cAction.AB;
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                action = Mask6cAction.valueOf(((ATModuleRfidUhfATM)this.mModule).getMask6cAction(index));
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getSelectMask6cAction(%d) - Failed to get mask 6c action [%s]", (Object[])new Object[]{index, this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getSelectMask6cAction(%d) - [%s]", (Object[])new Object[]{index, action});
        return action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSelectMask6cAction(int index, Mask6cAction action) throws ATException {
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                ((ATModuleRfidUhfATM)this.mModule).setMask6cAction(index, action.getCode());
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setSelectMask6cAction(%d, %s) - Failed to set mask 6c action [%s]", (Object[])new Object[]{index, action, this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setSelectMask6cAction(%d, %s)", (Object[])new Object[]{index, action});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BankType getSelectMask6cBank(int index) throws ATException {
        BankType bank = BankType.EPC;
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                bank = BankType.valueOf(((ATModuleRfidUhfATM)this.mModule).getMask6cBank(index));
                if (bank == BankType.Reserved) {
                    bank = BankType.EPC;
                }
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getSelectMask6cBank(%d) - Failed to get mask 6c bank [%s]", (Object[])new Object[]{index, this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getSelectMask6cBank(%d) - [%s]", (Object[])new Object[]{index, bank});
        return bank;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSelectMask6cBank(int index, BankType bank) throws ATException {
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            if (bank == BankType.Reserved) {
                bank = BankType.EPC;
            }
            try {
                ((ATModuleRfidUhfATM)this.mModule).setMask6cBank(index, bank.getCode());
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setSelectMask6cBank(%d, %s) - Failed to set mask 6c bank [%s]", (Object[])new Object[]{index, bank, this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setSelectMask6cBank(%d, %s)", (Object[])new Object[]{index, bank});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSelectMask6cOffset(int index) throws ATException {
        int offset = 0;
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                offset = ((ATModuleRfidUhfATM)this.mModule).getMask6cOffset(index);
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getSelectMask6cOffset(%d) - Failed to get mask 6c offset [%s]", (Object[])new Object[]{index, this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getSelectMask6cOffset(%d) - [%d]", (Object[])new Object[]{index, offset});
        return offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSelectMask6cOffset(int index, int offset) throws ATException {
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                ((ATModuleRfidUhfATM)this.mModule).setMask6cOffset(index, offset);
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setSelectMask6cOffset(%d, %d) - Failed to set mask 6c offset [%s]", (Object[])new Object[]{index, offset, this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setSelectMask6cOffset(%d, %d)", (Object[])new Object[]{index, offset});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Mask6cPattern getSelectMask6cPattern(int index) throws ATException {
        Mask6cPattern pattern = null;
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                pattern = new Mask6cPattern(((ATModuleRfidUhfATM)this.mModule).getMask6cPattern(index));
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getSelectMask6cPattern(%d) - Failed to get mack 6c pattern [%s]", (Object[])new Object[]{index, this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getSelectMask6cPattern(%d) - [%s]", (Object[])new Object[]{index, pattern});
        return pattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSelectMask6cPattern(int index, Mask6cPattern pattern) throws ATException {
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                ((ATModuleRfidUhfATM)this.mModule).setMask6cPattern(index, pattern.getPattern(), pattern.getLength());
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setSelectMask6cPattern(%d, [%s]) - Failed to set mask 6c pattern [%s]", (Object[])new Object[]{index, pattern, this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setSelectMask6cPattern(%d, [%s])", (Object[])new Object[]{index, pattern});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SelectMask6cParam getSelectMask6c(int index) throws ATException {
        boolean used = false;
        Mask6cTarget target = Mask6cTarget.SL;
        Mask6cAction action = Mask6cAction.AB;
        BankType bank = BankType.EPC;
        int offset = 16;
        Pair<String, Integer> pattern = null;
        SelectMask6cParam param = null;
        ATModuleRfidUhfATM module = (ATModuleRfidUhfATM)this.mModule;
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                used = ((ATModuleRfidUhfATM)this.mModule).getMask6cUsed(index) > 0;
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getSelectMask6c(%d) - Failed to get mask 6c used [%s]", (Object[])new Object[]{index, this.mReader.getLastError()});
                throw e;
            }
            try {
                target = Mask6cTarget.valueOf(module.getMask6cTarget(index));
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getSelectMask6c(%d) - Failed to get mask 6c target [%s]", (Object[])new Object[]{index, this.mReader.getLastError()});
                throw e;
            }
            try {
                action = Mask6cAction.valueOf(module.getMask6cAction(index));
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getSelectMask6c(%d) - Failed to get mask 6c action [%s]", (Object[])new Object[]{index, this.mReader.getLastError()});
                throw e;
            }
            try {
                bank = BankType.valueOf(module.getMask6cBank(index));
                if (bank == BankType.Reserved) {
                    bank = BankType.EPC;
                }
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getSelectMask6c(%d) - Failed to get mask 6c bank [%s]", (Object[])new Object[]{index, this.mReader.getLastError()});
                throw e;
            }
            try {
                offset = module.getMask6cOffset(index);
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getSelectMask6c(%d) - Failed to get mask 6c offset [%s]", (Object[])new Object[]{index, this.mReader.getLastError()});
                throw e;
            }
            try {
                pattern = module.getMask6cPattern(index);
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getSelectMask6c(%d) - Failed to get mask 6c pattern [%s]", (Object[])new Object[]{index, this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        param = new SelectMask6cParam(used, target, action, bank, offset, pattern);
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getSelectMask6c(%d) - [%s]", (Object[])new Object[]{index, param});
        return param;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSelectMask6c(int index, SelectMask6cParam param) throws ATException {
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            ATModuleRfidUhfATM module = (ATModuleRfidUhfATM)this.mModule;
            try {
                ((ATModuleRfidUhfATM)this.mModule).setMask6cUsed(index, param.isUsed() ? 1 : 0);
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setSelectMask6c(%d, [%s]) - Failed to set mask 6c used [%s]", (Object[])new Object[]{index, param, this.mReader.getLastError()});
                throw e;
            }
            try {
                module.setMask6cTarget(index, param.getTarget().getCode());
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setSelectMask6c(%d, [%s]) - Failed to set mask 6c target [%s]", (Object[])new Object[]{index, param, this.mReader.getLastError()});
                throw e;
            }
            try {
                module.setMask6cAction(index, param.getAction().getCode());
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setSelectMask6c(%d, [%s]) - Failed to set mask 6c action [%s]", (Object[])new Object[]{index, param, this.mReader.getLastError()});
                throw e;
            }
            try {
                BankType bank = param.getBank();
                if (bank == BankType.Reserved) {
                    bank = BankType.EPC;
                }
                module.setMask6cBank(index, bank.getCode());
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setSelectMask6c(%d, [%s]) - Failed to set mask 6c bank [%s]", (Object[])new Object[]{index, param, this.mReader.getLastError()});
                throw e;
            }
            try {
                module.setMask6cOffset(index, param.getOffset());
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setSelectMask6c(%d, [%s]) - Failed to set mask 6c offset [%s]", (Object[])new Object[]{index, param, this.mReader.getLastError()});
                throw e;
            }
            try {
                module.setMask6cPattern(index, param.getPattern(), param.getLength());
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setSelectMask6c(%d, [%s]) - Failed to set mask 6c pattern [%s]", (Object[])new Object[]{index, param, this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setSelectMask6c(%d, [%s])", (Object[])new Object[]{index, param});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getEpcMaskCount() throws ATException {
        int count = 0;
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                count = ((ATModuleRfidUhfATM)this.mModule).getEpcMaskCount();
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getEpcMaskCount() - Failed to get rfid version [%s]", (Object[])new Object[]{this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getEpcMaskCount() - [%d]", (Object[])new Object[]{count});
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getEpcMaskMatchMode() throws ATException {
        boolean enabled = false;
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                enabled = ((ATModuleRfidUhfATM)this.mModule).getEpcMaskMatchMode() > 0;
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getEpcMaskMatchMode() - Failed to get epc mask match mode [%s]", (Object[])new Object[]{this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getEpcMaskMatchMode() - [%s]", (Object[])new Object[]{enabled});
        return enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEpcMaskMatchMode(boolean enabled) throws ATException {
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                ((ATModuleRfidUhfATM)this.mModule).setEpcMaskMatchMode(enabled ? 1 : 0);
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setEpcMaskMatchMode(%s) - Failed to set epc mask match mode [%s]", (Object[])new Object[]{enabled, this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setEpcMaskMatchMode(%s)", (Object[])new Object[]{enabled});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearEpcMask() throws ATException {
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                ((ATModuleRfidUhfATM)this.mModule).clearEpcMask();
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. clearEpcMask() - Failed to clear epc mask [%s]", (Object[])new Object[]{this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. clearEpcMask()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEpcMask(EpcMaskParam param) throws ATException {
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                ((ATModuleRfidUhfATM)this.mModule).addEpcMask(param.getOffset(), param.getLength(), param.getPattern());
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. addEpcMask([%s]) - Failed to add epc mask [%s]", (Object[])new Object[]{param, this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. addEpcMask([%s])", (Object[])new Object[]{param});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EpcMaskParam getEpcMask(int index) throws ATException {
        ArrayList<Object> res = null;
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                res = ((ATModuleRfidUhfATM)this.mModule).getEpcMask(index);
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getEpcMask(%d) - Failed to get epc mask [%s]", (Object[])new Object[]{index, this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        EpcMaskParam param = new EpcMaskParam((Integer)res.get(0), (Integer)res.get(1), (String)res.get(2));
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getEpcMask(%d) - [%s]", (Object[])new Object[]{index, param});
        return param;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCurrentLinkProfile() throws ATException {
        int value = 1;
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                value = ((ATModuleRfidUhfATM)this.mModule).getCurrentLinkProfile();
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getCurrentLinkProfile() - Failed to get link profile [%s]", (Object[])new Object[]{this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getCurrentLinkProfile() - [%d]", (Object[])new Object[]{value});
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCurrentLinkProfile(int index) throws ATException {
        if (index < 0 || index > 3) {
            ResultCode result = ResultCode.InvalidParameter;
            ATLog.e((String)this.TAG, (String)"ERROR. setDefaultLinkProfile(%d) - [%s]", (Object[])new Object[]{index, result});
            throw new ATException(result);
        }
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                ((ATModuleRfidUhfATM)this.mModule).setCurrentLinkProfile(index);
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setCurrentLinkProfile(%d) - Failed to set link profile [%s]", (Object[])new Object[]{index, this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setCurrentLinkProfile(%d)", (Object[])new Object[]{index});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDefaultLinkProfile() throws ATException {
        int value = 1;
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                value = ((ATModuleRfidUhfATM)this.mModule).getDefaultLinkProfile();
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getDefaultLinkProfile() - Failed to get link profile [%s]", (Object[])new Object[]{this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getDefaultLinkProfile() - [%d]", (Object[])new Object[]{value});
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultLinkProfile(int index) throws ATException {
        if (index < 0 || index > 3) {
            ResultCode result = ResultCode.InvalidParameter;
            ATLog.e((String)this.TAG, (String)"ERROR. setDefaultLinkProfile(%d) - [%s]", (Object[])new Object[]{index, result});
            throw new ATException(result);
        }
        this.assertAction();
        ATModuleRfidUhf aTModuleRfidUhf = this.mModule;
        synchronized (aTModuleRfidUhf) {
            try {
                ((ATModuleRfidUhfATM)this.mModule).setDefaultLinkProfile(index);
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setDefaultLinkProfile(%d) - Failed to set link profile [%s]", (Object[])new Object[]{index, this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setDefaultLinkProfile(%d)", (Object[])new Object[]{index});
    }

    @Override
    public void onReadTag(String tag, Object params) {
        this.mListeners.generateRfidUhfReadTag(this, tag, params);
        if (ATLog.isLogging((int)6)) {
            ATLog.i((String)this.TAG, (int)6, (String)"INFO. onReadTag([%s])", (Object[])new Object[]{tag});
        }
    }

    @Override
    public void onAccessResult(ResultCode code, ActionType action, String epc, String data, Object params) {
        this.mListeners.generateRfidUhfAccessResult(this, code, ActionUtil.getAction((ActionType)action), epc, data, params);
        if (ATLog.isLogging((int)6)) {
            ATLog.i((String)this.TAG, (int)6, (String)"INFO. onAccessResult(%s, %s, [%s], [%s])", (Object[])new Object[]{code, action, epc, data});
        }
    }

    @Override
    public void onPowerGainChanged(int power, Object params) {
        this.mListeners.generateRfidUhfPowerGainChangedEventArgs(this, power, params);
        if (ATLog.isLogging((int)6)) {
            ATLog.i((String)this.TAG, (int)6, (String)"INFO. onPowerGainChanged(%d)", (Object[])new Object[]{power});
        }
    }

    protected void assertModule() throws ATException {
        if (this.mModule == null) {
            this.mReader.setLastError(ResultCode.InvalidModule);
            ATLog.e((String)this.TAG, (String)"ERROR. assertModule() - Failed to invalid module object");
            throw new ATException(ResultCode.InvalidModule);
        }
        if (this.mModule.getType() == ModuleRfidUhfType.None) {
            this.mReader.setLastError(ResultCode.NotSupported);
            ATLog.e((String)this.TAG, (String)"ERROR. assertModule() - Failed to not supported");
            throw new ATException(this.mReader.getLastError());
        }
    }

    protected void assertAction() throws ATException {
        this.assertModule();
        if (this.mReader.getAction() != ActionState.Stop) {
            this.mReader.setLastError(ResultCode.InOperation);
            ATLog.e((String)this.TAG, (String)"ERROR. assertAction() - Failed to in operation");
            throw new ATException(this.mReader.getLastError());
        }
    }

    protected void setAction(ActionState action, String password) throws ATException {
        ATModuleRfidUhfATM module = (ATModuleRfidUhfATM)this.mModule;
        password = StringUtil.getNull((String)password);
        try {
            this.mIsContinuousMode = module.getContinuousMode() > 0;
        }
        catch (ATException e) {
            this.mReader.setLastError(e.getCode());
            this.mReader.checkError();
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setAction(%s, [%s]) - Failed to get continuous mode", (Object[])new Object[]{action, password});
            throw new ATException(this.mReader.getLastError());
        }
        try {
            module.setContinuousMode(0);
        }
        catch (ATException e) {
            this.mReader.setLastError(e.getCode());
            this.mReader.checkError();
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setAction(%s, [%s]) - Failed to disable continuous mode", (Object[])new Object[]{action, password});
            throw new ATException(this.mReader.getLastError());
        }
        try {
            module.setAccessPassword(password);
        }
        catch (ATException e) {
            this.mReader.setLastError(e.getCode());
            this.mReader.checkError();
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setAction(%s, [%s]) - Failed to set access password", (Object[])new Object[]{action, password});
            throw new ATException(this.mReader.getLastError());
        }
        this.mReader.setAction(ActionState.Lock);
    }

    protected ResultCode checkError() {
        try {
            ((ATModuleRfidUhfATM)this.mModule).setContinuousMode(this.mIsContinuousMode ? 1 : 0);
        }
        catch (ATException e) {
            this.mReader.setLastError(e.getCode());
            this.mReader.checkError();
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. checkError() - Failed to restore continuous mode", (Object[])new Object[0]);
            return this.mReader.getLastError();
        }
        this.mReader.checkError();
        return this.mReader.getLastError();
    }

    protected void setException(ATException e) {
        this.mReader.setLastError(e.getCode());
        this.mReader.checkError();
    }
}

