/*
 * Decompiled with CFR 0.152.
 */
package com.atid.lib.module.barcode.spc.param;

import com.atid.lib.diagnostics.ATException;
import com.atid.lib.module.barcode.spc.param.SPCParamName;
import com.atid.lib.types.ResultCode;
import com.atid.lib.util.diagnotics.ATLog;
import java.util.ArrayList;

public class SPCParamNameList {
    private static final String TAG = SPCParamNameList.class.getSimpleName();
    private static final String QUERY_COMMAND = "?";
    private static final String STORAGE_COMMAND = ".";
    private ArrayList<SPCParamName> mList = new ArrayList();

    public SPCParamNameList() {
    }

    public SPCParamNameList(SPCParamName item) {
        this.add(item);
    }

    public SPCParamNameList(SPCParamName[] items) {
        this.add(items);
    }

    public synchronized int getCount() {
        return this.mList.size();
    }

    public synchronized boolean add(SPCParamName item) {
        if (item == null) {
            ATLog.e((String)TAG, (String)"ERROR. add(item) - Invalid parameter");
            return false;
        }
        return this.mList.add(item);
    }

    public synchronized boolean add(SPCParamName[] items) {
        boolean result = true;
        if (items == null) {
            ATLog.e((String)TAG, (String)"ERROR. add(item) - Invalid parameter");
            return false;
        }
        SPCParamName[] sPCParamNameArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            SPCParamName item = sPCParamNameArray[n2];
            result &= this.mList.add(item);
            ++n2;
        }
        return result;
    }

    public String getQueryCommand(int engine) throws ATException {
        return this.getCommand(QUERY_COMMAND, engine);
    }

    private String getCommand(String suffix, int engine) throws ATException {
        StringBuilder cmd = new StringBuilder();
        if (this.mList == null || this.mList.size() == 0) {
            ATLog.e((String)TAG, (String)"ERROR. Parameter is null or zero !!!");
            throw new ATException(ResultCode.InvalidParameter);
        }
        for (SPCParamName item : this.mList) {
            if (cmd.length() > 0) {
                cmd.append(";");
            }
            cmd.append(item.getCommand());
            cmd.append(suffix);
        }
        cmd.append(STORAGE_COMMAND);
        return cmd.toString();
    }
}

