/*
 * Decompiled with CFR 0.152.
 */
package com.atid.lib.util.collections;

import com.atid.lib.util.diagnotics.ATLog;

public class ByteQueue {
    private static final String TAG = ByteQueue.class.getSimpleName();
    private static final int INFO = 9;
    private static final int DEBUG = 2;
    private static final int DEFAULT_QUEUE_SIZE = 8192;
    private byte[] mData = new byte[8192];
    private int mFront = 0;
    private int mTail = 0;

    public synchronized int getQueueSize() {
        return this.mData.length;
    }

    public synchronized int getPos(int pos) {
        return pos % this.mData.length;
    }

    public synchronized int getFront() {
        return this.mFront;
    }

    public synchronized void setFront(int front) {
        this.mFront = front % this.mData.length;
    }

    public synchronized int getTail() {
        return this.mTail;
    }

    public synchronized void setTail(int tail) {
        this.mTail = tail % this.mData.length;
    }

    public synchronized int getSize() {
        return this.getSize(this.mFront, this.mTail);
    }

    public synchronized int getSize(int position) {
        return this.getSize(position, this.mTail);
    }

    public synchronized int getSize(int start, int end) {
        return start <= end ? end - start : this.mData.length + end - start;
    }

    private synchronized int getFreeSize() {
        return this.mData.length - this.getSize() - 1;
    }

    public synchronized void clear() {
        this.mFront = 0;
        this.mTail = 0;
    }

    public synchronized int enqueue(byte[] data) throws Exception {
        return this.enqueue(data, 0, data.length);
    }

    public synchronized int enqueue(byte[] data, int length) throws Exception {
        return this.enqueue(data, 0, length);
    }

    public synchronized int enqueue(byte[] data, int offset, int length) throws Exception {
        try {
            if (this.getFreeSize() < length) {
                this.resize(length);
            }
            if (this.mFront <= this.mTail) {
                if (this.mTail + length >= this.mData.length) {
                    int copySize = this.mData.length - this.mTail;
                    System.arraycopy(data, offset, this.mData, this.mTail, copySize);
                    System.arraycopy(data, offset + copySize, this.mData, 0, length - copySize);
                } else {
                    System.arraycopy(data, offset, this.mData, this.mTail, length);
                }
            } else {
                System.arraycopy(data, offset, this.mData, this.mTail, length);
            }
            this.mTail = (this.mTail + length) % this.mData.length;
        }
        catch (Exception e) {
            ATLog.e(TAG, e, "ERROR. enqueue(%d, %d) - Fialed to enqueue data [%d, %d, %d]", offset, length, this.mFront, this.mTail, this.getSize());
            throw e;
        }
        return this.mFront <= this.mTail ? this.mTail - this.mFront : this.mData.length + this.mTail - this.mFront;
    }

    public synchronized int dequeue(byte[] data) throws Exception {
        return this.dequeue(data, 0, data.length);
    }

    public synchronized int dequeue(byte[] data, int length) throws Exception {
        return this.dequeue(data, 0, length);
    }

    public synchronized int dequeue(byte[] data, int offset, int length) throws Exception {
        if (this.mFront == this.mTail) {
            return 0;
        }
        int size = Math.min(this.getSize(), length);
        try {
            if (this.mFront < this.mTail) {
                System.arraycopy(this.mData, this.mFront, data, offset, size);
            } else if (this.mFront > this.mTail) {
                if (this.mFront + size > this.mData.length) {
                    int copy = this.mData.length - this.mFront;
                    System.arraycopy(this.mData, this.mFront, data, offset, copy);
                    System.arraycopy(this.mData, 0, data, offset + copy, size - copy);
                } else {
                    System.arraycopy(this.mData, this.mFront, data, offset, size);
                }
            }
        }
        catch (Exception e) {
            ATLog.e(TAG, e, "ERROR. dequeue(%d, %d) - Failed to dequeue data [%d, %d, %d]", offset, length, this.mFront, this.mTail, this.getSize());
            throw e;
        }
        this.mFront = (this.mFront + size) % this.mData.length;
        return size;
    }

    public synchronized int peek() {
        return this.peek(this.mFront);
    }

    public synchronized int peek(int position) {
        return this.mData[position % this.mData.length];
    }

    public synchronized byte[] peek(int start, int end) {
        if (this.mFront == this.mTail) {
            return null;
        }
        int size = this.getSize();
        int length = this.getSize(start %= this.mData.length, end %= this.mData.length);
        byte[] data = null;
        try {
            if (start < end) {
                if (size > length) {
                    size = length;
                }
                data = new byte[size];
                System.arraycopy(this.mData, start, data, 0, size);
            } else if (start > end) {
                if (size > length) {
                    size = length;
                }
                data = new byte[size];
                if (start + size > this.mData.length) {
                    int copy = this.mData.length - start;
                    System.arraycopy(this.mData, start, data, 0, copy);
                    System.arraycopy(this.mData, 0, data, copy, size - copy);
                } else {
                    System.arraycopy(this.mData, start, data, 0, size);
                }
            }
        }
        catch (Exception e) {
            ATLog.e(TAG, e, "ERROR. peek(%d, %d) - Failed to dequeue data [%d, %d, %d]", start, end, this.mFront, this.mTail, this.getSize());
            return null;
        }
        return data;
    }

    public synchronized void remove() {
        if (this.mFront == this.mTail) {
            return;
        }
        this.mFront = (this.mFront + 1) % this.mData.length;
    }

    public synchronized int findKey(int key) {
        return this.findKey(this.mFront, key);
    }

    public synchronized int findKey(int position, int key) {
        if (this.mFront == this.mTail) {
            return -1;
        }
        int end = this.mFront < this.mTail ? this.mTail : this.mTail + this.mData.length;
        int pos = 0;
        int i = position %= this.mData.length;
        while (i < end) {
            pos = i % this.mData.length;
            if (this.mData[pos] == key) {
                return pos;
            }
            ++i;
        }
        return -1;
    }

    public synchronized int findPattern(byte[] pattern) {
        return this.findPattern(this.mFront, pattern);
    }

    public synchronized int findPattern(int position, byte[] pattern) {
        if (this.mFront == this.mTail) {
            return -1;
        }
        int end = (position < this.mTail ? this.mTail : this.mTail + this.mData.length) - pattern.length + 1;
        int pos = 0;
        boolean isMatch = true;
        int i = position %= this.mData.length;
        while (i < end) {
            isMatch = true;
            int j = 0;
            while (j < pattern.length) {
                pos = (i + j) % this.mData.length;
                if (this.mData[pos] != pattern[j]) {
                    isMatch &= false;
                    break;
                }
                ++j;
            }
            if (isMatch) {
                return i % this.mData.length;
            }
            ++i;
        }
        return -1;
    }

    private synchronized void resize(int size) throws Exception {
        byte[] newData = null;
        int newSize = (size / this.getFreeSize() + 1) * this.mData.length;
        newData = new byte[this.mData.length + newSize];
        try {
            if (this.mFront < this.mTail) {
                System.arraycopy(this.mData, this.mFront, newData, this.mFront, this.mTail - this.mFront);
            } else if (this.mFront > this.mTail) {
                System.arraycopy(this.mData, 0, newData, 0, this.mTail);
                System.arraycopy(this.mData, this.mFront, newData, this.mFront + newSize, this.mData.length - this.mFront);
                this.mFront += newSize;
            }
        }
        catch (Exception e) {
            ATLog.e(TAG, e, "ERROR. resize(%d) - Failed to resize queue [%d, %d, %d]", size, this.mFront, this.mTail, this.getSize());
            throw e;
        }
        this.mData = newData;
    }
}

