/*
 * Decompiled with CFR 0.152.
 */
package com.atid.lib.module.barcode.spc;

import com.atid.lib.device.IReader;
import com.atid.lib.diagnostics.ATException;
import com.atid.lib.module.barcode.ATBarcode;
import com.atid.lib.module.barcode.module.ATModuleBarcode;
import com.atid.lib.module.barcode.params.SymbolStateList;
import com.atid.lib.module.barcode.spc.param.SPCParamName;
import com.atid.lib.module.barcode.spc.param.SPCParamNameList;
import com.atid.lib.module.barcode.spc.param.SPCParamValue;
import com.atid.lib.module.barcode.spc.param.SPCParamValueList;
import com.atid.lib.module.barcode.types.BarcodePostType;
import com.atid.lib.module.barcode.types.BarcodeType;
import com.atid.lib.util.converts.BitConvert;
import com.atid.lib.util.diagnotics.ATLog;
import com.atid.lib.util.diagnotics.Dump;
import java.util.Locale;

public abstract class ATBarcodeSpc
extends ATBarcode
implements ATModuleBarcode.IModuleBarcodeEventListener {
    private static final int COMMAND_LEN = 6;
    private static final String RESULT_ACK = "\u0006";

    public ATBarcodeSpc(IReader reader) {
        super(reader);
        this.TAG = ATBarcodeSpc.class.getSimpleName();
    }

    @Override
    public boolean initMoudle() {
        try {
            this.mModule.setBarcodeParam(BitConvert.toBytes((String)"DFMCA3;PREBK2995C80;SUFBK2990D0A;SHWNRD1"));
        }
        catch (ATException e) {
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. initReader() - Failed to set barcode param init SPC code", (Object[])new Object[0]);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getVersion() throws ATException {
        String version = "";
        this.assertAction();
        ATModuleBarcode aTModuleBarcode = this.mModule;
        synchronized (aTModuleBarcode) {
            try {
                version = this.mModule.getVersion();
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getVersion() - Failed to get barcode version [%s]", (Object[])new Object[]{this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        if (ATLog.isLogging((int)6)) {
            ATLog.i((String)this.TAG, (int)6, (String)"INFO. getVersion() - [%s]", (Object[])new Object[]{version});
        }
        return version;
    }

    @Override
    public boolean isSuportSelPost() {
        return true;
    }

    @Override
    public BarcodePostType getSymbolPostState() throws ATException {
        BarcodePostType post = null;
        String data = null;
        SPCParamNameList paramNameList = new SPCParamNameList(new SPCParamName[]{SPCParamName.PostalCodes2D});
        SPCParamValueList paramValueList = null;
        try {
            data = this.getBarcodeParamString(paramNameList.getQueryCommand(this.getType().getCode()));
        }
        catch (ATException e) {
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getSymbolPostState() - Failed to send Barcode Postal data", (Object[])new Object[0]);
            throw e;
        }
        try {
            paramValueList = SPCParamValueList.parseParams(data, this.getType().getCode());
        }
        catch (ATException e) {
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getSymbolPostState() - Failed to parse Barcode Postal data", (Object[])new Object[0]);
            throw e;
        }
        post = (BarcodePostType)((Object)paramValueList.getValueAt(SPCParamName.PostalCodes2D));
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getSymbolPostState() - [%d , %s]", (Object[])new Object[]{post.getCode(), post.toString()});
        return post;
    }

    @Override
    public void setSymbolPostState(BarcodePostType post) throws ATException {
        SPCParamValueList paramValueList = null;
        SPCParamValue[] paramValue = null;
        paramValue = new SPCParamValue[]{new SPCParamValue(SPCParamName.PostalCodes2D, (Object)post)};
        paramValueList = new SPCParamValueList(paramValue);
        try {
            this.setBarcodeParamString(paramValueList.getCommand(this.getType().getCode()));
        }
        catch (ATException e) {
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setSymbolPostState() - Failed to send Barcode Postal data", (Object[])new Object[0]);
            throw e;
        }
    }

    protected String getBytes(BarcodeType type) {
        String code = "";
        switch (type) {
            case Codabar: {
                code = "CBRENA";
                break;
            }
            case Code39: {
                code = "C39ENA";
                break;
            }
            case Code32: {
                code = "C39B32";
                break;
            }
            case I2of5: {
                code = "I25ENA";
                break;
            }
            case N2of5: {
                code = "N25ENA";
                break;
            }
            case Code93: {
                code = "C93ENA";
                break;
            }
            case R2of5: {
                code = "R25ENA";
                break;
            }
            case IATA: {
                code = "A25ENA";
                break;
            }
            case M2of5: {
                code = "X25ENA";
                break;
            }
            case Code11: {
                code = "C11ENA";
                break;
            }
            case Code128: {
                code = "128ENA";
                break;
            }
            case ISBT_128: {
                code = "ISBENA";
                break;
            }
            case GS1_128: {
                code = "GS1ENA";
                break;
            }
            case UPCA: {
                code = "UPBENA";
                break;
            }
            case UPCE: {
                code = "UPEEN0";
                break;
            }
            case UPCE1: {
                code = "UPEEN1";
                break;
            }
            case EAN13: {
                code = "E13ENA";
                break;
            }
            case EAN8: {
                code = "EA8ENA";
                break;
            }
            case Bookland: {
                code = "E13ISB";
                break;
            }
            case MSI: {
                code = "MSIENA";
                break;
            }
            case GS1_14: {
                code = "RSSENA";
                break;
            }
            case GS1_Limited: {
                code = "RSLENA";
                break;
            }
            case GS1_Expanded: {
                code = "RSEENA";
                break;
            }
            case Trioptic: {
                code = "TRIENA";
                break;
            }
            case CodablockA: {
                code = "CBAENA";
                break;
            }
            case CodablockF: {
                code = "CBFENA";
                break;
            }
            case PDF417: {
                code = "PDFENA";
                break;
            }
            case MicroPDF: {
                code = "PDFMAC";
                break;
            }
            case GS1_Composite: {
                code = "MPDENA";
                break;
            }
            case TLC39: {
                code = "T39ENA";
                break;
            }
            case QRCode: {
                code = "QRCENA";
                break;
            }
            case DataMatrix: {
                code = "IDMENA";
                break;
            }
            case Maxicode: {
                code = "MAXENA";
                break;
            }
            case AztecCode: {
                code = "AZTENA";
                break;
            }
            case HanXin: {
                code = "HX_ENA";
                break;
            }
            case ChinaPost: {
                code = "CPCENA";
                break;
            }
            case KoreaPost: {
                code = "KPCENA";
                break;
            }
            case PostalSel: {
                code = "POSTAL";
                break;
            }
            default: {
                code = "";
            }
        }
        if (ATLog.isLogging((int)6)) {
            ATLog.i((String)this.TAG, (int)6, (String)"INFO. getBytes([%s])", (Object[])new Object[]{type});
        }
        return code;
    }

    protected BarcodeType getBarcodeType(String name) {
        BarcodeType type = BarcodeType.Unknown;
        type = name.startsWith("CBRENA") ? BarcodeType.Codabar : (name.startsWith("C39ENA") ? BarcodeType.Code39 : (name.startsWith("C39B32") ? BarcodeType.Code32 : (name.startsWith("I25ENA") ? BarcodeType.I2of5 : (name.startsWith("N25ENA") ? BarcodeType.N2of5 : (name.startsWith("C93ENA") ? BarcodeType.Code93 : (name.startsWith("R25ENA") ? BarcodeType.R2of5 : (name.startsWith("A25ENA") ? BarcodeType.IATA : (name.startsWith("X25ENA") ? BarcodeType.M2of5 : (name.startsWith("C11ENA") ? BarcodeType.Code11 : (name.startsWith("128ENA") ? BarcodeType.Code128 : (name.startsWith("ISBENA") ? BarcodeType.ISBT_128 : (name.startsWith("GS1ENA") ? BarcodeType.GS1_128 : (name.startsWith("UPBENA") ? BarcodeType.UPCA : (name.startsWith("UPEEN0") ? BarcodeType.UPCE : (name.startsWith("UPEEN1") ? BarcodeType.UPCE1 : (name.startsWith("E13ENA") ? BarcodeType.EAN13 : (name.startsWith("EA8ENA") ? BarcodeType.EAN8 : (name.startsWith("E13ISB") ? BarcodeType.Bookland : (name.startsWith("MSIENA") ? BarcodeType.MSI : (name.startsWith("RSSENA") ? BarcodeType.GS1_14 : (name.startsWith("RSLENA") ? BarcodeType.GS1_Limited : (name.startsWith("RSEENA") ? BarcodeType.GS1_Expanded : (name.startsWith("TRIENA") ? BarcodeType.Trioptic : (name.startsWith("CBAENA") ? BarcodeType.CodablockA : (name.startsWith("CBFENA") ? BarcodeType.CodablockF : (name.startsWith("PDFENA") ? BarcodeType.PDF417 : (name.startsWith("PDFMAC") ? BarcodeType.MicroPDF : (name.startsWith("MPDENA") ? BarcodeType.GS1_Composite : (name.startsWith("T39ENA") ? BarcodeType.TLC39 : (name.startsWith("QRCENA") ? BarcodeType.QRCode : (name.startsWith("IDMENA") ? BarcodeType.DataMatrix : (name.startsWith("MAXENA") ? BarcodeType.Maxicode : (name.startsWith("AZTENA") ? BarcodeType.AztecCode : (name.startsWith("HX_ENA") ? BarcodeType.HanXin : (name.startsWith("CPCENA") ? BarcodeType.ChinaPost : (name.startsWith("KPCENA") ? BarcodeType.KoreaPost : (name.startsWith("POSTAL") ? BarcodeType.PostalSel : BarcodeType.Unknown)))))))))))))))))))))))))))))))))))));
        if (ATLog.isLogging((int)6)) {
            ATLog.i((String)this.TAG, (int)6, (String)"INFO. getBarcodeType(%s) - [%s]", (Object[])new Object[]{name, type.toString()});
        }
        return type;
    }

    protected BarcodeType getBarcodeType(byte type) {
        switch (type) {
            case 44: {
                return BarcodeType.InfoMail;
            }
            case 60: {
                return BarcodeType.Code32;
            }
            case 63: {
                return BarcodeType.KoreaPost;
            }
            case 65: {
                return BarcodeType.Postal_Australia;
            }
            case 66: {
                return BarcodeType.Postal_UK;
            }
            case 67: {
                return BarcodeType.Postal_Canadian;
            }
            case 68: {
                return BarcodeType.EAN8;
            }
            case 69: {
                return BarcodeType.UPCE;
            }
            case 72: {
                return BarcodeType.HanXin;
            }
            case 73: {
                return BarcodeType.GS1_128;
            }
            case 74: {
                return BarcodeType.Postal_Japan;
            }
            case 75: {
                return BarcodeType.KixPost;
            }
            case 76: {
                return BarcodeType.Planet_US;
            }
            case 77: {
                return BarcodeType.IntelMail;
            }
            case 78: {
                return BarcodeType.Postal4i;
            }
            case 80: {
                return BarcodeType.Postnet_US;
            }
            case 81: {
                return BarcodeType.ChinaPost;
            }
            case 82: {
                return BarcodeType.MicroPDF;
            }
            case 84: {
                return BarcodeType.TLC39;
            }
            case 86: {
                return BarcodeType.CodablockA;
            }
            case 89: {
                return BarcodeType.N2of5;
            }
            case 97: {
                return BarcodeType.Codabar;
            }
            case 98: {
                return BarcodeType.Code39;
            }
            case 99: {
                return BarcodeType.UPCA;
            }
            case 100: {
                return BarcodeType.EAN13;
            }
            case 101: {
                return BarcodeType.I2of5;
            }
            case 102: {
                return BarcodeType.R2of5;
            }
            case 103: {
                return BarcodeType.MSI;
            }
            case 104: {
                return BarcodeType.Code11;
            }
            case 105: {
                return BarcodeType.Code93;
            }
            case 106: {
                return BarcodeType.Code128;
            }
            case 108: {
                return BarcodeType.Code49;
            }
            case 109: {
                return BarcodeType.M2of5;
            }
            case 113: {
                return BarcodeType.CodablockF;
            }
            case 114: {
                return BarcodeType.PDF417;
            }
            case 115: {
                return BarcodeType.QRCode;
            }
            case 116: {
                return BarcodeType.Telepen;
            }
            case 119: {
                return BarcodeType.DataMatrix;
            }
            case 120: {
                return BarcodeType.Maxicode;
            }
            case 121: {
                return BarcodeType.GS1_14;
            }
            case 122: {
                return BarcodeType.AztecCode;
            }
            case 123: {
                return BarcodeType.GS1_Limited;
            }
            case 125: {
                return BarcodeType.GS1_Expanded;
            }
        }
        return BarcodeType.NoRead;
    }

    @Override
    protected byte[] getBytes(BarcodeType[] names, int start, int end) {
        StringBuilder builder = new StringBuilder();
        String name = "";
        int i = start;
        while (i < end) {
            if (builder.length() > 0) {
                builder.append(";");
            }
            if (!(name = this.getBytes(names[i])).equals("")) {
                builder.append(name);
                builder.append("?");
            }
            ++i;
        }
        if (builder.length() > 0) {
            builder.append(".");
        }
        byte[] data = builder.toString().getBytes();
        if (ATLog.isLogging((int)6)) {
            ATLog.i((String)this.TAG, (int)6, (String)"INFO. getBytes(%d, %d, %d) - [%s]", (Object[])new Object[]{names.length, start, end, Dump.dump((byte[])data)});
        }
        return data;
    }

    @Override
    protected byte[] getBytes(BarcodeType[] names, boolean[] enabled, int start, int end) {
        StringBuilder builder = new StringBuilder();
        String name = "";
        int i = start;
        while (i < end) {
            if (builder.length() > 0) {
                builder.append(";");
            }
            if (!(name = this.getBytes(names[i])).equals("")) {
                builder.append(name);
                builder.append(enabled[i] ? "1" : "0");
            }
            ++i;
        }
        if (builder.length() > 0) {
            builder.append(".");
        }
        byte[] data = builder.toString().getBytes();
        if (ATLog.isLogging((int)6)) {
            ATLog.i((String)this.TAG, (int)6, (String)"INFO. getBytes(%d, %d, %d) - [%s]", (Object[])new Object[]{names.length, start, end, Dump.dump((byte[])data)});
        }
        return data;
    }

    @Override
    protected byte[] getBytes(BarcodeType[] names, boolean enabled, int start, int end) {
        StringBuilder builder = new StringBuilder();
        String name = "";
        int i = start;
        while (i < end) {
            if (builder.length() > 0) {
                builder.append(";");
            }
            if (!(name = this.getBytes(names[i])).equals("")) {
                builder.append(name);
                builder.append(enabled ? "1" : "0");
            }
            ++i;
        }
        if (builder.length() > 0) {
            builder.append(".");
        }
        byte[] data = builder.toString().getBytes();
        if (ATLog.isLogging((int)6)) {
            ATLog.i((String)this.TAG, (int)6, (String)"INFO. getBytes(%d, %d, %d) - [%s]", (Object[])new Object[]{names.length, start, end, Dump.dump((byte[])data)});
        }
        return data;
    }

    @Override
    protected byte[] getBytes(SymbolStateList list, int start, int end) {
        StringBuilder builder = new StringBuilder();
        String name = "";
        int i = start;
        while (i < end) {
            if (builder.length() > 0) {
                builder.append(";");
            }
            if (!(name = this.getBytes(list.getType(i))).equals("")) {
                builder.append(name);
            }
            builder.append(list.getUsed(i) ? "1" : "0");
            ++i;
        }
        if (builder.length() > 0) {
            builder.append(".");
        }
        byte[] data = builder.toString().getBytes();
        if (ATLog.isLogging((int)6)) {
            ATLog.i((String)this.TAG, (int)6, (String)"INFO. getBytes(%d, %d, %d) - [%s]", (Object[])new Object[]{list.getCount(), start, end, Dump.dump((byte[])data)});
        }
        return data;
    }

    @Override
    protected SymbolStateList getSymbolState(byte[] data) {
        SymbolStateList list = new SymbolStateList();
        String symbols = new String(data);
        if (symbols.endsWith(".")) {
            symbols = symbols.substring(0, symbols.length() - 1);
        }
        String[] values = symbols.split(";");
        int val = 0;
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            BarcodeType type;
            String value = stringArray[n2];
            if (value.endsWith(RESULT_ACK) && (type = this.getBarcodeType(value)) != BarcodeType.Unknown && type != BarcodeType.NoRead) {
                try {
                    val = Integer.parseInt(value.substring(6, 7));
                }
                catch (Exception e) {
                    val = 0;
                }
                list.add(type, val > 0);
            }
            ++n2;
        }
        if (ATLog.isLogging((int)6)) {
            ATLog.i((String)this.TAG, (int)6, (String)"INFO. getSymbolState([%s]) - [%d]", (Object[])new Object[]{Dump.dump((byte[])data), list.getCount()});
        }
        return list;
    }

    @Override
    public void onReadBarcode(int code, String data, Object params) {
        BarcodeType type = this.getBarcodeType((byte)code);
        String codeId = String.format(Locale.US, "%c", code);
        String barcode = data;
        this.mListeners.generateBarcodeReadData(this, type, codeId, barcode, null);
        if (ATLog.isLogging((int)6)) {
            ATLog.i((String)this.TAG, (int)6, (String)"INFO. onReadBarcode(%02X, [%s])", (Object[])new Object[]{code, data});
        }
    }
}

