/*
 * Decompiled with CFR 0.152.
 */
package com.atid.lib.atx88;

import com.atid.lib.atx88.ATx88Reader;
import com.atid.lib.atx88.device.ATDeviceATx88;
import com.atid.lib.diagnostics.ATException;
import com.atid.lib.reader.params.NotifyMethod;
import com.atid.lib.reader.types.NotifyTimeType;
import com.atid.lib.transport.ATransport;
import com.atid.lib.types.ResultCode;
import com.atid.lib.util.StringUtil;
import com.atid.lib.util.diagnotics.ATLog;

public class ATRFPrismaReader
extends ATx88Reader {
    public ATRFPrismaReader(ATransport transport) {
        super(transport);
        this.TAG = ATRFPrismaReader.class.getSimpleName();
    }

    @Override
    public synchronized boolean initReader() {
        ATDeviceATx88 device = (ATDeviceATx88)this.mDevice;
        String version = this.mDevice.getVersion();
        if (StringUtil.isNullOrEmpty((String)version)) {
            ATLog.e((String)this.TAG, (String)"ERROR. initReader() - Failed to unknown firmware version");
            return false;
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. Version : [%s]", (Object[])new Object[]{version});
        this.mDeviceVersion.setVersion(version);
        try {
            device.setKeyAction(0);
        }
        catch (ATException e) {
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. initReader() - Failed to disable key action", (Object[])new Object[0]);
            return false;
        }
        return true;
    }

    public NotifyTimeType getButtonNotifyTime() throws ATException {
        ATLog.e((String)this.TAG, (String)"ERROR. getButtonNotifyTime() - Failed to not supported method");
        throw new ATException(ResultCode.NotSupported);
    }

    public void setButtonNotifyTime(NotifyTimeType time) throws ATException {
        ATLog.e((String)this.TAG, (String)"ERROR. setButtonNotifyTime([%s]) - Failed to not supported method", (Object[])new Object[]{time});
        throw new ATException(ResultCode.NotSupported);
    }

    public NotifyMethod getButtonNotify() throws ATException {
        ATLog.e((String)this.TAG, (String)"ERROR. getButtonNotify() - Failed to not supported method");
        throw new ATException(ResultCode.NotSupported);
    }

    public void setButtonNotify(NotifyMethod method) throws ATException {
        ATLog.e((String)this.TAG, (String)"ERROR. setButtonNotify([%s]) - Failed to not supported method", (Object[])new Object[]{method});
        throw new ATException(ResultCode.NotSupported);
    }

    public NotifyMethod getAlertNotify() throws ATException {
        ATLog.e((String)this.TAG, (String)"ERROR. getAlertNotify() - Failed to not supported method");
        throw new ATException(ResultCode.NotSupported);
    }

    public void setAlertNotify(NotifyMethod method) throws ATException {
        ATLog.e((String)this.TAG, (String)"ERROR. setAlertNotify([%s]) - Failed to not supported method", (Object[])new Object[]{method});
        throw new ATException(ResultCode.NotSupported);
    }
}

