/*
 * Decompiled with CFR 0.152.
 */
package com.atid.lib.util.converts;

import com.atid.lib.util.StringUtil;
import com.atid.lib.util.diagnotics.ATLog;
import com.atid.lib.util.diagnotics.Dump;
import java.io.UnsupportedEncodingException;
import java.util.Locale;

public class BitConvert {
    private static final String TAG = BitConvert.class.getSimpleName();

    public static boolean isNullOrEmpty(byte[] data) {
        return data == null || data.length <= 0;
    }

    public static String toEAString(byte[] data, int offset, int length) {
        if (BitConvert.isNullOrEmpty(data)) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int len = data[offset] & 0x7F;
        if (len > length + 1) {
            len = length - 1;
        }
        int i = 0;
        while (i < len) {
            builder.append(String.format(Locale.US, "%02X", data[offset + i + 1]));
            ++i;
        }
        return builder.toString();
    }

    public static byte[] toEABytes(String data) {
        if (StringUtil.isNullOrEmpty(data)) {
            return null;
        }
        byte[] result = null;
        int length = data.length() / 2;
        result = new byte[length + 1];
        result[0] = (byte)((0x80 | length) & 0xFF);
        int i = 0;
        while (i < length) {
            result[i + 1] = (byte)Integer.parseInt(data.substring(2 * i, 2 * i + 2), 16);
            ++i;
        }
        return result;
    }

    public static byte[] appendEABytes(byte[] data) {
        if (BitConvert.isNullOrEmpty(data)) {
            return null;
        }
        byte[] newData = null;
        try {
            newData = new byte[data.length + 1];
            newData[0] = (byte)(data.length & 0xFF);
            System.arraycopy(data, 0, newData, 1, data.length);
        }
        catch (Exception e) {
            ATLog.e(TAG, e, "ERROR. appendEABytes([%s]) - Failed to add binary length", Dump.dump(data));
            return null;
        }
        return newData;
    }

    public static String toString(byte[] data) {
        if (BitConvert.isNullOrEmpty(data)) {
            return "";
        }
        String value = null;
        try {
            value = new String(data, "ASCII");
        }
        catch (Exception e) {
            ATLog.e(TAG, e, "ERROR. toString([%s]) - Failed to get string", Dump.dump(data));
            return "";
        }
        return value;
    }

    public static String toString(byte[] data, int offset, int length) {
        if (BitConvert.isNullOrEmpty(data)) {
            return "";
        }
        String value = null;
        try {
            value = new String(data, offset, length, "ASCII");
        }
        catch (Exception e) {
            ATLog.e(TAG, e, "ERROR. toString([%s], %d, %d) - Failed to get string", Dump.dump(data), offset, length);
            return "";
        }
        return value;
    }

    public static short toShort(byte[] data) {
        if (BitConvert.isNullOrEmpty(data)) {
            return 0;
        }
        short value = 0;
        String str = null;
        try {
            str = BitConvert.toString(data);
            value = (short)(Integer.parseInt(str) & 0xFFFF);
        }
        catch (Exception e) {
            ATLog.e(TAG, e, "ERROR. toShort([%s]) - Failed to get integer", Dump.dump(data));
            return 0;
        }
        return value;
    }

    public static short toShort(byte[] data, int offset, int length) {
        if (BitConvert.isNullOrEmpty(data)) {
            return 0;
        }
        short value = 0;
        String str = null;
        try {
            str = BitConvert.toString(data, offset, length);
            value = (short)(Integer.parseInt(str) & 0xFFFF);
        }
        catch (Exception e) {
            ATLog.e(TAG, e, "ERROR. toShort([%s], %d, %d) - Failed to get integer", Dump.dump(data), offset, length);
            return 0;
        }
        return value;
    }

    public static short toShort(byte[] data, int radix) {
        if (BitConvert.isNullOrEmpty(data)) {
            return 0;
        }
        short value = 0;
        String str = null;
        try {
            str = BitConvert.toString(data);
            value = (short)(Integer.parseInt(str, radix) & 0xFFFF);
        }
        catch (Exception e) {
            ATLog.e(TAG, e, "ERROR. toShort([%s], %d) - Failed to get integer", Dump.dump(data), radix);
            return 0;
        }
        return value;
    }

    public static short toShort(byte[] data, int offset, int length, int radix) {
        if (BitConvert.isNullOrEmpty(data)) {
            return 0;
        }
        short value = 0;
        String str = null;
        try {
            str = BitConvert.toString(data, offset, length);
            value = (short)(Integer.parseInt(str, radix) & 0xFFFF);
        }
        catch (Exception e) {
            ATLog.e(TAG, e, "ERROR. toShort([%s], %d, %d, %d) - Failed to get integer", Dump.dump(data), offset, length, radix);
            return 0;
        }
        return value;
    }

    public static int toInteger(byte[] data) {
        if (BitConvert.isNullOrEmpty(data)) {
            return 0;
        }
        int value = 0;
        String str = null;
        try {
            str = BitConvert.toString(data);
            value = (int)(Long.parseLong(str) & 0xFFFFFFFFFFFFFFFFL);
        }
        catch (Exception e) {
            ATLog.e(TAG, e, "ERROR. toInteger([%s]) - Failed to get integer", Dump.dump(data));
            return 0;
        }
        return value;
    }

    public static int toInteger(byte[] data, int offset, int length) {
        if (BitConvert.isNullOrEmpty(data)) {
            return 0;
        }
        int value = 0;
        String str = null;
        try {
            str = BitConvert.toString(data, offset, length);
            value = (int)(Long.parseLong(str) & 0xFFFFFFFFFFFFFFFFL);
        }
        catch (Exception e) {
            ATLog.e(TAG, e, "ERROR. toInteger([%s], %d, %d) - Failed to get integer", Dump.dump(data), offset, length);
            return 0;
        }
        return value;
    }

    public static int toInteger(byte[] data, int radix) {
        if (BitConvert.isNullOrEmpty(data)) {
            return 0;
        }
        int value = 0;
        String str = null;
        try {
            str = BitConvert.toString(data);
            value = (int)(Long.parseLong(str, radix) & 0xFFFFFFFFFFFFFFFFL);
        }
        catch (Exception e) {
            ATLog.e(TAG, e, "ERROR. toInteger([%s], %d) - Failed to get integer", Dump.dump(data), radix);
            return 0;
        }
        return value;
    }

    public static int toInteger(byte[] data, int offset, int length, int radix) {
        if (BitConvert.isNullOrEmpty(data)) {
            return 0;
        }
        int value = 0;
        String str = null;
        try {
            str = BitConvert.toString(data, offset, length);
            value = (int)(Long.parseLong(str, radix) & 0xFFFFFFFFFFFFFFFFL);
        }
        catch (Exception e) {
            ATLog.e(TAG, e, "ERROR. toInteger([%s], %d, %d, %d) - Failed to get integer", Dump.dump(data), offset, length, radix);
            return 0;
        }
        return value;
    }

    public static long toLong(byte[] data) {
        if (BitConvert.isNullOrEmpty(data)) {
            return 0L;
        }
        long value = 0L;
        String str = null;
        try {
            str = BitConvert.toString(data);
            value = Long.parseLong(str);
        }
        catch (Exception e) {
            ATLog.e(TAG, e, "ERROR. toLong([%s]) - Failed to get long", Dump.dump(data));
            return 0L;
        }
        return value;
    }

    public static long toLong(byte[] data, int radix) {
        if (BitConvert.isNullOrEmpty(data)) {
            return 0L;
        }
        long value = 0L;
        String str = null;
        try {
            str = BitConvert.toString(data);
            value = Long.parseLong(str, radix);
        }
        catch (Exception e) {
            ATLog.e(TAG, e, "ERROR. toLong([%s], %d) - Failed to get long", Dump.dump(data), radix);
            return 0L;
        }
        return value;
    }

    public static boolean toBoolean(byte[] data) {
        if (BitConvert.isNullOrEmpty(data)) {
            return false;
        }
        return BitConvert.toInteger(data) > 0;
    }

    public static byte[] toBytes(String value) {
        if (StringUtil.isNullOrEmpty(value)) {
            return null;
        }
        byte[] val = null;
        try {
            val = value.getBytes("ASCII");
        }
        catch (UnsupportedEncodingException e) {
            ATLog.e(TAG, e, "ERROR. toBytes([%s]) - Failed to convert from string", value);
            return null;
        }
        return val;
    }

    public static byte[] toBytes(int value) {
        return BitConvert.toBytes(String.format(Locale.US, "%d", value));
    }

    public static byte[] toBytes(long value) {
        return BitConvert.toBytes(String.format(Locale.US, "%d", value));
    }

    public static byte[] toBytes(boolean enabled) {
        return BitConvert.toBytes(enabled ? "1" : "0");
    }
}

