/*
 * Decompiled with CFR 0.152.
 */
package com.atid.lib.reader.event;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.atid.lib.reader.ATEAReader;
import com.atid.lib.reader.event.IATEAReaderEventListener;
import com.atid.lib.reader.types.KeyState;
import com.atid.lib.reader.types.KeyType;
import com.atid.lib.reader.types.NotificationState;
import com.atid.lib.reader.types.OperationMode;
import com.atid.lib.reader.types.UsbChargerState;
import com.atid.lib.reader.types.UsbChargerType;
import com.atid.lib.transport.types.ConnectState;
import com.atid.lib.types.ActionState;
import com.atid.lib.types.ResultCode;
import com.atid.lib.util.diagnotics.ATLog;
import java.util.ArrayList;
import java.util.Locale;

public class ATEAReaderEventManager {
    private static final String TAG = ATEAReaderEventManager.class.getSimpleName();
    private static final int EVENT_STATE_CHANGED = 1000;
    private static final int EVENT_ACTION_CHANGED = 1001;
    private static final int EVENT_OPERATION_MODE_CHANGED = 1002;
    private static final int EVENT_BATTERY_STATE = 1003;
    private static final int EVENT_KEY_CHANGED = 1004;
    private static final int EVENT_USB_CHARGER_CHANGED = 1005;
    private static final int EVENT_NOTIFICATION_STATE = 1006;
    private ArrayList<IATEAReaderEventListener> mListeners;
    private Handler mHandler;
    private Handler.Callback mEventCallback = new Handler.Callback(){

        public boolean handleMessage(Message msg) {
            switch (msg.what) {
                case 1000: {
                    ATEAReaderEventManager.this.onStateChanged((StateChangedEventArgs)msg.obj);
                    return true;
                }
                case 1001: {
                    ATEAReaderEventManager.this.onActionChanged((ActionChangedEventArgs)msg.obj);
                    return true;
                }
                case 1002: {
                    ATEAReaderEventManager.this.onOperationModeChanged((OperationModeChangedEventArgs)msg.obj);
                    return true;
                }
                case 1003: {
                    ATEAReaderEventManager.this.onBatteryState((BatteryStateEventArgs)msg.obj);
                    return true;
                }
                case 1004: {
                    ATEAReaderEventManager.this.onKeyChanged((KeyChangedEventArgs)msg.obj);
                    return true;
                }
                case 1005: {
                    ATEAReaderEventManager.this.onUsbChargerChanged((UsbChargerChangedEventArgs)msg.obj);
                    return true;
                }
                case 1006: {
                    ATEAReaderEventManager.this.onNotificationState((NotificationStateEventArgs)msg.obj);
                    return true;
                }
            }
            return false;
        }
    };

    public ATEAReaderEventManager() {
        this.mListeners = new ArrayList();
        this.mHandler = new Handler(Looper.getMainLooper(), this.mEventCallback);
    }

    public void destroy() {
        if (this.mListeners == null) {
            return;
        }
        if (this.mListeners != null) {
            this.mListeners.clear();
            this.mListeners = null;
        }
    }

    public void addListener(IATEAReaderEventListener listener) {
        if (this.mListeners == null) {
            return;
        }
        this.mListeners.add(listener);
    }

    public void removeListener(IATEAReaderEventListener listener) {
        if (this.mListeners == null) {
            return;
        }
        this.mListeners.remove(listener);
    }

    public void clear() {
        if (this.mListeners == null) {
            return;
        }
        this.mListeners.clear();
    }

    public void generateReaderStateChanged(ATEAReader reader, ConnectState state, Object params) {
        if (this.mListeners == null) {
            return;
        }
        if (this.mListeners.isEmpty()) {
            return;
        }
        StateChangedEventArgs args = new StateChangedEventArgs(reader, state, params);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1000, (Object)args));
    }

    public void generateReaderActionChanged(ATEAReader reader, ResultCode code, ActionState action, Object params) {
        if (this.mListeners == null) {
            return;
        }
        if (this.mListeners.isEmpty()) {
            return;
        }
        ActionChangedEventArgs args = new ActionChangedEventArgs(reader, code, action, params);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1001, (Object)args));
    }

    public void generateReaderOperationModeChanged(ATEAReader reader, OperationMode mode, Object params) {
        if (this.mListeners == null) {
            return;
        }
        if (this.mListeners.isEmpty()) {
            return;
        }
        if (mode == OperationMode.Normal && reader.getRfidUhf() == null) {
            return;
        }
        if (mode == OperationMode.Barcode && reader.getBarcode() == null) {
            return;
        }
        OperationModeChangedEventArgs args = new OperationModeChangedEventArgs(reader, mode, params);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1002, (Object)args));
    }

    public void generateReaderBatteryState(ATEAReader reader, int batteryState, Object params) {
        if (this.mListeners == null) {
            return;
        }
        if (this.mListeners.isEmpty()) {
            return;
        }
        BatteryStateEventArgs args = new BatteryStateEventArgs(reader, batteryState, params);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1003, (Object)args));
    }

    public void generateReaderKeyChanged(ATEAReader reader, KeyType type, KeyState state, Object params) {
        if (this.mListeners == null) {
            return;
        }
        if (this.mListeners.isEmpty()) {
            return;
        }
        KeyChangedEventArgs args = new KeyChangedEventArgs(reader, type, state, params);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1004, (Object)args));
    }

    public void generateReaderUsbChargerChanged(ATEAReader reader, UsbChargerType type, UsbChargerState state, Object params) {
        if (this.mListeners == null) {
            return;
        }
        if (this.mListeners.isEmpty()) {
            return;
        }
        UsbChargerChangedEventArgs args = new UsbChargerChangedEventArgs(reader, type, state, params);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1005, (Object)args));
    }

    public void generateReaderNotificationState(ATEAReader reader, NotificationState state, Object params) {
        if (this.mListeners == null) {
            return;
        }
        if (this.mListeners.isEmpty()) {
            return;
        }
        NotificationStateEventArgs args = new NotificationStateEventArgs(reader, state, params);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1006, (Object)args));
    }

    private IATEAReaderEventListener getLastListener() {
        if (this.mListeners == null) {
            return null;
        }
        int index = this.mListeners.size() - 1;
        if (index < 0) {
            return null;
        }
        return this.mListeners.get(index);
    }

    private void onStateChanged(StateChangedEventArgs args) {
        IATEAReaderEventListener listener = null;
        listener = this.getLastListener();
        if (listener == null) {
            return;
        }
        try {
            listener.onReaderStateChanged(args.Reader, args.State, args.Params);
        }
        catch (Exception e) {
            ATLog.e((String)TAG, (Throwable)e, (String)"ERROR. onReaderStateChange([%s])", (Object[])new Object[]{args});
        }
    }

    private void onActionChanged(ActionChangedEventArgs args) {
        IATEAReaderEventListener listener = null;
        listener = this.getLastListener();
        if (listener == null) {
            return;
        }
        try {
            listener.onReaderActionChanged(args.Reader, args.Code, args.Action, args.Params);
        }
        catch (Exception e) {
            ATLog.e((String)TAG, (Throwable)e, (String)"ERROR. onReaderActionChanged([%s])", (Object[])new Object[]{args});
        }
    }

    private void onOperationModeChanged(OperationModeChangedEventArgs args) {
        IATEAReaderEventListener listener = null;
        listener = this.getLastListener();
        if (listener == null) {
            return;
        }
        try {
            listener.onReaderOperationModeChanged(args.Reader, args.Mode, args.Params);
        }
        catch (Exception e) {
            ATLog.e((String)TAG, (Throwable)e, (String)"ERROR. onOperationModeChanged([%s])", (Object[])new Object[]{args});
        }
    }

    private void onBatteryState(BatteryStateEventArgs args) {
        IATEAReaderEventListener listener = null;
        listener = this.getLastListener();
        if (listener == null) {
            return;
        }
        try {
            listener.onReaderBatteryState(args.Reader, args.BatteryState, args.Params);
        }
        catch (Exception e) {
            ATLog.e((String)TAG, (Throwable)e, (String)"ERROR. onBatteryState([%s])", (Object[])new Object[]{args});
        }
    }

    private void onKeyChanged(KeyChangedEventArgs args) {
        IATEAReaderEventListener listener = null;
        listener = this.getLastListener();
        if (listener == null) {
            return;
        }
        try {
            listener.onReaderKeyChanged(args.Reader, args.Type, args.State, args.Params);
        }
        catch (Exception e) {
            ATLog.e((String)TAG, (Throwable)e, (String)"ERROR. onKeyChanged([%s])", (Object[])new Object[]{args});
        }
    }

    private void onUsbChargerChanged(UsbChargerChangedEventArgs args) {
        IATEAReaderEventListener listener = null;
        listener = this.getLastListener();
        if (listener == null) {
            return;
        }
        try {
            listener.onReaderUsbChargerChanged(args.Reader, args.Type, args.State, args.Params);
        }
        catch (Exception e) {
            ATLog.e((String)TAG, (Throwable)e, (String)"ERROR. onKeyChanged([%s])", (Object[])new Object[]{args});
        }
    }

    private void onNotificationState(NotificationStateEventArgs args) {
        IATEAReaderEventListener listener = null;
        listener = this.getLastListener();
        if (listener == null) {
            return;
        }
    }

    private class ActionChangedEventArgs {
        private final ATEAReader Reader;
        private final ResultCode Code;
        private final ActionState Action;
        private final Object Params;

        protected ActionChangedEventArgs(ATEAReader reader, ResultCode code, ActionState action, Object params) {
            this.Reader = reader;
            this.Code = code;
            this.Action = action;
            this.Params = params;
        }

        public String toString() {
            return String.format(Locale.US, "[%s], %s, %s", this.Reader, this.Code, this.Action);
        }
    }

    private class BatteryStateEventArgs {
        private final ATEAReader Reader;
        private final int BatteryState;
        private final Object Params;

        protected BatteryStateEventArgs(ATEAReader reader, int batteryState, Object params) {
            this.Reader = reader;
            this.BatteryState = batteryState;
            this.Params = params;
        }

        public String toString() {
            return String.format(Locale.US, "[%s], %d, [%s]", this.Reader, this.BatteryState, this.Params == null ? "NULL" : this.Params);
        }
    }

    private class KeyChangedEventArgs {
        private final ATEAReader Reader;
        private final KeyType Type;
        private final KeyState State;
        private final Object Params;

        protected KeyChangedEventArgs(ATEAReader reader, KeyType type, KeyState state, Object params) {
            this.Reader = reader;
            this.Type = type;
            this.State = state;
            this.Params = params;
        }
    }

    private class NotificationStateEventArgs {
        private final ATEAReader Reader;
        private final NotificationState State;
        private final Object Params;

        protected NotificationStateEventArgs(ATEAReader reader, NotificationState state, Object params) {
            this.Reader = reader;
            this.State = state;
            this.Params = params;
        }
    }

    private class OperationModeChangedEventArgs {
        private final ATEAReader Reader;
        private final OperationMode Mode;
        private final Object Params;

        protected OperationModeChangedEventArgs(ATEAReader reader, OperationMode mode, Object params) {
            this.Reader = reader;
            this.Mode = mode;
            this.Params = params;
        }

        public String toString() {
            return String.format(Locale.US, "[%s], %s, [%s]", new Object[]{this.Reader, this.Mode, this.Params == null ? "NULL" : this.Params});
        }
    }

    private class StateChangedEventArgs {
        private final ATEAReader Reader;
        private final ConnectState State;
        private final Object Params;

        protected StateChangedEventArgs(ATEAReader reader, ConnectState state, Object params) {
            this.Reader = reader;
            this.State = state;
            this.Params = params;
        }

        public String toString() {
            return String.format(Locale.US, "[%s], %s", this.Reader, this.State);
        }
    }

    private class UsbChargerChangedEventArgs {
        private final ATEAReader Reader;
        private final UsbChargerType Type;
        private final UsbChargerState State;
        private final Object Params;

        protected UsbChargerChangedEventArgs(ATEAReader reader, UsbChargerType type, UsbChargerState state, Object params) {
            this.Reader = reader;
            this.Type = type;
            this.State = state;
            this.Params = params;
        }
    }
}

